Comment
==========================================================

This include file contains a lot of useful utilities. It is
smart enough to present the netware choices only if connected
to a novell network.

=========================================================
EndComment

;----- Create Variables

Var
  PortChoices
  MyServer
  AllUsers
  NetAddress
  Station
  UserName
  BMess
  TitleBackColor
  TitleInsideColor
  PersonalMenu
  FilePicked
  NovCon


;=============[ Util Menu ]============*

:Util

if NetworkVersion then NovCon = NovConnection <> 0

;----- Port Choices

PortChoices = Set ['Lpt1','Lpt2','Lpt3']


AddChoice('Format Disk Menu',1)
AddChoice('Dos Functions',2)
if NovCon
   AddChoice('Printer Select',3)
   AddChoice('Novell Information',4)
   AddChoice('Novell User Options',5)
   if NovConsoleOperator
      AddChoice('Novell Utilities',6)
      AddChoice('Maintainence',7)
      AddChoice('Menu Utilities',8)
      AddChoice('Command Line',9)
   endif
endif
if not NovCon
   AddChoice('Menu Utilities',8)
   AddChoice('Command Line',9)
endif

CornerStretchBox ('Utility Menu',43,6)

OnKey Task(1)
  |SelectFormat
  |LastKey = ' '

OnKey Task(2)
  ^Dos

OnKey Task(3)
  |SelectPrintQueue
  |Dispose Choices
  |LastKey = ' '

OnKey Task(4)
  ^NovInfo

OnKey Task(5)
  ^NovUser

OnKey Task(6)
  ^NovUtils

OnKey Task(7)
  ^Maint

OnKey Task(8)
  ^MenuUtil

OnKey Task(9)
  |if ExistOnPath('DOLIST.EXE') > ''
     DropTo DoList
  |else
  |  Bat 'DropTo ' + ReadEnv('COMSPEC')
  |endif

;=============[ Dos Menu ]============*

:Dos

AddChoice('Directory Master',1)
AddChoice('Pick Directory',2)
AddChoice('Show Directory',3)
AddChoice('Free Space',4)
AddChoice('Memory Map',5)
AddChoice('Device Drivers',6)

CenterStretchBox ('DOS Menu',38,15)

OnKey Task(1)
  |if NovConsoleOperator
     DropTo DM3
  |else
     DropTo DMLITE
  |endif

OnKey Task(2)
   PD

OnKey Task(3)
   D/W

OnKey Task(4)
   Free
   Pause

OnKey Task(5)
   RamMap
   Pause

OnKey Task(6)
   Device
   Pause


;=============[ Maintenence Menu ]============*

:Maint

AddChoice('Tape Backup',1)
AddChoice('Delete *.BAK Files',2)
AddChoice('Delete *.MRX Files',3)

CenterStretchBox ('Maintenence Menu',38,15)

OnKey Task(1)
   |Error('Put Code for your Tape Backup Software here.')

OnKey Task(2)
   Whereis *.BAK /D

OnKey Task(3)
   Whereis *.MRX /D


;=============[ Menu Utilities Menu ]============*

:MenuUtil

AddChoice('Edit this Menu',1)
AddChoice('View Include Files',2)
AddChoice('Edit Include Files',3)
AddChoice('View a Menu File',4)
AddChoice('Edit a Menu File',5)
AddChoice('Run a Menu',6)
AddChoice('Load MarxHelp',7)
AddChoice('UnLoad MarxHelp',8)

CenterStretchBox ('Menu Utilities',38,15)

OnKey Task(1)
   ME %MenuFileName

OnKey Task(2)
   |FilePicked = PickAFile('*.INC','Include Files')
   |ViewFile(FilePicked)

OnKey Task(3)
   |FilePicked = GetIncludeFile
   |if FilePicked > ''
   |   Bat 'ME ' + FilePicked
   |endif

OnKey Task(4)
   |FilePicked = PickAFile ('*.MNU','Menus')
   |ViewFile(FilePicked)

OnKey Task(5)
   |FilePicked = PickAFile ('*.MNU','Menus')
   |if FilePicked > ''
   |   Bat 'ME ' + FilePicked
   |endif

OnKey Task(6)
   |FilePicked = PickAFile ('*.MNU','Menus')
   |if FilePicked > ''
   |   Bat 'MARX ' + FilePicked
   |endif

OnKey Task(7)
   |MxCmd = 'MarxHelp'

OnKey Task(8)
   |MxCmd = 'MarxHelp /U'


;=============[ Format Menu ]============*

Procedure SelectFormat
var Ch Message Option

   DrawTheBox(20,12,42,4 + HeightDifference,'Format Floppy Disk Menu')

   Writeln ' 1 - Format 360    5 - Format /S 360'
   Writeln ' 2 - Format 1.2M   6 - Format /S 1.2M'
   Writeln ' 3 - Format 720    7 - Format /S 720'
   Write   ' 4 - Format 1.4M   8 - Format /S 1.4M'

   Ch = ReadKey

   if Ch = '1'
      Message = '360k Format with no System Files.'
      Option = '/4'

   elseif Ch = '2'
      Message = '1.2m Format with no System Files.'
      Option = ''

   elseif Ch = '3'
      Message = '720k Format with no System Files.'
      Option = '/N:9/T:80'

   elseif Ch = '4'
      Message = '1.4m Format with no System Files.'
      Option = '/N:18/T:80'

   elseif Ch = '5'
      Message = '360k Format with System Files.'
      Option = '/4/S'

   elseif Ch = '6'
      Message = '1.2m Format with System Files.'
      Option = '/S'

   elseif Ch = '7'
      Message = '720k Format with System Files.'
      Option = '/N:9/T:80/S'

   elseif Ch = '8'
      Message = '1.4m Format with System Files.'
      Option = '/N:18/T:80/S'

   else
      Return

   endif

   if DosVersionString >= '5.00'
      Option = Option + '/U'     ;unconditional
      Option = Option + '/V:DOS' ;automatically adds volume label
   endif

   DrawTheBox(46,18,11,2 + HeightDifference,'Drive')
   Writeln '  A:'
   Write   '  B:'
   Ch = ReadKey
   if Ch = Esc then Return
   ExecFormat(Ch,Option,Message)
EndProc

;----- Execute FORMAT in a DOS Window

Procedure ExecFormat (Drv,Option,Message)
var FormatProg

   FormatProg = ExistOnPath('FORMAT.EXE')
   if FormatProg = '' then FormatProg = ExistOnPath('FORMAT.COM')
   if FormatProg = ''
      Error('FORMAT program not Found!')
      Return
   endif

   BoxHeader = ' Formatting Drive ' + Drv + ': ' + Message + ' '
   Shadow Off
   DrawBox 1 4 80 21
   Window  4 5 74 19
   Writeln
   ExecProg (FormatProg + ' ' + Drv + ': ' + Option)
   EraseTopWindow
EndProc


;=============[ Novell Utilities Menu ]============*

:NovUtils

AddChoice('Session Management',1)
AddChoice('File Management',2)
AddChoice('Volume Information',3)
AddChoice('System Configuration',4)
AddChoice('File Server Monitoring',5)
AddChoice('Print Queue Management',6)
AddChoice('Print Job Configurations',7)
AddChoice('Printer Definitions',8)
AddChoice('Folio Help System',9)

CenterStretchBox ('Novell Utilities',38,15)

OnKey Task(1)
   Session

OnKey Task(2)
   Filer

OnKey Task(3)
   VolInfo

OnKey Task(4)
   Syscon

OnKey Task(5)
   FConsole

OnKey Task(6)
   PConsole

OnKey Task(7)
   PrintCon

OnKey Task(8)
   PrintDef

OnKey Task(9)
   P:Help


;=============[ Novell Information Menu ]============*

:NovInfo

AddChoice('UserList',1)
AddChoice('Drive Map',2)
AddChoice('Current Dir',3)
AddChoice('Directory Rights',4)
AddChoice('List Servers',5)
AddChoice('Who Am I?',6)
AddChoice('Trustees',7)
AddChoice('System Time',8)
AddChoice('ChkVol',9)
AddChoice('Printer Status',10)

CenterStretchBox ('Novell Information',38,15)

OnKey Task(1)
   UserList/A
   Echo.
   Pause

OnKey Task(2)
   Map
   Echo.
   Pause

OnKey Task(3)
   NDir
   Pause

OnKey Task(4)
   Rights
   Echo.
   Pause

OnKey Task(5)
   SList
   Echo.
   Pause

OnKey Task(6)
   WhoAmI/A
   Echo.
   Pause

OnKey Task(7)
   TList
   Echo.
   Pause

OnKey Task(8)
   SysTime
   Echo.
   Pause

OnKey Task(9)
   ChkVol
   Echo.
   Pause

OnKey Task(10)
   Capture Show
   Echo.
   Pause


;=============[ Novell User Menu ]============*

:NovUser

AddChoice('Change Password',1)
AddChoice('Block Messages',2)
AddChoice('Receive Messages',3)
AddChoice('End Printer Capture',4)
AddChoice('Send a Message',5)

CenterStretchBox ('Novell User Menu',38,15)

OnKey Task(1)
   SetPass

OnKey Task(2)
   CastOff

OnKey Task(3)
   CastOn

OnKey Task(4)
   EndCap

OnKey Task(5)
   |SendMessage

;----- This routines selects a print queue

Procedure SelectPrintQueue
var Queues Queue PrnPort QCmd LocalName Servers Server

   NovAttachedServers(Servers)
   if NumberOfElements(Servers) > 1
      SortArray(Servers)
      DrawTheBox(15,13,23,Min(12,NumberOfElements(Servers) + HeightDifference),'Servers')
      Server = PickOne(Servers)
      if LastKey = Esc then Return
      NovPreferredServer = Server
   else
      Server = NovDefaultServer
   endif

   LocalName = '<Local Printer>'
   NovMyPrintQueues(Queues)
   SortArray(Queues)
   AppendArray(Queues,LocalName)

   DrawTheBox(28,11,23,Min(12,NumberOfElements(Queues) + HeightDifference),'Print Queues')
   Queue = PickOne(Queues)
   if LastKey = Esc
      Return
   endif

   Choices = PortChoices
   CenterStretchBox ('Port',38,20)
   PrnPort = Ord(ReadKey) - 64
   if LastKey = Esc then Return
   EraseTopWindow

   if Queue = LocalName
      NovEndCapture (PrnPort)
   else
      NovCaptureQueue (PrnPort) = Server + '/' + Queue
      NovCaptureTimeOut (PrnPort) = 5
   endif

EndProc

;----- Sends a novell message

Procedure SendMessage
var Choice Message
   Choice = PickUser('Send message To')
   if Choice = '' then Return
   Message = ReadTextLine('Message:','',0,21)
   if LastKey = Esc then Return
   ClearScreen
   TextColor MenuHeaderFG MenuBG
   Write ' Sending ... '
   ClearScreenFirst Off
   ExecProg ('Send "' + Message + '" to ' + Choice + '>nul')
EndProc

;----- Select Include File

Procedure GetIncludeFile
var IncPath Picked
   IncPath = PathPart(ExistOnPath('CUSTOM.INC'))
   Picked = PickAFile(CleanFileName(IncPath + '\*.INC'),'Include Files')
   if Picked = '' then Return ''
   DelFile(ForceExtension(%MenuFileName,'MRX'))
   Return CleanFileName(IncPath + '\' + Picked)
EndProc

;----- Reads a list of all users on the system

Procedure ReadUsers
   if NumberOfElements(AllUsers) > 0 then Return
   NovUsersLoggedIn(AllUsers)
   SortArray(AllUsers)
EndProc


Procedure PickUser (Message)
var MaxSize
   ReadUsers
   MaxSize = Min(15,NumberOfElements(AllUsers))
   DrawTheBox(46,12 - (MaxSize / 2),20,MaxSize + HeightDifference,Message)
   Return PickOne(AllUsers)
EndProc

;----- Execute a program in a window

Procedure ExecProg (Prog)
   TextColor MenuHeaderFG MenuBG
   Cursor Off
   DosWindow
   Execute Prog
EndProc


Procedure PickAFile (Mask,Message)
var Files Choice MaxSize
   ReadDirectory(Mask,Files)
   MaxSize = Min(15,NumberOfElements(Files))
   if MaxSize = 0
      Error('No Choices!')
      Return ''
   endif
   DrawTheBox(46,12 - (MaxSize / 2),20,MaxSize + HeightDifference,Message)
   Choice = PickOne(Files)
   Return Choice
EndProc

;----- Display Error and Wait for a Key

Procedure Error (Err)
var Ch
   BoxHeader = ' Error * Press any Key '
   DrawBox 11 19 Max(27,length(Err) + 4) 3
   Cursor Off
   UseArrows Off
   TextColor MenuHeaderFG MenuBG
   WriteCenter Err
   Write Char(7)
   Ch = ReadKey
   EraseTopWindow
EndProc
