Comment
==========================================================

This include file exports definitions that create a Novell menu look and
feel. This is one of several look and feel files that export the same
procedures.

Useful Routines Exported:

LookSetup
   Call this to initialize the screen. Set MenuTitle and StatusLineText
   before calling this routine.

CornerStretchBox (Header,Col,Row)
   Creates a window from the array Choices with the upper left corner at
   Row/Col. LastKey is set to the letter that is chosen.

CenterStretchBox (Header,Col,Row)
   Creates a window from the array Choices with the center at Row/Col.
   if a 0 is passed for either the Row or Col then the center of the
   screen is assumed. LastKey is set to the letter that is chosen.

Leave
   Puts up an exit box.


==========================================================
EndComment


var
  Choices
  MenuTitle
  StatusLineText
  StatusWindow
  HeightDifference
  Greek = False

var
  BackGroundFG
  BackGroundBG
  TitleBoxBorderFG
  TitleBoxBG
  TitleBoxInsideFG
  ClockColorFG
  StatusLineFG
  StatusLineBG
  MenuInsideFG
  MenuBG
  MenuHeaderFG
  MenuBorderFG
  MenuVertLinesFG
  MenuInverseFG
  MenuInverseBG
  MenuCapColorFG
  ConsoleInsideFG
  GreekFG
  GreekBG

;------ This is where you set your favorite colors.

Procedure SetColors
   if ColorScreen
      BackGroundFG     = Grey
      BackGroundBG     = Blue
      TitleBoxBG       = Brown
      TitleBoxBorderFG = White
      TitleBoxInsideFG = Yellow
      ClockColorFG     = Yellow
      StatusLineFG     = Yellow
      StatusLineBG     = Mag
      MenuBG           = Blue
      MenuInsideFG     = Yellow
      MenuBorderFG     = Yellow
      MenuHeaderFG     = LCyan
      MenuVertLinesFG  = LGreen
      MenuInverseFG    = White
      MenuInverseBG    = Mag
      MenuCapColorFG   = White
      ConsoleInsideFG  = White
      GreekFG          = Blue
      GreekBG          = Green
      BoxHeaderColor Yellow Green
   else
      BackGroundFG     = Grey
      BackGroundBG     = Black
      TitleBoxBG       = Grey
      TitleBoxBorderFG = Black
      TitleBoxInsideFG = Black
      ClockColorFG     = Black
      StatusLineFG     = Black
      StatusLineBG     = Grey
      MenuBG           = Black
      MenuInsideFG     = Grey
      MenuBorderFG     = Grey
      MenuHeaderFG     = White
      MenuVertLinesFG  = White
      MenuInverseFG    = Black
      MenuInverseBG    = Grey
      MenuCapColorFG   = White
      ConsoleInsideFG  = Grey
      GreekFG          = Black
      GreekBG          = Grey
      BoxHeaderColor Black Grey
   endif
EndProc

;------ Sets up main window to Novell look.

Procedure LookSetup
   if MenuInsideFG = 0 then SetColors
   NoExit

   ;------ Clear the screen with a textured background

   if not Overlayed
      TextColor BackGroundFG BackGroundBG
      ClearScreen 176

      ;------ If Greek is true then draw greek columns

      if Greek then GreekColumns
   endif

   ;------ Draw Status Line

   NoBoxBorder
   InactiveBox NoBoxBorder
   Explode Off
   BoxInsideColor StatusLineFG StatusLineBG
   DrawBox 1 ScreenHeight ScreenWidth 1
   StatusWindow = CurrentWindow
   WriteCenter(StatusLineText)

   if not Overlayed

      ;------ Draw the Title Box

      SingleLineBox
      BoxInsideColor TitleBoxInsideFG TitleBoxBG
      BoxBorderColor TitleBoxBorderFG TitleBoxBG
      DrawBox 1 1 ScreenWidth 3
      GotoXY(ScreenWidth - Length(MenuTitle) - 3,1)
      Write MenuTitle

      ;------ Display the clock

      ClockColor ClockColorFG TitleBoxBG
      ClockPos 3 2

      ;------ Setup Console

      ConsolePos 42 5
      ConsoleHeaderColor MenuInverseFG MenuInverseBG
      ConsoleInsideColor ConsoleInsideFG MenuBG

   endif
   HeightDifference = 4
EndProc


Procedure MakeBox(Header,Col,Row,Center)
var NumElem Height Width Cnt

   Width = Length(Header) - 1
   NumElem = NumberOfElements(Choices)

     ;Get the widest element in the Choices Array

   if Length(Choices[1]) > 0
      Cnt = 65
      loop NumElem
         Trim(Choices[LoopIndex])
         if left(Choices[LoopIndex],1) <> ''
            Choices[LoopIndex] = " " + Char(Cnt) + ". " + Choices[LoopIndex]
            Cnt = Cnt + 1
         endif
         Width = Max(Width,Length(Choices[LoopIndex]))
      endloop
   else
      Width = ScreenWidth - 7
   endif
   Height = NumElem + 2
   if Header > '' then Height = NumElem + 4
   Width = Width + 5
   if Center
      if Row = 0

         ;Center window verticaly

         Row = ((ScreenHeight - Height) / 2) + 2
      else

         ;Center window with X Coordinate

         Row = (Row - (Height / 2) + 1)
      endif
      if Col = 0

         ;Center window horizonitly

         Col = (ScreenWidth - Width) / 2 + 1
      else

         ;Center window with Y Coordinate

         Col = (Col - (Width / 2) + 1)
      endif
   endif

   ;Make Sure Row and Col are within their range

   Row = Max(Row,5)
   Row = Min(Row,ScreenHeight - Height - 1)
   Col = Max(Col,2)
   Col = Min(Col,ScreenWidth - Width)

   DrawTheBox(Col,Row,Width,Height,Header)

     ;Write the menu choices

   loop(NumElem - 1)
      if left(Choices[LoopIndex],1) = ''
         TextColor MenuVertLinesFG MenuBG
         ClearLine 196
         TextColor MenuInsideFG MenuBG
         CapsColor(MenuCapColorFG,MenuBG)
         Writeln
      else
         Writeln(Choices[LoopIndex])
      endif
   endloop

   Write Choices[NumElem]
   UseArrows On
   Dispose(Choices)
EndProc

;------ Draw the Box

Procedure DrawTheBox (Col,Row,Width,Height,Header)

     ;Draw the main window

   DoubleLineBox
   InactiveBox SingleLineBox
   BoxInsideColor(MenuInsideFG,MenuBG)
   BoxBorderColor(MenuBorderFG,MenuBG)
   DrawBox(Col, Row, Width, Height)

   if Header > ''

     ;Write the header

      TextColor(MenuHeaderFG,MenuBG)
      WriteCenter(Header)

     ;Write the vertical lines

      TextColor(MenuVertLinesFG,MenuBG)
      Writeln
      ClearLine 196
      GotoXY 2 2
      WriteVertical mid(VertLine,1,Height - 3)

     ;Draw the menu text box

      CapsColor(MenuCapColorFG,MenuBG)
      InverseColor(MenuInverseFG,MenuInverseBG)
      Window(Col + 3, Row + 3, Width - 4, Height - 4)
   else
      CapsColor Black Black
   endif
EndProc


