Comment
========================================================================

MarxMenu supports several "Look and Feel" options. You can choose from:

NOVELL.INC
BLOCK.INC
GRID.INC
SABER.INC

By including different files MarxMenu compiles the same menu with
completely different looks.

Colors are set by editing these include files.

========================================================================
EndComment

;----- Select include file.

Include 'NOVELL.INC'
;Include 'BLOCK.INC'
;Include 'GRID.INC'
;Include 'SABER.INC'

;----- Turn this on if you like the Greek Column Look.

Greek Off

;----- Windowing Support Logic and Initialization Code

Include 'WINSUP.INC'

;================< FEATURE CONTROL AREA >================

;----- WORM.INC loads the example custom screen blanker program

  Include 'WORM.INC'

;----- CRAWL.INC allows you to have moving text on the bottom line

  Include 'CRAWL.INC'

;----- Set up the blank screen message if you want one.

  BlankMessage = ''

;----- Change BlankTime to 0 if you do not want to blank the screen.

  BlankTime = 5

;----- Change LogoffTime to number of minutes if you want timed Logoff.

  LogoffTime = 0

;----- This makes the menu come back to the same menu level.

  SavePosition On

;----- Control Explode effects.

  Explode Off

;----- Novell Network Options

if NetworkVersion
   if NovConnection <> 0

;----- Use Novell Password or LockWord to unlock the screen blanker.

      Now = NovServerTime   ;Keeps workstation time in sync with server
      UseNovPassword Off    ;change to On to activate this feature
   else
      LockWord = ''         ;place lockword here for non novell menus
   endif
endif

