(*# check(stack=>off,
          index=>off,
          range=>off,
          overflow=>off,
          nil_ptr=>off) *)

IMPLEMENTATION MODULE ApplDlg;

IMPORT Windows,WinStr,Str,WMain,ApplFish,Lib;

CONST
(* String table constants *)
  IDSNAME  =   100;
  IDSABOUT =   200;
  IDSTITLE =   300;
  IDSMESSAGE = 400;
  IDSCAPTION = 500;
  IDSDEFSPEC = 501;
  IDSDEFEXT  = 502;

(* About Dialog box resource id *)
  ABOUTBOX =     1;
  FISHSELECT =   2;
  LIFEDATABOX =  3;
  FISHINFOBOX =  4;

(* Fish Select Box Controls *)
  IDC_FILENAME =   400;
  IDC_EDIT     =   401;
  IDC_FILES    =   402;
  IDC_PATH     =   403;
  IDC_LISTBOX  =   404;

  IDSAVERAGECHECK =  114;
  IDSBACK        =  119;
  IDSCANCEL      =  118;
  IDSFASTCHECK   =  115;
  IDSFISHNAME    =  108;
  IDSGROUPBOX    =  110;
  IDSHOWMANY     =  116;
  IDSHOWMANYTEXT =  112;
  IDSNEXT        =  120;
  IDSOK          =  117;
  IDSSELECTED    =  109;
  IDSSLOWCHECK   =  113;
  IDSPAINT       =  102;

  SPECIAL_CHANGE =     0401H;
  INIT_INSTANCES =     0402H;
  RESTART        =     0403H;

VAR
  lpprocAbout,lpOpenDlg,lpLifeDlg,lpInfoDlg: Windows.FARPROC;


PROCEDURE About ( hDlg    : Windows.HWND;
                 message : CARDINAL;
                 wParam  : WORD;
                 lParam  : LONGINT ) : Windows.BOOL ;

BEGIN
  IF message = Windows.WM_COMMAND THEN
    Windows.EndDialog( hDlg, CARDINAL(TRUE) );
    RETURN INTEGER(TRUE);
  ELSIF message = Windows.WM_INITDIALOG THEN
    IF Windows.SetFocus(Windows.GetDlgItem(hDlg,Windows.IDOK)) # 0 THEN END;
    IF Windows.SetTimer(hDlg,1,1000,Windows.FARPROC(0)) = 0 THEN
       IF Windows.SendMessage(Windows.GetParent(hDlg),Windows.WM_COMMAND,RESTART,0) = 0 THEN END;
    END;
    RETURN INTEGER(TRUE);
  ELSIF message = Windows.WM_TIMER THEN
    IF Windows.KillTimer(hDlg,1) = 0 THEN END;
    IF Windows.SendMessage(Windows.GetParent(hDlg),Windows.WM_COMMAND,RESTART,0) = 0 THEN END;
    RETURN INTEGER(TRUE);
  ELSE
    RETURN INTEGER(FALSE);
  END;
END About;

PROCEDURE  PaintWindow(  hWnd   : Windows.HWND;
                         hBitmap : Windows.HBITMAP;
                         xext,yext : INTEGER );

VAR hdc,hmemorydc : Windows.HDC;
    xoffset,yoffset : INTEGER;
    Rect : Windows.RECT;

BEGIN
    hdc := Windows.GetDC(hWnd);
    hmemorydc := Windows.CreateCompatibleDC(hdc);
    Windows.GetClientRect(hWnd,Rect);
    IF Windows.SelectObject(hmemorydc,hBitmap) # 0 THEN END;
    xoffset := (Rect.right - xext) DIV 2;
    yoffset := (Rect.bottom - yext) DIV 2;
    IF Windows.BitBlt(hdc,xoffset,yoffset,Rect.right,Rect.bottom,
                      hmemorydc,0,0,Windows.SRCCOPY) # 0 THEN END;
    IF Windows.DeleteDC(hmemorydc) # 0 THEN END;
    IF Windows.ReleaseDC(hWnd,hdc) # 0 THEN END
END PaintWindow;

PROCEDURE  PaintTheBlock(hCtrl   : Windows.HWND;
                         hBitmap : Windows.HBITMAP);
VAR Rect : Windows.RECT;
BEGIN
    Windows.GetClientRect(hCtrl,Rect);
    Windows.InvalidateRect(hCtrl,Rect,0);
    Windows.UpdateWindow(hCtrl);
    PaintWindow(hCtrl,hBitmap,75,75)
END PaintTheBlock;


PROCEDURE  LifeInfo ( hDlg    : Windows.HWND;
                 message : CARDINAL;
                 wParam  : WORD;
                 lParam  : LONGINT ) : Windows.BOOL ;

TYPE
  ITEMTYPE = ARRAY[0..2] OF CHAR;

CONST
  FISHMOVE = 99;
  SETUPMOVE = 101;
VAR
  Rect : Windows.RECT;
  s1,s2,s3,s4,s5 : ITEMTYPE;
  NewInstances : CARDINAL;
BEGIN
    CASE message OF
    | Windows.WM_TIMER:
         IF wParam = WORD(SETUPMOVE) THEN
            IF Windows.KillTimer(hDlg,SETUPMOVE) = 0 THEN END;
            IF Windows.SendMessage(Windows.GetParent(hDlg),SPECIAL_CHANGE,0,0) = 0 THEN END;
            IF Windows.SetTimer(hDlg,FISHMOVE,200,Windows.FARPROC(0)) = 0 THEN
               ApplFish.TimersLow(Windows.GetParent(hDlg))
            END;
         ELSE
            PaintWindow(Windows.GetDlgItem(hDlg,IDSPAINT),
                       WMain.FishHead[WMain.FishSelected].bmap[1,
                       WMain.FishHead[WMain.FishSelected].DialogFrame],
                       WMain.FishHead[WMain.FishSelected].xextent,
                       WMain.FishHead[WMain.FishSelected].yextent);
            IF WMain.FishHead[WMain.FishSelected].DialogFrame >= 4 THEN
               WMain.FishHead[WMain.FishSelected].DialogFrame := 1
            ELSE
               WMain.FishHead[WMain.FishSelected].DialogFrame :=
                WMain.FishHead[WMain.FishSelected].DialogFrame + 1
            END
         END;

       RETURN INTEGER(TRUE);

    | Windows.WM_COMMAND:
         CASE wParam OF
             | IDSSELECTED:
                 WHILE Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,
                       Windows.CB_DELETESTRING,1,07FFFH) >= 0 DO END;
                 IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,
                       Windows.CB_RESETCONTENT,0,0) = 0 THEN END;
                 IF Windows.SendDlgItemMessage(hDlg,IDSSELECTED,
                        Windows.BM_GETCHECK,0,07FFFH) # 0 THEN
                            s1 := "1"; s2 := "2"; s3 := "3"; s4 := "4"; s5 := "5";
                            IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                                          LONGINT(FarADR(s1))) = 0 THEN END;
                            IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                                          LONGINT(FarADR(s2))) = 0 THEN END;
                            IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                                          LONGINT(FarADR(s3))) = 0 THEN END;
                            IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                                          LONGINT(FarADR(s4))) = 0 THEN END;
                            IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                                          LONGINT(FarADR(s5))) = 0 THEN END;
                            IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,
                               Windows.CB_SETCURSEL,WMain.FishHead[WMain.FishSelected].Instances,07FFFH)
                               = 0 THEN END;
                ELSE
                    s1 := "0";
                    IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                                          LONGINT(FarADR(s1))) = 0 THEN END;
                    IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,
                       Windows.CB_SETCURSEL,0,07FFFH) = 0 THEN END;

                    RETURN INTEGER(TRUE);
                END;
                | IDSCANCEL:
                     Windows.EndDialog(hDlg,Windows.NULL);
                     IF Windows.KillTimer(hDlg,FISHMOVE) = 0 THEN END;

                     RETURN INTEGER(TRUE);
                | IDSOK:
                     IF Windows.SendDlgItemMessage(hDlg,IDSSELECTED,
                            Windows.BM_GETCHECK,0,07FFFH) # 0 THEN
                        WMain.FishHead[WMain.FishSelected].status := TRUE;
                        NewInstances := INTEGER(Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,
                        Windows.CB_GETCURSEL,0,07FFFH));
                        IF NewInstances <> WMain.FishHead[WMain.FishSelected].Instances  THEN
                           IF Windows.SendMessage(Windows.GetParent(hDlg),INIT_INSTANCES,NewInstances+1,LONGINT(WMain.FishSelected)) = 0 THEN END;
                        END;

                     ELSE
                        WMain.FishHead[WMain.FishSelected].status := FALSE
                     END;
                     IF Windows.SendDlgItemMessage(hDlg,IDSSLOWCHECK,
                            Windows.BM_GETCHECK,0,07FFFH) # 0 THEN
                            WMain.FishHead[WMain.FishSelected].basespeed := WMain.SLOWSPEED;
                     ELSIF
                         Windows.SendDlgItemMessage(hDlg,IDSAVERAGECHECK,
                            Windows.BM_GETCHECK,0,07FFFH) # 0 THEN
                            WMain.FishHead[WMain.FishSelected].basespeed := WMain.AVERAGESPEED;
                     ELSIF
                         Windows.SendDlgItemMessage(hDlg,IDSFASTCHECK,
                            Windows.BM_GETCHECK,0,07FFFH) # 0 THEN
                            WMain.FishHead[WMain.FishSelected].basespeed := WMain.FASTSPEED;
                     END;
                     Windows.EndDialog( hDlg, CARDINAL(TRUE) );
                     IF Windows.KillTimer(hDlg,FISHMOVE) = 0 THEN END;

                     RETURN INTEGER(TRUE);

         END;


    | Windows.WM_INITDIALOG:
       s1 := "1"; s2 := "2"; s3 := "3"; s4 := "4"; s5 := "5";

       Windows.SetDlgItemText(hDlg, IDSFISHNAME, WMain.FishHead[WMain.FishSelected].name);
       IF WMain.FishHead[WMain.FishSelected].status THEN
          IF Windows.SendDlgItemMessage(hDlg,IDSSELECTED,
                            Windows.BM_SETCHECK,1,07FFFH) # 0 THEN END;
          IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                        LONGINT(FarADR(s1))) = 0 THEN END;
          IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                        LONGINT(FarADR(s2))) = 0 THEN END;
          IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                        LONGINT(FarADR(s3))) = 0 THEN END;
          IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                        LONGINT(FarADR(s4))) = 0 THEN END;
          IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                        LONGINT(FarADR(s5))) = 0 THEN END;
          IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,
               Windows.CB_SETCURSEL,WMain.FishHead[WMain.FishSelected].Instances,07FFFH)
               = 0 THEN END;

       ELSE
          s1 := "0";
          IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,Windows.CB_ADDSTRING,0,
                                        LONGINT(FarADR(s1))) = 0 THEN END;
          IF Windows.SendDlgItemMessage(hDlg,IDSHOWMANY,
               Windows.CB_SETCURSEL,0,07FFFH) = 0 THEN END;

       END;

       CASE WMain.FishHead[WMain.FishSelected].basespeed OF
       | WMain.SLOWSPEED:
          IF Windows.SendDlgItemMessage(hDlg,IDSSLOWCHECK,
                            Windows.BM_SETCHECK,1,07FFFH) # 0 THEN END
       | WMain.AVERAGESPEED:
          IF Windows.SendDlgItemMessage(hDlg,IDSAVERAGECHECK,
                            Windows.BM_SETCHECK,1,07FFFH) # 0 THEN END
       | WMain.FASTSPEED:
          IF Windows.SendDlgItemMessage(hDlg,IDSFASTCHECK,
                            Windows.BM_SETCHECK,1,07FFFH) # 0 THEN END

       END;

       IF Windows.SetTimer(hDlg,SETUPMOVE,1000,Windows.FARPROC(0)) = 0 THEN
          ApplFish.TimersLow(Windows.GetParent(hDlg))
       END;
       PaintWindow(Windows.GetDlgItem(hDlg,IDSPAINT),
                   WMain.FishHead[WMain.FishSelected].bmap[1,1],
                   WMain.FishHead[WMain.FishSelected].xextent,
                   WMain.FishHead[WMain.FishSelected].yextent);
       IF Windows.SetFocus(Windows.GetDlgItem(hDlg,IDSPAINT)) # 0 THEN END;

         RETURN INTEGER(FALSE);
    ELSE
  RETURN INTEGER(FALSE);
  END; (*CASE message*)
  RETURN INTEGER(FALSE);
END LifeInfo;

PROCEDURE Selec ( hDlg    : Windows.HWND;
                 message : CARDINAL;
                 wParam  : WORD;
                 lParam  : LONGINT ) : Windows.BOOL ;
VAR index : WORD;
    fstr  : ARRAY [0..11] OF CHAR;

BEGIN
    CASE message OF
        | Windows.WM_COMMAND:
         CASE wParam OF
                | IDC_LISTBOX:
                CASE Windows.HIWORD(lParam) OF
                     | Windows.LBN_SELCHANGE:
                       IF Windows.DlgDirSelect(hDlg, fstr, IDC_LISTBOX) # INTEGER(TRUE) THEN
                          Windows.SetDlgItemText(hDlg, IDC_EDIT, fstr);
                          IF Windows.SendDlgItemMessage(hDlg, IDC_EDIT,
                                               Windows.EM_SETSEL,
                                               0,
                                               07FFFH) # 0 THEN
                          END; (*IF*)
                       ELSE
                          WinStr.Concat(fstr, fstr,WMain.szMask);
                          Windows.SetDlgItemText(hDlg, IDC_EDIT, fstr);
                          IF Windows.SendDlgItemMessage(hDlg, IDC_EDIT,
                                               Windows.EM_SETSEL,
                                               0,
                                               07FFFH) # 0 THEN
                          END; (*IF*)
                       END; (*IF*)
                     | Windows.LBN_DBLCLK:
                          IF Windows.MessageBox(hDlg,"Double Click","Howdy",Windows.MB_OK) = 0 THEN END;
                END; (*CASE lParam*)
                RETURN INTEGER(TRUE);
                | Windows.IDOK:
                     lpLifeDlg := Windows.MakeProcInstance( Windows.FARPROC(FarADR(LifeInfo)), WMain.hInst);
                     IF Windows.DialogBox( WMain.hInst, FarADDRESS(LONGCARD(LIFEDATABOX)), hDlg, lpLifeDlg ) # 0 THEN END;
                     Windows.FreeProcInstance(lpLifeDlg);
                | Windows.IDCANCEL:
                     Windows.EndDialog(hDlg,Windows.NULL);
                     RETURN INTEGER(TRUE);
          END; (*CASE wParam*)
    | Windows.WM_INITDIALOG:
       Str.Copy(WMain.szPath, CHR(0C) );
       IF Windows.DlgDirList(hDlg, WMain.szPath, IDC_LISTBOX, IDC_PATH, 04010H) # 0 THEN END;
       WinStr.Copy(WMain.szMask,WMain.szPath);
       Windows.SetDlgItemText(hDlg, IDC_EDIT, WMain.szMask);
       IF Windows.SendDlgItemMessage(hDlg, IDC_EDIT,
                                    Windows.EM_SETSEL,
                                    0,
                                    07FFFH) # 0 THEN
       END; (*IF*)
       IF Windows.SetFocus(Windows.GetDlgItem(hDlg,IDC_EDIT)) # 0 THEN END;
       RETURN INTEGER(FALSE);
  ELSE
  RETURN INTEGER(FALSE);
  END; (*CASE message*)
  RETURN INTEGER(FALSE);
END Selec;

END ApplDlg.
