{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application    := System wide hotkey edit control

	Files          := Hotkey2.exe, Hotkey2.pas, Hotkey2.res, Hk2Hook.dll, Hk2Hook.pas

	Units Required := MObjects and MWCC.dll

	Purpose        := HotKey2 shows you how to,

							   	   1. Install a 'system' hook using the new 'SetWindowHookEx' function.

							    	 2. Set up the associated dll contained 'Callback' function.

							    	 3. Set up an System wide HotKey.

								     4. Use some of the BWCC style objects in the MWCC library.

	Tabs           := 2

	Screen         := 800 * 600

	Date           := August, 1993.

	Hotkey 2 is an extension of HotKey 1 which was translated from the C program 'Shortcut
	Key Edit Sample' available on the MSDNLIB forum as 4-52.zip.

	Hotkey 2 lets the user install a system wide hotkey. The Hotkey is valid from within any
	application.

	Hotkey 2 uses different set of custum controls. It lets you use what I feel is a better
	BWCC look without using BWCC.dll.

	I hope you find HotKey2 useful.

	Jeff...

***}

program HotKey2;

{$R HotKey2.Res}
{$C DemandLoad Moveable Discardable}

uses WinTypes, WinProcs, Strings, Win31, MObjects,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	{*** Window ID's ***}
	idw_timer                       = 101;

	{*** Dialog ID's ***}
	idd_HotKeyEdit                  = 401;
	idd_Static1                     = 402;
	idd_Static2                     = 403;
	idd_Static3                     = 404;
	idd_Install                     = 405;

	{*** Menu ID's ***}
	idm_About                       = 701;
	idm_EditInstallHotKey           = 702;
	idm_RemoveHotKey                = 703;

	{*** User defined messages ***}
	wm_Hotkey                       = wm_User + 1;
	wm_InstallHotKey                = wm_User + 2;

	{*** Speaks for itself ***}
	AppName : PChar                 = 'HotKey2';

type

	THotKeyStruct = record
		wMenuKey          : Word;
		wControlKey       : Word;
		wShiftKey         : Word;
		wKey              : Word;
		wKeyNum           : Word;
		szText, szKeyName : array[0..30] of Char;
	end;

	PAboutDialog = ^TAboutDialog;
	TAboutDialog = object(TMWCCDialog)
		{***

			TMWCCBmpButton is a BWCC style bitMap button object. TMWCCStatic is a static object
			that displays either raised, recessed or normal static controls. WMDrawItem is required
			to draw the TMWCCBmpButton ownerdraw button object.

		***}
		OkBut    : PMWCCBmpButton;
		ST1, ST2 : PMWCCStatic;
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		procedure SetUpWindow; virtual;
		procedure WMDrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
	end;

	PHotKeyEdit = ^THotKeyEdit;
	THotKeyEdit = object(TEdit)
		{***

			If you make THotKeyEdit a descendant of TMWCCEdit you will get a recessed edit control.

		***}
		procedure DefWndProc (var Msg : TMessage); virtual;
		procedure DisplayHotKey (var wModifierKey : Word);
		procedure ResetHotKey; virtual;
		procedure EraseHotKey; virtual;
	end;

	PHotKeyEditDialog = ^THotKeyEditDialog;
	THotKeyEditDialog = object(TMWCCDialog)
		{***

			THotKeyEditDialog is where you enter the Hotkey combination. It is a descendant of
			TMWCCDialog which is one of the MWCC custom objects. It implements a dialog box that
			has a 3D painted background in either the BWCC pattern, my own Glaze pattern, your own
			pattern or no pattern (will be light gray);

		***}
		EC            : PHotKeyEdit;
		ST1, ST2, ST3 : PMWCCStatic;
		But1, But2    : PMWCCBmpButton;
		constructor Init(AParent: PWindowsObject; AName, ABmp: PChar);
		procedure IDDInstall (var Msg: TMessage); virtual id_First + idd_Install;
		procedure SetUpWindow; virtual;
		procedure WMDrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
	end;

	PHotKeyWindow = ^THotKeyWindow;
	THotKeyWindow = object(TWindow)
		GrayBrush, RedBrush : HBrush;
		GrayBkGround        : Boolean;
		WindowNotActive     : Boolean;
		WinMenu             : HMenu;
		IsHook              : Boolean;
		constructor Init (AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function  GetClassName : PChar; virtual;
		procedure GetWindowClass (var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure IDMEditInstallHotKey (var Msg: TMessage); virtual cm_First + idm_EditInstallHotKey;
		procedure IDMRemoveHotKey (var Msg: TMessage); virtual cm_First + idm_RemoveHotKey;
		procedure IDMAbout (var Msg: TMessage); virtual cm_First + idm_About;
		procedure WMInstallHotKey (var Msg: TMessage); virtual wm_First + wm_InstallHotKey;
		procedure RemoveHotKey; virtual ;
		procedure WMHotKey (var Msg: TMessage); virtual wm_First + wm_HotKey;
		procedure WMTimer  (var Msg: TMessage); virtual wm_First + wm_Timer;
	end;

	PHotKeyApplication = ^THotKeyApplication;
	THotKeyApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

	procedure InstallHook(Wnd: HWnd); far; external 'HK2Hook' Index 1;

	procedure UnInstallHook; far; external 'HK2Hook' Index 2;

var

	HotKeyRec   : THotKeyStruct;
	HLib        : THandle;

{********** THotKeyApplication **********}

procedure THotKeyApplication.InitMainWindow;
begin
	MainWindow := New(PHotKeyWindow, Init(nil, 'HotKey 2 Window - HotKey = None'));
end;

{********** THotKeyWindow **********}

constructor THotKeyWindow.Init(AParent: PWindowsObject; AName: PChar);
begin
	TWindow.Init(AParent, AName);
	{*** Makes the window a nice size for the screen ***}
	Attr.X := GetSystemMetrics(sm_CXScreen) div 6;
	Attr.Y := GetSystemMetrics(sm_CYScreen) div 6;
	Attr.W := GetSystemMetrics(sm_CXScreen) div 3 * 2;
	Attr.H := GetSystemMetrics(sm_CYScreen) div 3 * 2;
	{*** Sets the fields of THotKeyStruc to zero ***}
	HotKeyRec.wMenuKey := 0;
	HotKeyRec.wControlKey := 0;
	HotKeyRec.wShiftKey := 0;
	HotKeyRec.wKey := 0;
	{*** Creates the two brushes used to paint the background ***}
	GrayBrush := CreateSolidBrush (RGB (160, 160, 164));
	RedBrush := CreateSolidBrush (RGB (255, 0, 0));
	{*** Lets the window know that the background is initially Gray ***}
	GrayBkGround := True;
	{*** No hook to start with ***}
	IsHook := False;
end;

destructor THotKeyWindow.Done;
begin
	if IsHook = True then UnInstallHook;
	RemoveHotKey;
	DeleteObject(GrayBrush);
	DeleteObject(RedBrush);
	TWindow.Done;
end;

function THotKeyWindow.GetClassName;
begin
	GetClassName := 'HotKeyWindow';
end;

procedure THotKeyWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TWindow.GetWindowClass(AWndClass);
	AWndClass.hIcon := LoadIcon(HInstance, 'HotKeyEditIcon');
	AWndClass.lpszMenuName := PChar('HotKeyEditMenu');
	AWndClass.HBrBackground := GrayBrush;
end;

procedure THotKeyWindow.SetUpWindow;
begin
	TWindow.SetUpWindow;
end;

procedure THotKeyWindow.IDMEditInstallHotKey(var Msg: TMessage);
{***

	Launches the hotkey dialog box. If the return value is 1 then the install button
	was pressed and the Remove menu item is enabled.

***}
var
	ADlg: PHotKeyEditDialog;
begin
	WinMenu := GetMenu(HWindow);
	ADlg := New(PHotKeyEditDialog, Init(@Self, 'HotKeyEditBox', 'BWCC'));
	if (Application^.ExecDialog(ADlg) = 1) then
		EnableMenuItem(WinMenu, idm_RemoveHotKey, mf_ByCommand  or mf_Enabled);
end;

procedure THotKeyWindow.IDMRemoveHotKey(var Msg: TMessage);
{***

	Removes the  installed hotkey and disables the 'Remove' menu item.

***}
begin
	RemoveHotKey;
	WinMenu := GetMenu(HWindow);
	EnableMenuItem(WinMenu, idm_RemoveHotKey, mf_ByCommand  or mf_Grayed);
end;

procedure THotKeyWindow.IDMAbout(var Msg: TMessage);
begin
	Application^.ExecDialog(New(PABoutDialog, Init(@Self, 'AboutBox', 'BWCC')));
end;

procedure THotKeyWindow.WMInstallHotKey(var Msg: TMessage);
{*** Hook

	InstallHook intstalls the library defined system hook. szCaption sets the new
	caption to include the installed hotkey and SetTimer sets the timer thats used
	to flash the title bar (window).

***}
var
	szCaption : array[0..80] of Char;
	CharStr   : PChar;
begin
	if IsHook = False then
	begin
		IsHook := True;
		InstallHook(HWindow);
		CharStr := HotKeyRec.szText;
		wvsprintf(szCaption, 'HotKey 2 Window - HotKey = %s', CharStr);
		SetTimer(HWindow, idw_Timer, 1000, nil);
		SetWindowText(HWindow, szCaption);
	end
	else
	begin
		{*** Update title

			If the Hook is already installed just the title gets updated.

		***}
		CharStr := HotKeyRec.szText;
		wvsprintf(szCaption, 'HotKey 2 Window - HotKey = %s', CharStr);
		SetWindowText(HWindow, szCaption);
	end;
end;

procedure THotKeyWindow.RemoveHotKey;
{*** Unhook

	 UnInstallhook releases the library defined system hook. SetWindowText restores
	 the previous title. Killtimer removes the timer used to flash the title bar and
	 the FlashWindow function is turned off.

***}
begin
	if IsHook = True then
	begin
		IsHook := False;
		UnInstallhook;
		HotKeyRec.wMenuKey := 0;
		HotKeyRec.wControlKey := 0;
		HotKeyRec.wShiftKey := 0;
		SetWindowText(HWindow, 'HotKey 2 Window - HotKey = None');
		KillTimer(HWindow, idw_Timer);
		if WindowNotActive = True then FlashWindow(HWindow, False);
	end;
end;

procedure THotKeyWindow.WMHotKey(var Msg: TMessage);
{***

	This is the wm_hotkey user defined message that is sent from the library callback function.
	It contains part of the callback function from Hotkey 1. This part checks to make sure
	all of the defined modifier keys are down. If the appropriate modifier keys are down and
	the hotkey is pressed the Msg gets processed.

	wParam holds the virtual key code of the pressed key. I don't exactly understand the
	'32 Bit' structure of lParam. What I do know is that it can be used to get the 'text'
	name of the pressed key. See 'GetKeyNameText' in the Edit control's DefWndProc function.

	To make this useful you would need to collect the name of the key into a buffer, add each
	successive key name to the buffer , and use the text in this buffer to check off against
	a file held list of user defined Hot keys (to launch an application or run a menu item).

***}
label
	Exit;
begin
	{*** Check to see if ALT is part of the shortcut key and pressed ***}
	if HotKeyRec.wMenuKey = 1 then
		if HI(GetKeyState(vk_Menu)) = 0 then goto Exit;
	{*** Check to see if Control is part of the shortcut key and pressed ***}
	if HotKeyRec.wControlKey = 1 then
		if HI(GetKeyState(vk_Control)) = 0 then goto Exit;
	{*** Check to see if Shift is part of the shortcut key and pressed ***}
	if HotKeyRec.wShiftKey = 1 then
		if HI(GetKeyState(vk_Shift)) = 0 then goto Exit;
	with Msg do
	begin
		if (wParam <> vk_Menu) and (wParam <> vk_Control) and (wParam <> vk_Shift) then
		begin
			if GrayBkGround then
				SetClassWord(HWindow, gcw_HBrBackground, RedBrush)
			else
				SetClassWord(HWindow, gcw_HBrBackground, GrayBrush);
			InvalidateRect(HWindow, nil, True);
			UpdateWindow(HWindow);
			GrayBkGround := not GrayBkGround;
		end;
	end;
	Exit:
end;

procedure THotKeyWindow.WMTimer(var Msg: TMessage);
begin
	if Msg.WParam = idw_Timer then
		WindowNotActive := FlashWindow(HWindow, True);
end;

{********** THotKeyEditDialog **********}

constructor THotKeyEditDialog.Init(AParent: PWindowsObject; AName, ABmp: PChar);
{***

	This dialog displays the familiar BWCC pattern and bitmapped style buttons without BWCC.dll.

	Any MWCC object used in your program must have a unique id numder and be initialised.
	You can't just place them there with a -1 id like you can when you use BWCC.dll.

	Here 3 TMWCCStatic objects are initialised and used to display a recessed frame.
	You could display a raised frame by replacing 'ctl_Recessed' with 'ctl_Raised'. Since
	they're used as frames their text length is set to zero.

	TMWCCStatic is always light gray in colour. If you wanted to use it for text you would
	set the appropiate text length and use 'ctl_Static' constant. TMWCCStatic text objects
	are always flat.

	'ctl_Flush' paints a border around  a bitmapped button so that it appears reccessed.
	 If you don't want a recessed button enter '0' instead. The second last field, the number's
	 23 and 2 identify one of the predefined bitmapped buttons in MWCC.dll. 2 is the cancel
	 button and 23 is the install button. The buttons use the BWCC style and numbering system.

	 I use 'GetSystemMetrics(sm_CYSize) = 26' to test for screen resolution. When you use
	 bitmaps in dialogs there size and positon doesn't change between screen resolutions but
	 the size of the dialog box does. This results in skewed controls - say if you design a
	 dialog in vga or supervga (fonts.fon=vgasys.fon in system.ini) and the user displays the
	 dialog in extended vga (fonts.fon=8514sys.fon in system.ini). The menu bar bitmap is
	 26 pixels high in extended vga (1024 * 768) and less in vga and supervga. If sm_CYSize = 26
	 I move the buttons so that the dialog box looks right.

***}
begin
	TMWCCDialog.Init(AParent, AName, ABmp);
	ST1 := New(PMWCCStatic, InitResource(@Self, idd_Static1, 0, ctl_Recessed));
	ST2 := New(PMWCCStatic, InitResource(@Self, idd_Static2, 0, ctl_Recessed));
	ST3 := New(PMWCCStatic, InitResource(@Self, idd_Static3, 0, ctl_Recessed));
	EC := New(PHotKeyEdit, InitResource(@Self, idd_HotkeyEdit, 30));
	if GetSystemMetrics(sm_CYSize) = 26 then
	begin
		But1 := New(PMWCCBmpButton, Init(@Self, idd_Install, 108, 284, False, 101, ctl_Flush));
		But2 := New(PMWCCBmpButton, Init(@Self, id_Cancel, 296, 284, False, 2, ctl_Flush));
	end
	else
	begin
		But1 := New(PMWCCBmpButton, Init(@Self, idd_Install, 70, 227, False, 101, ctl_Flush));
		But2 := New(PMWCCBmpButton, Init(@Self, id_Cancel, 220, 227, False, 2, ctl_Flush));
	end;
end;

procedure THotKeyEditDialog.SetUpWindow;
{***

	CenterOverClient is a useful procedure found in MWCC.dll. It centres the dialog over
	the client area of the parent window. EnableWindow ensures the install button is disabled
	when the dialog fist appears.

***}
begin
	TMWCCDialog.SetUpWindow;
	CenterOverClient(Parent^.HWindow, HWindow);
	EnableWindow(But1^.HWindow, False);
end;

procedure THotKeyEditDialog.WMDrawItem(var Msg:tMessage);
{***

	WMDrawItem draws the ownerdraw button object TMWCCBmpButton. Without it you would only see a
	blank square.

***}
begin
  with PDrawItemStruct(Msg.lParam)^ do
    case CtlType of
      odt_Button:
        case CtlID of
					idd_Install : But1^.DrawItem(Msg);
					id_Cancel : But2^.DrawItem(Msg);
				end;
    end;
end;

procedure THotKeyEditDialog.IDDInstall(var Msg: TMessage);
{***

	This is the install button. When pressed the text in the edit control is copied to
	the szText field of HotKeyRec. The user defined wm_InstallHotKey message is sent to the
	mainwindow to install the hot key.

***}
begin
	EC^.GetLine(HotKeyRec.szText, 30, 1);
	PostMessage(Parent^.HWindow, wm_InstallHotKey, 0, 0);
	EndDlg(1);
end;

{********** THotKeyEdit **********}

procedure THotKeyEdit.DefWndProc(Var Msg : TMessage);
{***

	This is where the action starts. I was able to replace the difficult to understand C stuff
	with this function. It lets you intercept KeyBoard messages before DefWndProc handles
	them. When a wm_Keydown or wm_SysKeyDown message occurs wModifierkey is set to that key.
	If a modifier key (Ctrl, Shift or Alt) was not pressed or if only the shift key was pressed
	the input is ignored. If the backspace key is pressed or if other unwanted keyboard
	input occurs the entry is erased, otherwise the hotkey is displayed.

***}
var
	wModifierKey : Word;
begin
	with Msg do
		if (Message = wm_KeyDown) or (Message = wm_SysKeyDown) then
		begin
			wModifierKey := 0;
			HotKeyRec.wKeyNum := Msg.wParam;
			{***

				Get key name and copy it into the HotKeyRec.szKeyName bufferfor use in 'DisplayHotkey'.

			***}
			if (GetKeyNameText(Msg.lParam, HotKeyRec.szKeyName, sizeof(HotKeyRec.szKeyName))) = 0 then
				HotKeyRec.szKeyName[0] := #0;
			{*** Ignore key if one of the modifier keys is not pressed ***}
			if (HI(GetKeyState(vk_Menu)) <> 0) or (HI(GetKeyState(vk_Control)) <> 0) or
					 (HI(GetKeyState(vk_Shift)) <> 0) then
				wModifierKey := Msg.wParam;
			{*** Ignore key if it's a reserved key ***}
			if (Msg.wParam = vk_Tab) or (Msg.wParam = vk_Escape) or
				 (Msg.wParam = vk_Return) or (Msg.wParam = vk_Space) then EraseHotKey
			else
			{*** Erase edit control if backspace key was pressed by itself ***}
			if (Msg.wParam = vk_Back) and (wModifierKey = 0) then
			begin
				EraseHotKey;
				EnableWindow(GetDlgItem(Parent^.HWindow, idd_Install), False);
			end
			else
			if wModifierKey <> 0 then
				{*** Pass key to DisplayHotkey function ***}
				DisplayHotKey(wModifierKey);
		end
		else
		if (Message = wm_KeyUp) or (Message = wm_SysKeyUp) or
			 (Message = wm_Char) or (Message = wm_SysChar) then
		begin
			{*** Pass reserved key input onto DefWndProc for normal processing ***}
			if (Msg.wParam = vk_Return) or (Msg.wParam = vk_Escape) or (Msg.wParam = vk_Tab) then
				TEdit.DefWndProc(Msg);
			{***

				If only a modifier key was pressed and released or if only the shift key
				modifier is pressed ignore keys and erase edit control entry.

			***}
			if (HotKeyRec.wKey = 0) or ((HotKeyRec.wShiftKey = 1) and (HotKeyRec.wMenuKey = 0) and
				 (HotKeyRec.wControlKey = 0) and (Msg.Message = wm_KeyUp)) then
				EraseHotKey;
		end
		else
			TEdit.DefWndProc(Msg);
end;

procedure THotKeyEdit.DisplayHotKey(var wModifierKey: Word);
{***

	This function displays the Hotkey in then edit control. It's slightly different from the
	original C program but it does the same job. It first makes sure the install button is
	disabled and sets szHotKey buffer to zero. DisplayHotkey gets run everytime a valid key
	is pressed. If the edit control is empty (like when you open or reopen the dialog) the
	modifier key fields of THotKeyStruc are set to zero. This is so this example functions
	properly. If a valid key is pressed its name is added to the szHotKey buffer and szHotKey
	is set as the edit control text (the C Way). .

***}
var
	szHotKey      : array[0..30] of Char;
	iHotKeyStrLen : Integer;
	EditWnd       : HWnd;
	wKeyNum       : Word;
begin
	szHotKey[0] := #0;
	wKeyNum := HotKeyRec.wKeyNum;
	EnableWindow((GetDlgItem(Parent^.HWindow, idd_Install)), False);
	if GetlineLength(1) = 0 then ResetHotKey;
	if (HI(GetKeyState(vk_Menu)) <> 0) then
		StrCopy(szHotKey, 'Alt');
	if (HI(GetKeyState(vk_Control)) <> 0) then
	begin
		if (HI(GetKeyState(vk_Menu)) <> 0) then
			StrCat(szHotKey, '+Ctrl')
		else
			StrCopy(szHotKey, 'Ctrl');
	end;
	if (HI(GetKeyState(vk_Shift)) <> 0) then
	begin
		if (HI(GetKeyState(vk_Menu)) <> 0) or
		 (HI(GetKeyState(vk_Control)) <> 0) then
			StrCat(szHotKey, '+Shift')
		else
			StrCopy(szHotKey, 'Shift');
	end;
	EditWnd := (GetDlgItem(Parent^.HWindow, idd_HotKeyEdit));
	SetWindowText(EditWnd, szHotKey);
	{*** Set caret to the end of the line ***}
	iHotKeyStrLen := StrLen(szHotKey);
	SendMessage(EditWnd, em_SetSel, 0, MakeLong(iHotKeyStrLen, iHotKeyStrLen));
	{***

		Sets the value of the modifier key fields in THotKeyStruc to '1'. These
		fields are checked by the callback function everytime a key is pressed.

	***}
	if wModifierKey = vk_Menu then
		HotKeyRec.wMenuKey := 1;
	if wModifierKey = vk_Control then
		HotKeyRec.wControlKey := 1;
	if wModifierKey = vk_Shift then
		HotKeyRec.wShiftKey := 1;
	HotKeyRec.wKey := 0;
	{*** Only let keys other than modifier keys go any further ***}
	if (StrIComp(HotKeyRec.szKeyName, '') <> 0) and
		 ((wKeyNum <> vk_Menu) and (wKeyNum <> vk_Control) and (wkeyNum <> vk_Shift)) then
	begin
		StrCat(szHotKey, '+');
		StrCat(szHotKey, HotKeyRec.szKeyName);
		HotKeyRec.wKey := HotKeyRec.wKeyNum;
		SetWindowText(EditWnd, szHotKey);
		StrCopy(HotKeyRec.szText, szHotKey);
		{***

			Checks to make sure that a single modifier key is not the shift key.
			If it is we ignore it because Windows uses that key. If the key combination
			is valid enable the install button.

		***}
		if (HotKeyRec.wMenuKey = 1) or (HotKeyRec.wControlKey = 1) then
			EnableWindow((GetDlgItem(Parent^.HWindow, idd_Install)), True);
		{*** Sets the caret to the end of the line ***}
		iHotKeyStrLen := StrLen(szHotKey);
		SendMessage(EditWnd, em_SetSel, 0, MakeLong(iHotKeyStrLen, iHotKeyStrLen));
	end;
end;

procedure THotKeyEdit.ResetHotKey;
{*** Reset

	Sets the Hotkey fields to zero

***}
begin
	HotKeyRec.wMenuKey := 0;
	HotKeyRec.wControlKey := 0;
	HotKeyRec.wShiftKey := 0;
	HotKeyRec.wKey := 0;
end;

procedure THotKeyEdit.EraseHotKey;
{***

	Erases the entry in the edit control. (eg when the backspace key is pressed);

***}
begin
	DeleteSubText(0, 30);
	ResetHotKey;
end;

{********** TAboutDialog **********}

constructor TAboutDialog.Init(AParent: PWindowsObject; AName, ABmp: PChar);
{***

	Does the same as the hotkey Edit Dialog box does. It initializes two recessed TMWCCStatic
	objects and the BWCC style 'Ok Button' (id 1) in MWCC.dll.

***}
begin
	TMWCCDialog.Init(AParent, AName, ABmp);
	ST1 := New(PMWCCStatic, InitResource(@Self, idd_Static1, 0, ctl_Recessed));
	ST2 := New(PMWCCStatic, InitResource(@Self, idd_Static2, 0, ctl_Recessed));
	if GetSystemMetrics(sm_CYSize) = 26 then
		OkBut := New(PMWCCBmpButton, Init(@Self, id_Ok, 470, 26, False, 1, ctl_Flush))
	else
		OkBut := New(PMWCCBmpButton, Init(@Self, id_Ok, 356, 22, False, 1, ctl_Flush));
end;

procedure TAboutDialog.SetUpWindow;
begin
	TMWCCDialog.SetUpWindow;
	CenterOverClient(Parent^.HWindow, HWindow);
end;

procedure TAboutDialog.WMDrawItem (var Msg: TMessage);
begin
	with PDrawItemStruct(Msg.lParam)^ do
    case CtlType of
      odt_Button:
        case CtlID of
					id_Ok : OkBut^.DrawItem(Msg);
				end;
    end;
end;

{********** Main program **********}

var
	HKApp: THotKeyApplication;
begin
	HKApp.Init(AppName);
	HKApp.Run;
	HKApp.Done;
end.
