{*** HK1Hook.dll

	This is the library that installs and uninstalls the wh_Keyboard System hook. It needs
	to be in the same directory as the sample program 'Hotkey2.exe'. The library gets called
	by the program directly so there is no import unit.

***}

library HK1Hook;

{$C Fixed Preload Permanent}

uses WinTypes, WinProcs, Win31;

const

	HookInUse         : Boolean  = False;
	HotKeyWnd         : HWnd     = 0 ;
	wm_HotKey                    = wm_User + 1;
	{*** far declaration for Callback function ***}
	pToHotKeyHookProc : TFarProc = nil;

var

	HHotKeyHook : HHook;

{********** wh_Keyboard Callback Function **********}

function HotKeyHookProc(iCode: Integer; wParam: Word; lParam: LongInt): LongInt; Export;
label
	fExit;
begin
	if iCode < 0 then
	begin
		HotKeyHookProc := CallNextHookEx(HHotKeyHook, iCode, wParam, Longint(@lParam));
		Exit;
	end;
	if (iCode = hc_Action) and (wParam <> 0) and (HotKeyWnd <> 0) then
	begin
		{*** Ignore key if it was released or if it's a repeat ***}
		if (lParam = $80000000) or (lParam = $40000000) then
			goto fExit;
		{*** wParam contains the keys virtual key code and lParam can be used to get its name ***}
		PostMessage(HotKeyWnd, wm_HotKey, wParam, lParam);
	end;

	fExit:
	HotKeyHookProc := CallNextHookEx(HHotKeyHook, iCode, WParam, Longint(@LParam));
end;

{********** InstallHook **********}

procedure InstallHook(Wnd: HWnd); export;
begin
	if HookInUse then exit;
	pToHotKeyHookProc := TFarProc(@HotKeyHookProc);
	HHotKeyHook := SetWindowsHookEx(wh_Keyboard, THookProc(pToHotKeyHookProc), hInstance, 0);
	HotKeyWnd := Wnd;
	HookInUse := True;
end;

{********** UnInstallHook **********}

procedure UnInstallHook; export;
begin
	if HookInUse = true then
	begin
		HookInUse := false;
		UnhookWindowsHookEx(HHotKeyHook);
		pToHotKeyHookProc := nil;
		HotKeyWnd := 0;
	end;
end;

exports
	InstallHook   index 1,
	UnInstallHook index 2;

begin
end.
