{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Custom Control Object Library                    		*}
{*                                                                    *}
{*		 Version 1.03                                                 	*}
{*                                                                    *}
{*     Object Windows Library Extension for Borland Pascal v7.0       *}
{*                                                                    *}
{*     and Turbo Pascal for Windows v 1.5                             *}
{*                                                                    *}
{*		 MObjects : Object Unit                             		        *}
{*                                                                    *}
{*     Copyright 1992-93 Microworks (Jeff Franks) Sydney, Australia.  *}
{*                                                                    *}
{**********************************************************************}

unit MObjects;

{$C Moveable DemandLoad Discardable}

interface

uses Wintypes, WinProcs, Win31,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

		ctl_Static        = 50;
		ctl_Recessed      = 51;
		ctl_Raised        = 52;
		ctl_Flush         = 53;
		ctl_LoRes         = 54;
		ctl_HiRes         = 55;

type

	TMinMaxInfo = array [0..4] of TPoint;
	PMinMaxInfo = ^TMinMaxInfo;

	PMWCCStatic = ^TMWCCStatic;
	TMWCCStatic = object(TStatic)
		DefaultFont : HFont;
		constructor Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
											X, Y, W, H: Integer; ATextLen, AShade: Word; IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer;
															ATextLen, AShade: Word);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		StaticShade	: Word;
		CRect       : TRect;
		HasFont     : Boolean;
	end;

	PMWCCBmpButton = ^TMWCCBmpButton;
	TMWCCBmpButton = object(TButton)
		ResHdl : THandle;
		constructor Init(AParent: PWindowsObject; AnID, X, Y: Integer;
										 IsDefault: Boolean; iBmp: Integer; AStyle: Word);
    destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure DrawItem (var Msg:tMessage); virtual wm_First + wm_DrawItem;
		procedure WMSetFocus (var Msg: TMessage); virtual wm_First + wm_SetFocus;
	private
		BM                          : TBitmap;
		UpBmp, DownBmp, FocusBmp    : HBitmap;
		iUpBmp, iDownBmp, iFocusBmp : Integer;
		Style                       : Word;
		Default                     : Boolean;
		CRect        		            : TRect;
	end;

	PMWCCButton = ^TMWCCButton;
	TMWCCButton = object(TButton)
		ResHdl : THandle;
		Constructor Init (AParent: PWindowsObject; AnID: Integer; AText: PChar; X, Y, W, H: Integer;
											ABmp: PChar; AStyle: Word);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure DrawItem (var Msg: TMessage); virtual wm_First + wm_DrawItem;
	private
		Bmp           : HBitmap;
		BM            : TBitMap;
		PBmp          : PChar;
		bmX, bmY, Ofs : Integer;
		DefaultFont   : HFont;
		HasFont       : Boolean;
		Style         : Word;
		WinRect       : TRect;
		szTitle       : array[0..50] of Char;
	end;

	PMWCCGroupBox = ^TMWCCGroupBox;
	TMWCCGroupBox = object(TGroupBox)
		constructor Init (AParent: PWindowsObject; AnId: Integer; AText: PChar; X, Y, W, H: Integer;
											IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer; AText: PChar);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMSize (var Msg: TMessage); virtual wm_First + wm_Size;
		procedure WMEnable (var Msg: TMessage); virtual wm_First + wm_Enable;
	private
		BkStatic, GroupStatic : PMWCCStatic;
		FromResource          : Boolean;
		CRect                 : TRect;
		DefaultFont           : HFont;
		HasFont               : Boolean;
	end;

	PMWCCScrollBar = ^TMWCCScrollBar;
	TMWCCScrollBar = object(TScrollBar)
		constructor Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
											IsHScrollBar: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer);
		destructor Done; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		CRect   : TRect;
	end;

	PMWCCRadioButton = ^TMWCCRadioButton;
	TMWCCRadioButton = object(TRadioButton)
		constructor Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
											X, Y, W, H: Integer; AGroup: PGroupBox; IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMEnable (var Msg: TMessage); virtual wm_First + wm_Enable;
		procedure BMSetCheck (var Msg: TMessage); virtual wm_First + bm_SetCheck;
		procedure BMSetState (var Msg: TMessage); virtual wm_First + bm_SetState;
	private
		CRect       : TRect;
		DefaultFont : HFont;
		HasFont     : Boolean;
	end;

	PMWCCCheckBox = ^TMWCCCheckBox;
	TMWCCCheckBox = object(TCheckBox)
		constructor Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
											X, Y, W, H: Integer; AGroup: PGroupBox; IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMEnable (var Msg: TMessage); virtual wm_First + wm_Enable;
		procedure BMSetCheck (var Msg: TMessage); virtual wm_First + bm_SetCheck;
		procedure BMSetState (var Msg: TMessage); virtual wm_First + bm_SetState;
	private
		CRect       : TRect;
		DefaultFont : HFont;
		HasFont     : Boolean;
	end;

	PMWCCEdit = ^TMWCCEdit;
	TMWCCEdit = object(TEdit)
		constructor Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar; X, Y, W, H,
											ATextLen: Integer; Multiline, IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer; ATextLen: Word);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		CRect       : TRect;
		DefaultFont : HFont;
		HasFont     : Boolean;
	end;

	PMWCCComboBox = ^TMWCCComboBox;
	TMWCCComboBox = object(TComboBox)
		constructor Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
											AStyle, ATextLen: Word; IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer; ATextLen: Word);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		DefaultFont  : HFont;
		HasFont      : Boolean;
		FromResource : Boolean;
	end;

	PMWCCListBox = ^TMWCCListBox;
	TMWCCListBox = object(TListBox)
		constructor Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
											IsBold: Boolean);
		constructor InitResource (AParent: PWindowsObject; AnId: Integer);
		destructor Done; virtual;
		procedure SetupWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		CRect, WinRect : TRect;
		DefaultFont    : HFont;
		HasFont        : Boolean;
	end;

	PMWCCDialog = ^TMWCCDialog;
	TMWCCDialog = object(TDialog)
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		destructor Done; virtual;
		function  GetClassName: PChar; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	private
		BMP, BkBrush   : HBitmap;
		CRect, WinRect : TRect;
		MinMaxInfo     : PMinMaxInfo;
	end;

	PMWCCDlgWindow = ^TMWCCDlgWindow;
	TMWCCDlgWindow = object(TDlgWindow)
		IsSizeable, SFXFrame : Boolean;
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		destructor Done; virtual;
		function  GetClassName: PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		BMP, BkBrush       : HBitmap;
		IsMenu, IsScroller : Boolean;
		CRect, WinRect     : TRect;
		MinMaxInfo         : PMinMaxInfo;
	end;

	PMWCCWindow = ^TMWCCWindow;
	TMWCCWindow = object(TWindow)
		IsSizeable, SFXFrame : Boolean;
		constructor Init (AParent: PWindowsObject; AName, ABmp: PChar);
		destructor Done; virtual;
		function  GetClassName: PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		BMP, BkBrush       : HBitmap;
		IsMenu, IsScroller : Boolean;
		CRect, WinRect     : TRect;
		MinMaxInfo         : PMinMaxInfo;
	end;

	PSFXListBox = ^TSFXListBox;
	TSFXListBox = object(TListBox)
		constructor Init(Aparent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer);
		procedure WMRButtonDown (var Msg: TMessage); virtual wm_First + wm_RButtonDown;
		procedure WMLButtonDown (var Msg: TMessage); virtual wm_First + wm_LButtonDown;
		procedure WMRButtonUp (var Msg: TMessage); virtual wm_First + wm_RButtonUp;
		procedure WMMouseMove (var Msg: TMessage); virtual wm_First + wm_MouseMove;
	private
		DeffaultFont  : HFont;
		IsLeft,	IsSel : Boolean;
		Idx, YPoint   : Integer;
		WinRect       : TRect;
	end;

	PSFXDialog = ^TSFXDialog;
	TSFXDialog = object(TDialog)
		constructor Init (AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		WinRect : TRect;
		szTitle : array[0..144] of char;
	end;

	PSFXDlgWindow = ^TSFXDlgWindow;
	TSFXDlgWindow = object(TDlgWindow)
		IsSizeable : Boolean;
		constructor Init (AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		CtlStyle   : Boolean;
		MinMaxInfo : PMinMaxInfo;
		szTitle    : array[0..144] of char;
		WinRect    : TRect;
	end;

	PSFXWindow = ^TSFXWindow;
	TSFXWindow = object(TWindow)
		IsSizeable : Boolean;
		constructor Init(AParent: PWindowsObject; AName: PChar);
		destructor Done; virtual;
		function 	GetClassName : PChar; virtual;
		procedure GetWindowClass(var AWndClass: TWndClass); virtual;
		procedure SetUpWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
		procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
		procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
		procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
		procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
		procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
		procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
		procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
	private
		MinMaxInfo : PMinMaxInfo;
		szTitle    : array[0..144] of char;
		WinRect    : TRect;
	end;

	function  CreateDefaultFont (IsBold: Boolean): HFont;

	procedure CenterOverClient (ParentWnd, Wnd: HWnd);

	procedure CenterOverWindow (ParentWnd, Wnd: HWnd);

	procedure CenterOverScreen (Wnd: HWnd);

	procedure Draw3DBorder (Wnd: HWnd; X, Y, W, H: Integer; Shade: Word);

	procedure DrawRadioButton (Wnd: HWnd; X, Y: Integer; Resolution: Word);

	procedure DrawButton (Wnd: HWnd; Title: PChar; Bmp: HBitmap; Style: Word; lparam: LongInt);

	procedure DrawBmpButton (Wnd: HWnd; UpBmp, DownBmp, FocusBmp: HBitmap; Style: Word;
													 lparam: LongInt);

	procedure Draw3DFrame (Wnd: HWnd);

	procedure DrawSFXFrame (Wnd: HWnd);

	procedure DrawComboBox (Wnd: HWnd; FromResource: Boolean);

implementation

const

	idw_Static     = 56;
	idw_BkStatic   = 57;
	HLib : THandle = 0;

{********** External functions and procedures **********}

function  CreateDefaultFont; external 'MWCC' Index 1;

procedure CenterOverClient; external 'MWCC' Index 2;

procedure CenterOverWindow; external 'MWCC' Index 3;

procedure CenterOverScreen; external 'MWCC' Index 4;

procedure Draw3DBorder; external 'MWCC' Index 5;

procedure DrawRadioButton; external 'MWCC' Index 6;

procedure DrawButton; external 'MWCC' Index 7;

procedure DrawBmpButton; external 'MWCC' Index 8;

procedure Draw3DFrame; external 'MWCC' Index 9;

procedure DrawSFXFrame; external 'MWCC' Index 10;

procedure DrawComboBox; external 'MWCC' Index 14;

{********** TSFXWindow **********}

constructor TSFXWindow.Init (AParent: PWindowsObject; AName: PChar);
begin
	TWindow.Init(AParent, AName);
	HLib := LoadLibrary ('MWCC.dll');
	Attr.Style := ws_PopupWindow or ws_Caption or ws_ThickFrame or ws_MinimizeBox or
								ws_MaximizeBox or ws_Visible and not ws_VScroll and not ws_HScroll;
	IsSizeable := True;
end;

destructor TSFXWindow.Done;
begin
	if HLib >= 32 then FreeLibrary(HLib);
	TWindow.Done;
end;

function TSFXWindow.GetClassName;
begin
	GetClassName := 'SFXWindow';
end;

procedure TSFXWindow.GetWindowClass (var AWndClass: TWndClass);
begin
	TWindow.GetWindowClass(AWndClass);
	AWndClass.HBrBackground := GetStockObject(LtGray_Brush);
end;

procedure TSFXWindow.SetUpWindow;
var
	lStyle : LongInt;
begin
	TWindow.SetupWindow;
	lStyle := GetWindowLong (HWindow, gwl_Style);
	if lStyle = lStyle or ws_VScroll then lStyle := lStyle and not ws_VScroll;
	if lStyle = lStyle or ws_HScroll then lStyle := lStyle and not ws_HScroll;
	if lStyle = lStyle and not ws_ThickFrame then lStyle := lStyle or ws_ThickFrame;
	SetWindowLong (HWindow, gwl_Style, lStyle);
	if GetMenu(HWindow) <> 0 then
	begin
		DestroyMenu(GetMenu(HWindow));
		DrawMenuBar(HWindow);
	end;
end;

procedure TSFXWindow.WMPaint (var Msg: TMessage);
begin
	TWindow.WMPaint(Msg);
	DrawSFXFrame(HWindow);
end;

procedure TSFXWindow.WMNCPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	GetWindowText(HWindow, szTitle, sizeof(szTitle));
	SetWindowText(HWindow, szTitle);
	Msg.Result := 1;
end;

procedure TSFXWindow.WMNCCalcSize (var Msg: TMessage);
type
	CRect = array[0..2] of TRect;
	PRect = ^CRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXWindow.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TWindow.DefWndProc(Msg);
	end;
end;

procedure TSFXWindow.WMActivate (var Msg: TMessage);
begin
	TWindow.WMActivate(Msg);
	DrawSFXFrame(HWindow);
end;

procedure TSFXWindow.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TWindow.DefWndProc(Msg);
end;

procedure TSFXWindow.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TWindow.DefWndProc(Msg);
end;

procedure TSFXWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	longInt(MinMaxInfo) := Msg.lParam;
	if IsSizeable then
	begin
		MinMaxInfo^[1].X :=  GetSystemMetrics(sm_CXScreen);
		MinMaxInfo^[1].Y :=  GetSystemMetrics(sm_CYScreen);
		MinMaxInfo^[2].X :=  0;
		MinMaxInfo^[2].Y :=  0;
	end
	else
	begin
		GetWindowRect(HWindow, WinRect);
		if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
		begin
			MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
		end;
	end;
end;

{********** TSFXDlgWindow **********}

constructor TSFXDlgWindow.Init (AParent: PWindowsObject; AName: PChar);
begin
	TDlgWindow.Init(AParent, AName);
	HLib := LoadLibrary ('MWCC.dll');
	IsSizeable := True;
end;

destructor TSFXDlgWindow.Done;
begin
	if HLib >= 32 then FreeLibrary(HLib);
	TDlgWindow.Done;
end;

function TSFXDlgWindow.GetClassName;
begin
	GetClassName := 'SFXDlgWindow';
end;

procedure TSFXDlgWindow.SetUpWindow;
var
	lStyle : LongInt;
begin
	TDlgWindow.SetUpWindow;
	lStyle := GetWindowLong (HWindow, gwl_Style);
	if lStyle = lStyle or ws_VScroll then lStyle := lStyle and not ws_VScroll;
	if lStyle = lStyle or ws_HScroll then lStyle := lStyle and not ws_HScroll;
	if lStyle = lStyle and not ws_ThickFrame then lStyle := lStyle or ws_ThickFrame;
	SetWindowLong (HWindow, gwl_Style, lStyle);
	if GetMenu(HWindow) <> 0 then
	begin
		DestroyMenu(GetMenu(HWindow));
		DrawMenuBar(HWindow);
	end;
end;

procedure TSFXDlgWindow.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg, CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDlgWindow.DefWndProc(Msg);
	end;
end;

procedure TSFXDlgWindow.WMPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TSFXDlgWindow.WMNCPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	GetWindowText(HWindow, szTitle, sizeof(szTitle));
	SetWindowText(HWindow, szTitle);
	Msg.Result := 1;
end;

procedure TSFXDlgWindow.WMNCCalcSize (var Msg: TMessage);
type
	CRect = array[0..2] of TRect;
	PRect = ^CRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXDlgWindow.WMActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TSFXDlgWindow.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TSFXDlgWindow.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TSFXDlgWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	longInt(MinMaxInfo) := Msg.lParam;
	if IsSizeable then
	begin
		MinMaxInfo^[1].X :=  GetSystemMetrics(sm_CXScreen);
		MinMaxInfo^[1].Y :=  GetSystemMetrics(sm_CYScreen);
		MinMaxInfo^[2].X :=  0;
		MinMaxInfo^[2].Y :=  0;
	end
	else
	begin
		GetWindowRect(HWindow, WinRect);
		if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
		begin
			MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
		end;
	end;
end;

{********** TSFXDialog **********}

constructor TSFXDialog.Init (AParent: PWindowsObject; AName: PChar);
begin
	TDialog.Init(AParent, AName);
	HLib := LoadLibrary ('MWCC.dll');
end;

destructor TSFXDialog.Done;
begin
	if HLib >= 32 then FreeLibrary(HLib);
	TDialog.Done;
end;

function TSFXDialog.GetClassName;
begin
	GetClassName := 'SFXDialog';
end;

procedure TSFXDialog.SetUpWindow;
var
	SysMenu : HMenu;
	lStyle  : LongInt;
begin
	TDialog.SetUpWindow;
	SysMenu := GetSystemMenu(HWindow, False);
	RemoveMenu(SysMenu, 0, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 1, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	RemoveMenu(SysMenu, 2, mf_ByPosition);
	lStyle := GetWindowLong (HWindow, gwl_Style);
	if lStyle = lStyle or ws_VScroll then lStyle := lStyle and not ws_VScroll;
	if lStyle = lStyle or ws_HScroll then lStyle := lStyle and not ws_HScroll;
	if lStyle = lStyle and not ws_ThickFrame then lStyle := lStyle or ws_ThickFrame;
	SetWindowLong (HWindow, gwl_Style, lStyle);
	if GetMenu(HWindow) <> 0 then
	begin
		DestroyMenu(GetMenu(HWindow));
		DrawMenuBar(HWindow);
	end;
end;

procedure TSFXDialog.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg, CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDialog.DefWndProc(Msg);
	end;
end;

procedure TSFXDialog.WMPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDialog.DefWndProc(Msg);
end;

procedure TSFXDialog.WMNCPaint (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	GetWindowText(HWindow, szTitle, sizeof(szTitle));
	SetWindowText(HWindow, szTitle);
	Msg.Result := 1;
end;

procedure TSFXDialog.WMNCCalcSize (var Msg: TMessage);
type
	CRect = array[0..2] of TRect;
	PRect = ^CRect;
begin
	Inc(PRect(Msg.lParam)^[0].Top, 1);
	DefWindowProc(HWindow, wm_NCCalcSize, Msg.wParam, Msg.lParam);
end;

procedure TSFXDialog.WMActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDialog.DefWndProc(Msg);
end;

procedure TSFXDialog.WMNCActivate (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDialog.DefWndProc(Msg);
end;

procedure TSFXDialog.WMActivateApp (var Msg: TMessage);
begin
	DrawSFXFrame(HWindow);
	TDialog.DefWndProc(Msg);
end;

procedure TSFXDialog.WMGetMinMaxInfo (var Msg: TMessage);
type
	TMinMaxInfo = array [0..4] of TPoint;
	PMinMaxInfo = ^TMinMaxInfo;
var
	MinMaxInfo : PMinMaxInfo;
	buf : array [0..10] of Char;
begin
	longInt(MinMaxInfo) := Msg.lParam;
	GetWindowRect(HWindow, WinRect);
	if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
	begin
		MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
		MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
		MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
	end;
end;

{********** TSFXListBox **********}

constructor TSFXListBox.Init(Aparent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer);
begin
	TListbox.Init(Aparent, AnId, X, Y, W, H);
	Attr.Style := Attr.Style or lbs_MultipleSel;
	IsLeft := True;
	IsSel  := False;
end;

procedure TSFXListBox.WMRButtonDown (var Msg: TMessage);
begin
	IsLeft := False;
	Idx := (Msg.lParamHi div SendMessage(HWindow, lb_GetItemHeight, Idx, 0)) +
					SendMessage(HWindow, lb_GetTopIndex, 0, 0);
	YPoint := Msg.lParamHi;
	SendMessage(HWindow, wm_LButtonDown, Msg.wParam, Msg.lParam);
	if SendMessage(HWindow, lb_GetSel, Idx, 0) > 0 then
		IsSel := True
	else
		IsSel := False;
end;

procedure TSFXListBox.WMLButtonDown (var Msg: TMessage);
begin
	Idx := (Msg.lParamHi div SendMessage(HWindow, lb_GetItemHeight, Idx, 0)) +
					SendMessage(HWindow, lb_GetTopIndex, 0, 0);
	if Idx >= GetCount then Exit;
	if IsLeft then
	begin
		if (GetSelIndex = Idx) and (SendMessage(HWindow, lb_GetSel, Idx, 0) > 0) and
			 (GetCount = 1) then Exit;
		SendMessage(HWindow, lb_SetCaretIndex, Idx, 0);
		SendMessage(HWindow, lb_SetSel, 0, -1);
		SendMessage(HWindow, lb_SetSel, 1, Idx);
	end
	else
		TListbox.DefWndProc(Msg);
end;

procedure TSFXListBox.WMRButtonUp (var Msg: TMessage);
begin
	SendMessage(HWindow, wm_LButtonUp, Msg.wParam, Msg.lParam);
	IsLeft := True;
	if not IsSel then
		IsSel := True
	else
		IsSel := False;
end;

procedure TSFXListBox.WMMouseMove (var Msg: TMessage);
begin
	if IsLeft then Exit;
	if Msg.wParam = mk_RButton then
	begin
		Idx := (Msg.lParamHi div SendMessage(HWindow, lb_GetItemHeight, Idx, 0)) +
						SendMessage(HWindow, lb_GetTopIndex, 0, 0);
		if Idx = SendMessage(HWindow, lb_GetCaretIndex, 0, 0) then
			Exit
		else
		begin
			if IsSel then
			begin
				if SendMessage(HWindow, lb_GetSel, Idx, 0) = 0 then
					SendMessage(HWindow, lb_SetSel, 1, Idx);
				if (Msg.lParamHi > YPoint) then
				begin
					while Idx < GetCount do
					begin
						if SendMessage(HWindow, lb_GetSel, Idx+1, 0) > 0 then
							SendMessage(HWindow, lb_SetSel, 0, Idx+1);
						Inc(Idx);
					end;
				end;
				if (Msg.lParamHi < YPoint) then
				begin
					while Idx > 0 do
					begin
						if SendMessage(HWindow, lb_GetSel, Idx-1, 0) > 0 then
							SendMessage(HWindow, lb_SetSel, 0, Idx-1);
						Dec(Idx);
					end;
				end;
			end
			else
				SendMessage(HWindow, lb_SetSel, 0, Idx);
		end;
	end;
	TListbox.DefWndProc(Msg);
end;

{********** TMWCCWindow **********}

constructor TMWCCWindow.Init (AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TWindow.Init(AParent, AName);
	HLib := LoadLibrary ('MWCC.dll');
	if HLib >= 32 then Bmp := LoadBitmap(HLib, ABmp);
	if Bmp <> 0 then BkBrush := CreatePatternBrush(Bmp);
	Attr.Style := ws_PopupWindow or ws_Caption or ws_ThickFrame or ws_MinimizeBox or
								ws_MaximizeBox or ws_Visible and not ws_VScroll and not ws_HScroll;
	SFXFrame := False;
	IsSizeable := True;
	IsScroller := False;
	IsMenu := False;
end;

destructor TMWCCWindow.Done;
begin
	if Bmp <> 0 then
	begin
		DeleteObject(Bmp);
		DeleteObject(BkBrush);
	end;
	if HLib >= 32 then FreeLibrary(HLib);
	TWindow.Done;
end;

function TMWCCWindow.GetClassName: PChar;
begin
	GetClassName := 'MWCCWindow';
end;

procedure TMWCCWindow.GetWindowClass(var AWndClass: TWndClass);
begin
	TWindow.GetWindowClass(AWndClass);
	if Bmp <> 0 then
		AWndClass.HBrBackground := BkBrush
	else
		AWndClass.HBrBackground := GetStockObject(LtGray_Brush);
end;

procedure TMWCCWindow.SetUpWindow;
var
	lStyle : LongInt;
begin
	TWindow.SetUpWindow;
	lStyle := GetWindowLong (HWindow, gwl_Style);
	if (lStyle = lStyle or ws_VScroll) or (lStyle = lStyle or ws_HScroll) then
		IsScroller := True;
	if GetMenu(HWindow) <> 0 then
		IsMenu := True;
end;

procedure TMWCCWindow.WMCtlColor(var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TWindow.DefWndProc(Msg);
	end;
end;

procedure TMWCCWindow.WMPaint (var Msg: TMessage);
var
	W, H: Integer;
begin
	TWindow.WMPaint(Msg);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
	if SFXFrame then Draw3DFrame(HWindow);
end;

procedure TMWCCWindow.WMNCPaint (var Msg: TMessage);
var
	szTitle : array[0..50] of Char;
begin
	if SFXFrame then Draw3DFrame(HWindow);
	if IsScroller or IsMenu or (not SFXFrame) then
		TWindow.DefWndProc(Msg)
	else
	begin
		GetWindowText(HWindow, szTitle, sizeof(szTitle));
		SetWindowText(HWindow, szTitle);
		Msg.Result := 1;
	end;
end;

procedure TMWCCWindow.WMActivate (var Msg: TMessage);
begin
	TWindow.WMActivate(Msg);
	if SFXFrame then Draw3DFrame(HWindow);
end;

procedure TMWCCWindow.WMNCActivate (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TWindow.DefWndProc(Msg);
end;

procedure TMWCCWindow.WMActivateApp (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TWindow.DefWndProc(Msg);
end;

procedure TMWCCWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	longInt(MinMaxInfo) := Msg.lParam;
	if IsSizeable and SFXFrame then
	begin
		MinMaxInfo^[1].X :=  GetSystemMetrics(sm_CXScreen);
		MinMaxInfo^[1].Y :=  GetSystemMetrics(sm_CYScreen);
		MinMaxInfo^[2].X :=  0;
		MinMaxInfo^[2].Y :=  0;
	end
	else
	if IsSizeable and not SFXFrame then
		TWindow.DefWndProc(Msg)
	else 
	begin
		GetWindowRect(HWindow, WinRect);
		if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
		begin
			MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
		end;
	end;
end;

{********** TMWCCDlgWindow **********}

constructor TMWCCDlgWindow.Init (AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TDlgWindow.Init(AParent, AName);
	HLib := LoadLibrary ('MWCC.dll');
	if HLib >= 32 then Bmp := LoadBitmap(HLib, ABmp);
	if Bmp <> 0 then BkBrush := CreatePatternBrush(Bmp);
	SFXFrame := False;
	IsSizeable := True;
	IsScroller := False;
	IsMenu := False;
end;

destructor TMWCCDlgWindow.Done;
begin
	if Bmp <> 0 then
	begin
		DeleteObject(Bmp);
		DeleteObject(BkBrush);
	end;
	if HLib >= 32 then FreeLibrary(HLib);
	TDlgWindow.Done;
end;

function TMWCCDlgWindow.GetClassName: PChar;
begin
	GetClassName := 'MWCCDlgWindow';
end;

procedure TMWCCDlgWindow.SetUpWindow;
var
	lStyle : LongInt;
begin
	TDlgWindow.SetUpWindow;
	lStyle := GetWindowLong (HWindow, gwl_Style);
	if (lStyle = lStyle or ws_VScroll) or (lStyle = lStyle or ws_HScroll) then
		IsScroller := True;
	if GetMenu(HWindow) <> 0 then
		IsMenu := True;
end;

procedure TMWCCDlgWindow.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg:
		begin
			SetBkMode(Msg.WParam, Transparent);
			if Bmp <> 0 then
				Msg.Result := BkBrush
			else
				Msg.Result := GetStockObject(LtGray_Brush);
		end;
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDlgWindow.DefWndProc(Msg);
	end;
end;

procedure TMWCCDlgWindow.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
	EndPaint(HWindow, PS);
end;

procedure TMWCCDlgWindow.WMNCPaint (var Msg: TMessage);
var
	szTitle : array[0..50] of Char;
begin
	if SFXFrame then Draw3DFrame(HWindow);
	if IsScroller or IsMenu or (not SFXFrame) then
		TDlgWindow.DefWndProc(Msg)
	else
	begin
		GetWindowText(HWindow, szTitle, sizeof(szTitle));
		SetWindowText(HWindow, szTitle);
		Msg.Result := 1;
	end;
end;

procedure TMWCCDlgWindow.WMActivate (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TMWCCDlgWindow.WMNCActivate (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TMWCCDlgWindow.WMActivateApp (var Msg: TMessage);
begin
	if SFXFrame then Draw3DFrame(HWindow);
	TDlgWindow.DefWndProc(Msg);
end;

procedure TMWCCDlgWindow.WMGetMinMaxInfo (var Msg: TMessage);
begin
	longInt(MinMaxInfo) := Msg.lParam;
	if IsSizeable and SFXFrame then
	begin
		MinMaxInfo^[1].X :=  GetSystemMetrics(sm_CXScreen);
		MinMaxInfo^[1].Y :=  GetSystemMetrics(sm_CYScreen);
		MinMaxInfo^[2].X :=  0;
		MinMaxInfo^[2].Y :=  0;
	end
	else
	if IsSizeable and not SFXFrame then
		TDlgWindow.DefWndProc(Msg)
	else 
	begin
		GetWindowRect(HWindow, WinRect);
		if ((WinRect.Right-WinRect.Left) > 36) and ((WinRect.Bottom-WinRect.Top) > 36) then
		begin
			MinMaxInfo^[1].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[1].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[3].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[3].Y :=  WinRect.Bottom - WinRect.Top;
			MinMaxInfo^[4].X :=  WinRect.Right - WinRect.Left;
			MinMaxInfo^[4].Y :=  WinRect.Bottom - WinRect.Top;
		end;
	end;
end;

{********** TMWCCDialog **********}

constructor TMWCCDialog.Init (AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TDialog.Init(AParent, AName);
	HLib := LoadLibrary ('MWCC.dll');
	if HLib >= 32 then Bmp := LoadBitmap(HLib, ABmp);
	if Bmp <> 0 then BkBrush := CreatePatternBrush(Bmp);
end;

destructor TMWCCDialog.Done;
begin
	if Bmp <> 0 then
	begin
		DeleteObject(Bmp);
		DeleteObject(BkBrush);
	end;
	if HLib >= 32 then FreeLibrary(HLib);
	TDialog.Done;
end;

function TMWCCDialog.GetClassName: PChar;
begin
	GetClassName := 'MWCCDialog';
end;

procedure TMWCCDialog.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Dlg:
		begin
			SetBkMode(Msg.WParam, Transparent);
			if Bmp <> 0 then
				Msg.Result := BkBrush
			else
				Msg.Result := GetStockObject(LtGray_Brush);
		end;
		CtlColor_Btn, CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end;
	else
		TDialog.DefWndProc(Msg);
	end;
end;

procedure TMWCCDialog.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 1, 1, W-2, H-2, ctl_Raised);
	EndPaint(HWindow, PS);
end;

{********** TMWCCListBox **********}

constructor TMWCCListBox.Init (AParent: PWindowsObject; AnId: Integer;
															 X, Y, W, H: Integer; IsBold: Boolean);
begin
	TListBox.Init(AParent, AnID, X, Y, W, H);
	HLib := LoadLibrary ('MWCC.dll');
	Attr.Style  := Attr.Style or lbs_DisableNoScroll;
	DefaultFont := CreateDefaultFont(IsBold);
	HasFont  := True;
end;

constructor TMWCCListBox.InitResource (AParent: PWindowsObject; AnId: Integer);
begin
	TListBox.InitResource(AParent, AnID);
	HLib := LoadLibrary ('MWCC.dll');
	HasFont := False;
end;

destructor TMWCCListBox.Done;
begin
	if HasFont then DeleteObject(DefaultFont);
	if HLib >= 32 then FreeLibrary(HLib);
	TListBox.Done;
end;

procedure TMWCCListBox.SetupWindow;
var
	CPt1, CPt2 : TPoint;
begin
	TListBox.SetupWindow;
	if HasFont then SendMessage(HWindow, wm_SetFont, DefaultFont, 1);
	GetWindowRect(HWindow, WinRect);
	with WinRect do
	begin
		CPt1.X := Left;
		CPt1.Y := Top;
		CPt2.X := Right;
		CPt2.Y := Bottom;
	end;
	ScreenToClient(Parent^.HWindow, CPt1);
	ScreenToClient(Parent^.HWindow, CPt2);
	SetWindowPos(HWindow, 0, CPt1.X+2, CPt1.Y+2, (CPt2.X-CPt1.X)-4, (CPt2.Y-CPt1.Y)-4, swp_NoZOrder);
	UpdateWindow(Parent^.HWindow);
end;

procedure TMWCCListBox.WMPaint (var Msg: TMessage);
var
	PS     : TPaintstruct;
	W, H   : Integer;
	lStyle : LongInt;
begin
	TListBox.WMPaint(Msg);
	lStyle := GetWindowLong(HWindow, gwl_Style);
	GetClientRect (HWindow, CRect);
	W := CRect.Right + GetSystemMetrics(sm_CXVScroll) - 1;
	if (lStyle = lStyle or ws_HScroll) then
		H := CRect.Bottom + GetSystemMetrics(sm_CYHScroll) - 1
	else
		H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, -1, -1, W+2, H+2, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

{********** TMWCCComboBox **********}

constructor TMWCCComboBox.Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
																AStyle, ATextLen: Word; IsBold: Boolean);
begin
	TComboBox.Init(AParent, AnID, X, Y, W, H, Astyle, ATextLen);
	HLib := LoadLibrary ('MWCC.dll');
	DefaultFont := CreateDefaultFont(IsBold);
	HasFont     := True;
	FromResource := False;
end;

constructor TMWCCComboBox.InitResource (AParent: PWindowsObject; AnId: Integer; ATextlen: Word);
begin
	TComboBox.InitResource(AParent, AnID, ATextLen);
	HLib := LoadLibrary ('MWCC.dll');
	HasFont := False;
	FromResource := True;
end;

destructor TMWCCComboBox.Done;
begin
	if HasFont = True then DeleteObject(DefaultFont);
	if HLib >= 32 then FreeLibrary(HLib);
	TComboBox.Done;
end;

procedure TMWCCComboBox.SetupWindow;
var
	lStyle   : LongInt;
begin
	TComboBox.SetupWindow;
	lStyle := GetWindowLong (HWindow, gwl_Style);
	if lStyle = lStyle or cbs_Simple then
	begin
		lStyle := lStyle or cbs_NoIntegralHeight;
		DefaultFont := CreateDefaultFont(True);
		HasFont     := True;
	end;
	SetWindowLong (HWindow, gwl_Style, lStyle);
	if HasFont then SendMessage(HWindow, wm_SetFont, DefaultFont, 1);
end;

procedure TMWCCComboBox.WMPaint (var Msg: TMessage);
var
	PS : TPaintstruct;
begin
	TComboBox.WMPaint(Msg);
	BeginPaint(HWindow, PS);
	DrawComboBox(HWindow, FromResource);
	EndPaint(HWindow, PS);
end;

{********** TMWCCEdit **********}

constructor TMWCCEdit.Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar; X, Y, W, H,
														ATextLen: Integer; Multiline, IsBold: Boolean);
begin
	TEdit.Init(AParent, AnID, ATitle, X, Y, W, H, ATextlen, Multiline);
	HLib := LoadLibrary ('MWCC.dll');
	DefaultFont := CreateDefaultFont(IsBold);
	HasFont := True;
end;

constructor TMWCCEdit.InitResource (AParent: PWindowsObject; AnId: Integer; ATextLen: Word);
begin
	TEdit.InitResource(AParent, AnID, ATextLen);
	HLib := LoadLibrary ('MWCC.dll');
	HasFont := False;
end;

destructor TMWCCEdit.Done;
begin
	if HasFont then DeleteObject(DefaultFont);
	if HLib >= 32 then FreeLibrary(HLib);
	TEdit.Done;
end;

procedure TMWCCEdit.SetupWindow;
begin
	TEdit.SetupWindow;
	if HasFont then SendMessage(HWindow, wm_SetFont, DefaultFont, 1);
end;

procedure TMWCCEdit.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
	lStyle : LongInt;
begin
	TEdit.WMPaint(Msg);
	lStyle := GetWindowLong (HWindow, gwl_Style);
	GetClientRect(HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	if lStyle = lStyle or es_MultiLine then
	begin
		if lStyle = lStyle or ws_VScroll then
			W := W + GetSystemMetrics(sm_CXVScroll);
		if lStyle = lStyle or ws_VScroll then
			H := H + GetSystemMetrics(sm_CYHScroll);
	end;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 0, 0, W, H, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

{********** TMWCCCheckBox **********}

constructor TMWCCCheckBox.Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
																X, Y, W, H: Integer; AGroup: PGroupBox; IsBold: Boolean);
begin
	TCheckBox.Init(AParent, AnID, ATitle, X, Y, W, H, AGroup);
	HLib := LoadLibrary ('MWCC.dll');
	DefaultFont := CreateDefaultFont(IsBold);
	HasFont := True;
end;

constructor TMWCCCheckBox.InitResource (AParent: PWindowsObject; AnId: Integer);
begin
	TCheckBox.InitResource(AParent, AnID);
	HLib := LoadLibrary ('MWCC.dll');
	HasFont := False;
end;

destructor TMWCCCheckBox.Done;
begin
	if HasFont then DeleteObject(DefaultFont);
	if HLib >= 32 then FreeLibrary(HLib);
	TCheckBox.Done;
end;

procedure TMWCCCheckBox.SetupWindow;
var
	W, H    : Integer;
begin
	TCheckBox.SetupWindow;
	if HasFont then SendMessage(HWindow, wm_SetFont, DefaultFont, 1);
	GetClientRect(HWindow, CRect);
	W := CRect.Right - CRect.Left;
	H := CRect.Bottom - CRect.Top;
	if Odd(H) = True then
	begin
		SetWindowPos(HWindow, 0, 0, 0, W, H + 1, swp_NoMove or swp_NoZOrder);
	end;
end;

procedure TMWCCCheckBox.WMPaint (var Msg: TMessage);
var
	PS : TPaintStruct;
	Y  : Integer;
begin
	TCheckBox.WMPaint(Msg);
	GetClientRect (HWindow, CRect);
	Y := (CRect.Bottom - CRect.Top - 15) div 2 + 1;
	BeginPaint(HWindow, PS);
	if GetSystemMetrics(sm_CYSize) = 26 then
		Draw3DBorder(HWindow, 0, Y-1, 16, 16, ctl_Recessed)
	else
		Draw3DBorder(HWindow, 0, Y, 13, 13, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

procedure TMWCCCheckBox.WMEnable (var Msg: TMessage);
begin
	WMPaint(Msg);
	Msg.Result := 0;
end;

procedure TMWCCCheckBox.BMSetCheck (var Msg: TMessage);
begin
	WMPaint(Msg);
end;

procedure TMWCCCheckBox.BMSetState (var Msg: TMessage);
begin
	WMPaint(Msg);
end;

{********** TMWCCRadioButton **********}

constructor TMWCCRadioButton.Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
																	 X, Y, W, H: Integer; AGroup: PGroupBox; IsBold: Boolean);
begin
	TRadioButton.Init(AParent, AnID, ATitle, X, Y, W, H, AGroup);
	HLib := LoadLibrary ('MWCC.dll');
	DefaultFont := CreateDefaultFont(IsBold);
	HasFont := True;
end;

constructor TMWCCRadioButton.InitResource (AParent: PWindowsObject; AnId: Integer);
begin
	TRadioButton.InitResource(AParent, AnID);
	HLib := LoadLibrary ('MWCC.dll');
	HasFont := False;
end;

destructor TMWCCRadioButton.Done;
begin
	if HasFont then DeleteObject(DefaultFont);
	if HLib >= 32 then FreeLibrary(HLib);
	TRadioButton.Done;
end;

procedure TMWCCRadioButton.SetupWindow;
var
	W, H : Integer;
begin
	TRadioButton.SetupWindow;
	if HasFont then	SendMessage(HWindow, wm_SetFont, DefaultFont, 1);
	GetClientRect(HWindow, CRect);
	W := CRect.Right - CRect.Left;
	H := CRect.Bottom - CRect.Top;
	if Odd(H) = True then
	begin
		SetWindowPos(HWindow, 0, 0, 0, W, H + 1, swp_NoMove or swp_NoZOrder);
	end;
end;

procedure TMWCCRadioButton.WMPaint (var Msg: TMessage);
var
	PS : TPaintStruct;
	Y  : Integer;
begin
	TRadioButton.WMPaint(Msg);
	GetClientRect(HWindow, CRect);
	Y := (CRect.Bottom - CRect.Top - 15) div 2 + 1;
	BeginPaint(HWindow, PS);
	if GetSystemMetrics(sm_CYSize) = 26 then
		DrawRadioButton(HWindow, -3, Y-4, ctl_HiRes)
	else
		DrawRadioButton(HWindow, -3, Y-3, ctl_LoRes);
	EndPaint(HWindow, PS);
end;

procedure TMWCCRadioButton.WMEnable (var Msg: TMessage);
begin
	WMPaint(Msg);
	Msg.Result := 0;
end;

procedure TMWCCRadioButton.BMSetCheck (var Msg: TMessage);
begin
	WMPaint(Msg);
	TRadioButton.DefWndProc(Msg);
end;

procedure TMWCCRadioButton.BMSetState (var Msg: TMessage);
begin
	WMPaint(Msg);
	TRadioButton.DefWndProc(Msg);
end;

{********** TMWCCScrollBar **********}

constructor TMWCCScrollBar.Init (AParent: PWindowsObject; AnId: Integer; X, Y, W, H: Integer;
																 IsHScrollBar: Boolean);
begin
	TScrollBar.Init(AParent, AnId, X, Y, W, H, IsHScrollBar);
	HLib := LoadLibrary ('MWCC.dll');
end;

constructor TMWCCScrollBar.InitResource (AParent: PWindowsObject; AnId: Integer);
begin
	TScrollBar.InitResource(AParent, AnID);
	HLib := LoadLibrary ('MWCC.dll');
end;

destructor TMWCCScrollBar.Done;
begin
	if HLib >= 32 then FreeLibrary(HLib);
	TScrollBar.Done;
end;

procedure TMWCCScrollBar.WMPaint (var Msg: TMessage);
var
	PS   : TPaintStruct;
	W, H : Integer;
begin
	TScrollBar.WMPaint(Msg);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	Draw3DBorder(HWindow, 0, 0, W, H, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

{********** TMWCCGroupBox **********}

constructor TMWCCGroupBox.Init (AParent: PWindowsObject; AnId: Integer; AText: PChar;
									X, Y, W, H: Integer; IsBold: Boolean);
begin
	TGroupBox.Init(AParent, AnID, AText, X, Y, W, H);
	HLib := LoadLibrary ('MWCC.dll');
	GroupStatic :=	New(PMWCCStatic, Init(@Self, idw_Static, AText, 0, 0, 0, 0, 50, ctl_Static, IsBold));
	BkStatic :=	New(PMWCCStatic, Init(@Self, idw_BkStatic, '', 0, 0, 0, 0, 0, ctl_Static, False));
	FromResource := False;
end;

constructor TMWCCGroupBox.InitResource (AParent: PWindowsObject; AnId: Integer; AText: PChar);
begin
	TGroupBox.InitResource(AParent, AnID);
	HLib := LoadLibrary ('MWCC.dll');
	GroupStatic :=	New(PMWCCStatic, Init(@Self, idw_Static, AText, 0, 0, 0, 0, 50, ctl_Static, True));
	BkStatic :=	New(PMWCCStatic, Init(@Self, idw_BkStatic, '', 0, 0, 0, 0, 0, ctl_Static, False));
	FromResource := True;
end;

destructor TMWCCGroupBox.Done;
begin
	if HLib >= 32 then FreeLibrary(HLib);
	TGroupBox.Done;
end;

procedure TMWCCGroupBox.SetupWindow;
var
	W, H:Integer;
	lstyle : longInt;
begin
	TGroupBox.SetupWindow;
	SetCaption(nil);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	if FromResource then
	begin
		SetWindowPos(GroupStatic^.HWindow, 0, 3, 9, W-6, 16, swp_NoZOrder);
		SetWindowPos(BkStatic^.HWindow, 0, 3, 25, W-6, H-28, swp_NoZOrder);
	end
	else
	begin
		SetWindowPos(GroupStatic^.HWindow, 0, 3, 11, W-6, 16, swp_NoZOrder);
		SetWindowPos(BkStatic^.HWindow, 0, 3, 27, W-6, H-28, swp_NoZOrder);
	end;
end;

procedure TMWCCGroupBox.WMCtlColor (var Msg: TMessage);
begin
	case Msg.LParamHi of
		CtlColor_Static:
		begin
			SetBkMode(Msg.WParam, Transparent);
			Msg.Result := GetStockObject(LtGray_Brush);
		end
		else
			TGroupBox.DefWndProc(Msg);
	end;
end;

procedure TMWCCGroupBox.WMPaint (var Msg: TMessage);
var
	PS      : TPaintStruct;
	W, H    : Integer;
begin
	TGroupBox.WMPaint(Msg);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	BeginPaint(HWindow, PS);
	if FromResource then
		Draw3DBorder(HWindow, 2, 8, W-4, H-10, ctl_Recessed)
	else
		Draw3DBorder(HWindow, 2, 10, W-4, H-10, ctl_Recessed);
	EndPaint(HWindow, PS);
end;

procedure TMWCCGroupBox.WMSize (var Msg: TMessage);
var
	W, H    : Integer;
begin
	TGroupBox.WMSize(Msg);
	GetClientRect (HWindow, CRect);
	W := CRect.Right;
	H := CRect.Bottom;
	if FromResource then
	begin
		SetWindowPos(GroupStatic^.HWindow, 0, 3, 9, W-6, 16, swp_NoZOrder);
		SetWindowPos(BkStatic^.HWindow, 0, 3, 25, W-6, H-28, swp_NoZOrder);
	end
	else
	begin
		SetWindowPos(GroupStatic^.HWindow, 0, 3, 11, W-6, 16, swp_NoZOrder);
		SetWindowPos(BkStatic^.HWindow, 0, 3, 27, W-6, H-28, swp_NoZOrder);
	end;
end;

procedure TMWCCGroupBox.WMEnable (var Msg: TMessage);
begin
	if Msg.wParam <> 0 then
		EnableWindow(GroupStatic^.HWindow, True)
	else
		EnableWindow(GroupStatic^.HWindow, False);
	WMPaint(Msg);
	Msg.Result := 0;
end;

{********** TMWCCStatic **********}

constructor TMWCCStatic.Init (AParent: PWindowsObject; AnId: Integer; ATitle: PChar;
															X, Y, W, H: Integer; ATextLen, AShade: Word; IsBold: Boolean);
begin
	TStatic.Init(AParent, AnID, ATitle, X, Y, W, H, ATextlen);
	HLib := LoadLibrary ('MWCC.dll');
	StaticShade := AShade;
	DefaultFont := CreateDefaultFont(IsBold);
	HasFont := True;
end;

constructor TMWCCStatic.InitResource (AParent: PWindowsObject; AnId: Integer;
																			ATextLen, AShade: Word);
begin
	TStatic.InitResource(AParent, AnID, ATextLen);
	HLib := LoadLibrary ('MWCC.dll');
	StaticShade := AShade;
	HasFont := False;
end;

destructor TMWCCStatic.Done;
begin
	if HasFont then DeleteObject(DefaultFont);
	if HLib >= 32 then FreeLibrary(HLib);
	TStatic.Done;
end;

procedure TMWCCStatic.SetupWindow;
var
	lStyle : LongInt;
begin
	TStatic.SetupWindow;
	lStyle := GetWindowLong (HWindow, gwl_Style);
	lStyle := lStyle or ss_Left;
	if (StaticShade = ctl_Recessed) or (StaticShade = ctl_Raised) then
	begin
		lStyle := lStyle or ss_BlackFrame;
		lStyle := lStyle and not ws_Border;
	end;
	lStyle := lStyle and not ss_BlackRect;
	SetWindowLong (HWindow, gwl_Style, lStyle);
	if HasFont then	SendMessage(HWindow, wm_SetFont, DefaultFont, 1);
end;

procedure TMWCCStatic.WMPaint (var Msg: TMessage);
var
	PS         : TPaintStruct;
	X, Y, W, H : Integer;
begin
	TStatic.WMPaint(Msg);
	if (StaticShade = ctl_Recessed) or (StaticShade = ctl_Raised) then
	begin
		GetClientRect (HWindow, CRect);
		with CRect do
		begin
			X := Left;
			Y := Top;
			W := Right;
			H := Bottom;
		end;
		BeginPaint(HWindow, PS);
		Draw3DBorder(HWindow, X+2, Y+2, W-4, H-4, StaticShade);
		EndPaint(HWindow, PS);
	end;
end;

{********** TMWCCButton **********}

constructor TMWCCButton.Init (AParent: PWindowsObject; AnID: Integer; AText: PChar; X, Y, W, H:
															Integer; ABmp: PChar; AStyle: Word);
begin
	TButton.Init(Aparent, AnId, nil, X, Y, W, H, False);
	Attr.Style := Attr.Style or bs_OwnerDraw;
	HLib := LoadLibrary ('MWCC.dll');
	lstrcpy(szTitle, AText);
	Style := AStyle;
	PBmp  := ABmp;
	if szTitle[0] <> #0 then
	begin
		DefaultFont := CreateDefaultFont(False);
		HasFont := True;
	end
	else
	begin
		ResHdl := HInstance;
		HasFont := False;
	end;
end;

destructor TMWCCButton.Done;
begin
	if ResHdl <> 0 then DeleteObject(ResHdl);
	if Bmp <> 0 then DeleteObject(Bmp);
	if HasFont then DeleteObject(DefaultFont);
	if HLib >= 32 then FreeLibrary(HLib);
	TButton.Done;
end;

procedure TMWCCButton.SetupWindow;
begin
	TButton.SetupWindow;
	if HasFont then
		SendMessage(HWindow, wm_SetFont, DefaultFont, 1)
	else
		Bmp := LoadBitmap(ResHdl, PBmp);
end;

procedure TMWCCButton.DrawItem (var Msg: TMessage);
begin
	DrawButton (HWindow, szTitle, Bmp, Style, Msg.lParam);
end;

{**********TMWCCBmpButton**********}

constructor TMWCCBmpButton.Init(AParent: PWindowsObject; AnID, X, Y: Integer;
														 IsDefault: Boolean; iBmp: Integer; AStyle: Word);
begin
	TButton.Init(AParent, AnId, nil, X, Y, 0, 0, IsDefault);
	Attr.Style := Attr.Style or bs_OwnerDraw or ws_TabStop;
	iUpBmp := 1000 + iBmp;
	iDownBmp := 3000 + iBmp;
	iFocusBmp := 5000 + iBmp;
	Style := AStyle;
	HLib := LoadLibrary('MWCC.dll');
	ResHdl := HInstance;
	Default := IsDefault;
end;

destructor TMWCCBmpButton.Done;
begin
	DeleteObject(UpBmp);
	DeleteObject(DownBmp);
	if FocusBmp <> 0 then DeleteObject(FocusBmp);
	if Hlib >= 32 then FreeLibrary(HLib);
	if ResHdl <> 0 then DeleteObject(ResHdl);
	TButton.Done;
end;

procedure TMWCCBmpButton.SetUpWindow;
begin
	TButton.SetUpWindow;
	if (iUpBmp - 1000) < 99 then
		ResHdl := HLib;
	UpBmp := LoadBitmap(ResHdl, PChar(iUpBmp));
	DownBmp := LoadBitmap(ResHdl, PChar(iDownBmp));
	FocusBmp := LoadBitmap(ResHdl, PChar(iFocusBmp));
	GetObject(UpBmp, sizeof(BM), @BM);
	SetWindowPos(HWindow, 0, 0, 0, BM.bmWidth, BM.bmHeight, swp_NoZOrder or swp_NoMove);
end;

procedure TMWCCBmpButton.DrawItem(var Msg: TMessage);
begin
	DrawBmpButton (HWindow, UpBmp, DownBmp, FocusBmp, Style, Msg.lParam);
end;

procedure TMWCCBmpButton.WMSetFocus(var Msg : TMessage);
begin
	InvalidateRect(HWindow, nil, True);
	UpdateWindow(HWindow);
	TButton.DefWndProc(Msg);
end;

end.