{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application    := Basic SFX Dialog

	Files          := SFXDlg.pas, SFXDlg.res

	Units Required := MObjects and MWCC.dll

	Tabs           := 2

	Screen         := 800 * 600

	Date           := August, 1993.

	The TSFXDialog object does not support the use of standard menus (menu bars)
	or TScroller scroll bars (ws_VScroll or ws_HScroll).

	Warning - Don't overide any inherited methods (not listed here) without first consulting
	          the documentation.

***}

program SFXDlg;

{$R SFXDlg.res}

uses WinTypes, WinProcs, MObjects,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	AppName : PChar = 'NewSFXDialog';

type

PNewSFXApplication = ^TNewSFXApplication;
TNewSFXApplication = object(TApplication)
	procedure InitMainWindow; virtual;
end;

PNewSFXDialog = ^TNewSFXDialog;
TNewSFXDialog = object(TSFXDialog)
	constructor Init(AParent: PWindowsObject; AName: PChar);
	destructor Done; virtual;
	function  GetClassName : PChar; virtual;
	procedure SetUpWindow; virtual;
	procedure WMCtlColor (var Msg: TMessage); virtual wm_First + wm_CtlColor;
	procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	procedure WMNCPaint (var Msg: TMessage); virtual wm_First + wm_NCPaint;
	procedure WMNCCalcSize (var Msg: TMessage); virtual wm_First + wm_NCCalcSize;
	procedure WMActivate (var Msg: TMessage); virtual wm_First + wm_Activate;
	procedure WMNCActivate (var Msg: TMessage); virtual wm_First + wm_NCActivate;
	procedure WMActivateApp (var Msg: TMessage); virtual wm_First + wm_ActivateApp;
	procedure WMGetMinMaxInfo (var Msg: TMessage); virtual wm_First + wm_GetMinMaxInfo;
end;

{********** TNewSFXApplication **********}

procedure TNewSFXApplication.InitMainWindow;
begin
	MainWindow := New(PNewSFXDialog, Init(nil, 'SFXDialog'));
end;

{********** TNewSFXDialog **********}

constructor TNewSFXDialog.Init(AParent: PWindowsObject; AName: PChar);
begin
	TSFXDialog.Init(AParent, AName);
end;

destructor TNewSFXDialog.Done;
begin
	TSFXDialog.Done;
end;

function TNewSFXDialog.GetClassName;
begin
	GetClassName := AppName;
end;

procedure TNewSFXDialog.SetUpWindow;
var
	X, Y, W, H: Integer;
begin
	TSFXDialog.SetUpWindow;
	X := GetSystemMetrics(sm_CXScreen) div 4;
	Y := GetSystemMetrics(sm_CYScreen) div 4;
	W := GetSystemMetrics(sm_CXScreen) div 2;
	H := GetSystemMetrics(sm_CYScreen) div 2;
	MoveWindow(HWindow, X, Y, W, H, True);
	SetWindowText(Hwindow, 'SpecialFX Dialog');
end;

procedure TNewSFXDialog.WMPaint (var Msg: TMessage);
begin
	TSFXDialog.WMPaint(Msg);
end;

procedure TNewSFXDialog.WMNCPaint (var Msg: TMessage);
begin
	TSFXDialog.WMNCPaint(Msg);
end;

procedure TNewSFXDialog.WMNCCalcSize (var Msg: TMessage);
begin
	TSFXDialog.WMNCCalcSize(Msg);
end;

procedure TNewSFXDialog.WMCtlColor (var Msg: TMessage);
begin
	TSFXDialog.WMCtlColor(Msg);
end;

procedure TNewSFXDialog.WMActivate (var Msg: TMessage);
begin
	TSFXDialog.WMActivate(Msg);
end;

procedure TNewSFXDialog.WMNCActivate (var Msg: TMessage);
begin
	TSFXDialog.WMNCActivate(Msg);
end;

procedure TNewSFXDialog.WMActivateApp (var Msg: TMessage);
begin
	TSFXDialog.WMNCActivate(Msg);
end;

procedure TNewSFXDialog.WMGetMinMaxInfo (var Msg: TMessage);
begin
	TSFXDialog.WMGetMinMaxInfo(Msg);
end;

{********** Main program **********}

var
	SFXApp: TNewSFXApplication;
begin

	SFXApp.Init(AppName);
	SFXApp.Run;
	SFXApp.Done;
end.
