{**********************************************************************}
{*                                                                    *}
{* 		 Microworks Sample Application                           	     	*}
{*                                                                    *}
{*		 for Borland Pascal v7.0 and Turbo Pascal for Windows v1.5   		*}
{*                                                                    *}
{*     Copyright 1992-93 Jeff Franks (Microworks) Sydney, Australia.  *}
{*                                                                    *}
{*		 You are free to use, modify, reproduce and distribute the      *}
{*		 Sample Files (and/or any modified version) in any way you      *}
{*		 find useful.						                                        *}
{*                                                                    *}
{**********************************************************************}

{*** Introduction

	Application    := Basic MWCC Dialog

	Files          := MWCCDlg.pas and MWCCDlg.res

	Units Required := MObjects and MWCC.dll

	Tabs           := 2

	Screen         := 800 * 600

	Date           := August, 1993.

	The TMWCCDialog object is not as versatile as TMWCCWindow and TMWCCDlgWindow. It simply
	paints a 3D border around the client area and lets you add a BWCC or MWCC patterned
	background. It does not support the use of an SFXFrame.

	Warning - Don't overide any inherited methods (not listed here) without first consulting
	          the documentation.

***}

program MWCCDlg;

{$R MWCCDlg.res}

uses WinTypes, WinProcs, MObjects,
		 {$IFDEF Ver15}
			 WObjects;
		 {$ELSE}
			 Objects, OWindows, ODialogs;
		 {$ENDIF}

const

	AppName : PChar = 'NewMWCCDialog';

type

	PNewMWCCApplication = ^TNewMWCCApplication;
	TNewMWCCApplication = object(TApplication)
		procedure InitMainWindow; virtual;
	end;

	PNewMWCCDialog = ^TNewMWCCDialog;
	TNewMWCCDialog = object(TMWCCDialog)
		constructor Init(AParent: PWindowsObject; AName, ABmp: PChar);
	  destructor Done; virtual;
		function  GetClassName : PChar; virtual;
		procedure SetUpWindow; virtual;
		procedure WMPaint (var Msg: TMessage); virtual wm_First + wm_Paint;
	end;

{********** TNewMWCCApplication **********}

procedure TNewMWCCApplication.InitMainWindow;
begin
	MainWindow := New(PNewMWCCDialog, Init(nil, 'Dialog', nil));
end;

{********** TNewMWCCDialog **********}

constructor TNewMWCCDialog.Init(AParent: PWindowsObject; AName, ABmp: PChar);
begin
	TMWCCDialog.Init(AParent, AName, ABmp);
end;

destructor TNewMWCCDialog.Done;
begin
	TMWCCDialog.Done;
end;

function TNewMWCCDialog.GetClassName;
begin
  GetClassName := AppName;
end;

procedure TNewMWCCDialog.SetUpWindow;
var
	X, Y, W, H: Integer;
begin
	TMWCCDialog.SetUpWindow;
	X := GetSystemMetrics(sm_CXScreen) div 4;
	Y := GetSystemMetrics(sm_CYScreen) div 4;
	W := GetSystemMetrics(sm_CXScreen) div 2;
	H := GetSystemMetrics(sm_CYScreen) div 2;
	MoveWindow(HWindow, X, Y, W, H, True);
	SetWindowText(Hwindow, 'MWCC Dialog');
end;

procedure TNewMWCCDialog.WMPaint (var Msg: TMessage);
begin
	TMWCCDialog.WMPaint(Msg);
end;

{********** Main program **********}

var
	MWCCApp: TNewMWCCApplication;
begin
  MWCCApp.Init(AppName);
  MWCCApp.Run;
  MWCCApp.Done;
end.
