// **********************************************
// File: MENU.CPP
// Menu management module

#include "muzika.h"
#include "menu.h"

HMENU hMainMenu;                  // The main menu handle

// **********************************************
// ProcessMenu responds to a menu selection, which the user makes,
// calling the appropriate functions accordingly.

BOOL ProcessMenu(WORD item)
{
  FARPROC lpDialog;

  switch (item) {
    case M_FILE_NEW:
      // The user selected "File/New...":
      // create the relevant dialog box
      if (!AskSave())
        return TRUE;
      lpDialog = MakeProcInstance((FARPROC) DialogNew, hInst);
      DialogBox(hInst, "D_FILENEW", hMainWnd, lpDialog);
      FreeProcInstance(lpDialog);
      return TRUE;

    case M_FILE_OPEN:
      // The user selected "File/Open...":
      // create the relevant dialog box
      lpDialog = MakeProcInstance((FARPROC) DialogOpen, hInst);
      DialogBox(hInst, "D_FILEOPEN", hMainWnd, lpDialog);
      FreeProcInstance(lpDialog);
      return TRUE;

    case M_FILE_SAVE:
      // The user selected "File/Save":
      // call the Save function in FILE.CPP
      Save();
      return TRUE;

    case M_FILE_SAVEAS:
      // The user selected "File/Save As...":
      // create the relevant dialog box
      lpDialog = MakeProcInstance((FARPROC) DialogSaveAs, hInst);
      DialogBox(hInst, "D_FILESAVEAS", hMainWnd, lpDialog);
      FreeProcInstance(lpDialog);
      return TRUE;

    case M_FILE_CREATEMIDI:
      // The user selected "File/Create MIDI...":
      // create the relevant dialog box
      lpDialog = MakeProcInstance((FARPROC) DialogCreateMIDI, hInst);
      DialogBox(hInst, "D_FILECREATEMIDI", hMainWnd, lpDialog);
      FreeProcInstance(lpDialog);
      return TRUE;

    case M_PRINT:
      // The user selected "Print":
      // call the PrintEditWindow function in PRINT.CPP
      PrintEditWindow();
      return TRUE;

    case M_LAYOUT_PARTS:
      // The user selected "Layout/Parts...":
      // create the relevant dialog box
      lpDialog = MakeProcInstance((FARPROC) DialogParts, hInst);
      DialogBox(hInst, "D_LAYOUTPARTS", hMainWnd, lpDialog);
      FreeProcInstance(lpDialog);
      return TRUE;

    case M_LAYOUT_PAGE:
      // The user selected "Layout/Page...":
      // create the relevant dialog box
      lpDialog = MakeProcInstance((FARPROC) DialogPage, hInst);
      DialogBox(hInst, "D_LAYOUTPAGE", hMainWnd, lpDialog);
      FreeProcInstance(lpDialog);
      return TRUE;

    case M_LAYOUT_REFORMAT:
      // The user selected "Layout/Reformat":
      // call the FormatEntirePart function in FORMAT.CPP,
      if (!scoreDisplay)
        FormatEntirePart();
      return TRUE;

    case M_SYMBOLS_NOTES:
    case M_SYMBOLS_KEYS:
    case M_SYMBOLS_BEATS:
    case M_SYMBOLS_BARS:
    case M_SYMBOLS_LOUDNESS:
    case M_SYMBOLS_TEXT:
    case M_SYMBOLS_BLOCK:
      // The user selected a symbols set:
      // check the appropriate menu item and call the SelectSymbolSet
      // function in SYMBOLS.CPP
      CheckMenuItem(GetSubMenu(hMainMenu, M_SYMBOLS),
        activeSymbolSet+M_SYMBOLS_NOTES-1, MF_UNCHECKED);
      CheckMenuItem(GetSubMenu(hMainMenu, M_SYMBOLS),
        item, MF_CHECKED);
      SelectSymbolSet(item-M_SYMBOLS_NOTES+1);
      return TRUE;

    case M_HELP_ABOUT:
      // The user selected "Help/About...":
      // create the relevant dialog box
      lpDialog = MakeProcInstance((FARPROC) DialogAbout, hInst);
      DialogBox(hInst, "D_ABOUT", hMainWnd, lpDialog);
      FreeProcInstance(lpDialog);
      return TRUE;
  }

  return FALSE;
}

// **********************************************
// InitializeMenu enables (when enabled=TRUE) or grays out
// (when enabled=FALSE) several menu items, which are not
// relevant as long as no melody exists in the editor memory.

void InitializeMenu(BOOL enabled)
{
  EnableMenuItem(GetSubMenu(hMainMenu, M_FILE),
    M_FILE_SAVE, enabled ? MF_ENABLED : MF_DISABLED | MF_GRAYED);
  EnableMenuItem(GetSubMenu(hMainMenu, M_FILE),
    M_FILE_SAVEAS, enabled ? MF_ENABLED : MF_DISABLED | MF_GRAYED);
  EnableMenuItem(GetSubMenu(hMainMenu, M_FILE),
    M_FILE_CREATEMIDI, enabled ? MF_ENABLED : MF_DISABLED | MF_GRAYED);
  EnableMenuItem(hMainMenu, M_PRINT,
    (enabled ? MF_ENABLED : MF_DISABLED | MF_GRAYED) | MF_BYCOMMAND);
  EnableMenuItem(hMainMenu, M_LAYOUT,
    (enabled ? MF_ENABLED : MF_DISABLED | MF_GRAYED) | MF_BYPOSITION);
  DrawMenuBar(hMainWnd);
}
