;*****************************************************************************;
;                                                                             ;
;   This is a sample control file for MUPURGE / MUPURGEP.                     ;
;                                                                             ;
;   MUPURGE(P) is Copyright (c) by Bob Swift, 1995.  All Rights Reserved.     ;
;                                                                             ;
;   This control file is to allow you to define the user purge criteria       ;
;   as well as changing the default operation of the program.  The default    ;
;   operation is to ignore the first user record (usually the Sysop),         ;
;   mark the records for deletion (but not remove them from the user file),   ;
;   use the USER.BBS and USER.IDX files in the current directory, and not     ;
;   to produce a log file.                                                    ;
;                                                                             ;
;   The keywords which are used in this control file are:                     ;
;                                                                             ;
;   LOGFILE <filename>                                                        ;
;   LOGMAX                                                                    ;
;   USERPATH <path>                                                           ;
;   CHKFIRST                                                                  ;
;   PURGE                                                                     ;
;   DELETE A=<numeric access level> C=<calls> D=<days since last call>        ;
;                                                                             ;
;   These are further described below.  Note that any other commands          ;
;   will be ignored.  Each command must appear on a separate line and         ;
;   may not be preceded with any characters other than spaces.  Also note     ;
;   that none of the commands are case sensitive.                             ;
;                                                                             ;
;*****************************************************************************;
;                                                                             ;
;                                                                             ;
;   LOGFILE <filename>                                                        ;
;                                                                             ;
;   This command allows you to select to log all program activity to a        ;
;   file.  The filename may include a fully-qualified drive and path          ;
;   specifier.  If this keyword is omitted, no log file will be written.      ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   LOGMAX                                                                    ;
;                                                                             ;
;   This command allows you to select to log all information in a style       ;
;   compatible with the log files created by Maximus.  If this keyword is     ;
;   omitted, all logging will be done in standard text format.                ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   USERPATH <path>                                                           ;
;                                                                             ;
;   This command allows you to specify the path to the Maximus USER.BBS       ;
;   and USER.IDX files.  This allows you to run the program without the       ;
;   files being in the current directory.                                     ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   CHKFIRST                                                                  ;
;                                                                             ;
;   This command tells the program to apply the deletion rules to the         ;
;   first name in the user file.  The default is to ignore the first name     ;
;   in the file because this is typically the Sysop.                          ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   PURGE                                                                     ;
;                                                                             ;
;   This command tells the program to remove all deleted entried from         ;
;   the output file.  The default is to leave the entries in the file         ;
;   but mark them as DELETED.                                                 ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   DELETE A=<numeric access level> C=<calls> D=<days since last call>        ;
;                                                                             ;
;   This command defines the rules for deleting users from the file.  Each    ;
;   line must include three parameters (in any order) to identify the         ;
;   deletion rule.  The parameters are:                                       ;
;                                                                             ;
;       A=<number>  which is the numeric access identified in Maximus.        ;
;                   The rule will be applied to all users with a level        ;
;                   less than or equal to this access number.                 ;
;                                                                             ;
;       C=<number>  which is the number of times the user has called.         ;
;                   The rule will be applied to all users who have called     ;
;                   less than or equal to the number of calls indicated.      ;
;                   If this number is set at zero, then this parameter is     ;
;                   ignored when applying the rule.                           ;
;                                                                             ;
;       D=<number>  which is the number of days allowed since the last        ;
;                   time the user called.  The rule will be applied to        ;
;                   all users who have not called within the specified        ;
;                   number of days.                                           ;
;                                                                             ;
;   Note that there must not be any spaces in any of these parameters.        ;
;   If an invalid DELETE line is entered (one or more incorrect or missing    ;
;   parameters), the line will be ignored during processing.                  ;
;                                                                             ;
;   Each DELETE line is handled separately, and all three parameters must     ;
;   be met in order for a record to be deleted.  If a record matches ANY      ;
;   valid DELETE line, it will be deleted.  This allows you to set a          ;
;   number of different deletion criteria which can vary widely.              ;
;                                                                             ;
;   For the programmer types among you, think of the three conditions on      ;
;   each DELETE line as being ANDed, and the deletion lines themselves        ;
;   being ORed.  For example:                                                 ;
;                                                                             ;
;       DELETE (if)   a=19  (and)  c=0  (and)  d=30                           ;
;                                                                             ;
;                           (or)                                              ;
;                                                                             ;
;       DELETE (if)   a=19  (and)  c=1  (and)  d=5                            ;
;                                                                             ;
;                           (or)                                              ;
;                                                                             ;
;       DELETE (if)   a=29  (and)  c=0  (and)  d=60                           ;
;                                                                             ;
;                                                                             ;
;   There are a maximum of 20 DELETE lines allowed.  Some examples of         ;
;   valid deletion rules are:                                                 ;
;                                                                             ;
;       DeLeTe c=0               D=120 a=87                                   ;
;       DELETE  A=100   C=5     D=30                                          ;
;                                                                             ;
;   The following lines are NOT valid, and would be ignored:                  ;
;                                                                             ;
;       ; DELETE    A=100   C=5     D=30                                      ;
;       delete a = 100 c = 5 d = 30                                           ;
;       DELETE  a=100   C=5     A=30                                          ;
;       Delete  C=1 D=90                                                      ;
;       Delete  a=50    c=1     d=0                                           ;
;       Delete  a=0     c=1     d=90                                          ;
;       Delete  a=-1    c=1     d=90                                          ;
;                                                                             ;
;                                                                             ;
;*****************************************************************************;

;
;       Set up the defaults...
;
; Note that blank lines and leading spaces are ignored.
; Note that the USERPATH statement can have a trailing backslash but it is
; not necessary.
;

;USERPATH   H:\Max          ;User files in this directory.
LOGFILE     MaxPurge.Log    ;Log activity to file.
LOGMAX                      ;Use Maximus style log file.
;CHKFIRST                   ;Include first record in check.
;PURGE                      ;Remove deleted records from file.

;
;       Now for the deletion rules...
;

DELETE      A=29    C=1     D=30
DELETE      A=99    C=1     D=60
DELETE      A=29    C=0     D=60
DELETE      A=49    C=0     D=90
DELETE      A=89    C=0     D=120
DELETE      A=99    C=0     D=365

;
;   End of sample MUPURGE / MUPURGEP control file.
;
