#include <stdio.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "multi_ui.h"
#include "views.h"

long COLORS[]={
BLACK,BLUE,GREEN,CYAN,RED,MAGENTA,BROWN,LIGHTGRAY,DARKGREY,LIGHTBLUE,	
LIGHTGREEN,LIGHTCYAN,LIGHTRED,LIGHTMAGENTA,YELLOW,WHITE};		


MENU *file,*edit,*sub;

class M_FILE:public MENU
{
public:
	M_FILE();
	void event(int i);
};


class M_EDIT:public MENU
{
public:
	M_EDIT();
	void event(int i);
};


class M_SUBMENU:public MENU
{
public:
	M_SUBMENU();
	void event(int i);
};


void alp_failed(void){}
void update_menus(void){}
void idle_function(void){}




M_FILE::M_FILE(void)
{		
	create(128,"File");
	add('N',"New Graphic",NULL);
	add('G',"View a GIF",NULL);
	add('O',"Sub Menus",sub);
	add(000,"-----",NULL);
	add('P',"Print...",NULL);
	add(000,"-----",NULL);
	add('Q',"Quit",NULL);
}


void M_FILE::event(int i)
{
WINDOW *w;
	
	switch(i)
		{
		case 1:
			{
			WINDOW *w;
			V_BITMAP *bm;
            char name[80];

	  		w=new WINDOW;
			bm=new V_BITMAP;

			w->create(128);
			app->add(w);
			w->add(bm);
			w->set_title("Untitled");
			}
		break;

		case 2:
			{
			WINDOW *w;
			V_GIF *gif;
            char name[80];
            FILEIO *fp;


            *name=0;
			fp=new FILEIO;
			fp->open_file("",name,'r',"","");
			if(!fp->error())
            	{
	    		w=new WINDOW;
				gif=new V_GIF;

				w->create(128);
				gif->cV_GIF(0,0,0,0,0);
				app->add(w);
				w->add(gif);
				gif->gif_in(fp);
				w->set_title(name);

	            w->update();
				w->resize(gif->maxx,gif->maxy);
				w->redraw();
				}
			delete fp;
			}
		break;

		case 5:
			w=app->front_window();
			if(w==NULL)
				{
				beep();
				return;
				}
			w->print();
			break;
		        	
		case 7:
			global_quit++;
			break;
		}
}
	
		
M_EDIT::M_EDIT(void)
{

	create(129,"Edit");
	add('X',"Cut",0);
	add('C',"Copy",0);
	add('V',"Paste",0);


}


#pragma argsused
void M_EDIT::event(int i)
{
WINDOW *w;
	
	w=app->front_window();

	if(w==NULL)
		return;

	switch(i)
		{
		case 1:
			w->cut();
			break;

		case 2:
			 w->copy();
			 break;

		case 3:
			w->paste();
			break;
        }
}


M_SUBMENU::M_SUBMENU(void)
{
	create(130,"");// Sub-menus may not have a name(thats how multiapp knows their sub)
	add(000,"Sub Item 1",0);
	add(000,"Sub Item 2",0);
	add(000,"Sub Item 3",0);
	add(000,"-",0);
	add(000,"Sub Item A",0);
}


#pragma argsused
void M_SUBMENU::event(int i){}


void debug(char *format,...)
{
FILE *fp;
char s[80];
time_t now;
struct tm *date;
char string[200];
va_list ptr;

	va_start(ptr,format);
	vsprintf(string,format,ptr);
	
	now=time(NULL);
	date=localtime(&now);
	strcpy(s,asctime(date));
	*(s+strlen(s)-1)=0;
	fp=fopen("DEBUG.TXT","a");
	if(fp==NULL)
		fp=fopen("DEBUG.TXT","w");
	
	fprintf(fp,"%s : %s\r",s,string);
	fclose(fp);
	va_end(ptr);
}


class MULTI_APP:public WINDOW
{
	public:
		int c;
		MULTI_APP();
		void update(void);
		void idle(void);
};


MULTI_APP::MULTI_APP()
{
	create(128);
	c=0;
	set_title("MultiApp V1.0");
}

void MULTI_APP::update(void)
{

	goxy(0,0);
	setcolor(COLORS[c]);
	size(20);
	center("MultiApp!");  
}

void MULTI_APP::idle(void)
{
static long tm=0;

	if(!tm)
		{
		tm=timer_set(10);
		}
	if(timer_check(tm))
		{
		c++;
		if(c==15)
			c=0;
		tm=timer_set(10);
		update();
		}
}






class CONNECT_DOTS:public WINDOW
{
	public:
		CONNECT_DOTS();
		void update(void);
		void content(EVENT *e);
		
		int points[30][2];
		int num_points;
};

CONNECT_DOTS::CONNECT_DOTS()
{
	num_points=0;
	create(129);
	add(new V_SIZE);
	set_title("Click Under Me!");
}

void CONNECT_DOTS::update(void)
{
int x,y;

	for(x=0;x<num_points;x++)
		{
		setcolor(COLORS[rand()%15]);
		for(y=0;y<num_points;y++)
			{
			
			line(points[x][0],points[x][1],
				 points[y][0],points[y][1],
				 1);
			}
		}
	WINDOW::update();
}

void CONNECT_DOTS::content(EVENT *e)
{
	if(num_points==29)
		{
		beep();
		return;
		}
	points[num_points][0]=e->x;
	points[num_points++][1]=e->y;
	redraw();
}


class CALC:public DLOG
{
	public:
		CALC();
		void keydown(char key);
		void total(void);
		void dlog(int i);
		
		char opp;
		char str[80];
		char hold[80];
		int clr;
};

CALC::CALC()
{
	create(128);
	set_title("Calculator");
	strcpy(str,"");
	clr=0;
}

void CALC::total(void)
{
double x,y,z;
char *end;

	x=strtod(hold,&end);
	y=strtod(str,&end);
	switch(opp)
		{
		case '+':z=x+y;break;
		case '-':z=x-y;break;
		case '/':z=x/y;break;
		case '*':z=x*y;break;
		}
	sprintf(str,"%10.lf",z);
	clr=1;
}
	

void CALC::keydown(char key) 
{
char ky[2];
double d;
char *end;
char s[80];

	if(key==0)
		return;

	ky[1]=0;
	if(isdigit(key))
		{
		if(clr)
			{
			*str=0;
			clr=0;
			}
		if(strlen(str)>=9)
			beep();
		else{
			ky[0]=key;
		
			strcat(str,ky);
			}
		}
		
	if(key=='.')
		{
		if(strchr(str,'.')!=NULL)
			{
			beep();
			}
		else{
			ky[0]=key;
			strcat(str,ky);
			}
		}
	
	switch(key)
		{
		case 'C':
			strcpy(str,"");
			strcpy(hold,"");
			break;
		case '+':
		case '-':
		case '/':
		case '*':
			opp=key;
			strcpy(hold,str);
			*str=0;
			break;
			
		case '=':
			total();
			break;	
		}
		
	d=strtod(str,&end);
	sprintf(s,"%10.lf",d);
	iset_text(10,s);
}

void CALC::dlog(int i)
{
	if(i!=10)
		{
		char str[80];
		
		iget_text(i,str);
		keydown(*str);
		keydown(*(str+1));
		}
}

class EDITOR:public WINDOW
{
	public:
	EDITOR();
	void set(char *str);
	void grow(EVENT *e);
	V_TEXT *text;
};

EDITOR::EDITOR()
{
	create(131);
	text=new V_TEXT;
	text->cV_TEXT(3,3,maxx-SCROLL_WIDTH,maxy-SCROLL_WIDTH);
	add(focus=text);
	add(new V_SIZE);
	text->attach_scroll(1);
	text->normal_position();
}

void EDITOR::set(char *str)
{
	text->set_text(str);
}

void EDITOR::grow(EVENT *e)
{
	VIEW::grow(e);
	text->normal_position();
}


#ifdef msWINDOWS
#pragma argsused
int PASCAL WinMain( HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
#else
void main(void)
#endif
{
EDITOR *v;
V_TEXT *tex;
V_GIF *gif;

	#ifdef MAC
	app=new APP;
	#endif

	#ifdef msWINDOWS
	app=new APP(hInstance,hPrevInstance,nCmdShow);
	#endif


	app->play(128);
	app->about_alert=129;
	strcpy(app->about_menu,"About MultiApp...");

	app->add_menu(sub=new M_SUBMENU);
	app->add_menu(file=new M_FILE);
	app->add_menu(edit=new M_EDIT);
	app->build_menu_bar();
	update_menus();

	app->alert(128);
	global_quit=0;

	app->add(new CALC);
	app->add(new CONNECT_DOTS);
	app->add(v=new EDITOR);
	v->set("HELLO WORLD!!");

	app->add(new MULTI_APP);



	while(!global_quit)
		{
		app->process_event();
		}
}