/********************************************************************
							   MULTI-APP CORE 
					 Copyright 1992 by Jeff Heaton
							All Rights Reserved
							
	COMPAT: DOS,MAC & WINDOWS
							
MicroGenesis Software
P.O. Box 25534
St. Louis, Mo 63125


********************************************************************/

#ifndef __MULTI_C_H
#define __MULTI_C_H


// UnComment these lines to make the windows library.
//#define NOATOM
//#include "windows.h"
//#define IBM
//#define msWINDOWS

// First lets find out what platform we are on
#ifndef msWINDOWS
#ifndef THINK_C
#define IBM
#else
#define MAC
#endif
#endif

// Path separation, is it:
// C:\DOS\file
//      or
// MacintoshHD:System:file
#ifdef MAC
#define PATH ':'
#endif
#ifdef IBM
#define PATH '\\'
#endif

// Define data types for BYTEs and WORDs
typedef unsigned char BYTE;
typedef unsigned WORD;
typedef unsigned long DWORD;

// This is the standard MULTI-APP way of storeing integers in binary files
// and communication.  Not all platforms(particularly Intel and Motorola)
// store hi/lo byte in the same order.
#define HI_BYTE(x) (x/256)
#define LO_BYTE(x) (x-(HI_BYTE(x)*256))
#define BYTE_COMB(x,y) ((x*256)+y)

#ifdef IBM
#define COM1_base    0x3f8
#define COM1_irq     4
#define COM2_base    0x2f8
#define COM2_irq     3
#define COM3_base    0x3e8
#define COM3_irq     4
#define COM4_base    0x2e8
#define COM4_irq     3
#endif

#define ALP_IN 4096

// Some communications standards
#define	NUL		0x00
#define SOTT	0x01
#define STX		0x02
#define ETY		0x03
#define EOT		0x04
#define ENQ		0x05
#define	ACK		0x06
#define BEL		0x07
#define BKSPC	0x08
#define HZTAB	0x09
#define LF		0x0a
#define VTAB	0x0b
#define FF		0x0c
#define CR		0x0d
#define SO		0x0e
#define SI		0x0f
#define DLE		0x10
#define XON		0x11
#define DC2		0x12
#define XOFF	0x13
#define	DC4		0x14
#define NAK		0x15
#define SYN		0x16
#define ETB		0x17
#define CAN		0x18
#define EM		0x19
#define	SUB		0x1a
#define ESC		0x1b
#define FS		0x1c
#define GS		0x1d
#define RS		0x1e
#define US		0x1f

// Some external functions you must provide for MULTI-APP
void alp_failed(void);
void debug(char *,...);
void idle_function(void);
void update_menus(void);

// MULTI-APP Global Functions
int		decode	(void *dest,void *source);
int		encode	(void *dest,void *source,int length);
long	timer_set(int tenths);
int 	timer_check	(long tm);
void 	timer_wait	(long tm);
void 	sleep	(int tenths);
void 	c2pas	(char *str);
void 	pas2c	(char *str);
void 	updcrc	(unsigned char b);
void 	beep	(void);
int 	is_color_computer(void);
void 	path	(char *p);
void 	strsplice	(char **dest,char *str1,char *str2);
void 	strins	(char *str,char *ins,int n);
char 	includes(char *str,char key);


extern unsigned short crc;

// A5 For the Mac
#ifdef MAC
pascal long SetUpA5  (void)      ={0x2E8D,0x2A78,0x0904};
pascal long RestoreA5(long newA5)={0x2F4D,0x0004,0x2A5F};			
#endif

// Definitions used by ATOM.CPP

class ATOM
{
	public:
	ATOM();

	ATOM *next;// Next atom in a linked list
};

class LIST:public ATOM
{
	public:

	LIST(void);

	void add(ATOM *atom);
	void del(ATOM *atom);

	void first_element(void);
	void forward(void);
	void pos(long p);
	virtual int  comp(ATOM *a1,ATOM *a2);

		ATOM *first,*current;
};



// Defubutuibs used by DEVICE.CPP
class DEVICE:public LIST
{
	public:
	virtual int put(BYTE ch);
	virtual int putstr(char *str);
	virtual int goxy(int x,int y);
	virtual int inverse(void);
	virtual int normal(void);
	virtual BYTE get(BYTE *ch);
	virtual BYTE wait2get(BYTE *ch);
	virtual int hit(void);
	virtual int reset(void);
	virtual int ceol(void);
	virtual int wherex(void);
	virtual int wherey(void);
	virtual int printf(char *format,...);
	int getstr(char *str,int len);
};



// Definitions used by COMIO.CPP


class COMIO:public DEVICE
{
    public:
	COMIO(void);
	~COMIO();
	int init(int p);
	virtual int put(BYTE ch);
	virtual BYTE get(BYTE *ch);
	virtual int putstr(char *str);
	virtual int hit(void);
	virtual void baud(long r);
	virtual void disconnect(void);
	virtual int timed_get(BYTE *ch,int secs);

	void flush_out(void);
	void flush_in(void);
	void purge_out(void);
	void purge_in(void);
	char detect_carrier;
	void flow(int i);

	void dtr(int i);
	char carrier(void);
	long lockbaud;
	int direct,no_modem;
	int flow_control;
	long baudrate,bps;
	private:
#ifdef MAC
		short in_ref,out_ref;
#endif
	int port;
};




// Definitions used by ALP.CPP


struct ALP:public COMIO
{

	ALP();
	void update(void);// Call this as often as possable
	void intr(void);
	int check(void);  // Check for ALP-compat device on remote side
	void transmit(void); // transmit a packet

	// Replacements for CONIO functions:
	virtual int put(BYTE ch);
	virtual BYTE get(BYTE *ch);
	virtual int hit(void);
	virtual void disconnect();
	
	// Incomeing queue
	void push(BYTE ch);
	BYTE pop(void);
	
	void input(BYTE ch);

	BYTE hi,lo;
BYTE in_packet[2048];
BYTE uncomp[2048];
BYTE phase;
int in_length;
int in_num;
unsigned short in_crc;
unsigned short in_tcrc;
int in_loc;

	BYTE queue[ALP_IN],str[2000];
	int front,back;

	int p;
	int background;
	BYTE intrans;
	BYTE no_alp;
	BYTE outnum;
	BYTE lastnum;

	BYTE macro_buffer[100];
	BYTE *macro_ptr;

	int wait;
};



// Declarations ued by COMPRESS.CPP



// Definitions used by FILEIO.CPP


class FILEIO:public DEVICE
{
	int handle;
	long offset,length,size;
	BYTE rbuf[5000],*p_rbuf;
	long l_rbuf,rbase;
	
	BYTE wbuf[5000],*p_wbuf;

	public:
	FILEIO();
	~FILEIO();

	int gethandle(void);

	void open_file(char *path,char *name,char md,char *type,char *creator);

	void fread(void *loc,long len);
	void fwrite(void *loc,long len);
	char end(void);
	char error(void);
	void close_file(void);
	void pos(long loc);
	long where(void);
	long file_length(void);

	virtual int put(BYTE ch);
	virtual BYTE get(BYTE *ch);
	char sharing;
	char filename[80];

#ifdef MAC

	int	vRef;
#endif
	};


// Declarations for STACK.CPP
#define STACK_SIZE 100

class STACK
{
public:
	STACK();
	int pop(void);
	void push(int v);
	int empty(void);

private:
	int location;
	int stack[STACK_SIZE];
};







#endif