/**********************************************************************

   = = = A General Demo of the MultiApp Core V1.0 = = =


   Copyright 1992 by Jeff Heaton, MicroGenesis Software

Compilers Tested On:

 Borland C++ V3.0     - IBM DOS/WINDOWS
 Turbo C++ V2.0      - IBM DOS/WINDOWS
 Symantec Think C 5.0(with objects) - MAC System 6&7

 This demo shows some of the major features of the MultiApp core.
The four demos are: FILEIO, Atomic Structures, Communications and timing.
Because MultiApp core has ABSOLUTELY NO user interface one had to be provided
in this demo.  Unfortunately ANSI C/C++ does not have an advanced enough
user interface for this demo, so some compiler specific commands had to be
used.  These are masked with #ifdef's using the keywords of IBM and MAC.
The keyword of msWINDOWS may also be used with the windows version of
MULTI-APP core.

MicroGenesis Software
P.O. Box 25534
St. Louis, MO 63125

CIS: 76476,1701

VOICE: (314) 638-2506
BBS  : (314) 638-1731


 MUST COMPILE UNDER LARGE MEMORY MODEL IF ON DOS

 **********************************************************************/

// ANSI-C comapt includes
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#include "multi_c.h"

// Compiler specific includes
#ifdef MAC
#include <console.h>
#endif

#ifdef IBM
#include <conio.h>
#include <alloc.h>
#endif


// Even the ANSI-C interface cannot provide a system-independant enough
// interface for this demo.
int waiting=-1;// Character that is waiting to be read


int key_get(void)// Get a SINGLE key stroke
{
#ifdef IBM
 return getch();
#endif
#ifdef MAC

 if(waiting>0)
  {
  char c=waiting;
  waiting=-1;
  return c;
  }
 return getchar();
#endif
}

int key_hit(void)// Has the user hit a key?
{
#ifdef IBM
 return kbhit();
#endif
#ifdef MAC
 if(waiting>0)
  return 1;

 waiting=getchar();
 if(waiting>0)
  return 1;
 else return 0;
#endif
}


// This is called internally by MultiApp when ALP times out.
void alp_failed(void)
{
 printf("\n\nLine noise too bad, ALP connection lost.\n\n");
}




/************************************************************************

Demo for file sharing


 ************************************************************************/
void file_demo()
{
FILEIO *fp;

 printf("\n\nFILEIO/File Sharing Demo\n\n");
 fp=new FILEIO;

 // Open file for read/write, which allows no shared access
 // If we cannot gain that access now, then open_file waits for such
 // access to become available.
 fp->open_file("","DEMO.TXT",'+',"TEXT","DEMO");

 // Dump the file to stdout
 while( !fp->end() )
  putchar(fp->get(NULL));

 printf("\n\nPress any key so that other tasks may access this file.");
 key_get();

 // Release file
 fp->close_file();
 delete fp;
}



/************************************************************************

Demo For communications


 ************************************************************************/

// Strip is a useful function that will remove path information from a
// file name.  This works for both Macintosh and IBM File formats.
// Example for IBM:
// IN - C:\WINDOWS\SYSTEM\WIN.INI
//  OUT- WIN.INI
//
// Example for Macintosh:
//
//  IN - MacintoshHD:System:system
// OUT - system
void strip(char *str)
{
char *ptr=str,*s1,*s2;

 s1=strchr(str,':');
 s2=strchr(str,'\\');

 while( (s1!=NULL) || (s2!=NULL) )
  {
  if(s1>s2)
   ptr=s1+1;
  else
   ptr=s2+1;

  s1=strchr(ptr,':');
  s2=strchr(ptr,'\\');
  }
 strcpy(str,ptr);
}



// rec_file - This function is called whenever a ctrl-A character is
// received over the ALP link.  ctrl-A is simply the value I selected for this
// demo to start a file transfer-- it is not a multi-app standard.  After
// the ctrl-a the name and size(separated by carriage returns) should follow.
//
// This file transfer is just a straight binary dump.  There is no block size
// implied at this level.  All error detection/compression is handled by
// the ALP object(or any ALP-compatible object, which could use for example
// netbios/appletalk rather than serial).
void rec_file(ALP *com)
{
char name[80],size[80];
FILEIO *fp;
long todo;
char str[80];
int k=0;
float f;

 com->getstr(name,79);// Needed values from remote
 com->getstr(size,79);

 printf("\n\nReceiving: %s(%s)\n",name,size);
 fp=new FILEIO;
 fp->open_file("",name,'w',"TEXT","ttxt");// Save as teach text(if mac)
 strip(name);
 todo=atol(size);

 while(todo>0)
  {
  k=0;

  while(com->hit() && (k<512) )
   {
   fp->put(com->get(NULL));// This statement writes out every byte
   todo--;
   k++;

   if(key_hit())// Check for a local abort
    {
    if(key_get()==ESC)
     {
	 com->putstr("~~~~");
     break;
     }
    }

   }

  printf("%s: %ld         \r",name,todo);// Status line
  com->update();
  }
 fp->close_file();
 delete fp;
}


void send_file(ALP *com)
{
long l;
char size[80];
BYTE ch;
FILEIO *fp;
char name[80];

 if(com->no_alp)// This transfer wont work so well without ALP
  {
  printf("\n\nYou must establish an ALP link to transfer.\n\n");
  return;
  }

 printf("\nSend what file: ");// Input filename
 gets(name);

 // Warn Macintosh users
#ifdef MAC
 printf("\n\nThis demo will ONLY transfer the data fork of a file!\n");
 printf("Transparent resource fork transfer is planed for the next version.\n");
#endif

 fp=new FILEIO;
 fp->open_file("",name,'r',"","");
 l=fp->file_length();
 if(l<=0)
  {
  printf("\nFile Not Found\n");
  delete fp;
  return;
  }

 strip(name);
 com->printf("%c%s\r%ld\r",1,name,l);// Prompt other side to begin rec.
 com->update();// Clear out the ALP buffer
 while(com->intrans)
  com->update();
 do
  {

  // This is how to read DIRECTLY into ALP's outbound buffer.
  // WARNING: Make SURE nothing is in transit before you do this.
  //      It is accomplished here in the loop while loop below.

  fp->fread(com->str,1024);

  com->p=l;// determine length(and short length on last "block")
  if(l>1024)
   com->p=1024;
  l-=com->p;

  com->update();// Cause packet to be sent

  while(com->intrans)
   com->update();// Loop until its done with that packet(see WARNING)

  printf("%s:%ld        \r",name,l);// Display status

  if(com->hit())// Check for remote abort
   {
   com->get(&ch);
   if(ch=='~')
    {
    com->update();
    break;
    }
   }

  if(key_hit())// Check for a local abort
   {
   if(key_get()==ESC)
    {
    com->putstr("~~~~");
    break;
    }
   }

  } while( (l>0) && (!com->hit()) );
 delete fp;
}



void comm_demo()
{
ALP *com;
char str[80];
int done=0;

 com=new ALP;
 com->direct=1;

 printf("\n\nTTY Terminal\n\n");
 printf("Press ESC to quit, ~ to establish ALP, \\ to send a file.\n");
 printf("Use comport(1-2)> ");

 gets(str);
 if( com->init(atoi(str)) )
	{
	printf("\n\nThat comport does not exist\n\n");
	return;
	}


 printf("Baud rate(300-38400)> ");
 gets(str);
 com->baud(atol(str));

// Turn mac console back to single character terminal
#ifdef MAC
 csetmode(C_RAW, stdin);
#endif

 com->putstr("ATZ{");

 while(!done)
  {
  int ch;

  if(key_hit())
   {
   ch=key_get();

   if(ch==ESC)
    done++;
   else
   if(ch=='~')
    {
    if(com->check())
     printf("\n\nALP CONNECT\n");
    }
   else
    if(ch=='\\')
     send_file(com);
   else
    com->put(ch);
   }

  while( com->hit() )
   {
   char ch=com->get(NULL);

   if(ch==1)
    rec_file(com);
   else putchar(ch);
   }

  com->update();
  }
 delete com;

// Turn mac console back to normal
#ifdef MAC
 csetmode(C_ECHO, stdin);
#endif
}

/************************************************************************

Demo For Atomic Data Structures


 ************************************************************************/

// Declare a simple atomic class to hold a string
class DEMO_ITEM:public ATOM
{
 public:
 DEMO_ITEM();
 ~DEMO_ITEM();

 void set(char *str);
 char *value(void);


 private:
  char *data;
};

DEMO_ITEM::DEMO_ITEM()
{
 data=NULL;
}

DEMO_ITEM::~DEMO_ITEM()
{
 if(data!=NULL)
  free(data);
}

void DEMO_ITEM::set(char *str)
{
 if(data!=NULL)
  free(data);

 data=(char*)malloc( (sizeof(char)*strlen(str))+1 );
 strcpy(data,str);
}

char *DEMO_ITEM::value(void)
{
 return data;
}



// Declare a simple atomic list to hold a list of strings
class DEMO_LIST:public LIST
{
 public:
 void insert(char *str);
 void dump(void);
 int comp(ATOM *a1,ATOM *a2);

};

void DEMO_LIST::insert(char *str)
{
DEMO_ITEM *item;

 item=new DEMO_ITEM;
 item->set(str);
 add((ATOM*)item);
}

int DEMO_LIST::comp(ATOM *a1,ATOM *a2)
{
DEMO_ITEM *i1,*i2;

 i1=(DEMO_ITEM*)a1;
 i2=(DEMO_ITEM*)a2;

 return(strcmp(i1->value(),i2->value())<0);
}


void DEMO_LIST::dump(void)
{
 printf("\nThe list contains:\n\n");
 first_element();
 while(current!=NULL)
  {
  DEMO_ITEM *itm=(DEMO_ITEM*)current;

  printf("%s\n",itm->value());
  forward();
  }
}

void atomic_demo()
{
DEMO_LIST *list;
char str[80];

 printf("\nPlease enter some words on the next few lines, <CR> on a blank\n");
 printf("Line to sort list.\n");

 list=new DEMO_LIST;

 do {
  gets(str);
  if(*str)
   list->insert(str);
  } while(*str);

 list->dump();
 delete list;
}






/************************************************************************

Demo platform-independant timers


 ************************************************************************/


void timers_demo()
{
long tm1,tm2,tm3;
int time1,time2,time3;
char str[80];
int done=0;

 printf("\nPlease enter a time to wait in 1/10ths of a second>");
 gets(str);
 printf("\n\nPauseing for %s 1/10ths of a second..",str);
 sleep(atoi(str));


 printf("\n\nPlease enter a value for timer 1(10ths of a second)> ");
 gets(str);
 time1=atoi(str);

 printf("\n\nPlease enter a value for timer 2(10ths of a second)> ");
 gets(str);
 time2=atoi(str);

 printf("\n\nPlease enter a value for timer 3(10ths of a second)> ");
 gets(str);
 time3=atoi(str);

 tm1=timer_set(time1);// Set all 3 as close as possible to same time
 tm2=timer_set(time2);
 tm3=timer_set(time3);

 while(!done)
  {
  if(timer_check(tm1))
   if(timer_check(tm2))
    if(timer_check(tm3))
     done=1;

  printf("Timer 1: %s  Timer 2: %s  Timer 3: %s\n",
   timer_check(tm1)?"Stop":"Running",
   timer_check(tm2)?"Stop":"Running",
   timer_check(tm3)?"Stop":"Running");
  }
}



void main(void)
{
 printf("\n\n\nSorry about the cheap user interface, but this is a demo of\n");
 printf("MultiApp core, and for simplicity the ANSI C++ interface has been used\n\n");

 for(;;)
  {
  char str[80];// To hold user's menu selection
  char *ptr;// To strip off any leading spaces

  printf("\n\nMultiApp Core Demo V1.0 Copyright 1992 by Jeff Heaton, MicroGenesi\n");
  printf("\nPlease select the demo you wish to see:\n");
  printf("1> Files and file sharing\n");
  printf("2> Communications\n");
  printf("3> Atomic structures\n");
  printf("4> Timers\n");
  printf("Q> Quit demo\n");

  gets(str);
  ptr=str;

  while(*ptr==' ')// Remove leading space
   ptr++;

  switch( toupper(*ptr) )
   {
   case '1':
    file_demo();
    break;

   case '2':
    comm_demo();
    break;

   case '3':
    atomic_demo();
    break;

   case '4':
    timers_demo();
    break;

   case 'Q':
    return;

   default:
    printf("\a\n\nInvalid Entry\n\n");
    break;
   }
  }
}
