/************************************************************
* MultiUser - MultiUser Task/File Support System				*
* ---------------------------------------------------------	*
* Set the Default Protection Bits									*
* ---------------------------------------------------------	*
*  Copyright 1993 by Geert Uytterhoeven							*
* All Rights Reserved.													*
************************************************************/


#include <exec/types.h>
#include <dos/dos.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <utility/tagitem.h>
#include <libraries/multiuser.h>
#include <proto/multiuser.h>

#include "SetDefProtect_rev.h"


char __VersTag__[] = VERSTAG;


#define FLAGS_OWNER	1
#define FLAGS_GROUP	2
#define FLAGS_OTHER	3


static BOOL __regargs ProcessFlags(char *str, ULONG *flags, ULONG type,
											  struct DosLibrary *DOSBase);


int __saveds Start(char *arg)
{
	struct ExecBase *SysBase;
	struct DosLibrary *DOSBase;
	struct muBase *muBase = NULL;
	struct RDArgs *args;
	LONG argarray[] = {
		NULL, NULL, NULL, NULL
	};
	ULONG flags = NULL;
	int rc = RETURN_ERROR;
	struct TagItem tags[3];

	SysBase = *(struct ExecBase **)4;

	if ((!(DOSBase = (struct DosLibrary *)OpenLibrary("dos.library", 37))) ||
		 (!(muBase = (struct muBase *)OpenLibrary("multiuser.library", 39)))) {
		rc = RETURN_FAIL;
		goto Exit;
	}

	args = ReadArgs("FLAGS,GROUP/K,OTHER/K,GLOBAL/S", argarray, NULL);
	if (!args)
		PrintFault(IoErr(), NULL);
	else if (!((argarray[0] && !ProcessFlags((char *)argarray[0], &flags,
														  FLAGS_OWNER, DOSBase)) ||
				  (argarray[1] && !ProcessFlags((char *)argarray[1], &flags,
														  FLAGS_GROUP, DOSBase)) ||
				  (argarray[2] && !ProcessFlags((char *)argarray[2], &flags,
														  FLAGS_OTHER, DOSBase)))) {
		flags ^= FIBF_READ|FIBF_WRITE|FIBF_EXECUTE|FIBF_DELETE;
		tags[0].ti_Tag = muT_DefProtection;
		tags[0].ti_Data = (LONG)flags;
		tags[1].ti_Tag = muT_Global;
		tags[1].ti_Data = (BOOL)argarray[3];
		tags[2].ti_Tag = TAG_DONE;
		if (muSetDefProtectionA(tags))
			rc = RETURN_OK;
		else
			PutStr("SetDefProtect failed\n");
	}
	FreeArgs(args);

Exit:
	CloseLibrary((struct Library *)muBase);
	CloseLibrary((struct Library *)DOSBase);

	return(rc);
}


static BOOL __regargs ProcessFlags(char *str, ULONG *flags, ULONG type,
											  struct DosLibrary *DOSBase)
{
	int i;
	BOOL rc = TRUE;

	for (i = 0; str[i] && rc; i++) {
		switch(str[i]) {
			case 's':
			case 'S':
				if (type == FLAGS_OWNER)
					*flags |= FIBF_SCRIPT;
				else
					goto Error;
				break;

			case 'p':
			case 'P':
				if (type == FLAGS_OWNER)
					*flags |= FIBF_PURE;
				else
					goto Error;
				break;

			case 'a':
			case 'A':
				if (type == FLAGS_OWNER)
					*flags |= FIBF_ARCHIVE;
				else
					goto Error;
				break;

			case 'r':
			case 'R':
				if (type == FLAGS_OWNER)
					*flags |= FIBF_READ;
				else if (type == FLAGS_GROUP)
					*flags |= FIBF_GRP_READ;
				else
					*flags |= FIBF_OTR_READ;
				break;

			case 'w':
			case 'W':
				if (type == FLAGS_OWNER)
					*flags |= FIBF_WRITE;
				else if (type == FLAGS_GROUP)
					*flags |= FIBF_GRP_WRITE;
				else
					*flags |= FIBF_OTR_WRITE;
				break;

			case 'e':
			case 'E':
				if (type == FLAGS_OWNER)
					*flags |= FIBF_EXECUTE;
				else if (type == FLAGS_GROUP)
					*flags |= FIBF_GRP_EXECUTE;
				else
					*flags |= FIBF_OTR_EXECUTE;
				break;

			case 'd':
			case 'D':
				if (type == FLAGS_OWNER)
					*flags |= FIBF_DELETE;
				else if (type == FLAGS_GROUP)
					*flags |= FIBF_GRP_DELETE;
				else
					*flags |= FIBF_OTR_DELETE;
				break;

			default:
			Error:
				rc = FALSE;
				PutStr("Invalid flag - must be one of ");
				if (type == FLAGS_OWNER)
					PutStr("SPARWED\n");
				else
					PutStr("RWED\n");
				break;
		}
	}

	return(rc);
}
