/************************************************************
* MultiUser - MultiUser Task/File Support System				*
* ---------------------------------------------------------	*
* Make the .MultiUser.keyfiles										*
* ---------------------------------------------------------	*
*  Copyright 1993 by Geert Uytterhoeven							*
* All Rights Reserved.													*
************************************************************/


#include <exec/types.h>
#include <dos/dos.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/intuition.h>
#include <libraries/multiuser.h>
#include <stdlib.h>

#include "MakeKeyfiles_rev.h"


char __VersTag__[] = VERSTAG;


int __saveds Start(char *arg)
{
	struct ExecBase *SysBase;
	struct DosLibrary *DOSBase;
	struct IntuitionBase *IntuitionBase;
	struct RDArgs *args;
	LONG argarray[] = {
		NULL, NULL, NULL
	};
	int rc = RETURN_ERROR;
	int error;
	BPTR passwddirlock, configdirlock, fl, fh;
	struct DevProc *passwddirdp, *configdirdp, *devproc;
	STRPTR *volume;
	char key[64];
	char buffer1[1024];
	char buffer2[1024];
	int i, j;
	BOOL passwddirok = FALSE, configdirok = FALSE, ok = TRUE;
	LONG stream[3];
	ULONG seconds, micros;

	SysBase = *(struct ExecBase **)4;

	if ((!(DOSBase = (struct DosLibrary *)OpenLibrary("dos.library", 37))) ||
		 (!(IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library", 37)))) {
		rc = RETURN_FAIL;
		goto Exit;
	}

	args = ReadArgs("PASSWDDIR/A,CONFIGDIR/A,VOLUME/A/M", argarray, NULL);
	if (!args)
		PrintFault(IoErr(), NULL);
	else {
		if (passwddirlock = Lock((STRPTR)argarray[0], ACCESS_READ)) {
			if (configdirlock = Lock((STRPTR)argarray[1], ACCESS_READ)) {
				passwddirdp = GetDeviceProc((STRPTR)argarray[0], NULL);
				configdirdp = GetDeviceProc((STRPTR)argarray[1], NULL);
				CurrentTime(&seconds, &micros);
				srand(micros);
				for (i = 0; i < 64; i++)
					key[i] = (char)(((ULONG)rand()>>25)+32);
				stream[0] = (LONG)key;
				volume = (STRPTR *)argarray[2];
				for (i = 0; volume[i] && ok; i++) {
					if (fl = Lock(volume[i], ACCESS_READ)) {
						devproc = GetDeviceProc(volume[i], NULL);
						if (passwddirdp->dvp_Port == devproc->dvp_Port) {
							NameFromLock(passwddirlock, buffer1, 1024);
							passwddirok = TRUE;
						} else
							buffer1[0] = '\0';
						for (j = 0; buffer1[j] && (buffer1[j] != ':'); j++);
						stream[1] = (LONG)&buffer1[j];
						if (configdirdp->dvp_Port == devproc->dvp_Port) {
							NameFromLock(configdirlock, buffer2, 1024);
							configdirok = TRUE;
						} else
							buffer2[0] = '\0';
						for (j = 0; buffer2[j] && (buffer2[j] != ':'); j++);
						stream[2] = (LONG)&buffer2[j];
						fl = CurrentDir(fl);
						error = 0;
						if (fh = Open(muKey_FileName, MODE_NEWFILE)) {
							if (VFPrintf(fh, "%s\n%s\n%s\n", stream) == -1)
								error = IoErr();
							Close(fh);
						} else
							error = IoErr();
						if (error) {
							VPrintf("Couldn't create keyfile on volume '%s'", (LONG *)&volume[i]);
							PrintFault(error, " ");
						}
						UnLock(CurrentDir(fl));
						FreeDeviceProc(devproc);
					} else {
						PrintFault(IoErr(), NULL);
						ok = FALSE;
					}
				}
				if (ok)
					if (passwddirok)
						if (configdirok) {
							PutStr("\n[1m     Do NOT forget to make a backup of all Keyfiles!![0m\n\n");
							rc = RETURN_OK;
						} else
							PutStr("The configuration directory must be on a"
									 "partition using the MultiUserFileSystem\n");
					else
						PutStr("The password directory must be on a"
								 "partition using the MultiUserFileSystem\n");
				FreeDeviceProc(configdirdp);
				FreeDeviceProc(passwddirdp);
				UnLock(configdirlock);
			} else
				PrintFault(IoErr(), NULL);
			UnLock(passwddirlock);
		} else
			PrintFault(IoErr(), NULL);
	}
	FreeArgs(args);

Exit:
	CloseLibrary((struct Library *)IntuitionBase);
	CloseLibrary((struct Library *)DOSBase);

	return(rc);
}
