/************************************************************
* MultiUser - MultiUser Task/File Support System				*
* ---------------------------------------------------------	*
* LimitDOSSetProtection													*
* ---------------------------------------------------------	*
*  Copyright 1993 by Geert Uytterhoeven							*
* All Rights Reserved.													*
************************************************************/


#include <exec/types.h>
#include <dos/dos.h>
#include <proto/exec.h>
#include <proto/dos.h>
#include <utility/tagitem.h>
#include <libraries/multiuser.h>
#include <proto/multiuser.h>

#include "LimitDOSSetProtection_rev.h"


char __VersTag__[] = VERSTAG;


int __saveds Start(char *arg)
{
	struct ExecBase *SysBase;
	struct DosLibrary *DOSBase;
	struct muBase *muBase = NULL;
	struct RDArgs *args;
	LONG argarray[] = {
		NULL, NULL
	};
	int rc = RETURN_ERROR;

	SysBase = *(struct ExecBase **)4;

	if ((!(DOSBase = (struct DosLibrary *)OpenLibrary("dos.library", 37))) ||
		 (!(muBase = (struct muBase *)OpenLibrary("multiuser.library", 39)))) {
		rc = RETURN_FAIL;
		goto Exit;
	}

	args = ReadArgs("ON/S,OFF/S", argarray, NULL);
	if (!args)
		PrintFault(IoErr(), NULL);
	else if (argarray[0] && argarray[1])
		PutStr("You can't specify both ON and OFF\n");
	else if (!argarray[0] && !argarray[1])
		PutStr("You must specify one of ON and OFF\n");
	else
		muLimitDOSSetProtection((BOOL)argarray[0]);
	FreeArgs(args);

Exit:
	CloseLibrary((struct Library *)muBase);
	CloseLibrary((struct Library *)DOSBase);

	return(rc);
}
