/*
**	$VER: debug.h 1.0 (07.02.94)
**
**	debug library header file
**
**	 Copyright 1994 by Norbert Pschel
**	All Rights Reserved
*/

#ifndef DEBUG_H
#define DEBUG_H

#ifdef DEBUG

#include <proto/exec.h>

#pragma libcall DebugBase DEBUGA 1e 32103
#pragma tagcall DebugBase DEBUG 1e 32103

#ifndef DEBUG_LOGFILE
#define DEBUG_LOGFILE "t:debug.log"
#endif

void DEBUGA(STRPTR fname,STRPTR format,LONG *args);

#define debug2 debug
#define debug3 debug
#define debug4 debug
#define debug5 debug
#define debug6 debug
#define debug7 debug

static void debug(STRPTR format,...)

{
  struct Library *DebugBase;

  DebugBase = OpenLibrary("debug.library",0);
  if(DebugBase) {
    DEBUGA(DEBUG_LOGFILE,format,(LONG *)(&format+1));
    CloseLibrary(DebugBase);
  }
}

#else

#define debug(f)
#define debug2(f,a1)
#define debug3(f,a1,a2)
#define debug4(f,a1,a2,a3)
#define debug5(f,a1,a2,a3,a4)
#define debug6(f,a1,a2,a3,a4,a5)
#define debug7(f,a1,a2,a3,a4,a5,a6)

#endif

#endif
