;*****************************************************************************;
;                                                                             ;
;   This is a sample control file for MAXTOP / MAXTOPP.                       ;
;                                                                             ;
;   MAXTOP(P) is Copyright (c) by Bob Swift, 1995.  All Rights Reserved.      ;
;                                                                             ;
;   This control file is to allow you to define the parameters used when      ;
;   creating the top user file.  The default operation is to ignore the       ;
;   first user record (usually the Sysop), use real names, output to a        ;
;   file called TOPUSER.BBS in the current directory, and to use the          ;
;   USER.BBS file in the current directory.                                   ;
;                                                                             ;
;   The keywords which are used in this control file are:                     ;
;                                                                             ;
;   OUTPUT <filename>                                                         ;
;   USERPATH <path>                                                           ;
;   USEFIRST                                                                  ;
;   ALIAS                                                                     ;
;   CATEGORY <cat-1> [cat-2] [cat-3]                                          ;
;   CLSFIRST                                                                  ;
;   CLSAFTER                                                                  ;
;   ENTERAFTER                                                                ;
;                                                                             ;
;   These are further described below.  Note that any other commands          ;
;   will be ignored.  Each command must appear on a separate line and         ;
;   may not be preceded with any characters other than spaces.  Also note     ;
;   that none of the commands are case sensitive.                             ;
;                                                                             ;
;*****************************************************************************;
;                                                                             ;
;                                                                             ;
;   OUTPUT <filename>                                                         ;
;                                                                             ;
;   This command allows you to select the name of the MECCA display file      ;
;   created.  The filename may include a fully-qualified drive and path       ;
;   specifier.  If this keyword is omitted, the output will be written to     ;
;   a file called MAXTOP.BBS.                                                 ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   USERPATH <path>                                                           ;
;                                                                             ;
;   This command allows you to specify the path to the Maximus USER.BBS       ;
;   and USER.IDX files.  This allows you to run the program without the       ;
;   files being in the current directory.                                     ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   USEFIRST                                                                  ;
;                                                                             ;
;   This command tells the program to apply the top user rules to the         ;
;   first name in the user file.  The default is to ignore the first name     ;
;   in the file because this is typically the Sysop.                          ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   CATEGORY <cat-1> [cat-2] [cat-3]                                          ;
;                                                                             ;
;   This command tells the program which categories to report in the output   ;
;   file.  A minimum of one and a maximum of three categories can be          ;
;   selected for output.  If there are no categories selected, the program    ;
;   will default to using calls and downloads as the top categories.  The     ;
;   available categories are CALLS, UPLOADS, DOWNLOADS and MESSAGES.  Note    ;
;   that only the first character is significant when specifying categories,  ;
;   and that the different categories must be separated by spaces or tabs.    ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   ALIAS                                                                     ;
;                                                                             ;
;   This command tells the program to use the alias names from the user       ;
;   file, rather than the users' real names in the output file.               ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   CLSFIRST                                                                  ;
;                                                                             ;
;   This command tells the program to insert a clear screen command at the    ;
;   start of the output file.                                                 ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   CLSAFTER                                                                  ;
;                                                                             ;
;   This command tells the program to insert a clear screen command at the    ;
;   end of the output file.                                                   ;
;                                                                             ;
;                                                                             ;
;                                                                             ;
;   ENTERAFTER                                                                ;
;                                                                             ;
;   This command tells the program to insert a "Press ENTER to Continue"      ;
;   command at the end of the output file (before the clear screen command    ;
;   inserted using the CLSAFTER command).                                     ;
;                                                                             ;
;                                                                             ;
;*****************************************************************************;

;
;       Set up the defaults...
;
; Note that blank lines and leading spaces are ignored.
; Note that the USERPATH statement can have a trailing backslash but it is
; not necessary.
;

USERPATH    H:\Max                      ;User files in this directory.

OUTPUT      H:\Max\Misc\Bullet-G.Bbs    ;Output to this file.

;USEFIRST                               ;Include first record in check.

;ALIAS                                  ;Use alias rather than real name.

CATEGORY    Calls   Downloads           ;Categories of top users to display.

CLSFIRST                                ;Clear screen before displaying
                                        ;top users.

CLSAFTER                                ;Clear screen after displaying
                                        ;top users.

ENTERAFTER                              ;Display "Press ENTER" after
                                        ;displaying top users.

;
;   End of sample MAXTOP / MAXTOPP control file.
;
