#define RDS_TITLE     "MAXTOP"                  /*  Program Name      */
#ifdef __OS2__
  #undef  RDS_TITLE
  #define RDS_TITLE   "MAXTOPP"                 /*  Program Name      */
#endif
#define RDS_DATES     "1995"                    /*  Copyright Date    */
#define RDS_VERSION   "1.11"                    /*  Version Number    */
#define NUM_TO_LIST   10                        /*  List Top n Users  */
/*

                              MAXTOP / MAXTOPP
             Copyright (c) Bob Swift, 1995.  All Rights Reserved.

   This program is used to read the Max 3.00 USER.BBS file and generate a
   file listing the top users (upload, download, calls) for the BBS.  The
   first record in USER.BBS (usually the sysop) is ignored.

   The program is based on an example program included with the Maximus
   User Language (MUL) package for use with Maximus 2.x, which is
   Copyright (c) by CodeLand Australia.

   The format for using this program is as follows:

                MAXTOP  [ctlfile]            (for DOS)
                MAXTOPP [ctlfile]            (for OS/2)

   Where [ctlfile] is the path and name of the control file (default is
                   MAXTOP.CTL in the current directory).

   Examples:        MAXTOP  c:\max\misc\topuser.cfg
                    MAXTOPP ctlfiles\maxtop.ctl
                    MAXTOPP

   The program will display a VERY brief set of instructions if it encounters
   an error.  The following is a list of the error codes returned by the
   program:

                  0 - No errors.  Normal termination.
                  1 - Bad / Extra command line argument.
                  2 - Unable to open the control file.
                  3 - Unable to read the input file.
                  4 - Unable to write the output file.
                  5 - No user records to process.

   When an error is encountered, the program will exit immediately and will
   attempt to properly close all files.

   Although I have chosen to retain all rights to this program, you are free
   to use it under the following conditions:

            - You realize that there is NO Warrantee of any sort.
              It was tested pretty thoroughly here before release
              but who knows what bugs may be lurking within.

            - You will not modify the code and release a new version
              of the program.  I welcome suggestions for improvement
              (especially when accompanied by code) but I make no
              guarantee of future releases.

            - You drop me a note to let me know that you use the
              program.  That way, I know who to inform if there are
              any future releases.  Please either send netmail to:

                        Bob Swift
                        1:342/5 @ fidonet

              or a postcard to:

                        Bob Swift
                        5708 - 47th Street
                        Stony Plain, Alberta
                        T7Z 1C6, Canada

            - If you find the program useful, I ask that you do
              something to brighten somebody else's day.  Just
              exactly what, I will leave up to you.

   You may freely distribute this program provided that you distribute only
   the complete archive which includes the files:

        MAXTOP.EXE      -   Program File for DOS
        MAXTOPP.EXE     -   Program File for OS/2
        MAXTOP.CTL      -   Sample Control File
        MAXTOP.C        -   'C' Source Code
        MAX_U.H         -   Maximus User Structures
        STAMP.H         -   Maximus Stamp Structures
        TYPEDEFS.H      -   Maximus Type Definitions
        MAXTOP.DOC      -   Program Documentation
        FILE_ID.DIZ     -   Program Description File

   If you run across any bugs with this program, please report them to the
   address listed above.  Thanks for giving MAXTOP(P) a try.


                                                   Bob Swift (1:342/5)


   Revision History
   ----------------

   1.00     95/09/02    First release version.

   1.01     95/09/04    Fixed a (stupid) bug that would only display a
                        partial top users list if the user file was
                        specified on the command line.  Thanks Tom.

   1.10     95/09/06    Revised to allow options to be changed via a
                        control file.

   1.11     95/09/09    Corrected a bug that would screw up the report
                        format if a long user name was encountered.  The
                        program now truncates long names.


*/


#include <stdio.h>
#include <string.h>
#include <time.h>
#ifdef __OS2__
  #include <os2.h>
#endif
#include "max_u.h"

#define NUL '\0'

#define BLACK           "\x16\x01\x00"
#define BLUE            "\x16\x01\x01"
#define GREEN           "\x16\x01\x02"
#define CYAN            "\x16\x01\x03"
#define RED             "\x16\x01\x04"
#define MAGENTA         "\x16\x01\x05"
#define BROWN           "\x16\x01\x06"
#define GRAY            "\x16\x01\x07"
#define GREY            "\x16\x01\x07"
#define LBLACK          "\x16\x01\x08"
#define LBLUE           "\x16\x01\x09"
#define LGREEN          "\x16\x01\x0a"
#define LCYAN           "\x16\x01\x0b"
#define LRED            "\x16\x01\x0c"
#define LMAGENTA        "\x16\x01\x0d"
#define YELLOW          "\x16\x01\x0e"
#define WHITE           "\x16\x01\x0f"

#define COLOURHEAD      "\x16\x01\x0f"
#define COLOURHUND      "\x16\x01\x0c"
#define COLOURBOXB      "\x16\x01\x03"
#define COLOURLABL      "\x16\x01\x1b"
#define COLOUROPT1      "\x16\x01\x0e"
#define COLOUROPT2      "\x16\x01\x0a"
#define COLOUROPT3      "\x16\x01\x0c"
#define COLOURDATA      "\x16\x01\x07"
#define COLOURFOOT      "\x16\x01\x02"

void helpscrn(int ernum);


/*******************************************************************/

void main(int argc, char *argv[])
{

struct tm tm_now;
time_t secs_now;

FILE *infile1,*outfile;

char temp[256];
char temp1[256];
char temp2[256];
char temp3[256];
char *p,*p1,*p2,*p3;
char *line="                 \r\n";
char *b1 =   "";
char *b2 =   "Ŀ\r\n";
char *c1 =   "";
char *c2 =   "Ĵ\r\n";
char *d1 =   "";
char *d2 =   "\r\n";
char *e1 =   "";
char *e2 =   "Ĵ\r\n";

char *s_check;

static struct _usr max_data;

word i,j,k,l,numtolist;
word f_uf,f_ua,f_cf,f_ca,f_ea;

char u_name[NUM_TO_LIST][20],
     d_name[NUM_TO_LIST][20],
     c_name[NUM_TO_LIST][20];

SCOMBO u_call[NUM_TO_LIST],
                  d_call[NUM_TO_LIST],
                  c_call[NUM_TO_LIST];

struct _dos_st usr_time;

word  c_calls[NUM_TO_LIST];         /* number of calls */

dword dl_bytes[NUM_TO_LIST],        /* total K bytes downloaded */
      ul_bytes[NUM_TO_LIST];        /* total K bytes uploaded */

word u_index[NUM_TO_LIST],
     d_index[NUM_TO_LIST],
     c_index[NUM_TO_LIST];

numtolist = NUM_TO_LIST;

printf("\n\n%s (v%s)\n",RDS_TITLE,RDS_VERSION);
printf("Copyright (c) Bob Swift, %s.  All Rights Reserved.",RDS_DATES);

if (argc > 2) helpscrn(1);

strcpy(temp1,"MAXTOP.CTL");                               /* Control File  */
if (argc == 2) strcpy(temp1,strupr(argv[1]));             /* Control File  */

if ((infile1=fopen(temp1,"rt")) == NULL) helpscrn(2);

f_uf = 0;
f_ua = 0;
f_cf = 0;
f_ca = 0;
f_ea = 0;
temp1[0] = '\0';
strcpy(temp2,"MAXTOP.BBS");

while (fgets(temp3,256,infile1) != NULL)
  {
  strcpy(temp,temp3);

/*********************************************************
*                                                        *
*  The following routine is used to pull the tokens out  *
*  of the input string from the control file.  This is   *
*  being used rather than the strtok() function because  *
*  of a problem with the strtok() function in the OS/2   *
*  version compiled with the Watcom C/C++ compiler.      *
*                                                        *
*********************************************************/

  l = 0;
  p = temp;
  p1 = p;
  p2 = p;
  p3 = p;
  k = 0;
  i = 0;
  j = strlen(temp);
  while (i < j)
    {
    if ((temp[i] == ' ') || (temp[i] == '\t') || (temp[i] == '\n'))
      {
      if (k != 0)
        {
        k = 0;
        temp[i] = '\0';
        if (l == 1) i = j;
        }
      if (p == p3) p++;
      if (p1 == p3) p1++;
      if (p2 == p3) p2++;
      if (l == 0) p3++;
      }
    else
      {
      if (k == 0)
        {
        k = 1;
        if (p == p3)
          {p1++; p2++; p3++;}
        else
          {
          if (p1 == p3)
            {p2++; p3++;}
          else
            {
            if (p2 == p3)
              p3++;
            else
              l = 1;
            }
          }
        }
      else
        {
        if (p == p3) p++;
        if (p1 == p3) p1++;
        if (p2 == p3) p2++;
        if (l == 0) p3++;
        }
      }
    i++;
    }

/************************************
*                                   *
*  End of special parsing routine.  *
*                                   *
************************************/

  if (strcmpi(p,"USEFIRST") == 0) f_uf = 1;
  if (strcmpi(p,"CLSFIRST") == 0) f_cf = 1;
  if (strcmpi(p,"CLSAFTER") == 0) f_ca = 1;
  if (strcmpi(p,"ENTERAFTER") == 0) f_ea = 1;
  if (strcmpi(p,"ALIAS") == 0) f_ua = 1;
  if (strcmpi(p,"OUTPUT") == 0)
    {
//    p1 = strtok(NULL," \n");
//    if (p1 != NULL)
    if ((p1[0] != '\0') && (p1[0] != ';'))
      {
      strcpy(temp2,p1);
      }
    else
      {
      strcpy(temp2,"MAXTOP.BBS");
      }
    }
  if (strcmpi(p,"USERPATH") == 0)
    {
//    p1 = strtok(NULL," \n");
//    if (p1 != NULL)
    if ((p1[0] != '\0') && (p1[0] != ';'))
      {
      strcpy(temp1,p1);
      }
    else
      {
      temp1[0] = '\0';
      }
    }
  }
fclose(infile1);

if (temp1[0] != '\0')
  {
  if (temp1[strlen(temp1)-1] != ':' && temp1[strlen(temp1)-1] != '\\')
    strcat(temp1,"\\");
  }

strcat(temp1,"USER.BBS");

if ((infile1=fopen(temp1,"rb")) == NULL) helpscrn(3);
if ((outfile=fopen(temp2,"wb")) == NULL) helpscrn(4);

printf("\n\nInitializing.");

i = 0;

while (i < numtolist)
    {
    u_index[i] = i;
    d_index[i] = i;
    c_index[i] = i;
    u_name[i][0] = '\0';
    d_name[i][0] = '\0';
    c_name[i][0] = '\0';
    c_calls[i] = 0;
    ul_bytes[i] = 0;
    dl_bytes[i] = 0;
    i++;
    }

printf("\n");

i = 0;

while (fread(&max_data,sizeof(struct _usr),1,infile1) == 1)
{
  i++;
  printf("\rProcessing User %d",i);

  if (i > 1 || f_uf == 1)
    {
    j = 0;
    while (j < numtolist)
        {
        if (max_data.times > c_calls[c_index[j]])
            {
            strcpy(c_name[c_index[numtolist-1]],max_data.name);
            if (f_ua == 1) strcpy(c_name[c_index[numtolist-1]],max_data.alias);
            c_call[c_index[numtolist-1]] = max_data.ludate;
            c_calls[c_index[numtolist-1]] = max_data.times;
            l = c_index[numtolist-1];
            k = numtolist - 1;
            while (k > j)
                {
                c_index[k] = c_index[k-1];
                k--;
                }
            c_index[j] = l;
            j = numtolist;
            }
        j++;
        }
    }

  if (i > 1 || f_uf == 1)
    {
    j = 0;
    while (j < numtolist)
        {
        if (max_data.down > dl_bytes[d_index[j]])
            {
            strcpy(d_name[d_index[numtolist-1]],max_data.name);
            if (f_ua == 1) strcpy(d_name[d_index[numtolist-1]],max_data.alias);
            d_call[d_index[numtolist-1]] = max_data.ludate;
            dl_bytes[d_index[numtolist-1]] = max_data.down;
            l = d_index[numtolist-1];
            k = numtolist - 1;
            while (k > j)
                {
                d_index[k] = d_index[k-1];
                k--;
                }
            d_index[j] = l;
            j = numtolist;
            }
        j++;
        }
    }

  if (i > 1 || f_uf == 1)
    {
    j = 0;
    while (j < numtolist)
        {
        if (max_data.up > ul_bytes[u_index[j]])
            {
            strcpy(u_name[u_index[numtolist-1]],max_data.name);
            if (f_ua == 1) strcpy(u_name[u_index[numtolist-1]],max_data.alias);
            u_call[u_index[numtolist-1]] = max_data.ludate;
            ul_bytes[u_index[numtolist-1]] = max_data.up;
            l = u_index[numtolist-1];
            k = numtolist - 1;
            while (k > j)
                {
                u_index[k] = u_index[k-1];
                k--;
                }
            u_index[j] = l;
            j = numtolist;
            }
        j++;
        }
    }

}

if (i == 0)
    helpscrn(5);

fclose(infile1);

j = 0;
while (j < numtolist)
    {
    c_name[j][16] = '\0';
    u_name[j][16] = '\0';
    d_name[j][16] = '\0';
    j++;
    }

printf("\nWriting output file");

secs_now = time(NULL);

// Output CLS, MoreOff, heading and underline
if (f_cf == 1)
  {
  if (fputc(12,outfile) == EOF) helpscrn(4);
  }
if (fputc(11,outfile) == EOF) helpscrn(4);
strftime(temp1,77,"Maximus Top User Report as of %a, %Y %b %d",localtime(&secs_now));
sprintf(temp,"%77s"," ");
j = (strlen(temp) - strlen(temp1)) / 2 + 2;
i = 0;
while (temp1[i] != '\0')
  {
  temp[j] = temp1[i];
  j++;
  i++;
  }
if (fprintf(outfile,"%s%s\r\n",COLOURHEAD,temp) == EOF) helpscrn(4);
if (fprintf(outfile,"%s%s",COLOURHUND,line) == EOF) helpscrn(4);

// Output box top
if (fprintf(outfile,"%s%s%s",COLOURBOXB,b1,b2) == EOF) helpscrn(4);

// Output box heading
if (fprintf(outfile,"%s TOP CALLER      (Calls) %s",COLOURLABL,COLOURBOXB) == EOF) helpscrn(4);
if (fprintf(outfile,"%s TOP UPLOADER       (Kb) %s",COLOURLABL,COLOURBOXB) == EOF) helpscrn(4);
if (fprintf(outfile,"%s TOP DOWNLOADER     (Kb) %s",COLOURLABL,COLOURBOXB) == EOF) helpscrn(4);

// Output box divider
if (fprintf(outfile,"\r\n%s%s",c1,c2) == EOF) helpscrn(4);

// Output first data line
if (fprintf (outfile," %s",COLOUROPT1) == EOF) helpscrn(4);
if (fprintf (outfile,"%-17s %5u %s %s",c_name[c_index[0]],c_calls[c_index[0]],COLOURBOXB,COLOUROPT2) == EOF) helpscrn(4);
if (fprintf (outfile,"%-17s %5lu %s %s",u_name[u_index[0]],ul_bytes[u_index[0]],COLOURBOXB,COLOUROPT3) == EOF) helpscrn(4);
if (fprintf (outfile,"%-16s %6lu %s\r\n",d_name[d_index[0]],dl_bytes[d_index[0]],COLOURBOXB) == EOF) helpscrn(4);

// Output the remaining data
i = 1;
while (i < numtolist)
    {
    if (fprintf (outfile," %s",COLOURDATA) == EOF) helpscrn(4);
    if (fprintf (outfile,"%-17s %5u %s %s",c_name[c_index[i]],c_calls[c_index[i]],COLOURBOXB,COLOURDATA) == EOF) helpscrn(4);
    if (fprintf (outfile,"%-17s %5lu %s %s",u_name[u_index[i]],ul_bytes[u_index[i]],COLOURBOXB,COLOURDATA) == EOF) helpscrn(4);
    if (fprintf (outfile,"%-16s %6lu %s\r\n",d_name[d_index[i]],dl_bytes[d_index[i]],COLOURBOXB) == EOF) helpscrn(4);
    i++;
    }

if (fprintf(outfile,"%s%s",e1,e2) == EOF) helpscrn(4);      // Output box divider
sprintf(temp,"%77s"," ");
sprintf(temp1,"Prepared by %s (v%s)",RDS_TITLE,RDS_VERSION);
j = (strlen(temp) - strlen(temp1)) / 2;
i = 0;
while (temp1[i] != '\0')
  {
  temp[j] = temp1[i];
  j++;
  i++;
  }
if (fprintf(outfile,"%s%s%s\r\n",COLOURFOOT,temp,COLOURBOXB) == EOF) helpscrn(4);
sprintf(temp,"%77s"," ");
sprintf(temp1,"Copyright (c) Bob Swift, %s.  All Rights Reserved.",RDS_DATES);
j = (strlen(temp) - strlen(temp1)) / 2;
i = 0;
while (temp1[i] != '\0')
  {
  temp[j] = temp1[i];
  j++;
  i++;
  }
if (fprintf(outfile,"%s%s%s\r\n",COLOURFOOT,temp,COLOURBOXB) == EOF) helpscrn(4);

// Output lower box border
if (fprintf(outfile,"%s%s%s",COLOURBOXB,d1,d2) == EOF) helpscrn(4);

// Press Enter prompt and CLS
if (fprintf(outfile,"%s",WHITE) == EOF) helpscrn(4);
if (f_ea == 1)
  {
  if (fputc(1,outfile) == EOF) helpscrn(4);
  }
if (fprintf(outfile,"%s",GRAY) == EOF) helpscrn(4);
if (f_ca == 1)
  {
  if (fputc(12,outfile) == EOF) helpscrn(4);
  }

/*  Close the destination file  */
fclose(outfile);

/*  Thank the user and exit gracefully  */
printf("\n\nOperation complete.  Thank-you for using %s.\n\n",RDS_TITLE);
exit(0);
}

/*******************************************************************/

void helpscrn(int ernum)
/*  Here are the error messages and VERY brief instructions  */
{
printf("\n\n");
switch (ernum) {

case  1 : printf("Bad / Extra command line argument.\n\n");
          break;

case  2 : printf("Unable to open the control file.\n\n");
          break;

case  3 : printf("Unable to read the input file.\n\n");
          break;

case  4 : printf("Unable to write the output file.\n\n");
          break;

case  5 : printf("No user records to process.\n\n");
          break;

    }

printf("This program is used to read the Max 3.00 USER.BBS file and generate a\n");
printf("file listing the top users (upload, download, calls) for the BBS.\n\n");
printf("The format for using this program is as follows:\n\n");
printf("                 %s [ctlfile]\n\n",RDS_TITLE);
printf("Where [ctlfile] is the path and name of the control file (default is\n");
printf("                MAXTOP.CTL in the current directory).\n\n");
printf("Examples:        %s c:\max\misc\topuser.cfg\n",RDS_TITLE);
printf("                 %s ctlfiles\maxtop.ctl\n",RDS_TITLE);
printf("                 %s\n\n",RDS_TITLE);

exit(ernum);
}

/*******************************************************************/

