/*
 * January 12, 1993
 * Copyright 1993 George Woyansky and Kevin Bradley
 * 
 * This source code is freely redistributable and may be used for
 * any purpose.  This copyright notice must be maintained. 
 * 
 */

/*
 * Matlab .mat format conversion
 */

#include "st.h"

/* Private data for .mat file */
typedef struct matstuff{
     long type;   /* type */
     long mrows;  /* row dimension */
     long ncols;  /* column dimension */
     long imagf;  /* flag indicating imag part */
     long namlen; /* name length (including NULL) */
} *mat_t;

extern float volume, amplitude;
extern long summary, verbose;
int shift;

/*
 * Do anything required before you start reading samples.
 * Read file header
 */
matstartread(ft) 
ft_t ft;
{
	mat_t	mat = (mat_t) ft->priv;
	char name[80];

	/* If you need to seek around the input file. */
	if (0 && ! ft->seekable)
		fail(".mat input file must be a file, not a pipe");

	fread(mat, sizeof(struct matstuff), 1, ft->fp);

	fread(name, sizeof(char), mat->namlen, ft->fp);
	if (ft->info.size == WORD)
	    ft->info.size = DBLWRD;
	else ft->info.size = DBLBYT;
	
/*	if(ft->info.size == BYTE) shift = 24;
        else shift = 16;
        printf("Size of data = %d\n",shift);
	ft->info.size = DOUBLE; */
        if (ft->info.style = -1) 
        	ft->info.style = SIGN2;      /* Default - signed data */
}

/*
 * Read up to len samples from file.
 * Convert to signed longs.
 * Place in buf[].
 * Return number of samples read.
 */

matread(ft, buf, len) 
ft_t ft;
long *buf, len;
{
	mat_t	mat = (mat_t) ft->priv;
	long i;
        double data;

	if (len > mat->mrows) len = mat->mrows;
	if (len == 0) return 0;

	i = rawread(ft,buf,len);
	mat->mrows -= i;
	return (int) i;
}

/*
 * Do anything required when you stop reading samples.  
 * Don't close input file! 
 */
matstopread(ft)
ft_t ft;
{
}

matstartwrite(ft)
ft_t ft;
{
	mat_t	mat = (mat_t) ft->priv;
	int	littlendian = 0;
	char	*endptr;

	if (! ft->seekable)
		fail("Output .mat file must be a file, not a pipe");

	endptr = (char *) &littlendian;
	*endptr = 1;
	if (!littlendian) ft->swap = 1;

	mat->mrows = 0;
	matwritehdr(ft);
}

matwritehdr(ft)
ft_t ft;
{
	mat_t	mat = (mat_t) ft->priv;

	if (ft->info.size == WORD)
		ft->info.size = DBLWRD;
	else ft->info.size = DBLBYT;               /* default to bytes */


	if (ft->info.style == SIGN2)
		ft->info.style = UNSIGNED;
	else
		ft->info.style = SIGN2;

	mat->ncols = 1;
	mat->type = 0;
	mat->imagf = 0;
        mat->namlen = 6;
	fwrite(mat,sizeof(struct matstuff), 1, ft->fp);
	fputs("sound",ft->fp);
	putc('\0',ft->fp);
}

matwrite(ft, buf, len)
ft_t ft;
long *buf, len;
{
	mat_t	mat = (mat_t) ft->priv;
	long i,foo;
	double data;

	mat->mrows += len; 

	rawwrite(ft,buf,len);
}

void
matstopwrite(ft)
ft_t ft;
{
	/* All samples are already written out. */
	/* If file header needs fixing up, for example it needs the */
 	/* the number of samples in a field, seek back and write them here. */
	mat_t	mat = (mat_t) ft->priv;

	if (!ft->seekable)
		return;
	if (fseek(ft->fp, 0L, 0) != 0)
		fail("Can't rewind output file to rewrite .mat header.");
	matwritehdr(ft);
}
