comment *

  MTMem - Memory to store mtdirs and mtprev[] for Move To (mt.com)
  Copyright Jason Hood 1996-7.
  Started:   5 May, 1996.
  Finished:  2 June.
  Modified: 29 October - updated to reflect changes in mt.cpp
	    10-11 February, 1997 - changed to AMIS, support for virtual machines

  Usage: mtmem [d:/path] [;path] [;;path]
  Where: d:/path is the path to place the directory structure file.
		   Default is the same path as mtmem.com.
	 ;path	 is the initial previous directory.
		   Default is an empty string ("" is an invalid path.).
	 ;;path  is the initial before previous directory.
		   Default as above.

  Assumptions: all parameters are valid.

  Acknowledgements: Ralf Brown's interrupt list and AMIS;
		    DOSCLIP by Douglas Boling for instance data setup.

  You are free to use this code, or a portion thereof, as long as an appropriate
  acknowledgement is made.

  Questions, suggestions and comments to hoodj@topaz.cqu.edu.au.

*

VERSION_NUM	equ	200h

MaxPath 	equ	80		; These values are from dir.h
MaxDir		equ	66

byt		equ	<byte ptr>
wrd		equ	<word ptr>
ofs		equ	<offset>


__TINY__	equ	0		; Define tiny model for AMIS

		INCLUDE AMIS.MAC

		@Startup 3,00


TSRcode@

StartupInfo     =       $
 sisVersion	dw	3		; Switcher structure ID
 sisNextDev	dd	0		; Ptr to prev startup structure
 sisVirtDevFile dd	0		; Ptr to name of opt dev drvr
 sisReferenceData dd	0		; Data for Win dev drivr
 sisInstData	dd	0		; Ptr to instance mem list

DataBlockPtr	dd	0		; Ptr to instance data
DataBlockSize	dw	0		; Size of instance data
		dd	0		; Ptr to next block = 0 to
		dw	0		;   terminate list

; Instance data
DataBlock	=	$

mtdirs		db	MaxPath  dup (0)
prev		db	2*MaxDir dup (0)

DataBlockEnd	=	$

INSTDATASIZE	equ	ofs DataBlockEnd - ofs DataBlock


; Multiplex service function - return the address for mt.com:
;   DX:AX			mtdirs
;   DX:AX+MaxPath		prev[0]
;   DX:AX+MaxPath+MaxDir	prev[1]

address:
	mov	dx, cs
	mov	ax, ofs mtdirs
	iret


	HOOKED_INTS 2fh

	ALTMPX	'Adoxa', 'MTMem', VERSION_NUM,, address


; Initialise instance data
	ISP_HEADER 2fh

	cmp	ax, 1605h		; Windows launch
	je	instance
	cmp	ax, 4b05h		; Switcher instance data
	je	instance
	jmp	ORIG_INT2Fh
instance:
	pushf
	call	ORIG_INT2Fh
	mov	wrd sisNextDev, bx
	mov	wrd sisNextDev+2, es
	push	cs			; ES:BX point to switcher struc
	pop	es
	mov	bx, ofs StartupInfo

	iret

TSRcodeEnd@

;-----------------------------------------------------------------------

_TEXT	SEGMENT 'CODE'
	ASSUME	cs:_TEXT, ds:_INIT, es:TGROUP, ss:NOTHING

F_PATH	equ	01b
F_INST	equ	10b

flags	db	0			; Bit 0 - path was initialised
					;     1 - already installed
mtfile	db	'MTDIRS.DAT'            ; Filename to append to mtdirs

	@Startup2 PSP

	IF_INSTALLED get_segment
	jmp	parse

get_segment:
	mov	al, 10h
	int	2dh
	mov	es, dx
	or	flags, F_INST

parse:	mov	si, 81h 		; Command line
	xor	ah, ah			; Terminating null

param:	lodsb
	cmp	al, 0dh
	je      done
	cmp     al, ' '                 ; Ignore spaces
	je      param
	cmp	al, 9			; and tabs
	je	param

	cmp	al, ';'                 ; Is it a previous directory?
	je	isprev
	mov	di, ofs mtdirs		; Offset for directory structure path
	or	flags, F_PATH		; Indicate a path was specified
	jmp	copy

isprev: lodsb
	cmp     al, ';'                 ; Before previous directory
	je      bprev
	mov	di, ofs prev		; Offset for prev[0]
	jmp	copy

bprev:  lodsb
	mov	di, ofs prev + MaxDir	; Offset for prev[1]

copy:   cmp     al, ' '                 ; End of this parameter
	je	null
	cmp	al, 9
	je	null
	cmp     al, 0dh
	je      null
	cmp     al, '/'                 ; Replace slashes with backslashes
	jne     nslash                  ; for comparison purposes
	mov     al, '\'
	jmp     store
nslash: cmp     al, 'a'                 ; Convert lower to uppercase for the
	jb      store                   ; same reason and to select the drive
	cmp     al, 'z'
	ja      store
	and     al, 5fh
store:  stosb
	lodsb
	jmp	copy

null:	mov	byt es:[di], ah 	; Place the terminating null
	cmp	di, ofs prev		; If copying the path
	jae	more			; point BX to its end
	mov     bx, di
more:	cmp	al, 0dh 		; More parameters?
	jne	param

done:	test	flags, F_PATH		; Was a path entered?
	jnz     append                  ; Yes, so don't search for one

	mov	bx, es			; Save where I'm copying in BX
	mov	ax, ds:[2ch]		; Get the environment segment
	mov	dx, ax			; and save it in DX
	mov	es, ax
	ASSUME	es:NOTHING
	sub	di, di
	xor     al, al
	mov     cx, 0ffffh
envend: repne   scasb                   ; End of environment variable
	cmp     byt es:[di], 0          ; End of environment?
	jne     envend
	inc     di                      ; Point past the word stored after
	inc     di                      ; the environment variables to get
	inc     di                      ; the path of mtmem.com
	mov	si, ofs mtdirs		; Swap source and destination
	xchg    si, di                  ; for the copy
	mov     ds, dx
	mov	es, bx
	ASSUME	ds:NOTHING, es:TGROUP
mvpath: lodsb
	or      al, al                  ; Terminating null?
	jz	append
	stosb
	cmp     al, '\'
	jne     mvpath
	mov     bx, di                  ; BX will point to "MTMEM.COM"
	jmp     mvpath

append: mov	di, bx			; The end of the path
	cmp     byt es:[di-1], '/'      ; Is there a trailing slash
	je      app
	cmp     byt es:[di-1], '\'      ; or backslash?
	je      app
	mov	byt es:[di], '\'        ; No, so add one
	inc     di
app:	push	cs
	pop	ds
	ASSUME	ds:_TEXT
	mov	si, ofs mtfile		; The filename to append
	movsw                           ; It's ten characters
	movsw                           ; which means five words
	movsw
	movsw
	movsw
	mov	byt es:[di], al 	; Terminating null

	test	flags, F_INST
	jz	install
	mov	ax, 4c00h
	int	21h

install:
	INSTALL_TSR , BEST, TOPMEM, installed

installed:
	; Initialise the switcher instance structure
	mov	ds, ax
	ASSUME	ds:TGROUP

	mov	wrd DataBlockPtr+2, ax
	mov	wrd DataBlockPtr, ofs DataBlock
	mov	wrd DataBlockSize, INSTDATASIZE

	mov	wrd sisInstData+2, ax
	mov	ax, ofs DataBlockPtr
	mov	wrd sisInstData, ax

	ret

_TEXT	ENDS

	end	INIT
