/* strextra.c

Released into the PUBLIC DOMAIN 30 jul 1990 by jim nutt
Modified by Paul Edwards, and also released to the Public Domain

A few string handling routines for msged.

*/

#include <string.h>
#include <ctype.h>

#include "strextra.h"

void  strins(char *l, char c, int x)

{
    int     i = strlen(l);

    if (x > (i+1))
        return;
    else {
        x--;
        memmove((l + x + 1), (l + x), (i - x) + 1);
        *(l + x) = c;
    }
}

void  strdel(char *l, int x)

{
    int     i = strlen(l);

    if (x > i) return;
    x--;
    memmove((l + x), (l + x + 1), (i - x) + 1);
    *(l + i) = 0;
}

/*
 *    strncmpi() ->    strncmp(), ignore case
 */

int  strncmpi(const char *s, const char *t, size_t x)

{
    long n = (long)x;
    
    for (; n-- && (tolower(*s) == tolower(*t)); ++t)
        if (!*s++)
            return (0); /* equal */

    if (n < 0)        /* maximum hit */
        return (0);     /* equal */

    return ((tolower(*s) > tolower(*t)) ? 1 : (-1));    /* not equal */
}
