/* msged.c
**
** released into the PUBLIC DOMAIN 30 jul 1990 by jim nutt
** Changes released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
**
*/

#define SQUISH_INCL

#include <msgapi.h>
#define ULONG_DEFINED

#ifdef MSDOS
#include <process.h>
#include <dos.h>
#endif

#ifdef __OS2__
#include <process.h>
#endif

#include "msged.h"
#include "maincmds.h"
#include "bmg.h"
#include "main.h"
#include "keys.h"
#include "menu.h"
#include "help.h"
#include "nshow.h"
#include "makemsgn.h"
#include "dialogs.h"
#include "spawn.h"
#include "system.h"

/* prototypes */

void          r_assignkey(unsigned int key, char *label);
char *        r_getbind(unsigned int key);
char *        r_getlabels(int i);
int           setcwd(char *path);
static  void  highest(void);

/* local/global variables */

struct _minf minf;

int          endMain    = 0;
int          direction  = RIGHT; /* travel direction in msgbase */
int          msgederr   = 0;     /* errno for msged */
int          set_rcvd   = 1;     /* used to tell readmsg() not to set rcvd */
                                 /* only used between readmail.c and msged.c */
static ulong root       = 0;     /* root message of a thread */
static ulong back       = 0;     /* what ? */
static ulong areastart  = 0;     /* msg number we started on in this area */
static ulong lastfound  = 0;     /* msg number last found */
static ulong oldmsg     = 0;
static int command;

#if defined(MSDOS) && defined(__TURBOC__)
extern unsigned _stklen = 8096;
#endif

char *  show_address(ADDRESS a)
{
    static char s[80];
    char field[20];

    memset(s,0,sizeof s);
    memset(field,0,sizeof field);

    if (a.notfound)
    {
        strcpy(s,"unknown");
        return(s);
    }

    if (a.fidonet)
    {
        if (a.zone)
        {
            sprintf(field, "%d", a.zone);
            strcat(s,field);
            strcat(s,":");
        }
        sprintf(field, "%d", a.net);
        strcat(s,field);
        strcat(s,"/");
        sprintf(field, "%d", a.node);
        strcat(s,field);
        if (a.point)
        {
            strcat(s,".");
            sprintf(field, "%d", a.point);
            strcat(s,field);
        }

        if (a.domain != NULL)
        {
            strcat(s,"@");
            strcat(s,a.domain);  /* could be strlwr()'ed */
        }
    }

    if (a.internet)
    {
        strncpy(s,a.domain,60);
    }

    if (a.bangpath)
    {
        char *t,*t1;

        t1 = strrchr(a.domain,'!');
        if (t1 == NULL)
            strcpy(s,a.domain);
        else {
            *t1 = '\0';
            t = strrchr(a.domain,'!');
            if (!t)
                t = a.domain;
            *t1 = '!';
            strcat(strcpy(s,"..."),t);
        }

    }
    return(s);
}

static void   delete()
{
    deletemsg();
}

static void   move()
{
    movemsg();
}

static void   outtxt()
{
    if (message != NULL)
        writetxt();
}

static void   set()
{
    set_switch();
}

static void  chngaddr()
{
    change_curr_addr();
}

static void  chngname()
{
    change_username();
}

static void   chngnodel()
{
    change_nodelist();
}

static void   do_help(void)
{
    show_help();
}

static void   first()
{
    CurArea.current = CurArea.first;
}

char *  r_getbind(unsigned int key)
{
    unsigned int i = 0;
    void (  *action)();

    if (key & 0xff)
        action = mainckeys[key & 0xff];
    else
        action = mainakeys[(key >> 8) & 0xff];

    while ((maincmds[i].label != NULL) &&
           (action != maincmds[i].action))
        i++;

    return(maincmds[i].label);

}

char *  r_getlabels(int i)
{
    return(maincmds[i].label);
}

void  r_assignkey(unsigned int key, char *label)
{
    unsigned int i = 0;

    while ((maincmds[i].label != NULL) &&
           (strncmp(maincmds[i].label,label,strlen(maincmds[i].label)) != 0))
        i++;

    if (maincmds[i].label != NULL)
        if (key & 0xff)
            mainckeys[key & 0xff] = maincmds[i].action;
        else
            mainakeys[(key >> 8) & 0xff] = maincmds[i].action;
}

ADDRESS  parsenode(char *t)
{
    ADDRESS tmp;
    char   *t1    = t;
    int     n     = 0;
    int     point = 0;
    char   *s, ch;

    if (SW->areas)
        tmp = CurArea.addr;
    else
        tmp = thisnode;

    tmp.point    = tmp.notfound = 0;
    tmp.fidonet  = 1;
    tmp.internet = 0;
    tmp.bangpath = 0;
    tmp.domain   = NULL;

    if (t == NULL)
    {
        tmp.notfound = 1;
        return(tmp);
    }

    while (isspace(*t)) t++;
    if (!isdigit(*t))
    {
        tmp.notfound = 1;
        tmp.fidonet  = 0;
        tmp.internet = 0;
        tmp.bangpath = 0;
        return tmp;
    }

    while (t1)
    {
        n = (int) strtol(t1,&t1,10);

        if (t1 == NULL)
        {
            if (point)
                tmp.point = n;
            else
                tmp.node = n;
            if (tmp.zone == 0)
                tmp.zone = CurArea.addr.zone;
            return tmp;
        }

        switch (*t1)
        {
            case ')' :
            case ' ' :
            case '\0':
                if (point)
                    tmp.point = n;
                else
                    tmp.node = n;
                if (tmp.zone == 0)
                    tmp.zone = CurArea.addr.zone;
                return(tmp);

            case ':' :
                tmp.zone = n;
                break;

            case '/' :
                tmp.net = n;
                break;

            case '.' :
                tmp.node = n;
                point    = 1;
                break;

            case '@' :
                if (point)
                    tmp.point = n;
                else
                    tmp.node = n;

                release(tmp.domain);

                s = t1 + 1;
                while (*s && !isspace(*s) && *s != ')') s++;

                if (*s)
                {
                    ch = *s;
                    *s = '\0';
                }
                else
                    ch = 0;

                tmp.domain = strdup(t1+1);

                if (ch)
                    *s = ch;

                if (tmp.zone == 0)
                    tmp.zone = CurArea.addr.zone;

                return tmp;
        }
        t1++;
    }
    if (tmp.zone == 0)
        tmp.zone = CurArea.addr.zone;

    return tmp;
}

void  dispose(msg *message)
{
    if (message == NULL)
        return;

    if (message->text != NULL)
        message->text = clearbuffer(message->text);

    release(message->isto);
    release(message->isfrom);
    release(message->reply);
    release(message->msgid);
    release(message->subj);
    release(message->to.domain);
    release(message->from.domain);
    release(message);
}


msg *KillMsg(msg *m)
{
    dispose(m);
    return NULL;
}


/*
**
** Lets the user edit the header only.
**
*/

static void  edithdr(void)
{
    int  q;

    if (message == NULL)
        return;

    q    = 0;
    while (!q)
    {
        if (EditHeader(message) == Key_Esc)
        {
            if (confirm())
            {
                message = KillMsg(message);
                return;
            }
        }
        else
            q = 1;
    }
    MsgWriteHeader(message, WR_HEADER);
    message = KillMsg(message);
}


void  cleanup(char *msg)
{
#ifdef __OS2__
    int errorlevel = 0;
#else
    unsigned char errorlevel = 0;
#endif
    FILE *fp = NULL;
    AREA *a;

    highest();
    AreaSetLast(CurArea);
    MsgAreaClose();
    setcwd(ST->home);
    WClose(hMnScr);
    TTgotoxy(term.NRow - 1, 0);
    TTclose();

    for (a = &(arealist[SW->area = 0]); SW->area < SW->areas; a = &(arealist[++SW->area]))
    {
        errorlevel |= (a->netmail  && a->new) ?  0x01 : 0;
        errorlevel |= (a->echomail && a->new) ?  0x02 : 0;
        errorlevel |= (a->uucp     && a->new) ?  0x04 : 0;
        errorlevel |= (a->news     && a->new) ?  0x08 : 0;
        errorlevel |= (a->local    && a->new) ?  0x10 : 0;

        if (a->echomail && a->new)
        {
            if (fp == NULL)
            {
                if (*ST->confmail == '+')
                    fp = fopen(ST->confmail+1,"a");
                else
                    fp = fopen(ST->confmail, "w");
            }
            if (a->tag && fp != NULL)
                fprintf(fp, "%s\n", a->tag);
        }
    }

    if (fp)  fclose(fp);
    if (msg) printf("\n%s", msg);

    printf("\nexiting with errorlevel %d\n",errorlevel);

    DeinitMem();
    MsgCloseApi();
    TTCurSet(1);

    exit(errorlevel);
}

static void  quitc(void)
{
    if (confirm()) 
    {
        quit();
    }
    return;
}

static void  quit(void)
{
    cleanup(NULL);
    return;
}

void  outamemory(void)
{
    cleanup("OutaMemory! <tm>");
    return;
}

static void  search(void)
{
    LINE          *l;
    static char    prompt[256] = "";
    static char    patstr[256] = "";
    char           tempstr[40];
    msg           *m      = NULL;
    ulong          tmp    = 0;
    int            done   = 0;

    if (!GetString(" Find String ", "Enter string to search for:", prompt, 64))
        return;

    if (strlen(prompt) == 0)
        return;

    sprintf(tempstr, " Searching for \"%.30s\" ", prompt);

    if (!OpenMsgWnd((strlen(tempstr) + 8), 6, tempstr, NULL, 0, 0))
        return;

    message  = KillMsg(message);

    /*
    ** We use this to ensure the rcvd bit doesn't get set.
    ** Possibly a mistake if the msg found is addressed to the user...
    */

    set_rcvd = 0;

    SendMsgWnd("ESC to Abort", 0);

    if ((strcmpl(prompt, patstr) == 0) && (lastfound == CurArea.current)
        && (CurArea.current < CurArea.messages))
    {
        tmp = CurArea.current + 1;
    }
    else 
    {
        tmp       = CurArea.current;
        lastfound = 0;
        strcpy(patstr, prompt);
        bmg_setsearch(prompt);
    }

    for (;tmp <= CurArea.messages; tmp++)
    {
        /* check for event here */

        if (done == TRUE || (KeyHit() && GetKey() == Key_Esc))
            break;

        l = NULL;

        if ((m = readmsg(tmp)) != NULL)
        {
            sprintf(tempstr, "Looking at #%ld", tmp);
            SendMsgWnd(tempstr, 1);

            if (bmg_search(m->isto) != NULL)
            {
                done = TRUE;
                break;
            }

            if (bmg_search(m->isfrom) != NULL)
            {
                done = TRUE;
                break;
            }

            if (bmg_search(m->subj) != NULL)
            {
                done = TRUE;
                break;
            }

            l = m->text;

            while ((l != NULL) && (done == FALSE))
            {
                if (l->text && (strlen(l->text) > 0))
                {
                    if (bmg_search(l->text) != NULL)
                    {
                        done = TRUE;
                        break;
                    }
                }
                l = l->next;
            }
            if (done == TRUE)
                break;

            dispose(m);
            m = NULL;
        }
    }
    CloseMsgWnd();

    set_rcvd = 1;               /* readmsg() is now free to set it */

    if (done)
    {
        CurArea.current = tmp;
        lastfound       = tmp;
        oldmsg          = tmp;
        message         = m;

        ShowMsgHeader(message);

        if (l != NULL)
        {
            l->block = TRUE;
            RefreshMsg(l, 6);
        }
        else
            RefreshMsg(message->text, 6);
    }
    else
    {
        dispose(m);
    }
    return;
}


/*/$/ int  confirm();
**
** Ask if the user is doing something
** on purpose (Never! :-)
**
*/

int  confirm(void)
{
    int ret;

    if (!SW->confirmations)
        return TRUE;

    ret = ChoiceBox(" Confirm ", "Do you want to do this?", "Ok", "Cancel", NULL);

    return (ret == ID_ONE);
}


/*
**
** Sets up the operating vars for the current area.
**
*/

void SetupArea(void)
{
    lastfound  = 0;
    direction  = RIGHT;
    back       = CurArea.current;
    root       = CurArea.current;
    areastart  = CurArea.current;

    /*
    ** Set this area up with it's info:
    **      The template,
    **      The username,
    **      lastread (fido areas) name,
    **      useroffset (squish areas).
    */

    release(ST->username);
    release(ST->template);
    release(ST->lastread);

    ST->username   = strdup(user_list[CurArea.username].name);
    SW->useroffset = user_list[CurArea.username].offset;
    ST->lastread   = strdup(user_list[CurArea.username].lastread);

    if (templates != NULL)
        ST->template = strdup(templates[CurArea.template]);
}

/*/$/
**
** Opens a new area & sets all the vars.
**
*/

void  set_area(int newarea)
{
    int done = 0;
    int ret;

    if (CurArea.status)            /* close current area, if open */
    {
        highest();
        AreaSetLast(CurArea);
        MsgAreaClose();
    }

    message  = KillMsg(message);
    SW->area = newarea;

    while (!CurArea.status && !done)
    {
        CurArea.messages = MsgAreaOpen(&CurArea);

        if (!CurArea.status)
        {
            ret = ChoiceBox(" Error ",  "Error opening area;", "Retry", "New area", "Cancel");

            switch (ret)
            {
                case ID_TWO:
                    SW->area = selectarea();
                    break;

                case ID_THREE:
                    done = TRUE;
                    break;

                default:
                    break;
            }
        }
        else
            done = TRUE;
    }
    ShowNewArea();                   /* display the new area */
}


/*/$/ void AreaScan();
**
** Scans all the areas for new mail, calling
** scan_areas(), but is callable from other
** modules.
*/

void  area_scan(void)
{
    scan_areas();
}


/*/$/ static void   scan_areas();
**
** Scans all the areas for new messages.
** Saves the current area & returns to it.
*/

static void  scan_areas(void)
{
    char line[255];
    int  a = SW->area;

    if (!OpenMsgWnd(50, 6, " Scanning Areas for new Messages ", NULL, 0, 0))
        return;

    SendMsgWnd("ESC to Abort", 0);

    if (CurArea.status)
    {
        highest();
        AreaSetLast(CurArea);
        MsgAreaClose();
    }

    for (SW->area = 0; SW->area < SW->areas; SW->area++)
    {
        sprintf(line, "%.40s" , CurArea.description);
        SendMsgWnd(line, 1);

        if (KeyHit() && GetKey() == Key_Esc)
            break;

        CurArea.messages = MsgAreaOpen(&CurArea);

        if (CurArea.status)
            MsgAreaClose();
    }
    CloseMsgWnd();
    SW->scanned      = TRUE;
    SW->area         = a;
    CurArea.messages = MsgAreaOpen(&CurArea);
}

/*
**
** Goes to the next area with unread messages.
**
*/

static void   next_area(void)
{
    int NewArea;
    int OldArea;

    if (SW->areas < 2)
        return;

    OldArea = SW->area;

    if (SW->scanned)
    {
        NewArea = (SW->area + 1) % SW->areas;
        while ((long)arealist[NewArea].messages
               <= (long)arealist[NewArea].lastread)
        {
            NewArea = (NewArea + 1) % SW->areas;
            if (NewArea == OldArea)
            {
                NewArea = (NewArea + 1) % SW->areas;
                break;
            }
        }
    }
    else
        NewArea = (SW->area + 1) % SW->areas;

    set_area(NewArea);
    SetupArea();
}

/*
**
** Goes to the previous area with unread messages.
**
*/

static void   prev_area(void)
{
    int OldArea;
    int NewArea;

    if (SW->areas < 2)
        return;

    OldArea = SW->area;
    NewArea = SW->area;

    if (SW->scanned)
    {
        NewArea--;
        NewArea = (SW->area < 0) ? SW->areas - 1 : NewArea;
        while (((long) arealist[NewArea].messages - (long) arealist[NewArea].lastread - 1) <= 0)
        {
            NewArea--;
            NewArea = (NewArea < 0) ? SW->areas - 1 : NewArea;
            if (NewArea == OldArea)
            {
                NewArea--;
                NewArea = (NewArea < 0) ? SW->areas - 1 : NewArea;
                break;
            }
        }
    }
    else
    {
        NewArea--;
        NewArea = (NewArea < 0) ? SW->areas - 1 : NewArea;
    }

    set_area(NewArea);
    SetupArea();
}


/*
**
** Sets the higest read message.
**
*/

static void   highest()
{
    CurArea.lastread = min(max(CurArea.lastread, CurArea.current), CurArea.messages);
    root             = CurArea.current;
}


/*
**
** Goes one message to the left.
**
*/

static void   left(void)
{
    direction = LEFT;

    if (CurArea.current > 1)
        CurArea.current--;

    root = CurArea.current;
}


/*
**
** Goes one message to the right.
**
*/

static void   right(void)
{
    direction = RIGHT;

    if (CurArea.current < CurArea.messages)
        CurArea.current++;

    highest();
}


/*
**
** Gets a number from the user and goes
** to that msg number if valid.
**
*/

static void   gotomsg(ulong i)
{
    EVT  e;
    WND *hWnd, *hCurr;
    char buf[10] = " ";                            /* MUST be initialized! */
    int  done    = 0;
    int  disp    = 1;
    int  ret;
    int  pos;

    hCurr = Wtop();
    hWnd  = WPopUp(30, 6, INSBDR|SHADOW, cm[IP_BTXT], cm[IP_NTXT]);
    WTitle(" Goto Message ", cm[IP_NTXT]);
    WWriteStr(1, 1, cm[IP_NTXT], "Message #?");

    sprintf(buf, "%lu", i);
    pos = strlen(buf);

    while (!done)
    {
        ret = WGetLine(17, 1, 4, buf, cm[IP_ETXT], &pos, 0, 0, disp, &e);
        switch (e.msgtype)
        {
            case WM_CHAR:
                switch (ret)
                {
                    case Key_Ent:
                        i = atoi(buf);

                        if (i == 0)
                        {
                            done = 1;
                            i     = CurArea.current;
                        }
                        else
                        {
                            if (i > 0 && i <= CurArea.messages)
                                done = 1;
                        }
                        break;

                    case Key_Esc:
                        done = 1;
                        i     = CurArea.current;
                        break;

                    default:
                        break;
                }
                break;

            default:
                break;
        }
        disp = 0;
    }
    WClose(hWnd);
    WCurr(hCurr);
    CurArea.current = i;
    highest();
}


/*
**
** Gets a new area from the user and goes to it.
**
*/

void  newarea(void)
{
    int new;

    if (SW->areas < 2)
        return;

    new = selectarea();

/*
** Commented out to ensure that an area is re-scanned this way.
**

    if (new == SW->area)
        return;

*/
    if (CurArea.status)
    {
        highest();
        AreaSetLast(CurArea);
        MsgAreaClose();
    }

    set_area(new);
    SetupArea();
}


/*
**
** Reads the config file(s) and starts up
** by reading a message.
**
*/

static int   start(char *cfg, char *afn)
{
    opening(cfg, afn);

    SW->area         = 0;
    CurArea.messages = MsgAreaOpen(&CurArea);
    root             = CurArea.current;
    back             = root;
    areastart        = CurArea.current;
    message          = NULL;

    if (CurArea.status && CurArea.messages > 0)
        message = readmsg(CurArea.current);

    return 0;
}

/*
**
** Goes to the highest-read message in the msgbase.
**
*/

static void   go_last(void)
{
    CurArea.current = min(CurArea.lastread, CurArea.messages);
    root            = CurArea.current;
}

/*
**
** Goes to the abs last msg in the msgbase.
**
*/

static void   slast(void)
{
    CurArea.current = CurArea.messages;
    highest();
}

/*
**
** Goes to the first read msg in the msgbase
** (for this session).
*/

static void   astart(void)
{
    CurArea.current = min(areastart, CurArea.messages);
    highest();
}


/*
**
** Goes to the message that the current
** message is a reply to.
*/

static void   link_from(void)
{
    if (!message || !message->replyto)
        return;

    CurArea.current = message->replyto;
}


/*
**
** Toggles the showing of hidden information.
**
*/

static void   view()
{
    SW->shownotes = !SW->shownotes;
/*    SW->seenbys   = SW->shownotes; */
    message       = KillMsg(message);
}


/*
** Function to format names for link_to().
*/

char *  split_name(char *txt, char *new)
{
    char *s, *c;

    s = strchr(txt,' ');
    if (s == NULL)
    {
        strncpy(new, txt, 36);
        return new;
    }
    c = new;
    *c++ = (char)toupper(*txt);
    *c++ = '.';
    strcpy(c, ++s);
    return new;
}


/*/$/ static void   link_to()
**
** Links up the msgbase, putting up a small
** menu if there are more than one msg to go
** to. Quite compilcated.
*/

static void   link_to(void)
{
    msg  *m      = NULL;
    ulong cnt, k = 0;
    char  txtbuf[40];
    char  fr[40];
    char  *replies[11];

    if (!message)
        return;

    for (cnt = 0; cnt < 10; cnt++)
    {
        if (message->replies[(size_t)cnt] != 0) k++;
    }
    if (k < 1)
        return;
    else
    {
        if (k == 1)
        {
            for (cnt = 0; cnt <= 10; cnt ++)
            {
                if (message->replies[(size_t)cnt] != 0)
                    break;
            }
            CurArea.current  = message->replies[(size_t)cnt];
            CurArea.lastread = max(CurArea.lastread,CurArea.current);
            return;
        }
    }
    k = 0;
    for (cnt = 0; cnt < 10; cnt++)
    {
        if (message->replies[(size_t)cnt] != 0)
        {
            if ((m = MsgReadHeader(message->replies[(size_t)cnt], 
                                   RD_HEADER)) != NULL)
            {
                sprintf(txtbuf,"%3ld. %.12s", 
                        message->replies[(size_t)cnt], 
                        split_name(m->isfrom, fr));

                if ((replies[(size_t)k++] = strdup(txtbuf)) == NULL)
                    break;

                m = KillMsg(m);
            }
        }
    }
    replies[(size_t)k] = NULL;

    cnt = DoMenu(maxx - 23, 9, maxx - 6, 9 + (int) k - 1, replies, 0);

    if (cnt != (ulong)-1)
    {
        CurArea.current  = atoi(replies[(size_t)cnt]);
        CurArea.lastread = max(CurArea.lastread, CurArea.current);
    }

    for (k = 0; k < 10; k++)
    {
        if (replies[(size_t)k] == NULL)
            break;

        free(replies[(size_t)k]);
    }
}


/*
**
** Does the same as above but ignores all but
** the first reply chain.
*/

static void   go_next(void)
{
    if (!message || !message->replies[0])
        return;

    back             = CurArea.current;
    CurArea.current  = message->replies[0];
    CurArea.lastread = max(CurArea.lastread,CurArea.current);
}


/*
**
** Goes to the first msg in a reply chain.
** (you must have navigated through it already).
*/

static void   go_root()
{
    back            = CurArea.current;
    CurArea.current = root;
    highest();
}


/*
**
** Sets the ROT char.
**
*/

static void   rotate()
{
    rot13   = (rot13 + 1) % 3;
    message = KillMsg(message);
}


#ifndef __OS2__

/* These swap routines imply the use of Thomas Wagner's EXEC module */
/* somewhere in the executable.  If you don't have this (it's free, */
/* and PD), then simply comment it out and use the same function as */
/* the os2 versiom.                                                 */

/* Return codes (only upper byte significant) */

#define RC_PREPERR   0x0100
#define RC_NOFILE    0x0200
#define RC_EXECERR   0x0300
#define RC_ENVERR    0x0400
#define RC_SWAPERR   0x0500

/* Swap method and option flags */

#define USE_EMS      0x01
#define USE_XMS      0x02
#define USE_FILE     0x04
#define EMS_FIRST    0x00
#define XMS_FIRST    0x10
#define HIDE_FILE    0x40
#define NO_PREALLOC  0x100
#define CHECK_NET    0x200

#define USE_ALL      (USE_EMS | USE_XMS | USE_FILE)

extern int do_spawn (int swapping,     /* swap if non-0 */
                     char *xeqfn,      /* file to execute */
                     char *cmdtail,    /* command tail string */
                     unsigned envlen,  /* environment length */
                     char *envp);      /* environment pointer */

#define SWAP_FILENAME "$msgedsq.swp" 

/* internal flags for prep_swap */

#define CREAT_TEMP      0x0080
#define DONT_SWAP_ENV   0x4000

#endif

void  shell_to_dos(void)
{
#ifndef __OS2__
    
    int rc;

    char swapfn[PATHLEN];
    char **envp  = environ, **env, *envbuf, *envptr, *ep;
    int swapping = USE_ALL|HIDE_FILE;
    int envlen   = 0;
    
    if (envp != NULL)
        for (env = envp; *env != NULL; env++)
            envlen += strlen (*env) + 1;

    if (envlen)
    {
        envlen = (envlen + 32) & 0xfff0;
        envbuf = (char *) malloc(envlen);

        if (envbuf == NULL)
            outamemory();

        envptr = envbuf;

        if (FP_OFF (envptr) & 0x0f)
            envptr += 16 - (FP_OFF (envptr) & 0x0f);

        ep = envptr;

        for (env = envp; *env != NULL; env++)
        {
            strcpy(ep, *env);
            ep = ep + strlen(*env) + 1;
        }
        *ep = 0;
    }

    if (ST->swap_path)
        sprintf(swapfn, "%s\\%s", ST->swap_path, SWAP_FILENAME);
    else
        strcpy(swapfn, SWAP_FILENAME);

    rc = prep_swap(swapping, swapfn);
    
    if (rc > -1) 
        rc = do_spawn(swapping, ST->comspec, "", envlen, envptr);
    else
    {
        fputs("\nError occured during swap...Press <enter> to return;",stderr);
        GetKey();
    }

#else /* ifndef __OS2__ */

    spawnl(0, ST->comspec, ST->comspec, NULL);

#endif    
}

static void  go_dos(void)
{
    char tmp[PATHLEN];
    
    mygetcwd(tmp,PATHLEN);
    setcwd(ST->home);

    cursor(TRUE);
    WClose(hMnScr);
    KillHotSpots();
    TTgotoxy(term.NRow - 1, 0);
    TTclose();

    fputs("Type EXIT to return to Msgedsq.",stderr);
    shell_to_dos();

    InitScreen();
    BuildHotSpots();
    DrawHeader();
    message = KillMsg(message);
    cursor(FALSE);
    setcwd(tmp);
}


static void   rundos()
{
    WND *hCurr, *hWnd;
    char tmp[PATHLEN];
    char cmd[64];
    int  ret;

    mygetcwd(tmp,PATHLEN);
    memset(cmd,0,sizeof cmd);

    if (!GetString(" Dos Command ", "Enter DOS command to execute:", cmd, 64))
        return;

    hCurr = Wtop();
    if ((hWnd = WndOpen(0, 0, maxx-1, maxy-1, NBDR, 0, cm[CM_NTXT])) == NULL)
        return;

    cursor(TRUE);

    ret = system(cmd);

    cursor(FALSE);

    sprintf(tmp, "DOS command returned %d", ret);
    ChoiceBox(" Info ", tmp, "Ok", NULL, NULL);

    WClose(hWnd);
    WCurr(hCurr);
    setcwd(tmp);
    message = KillMsg(message);
}


static void   nada()
{
    /* do nothing */
}

void  dolist(void)
{
    do_list();
    ClearScreen();
    DrawHeader();
    ShowNewArea();
}

static void  list(void)
{
    dolist();
}

int CKey(int ch)
{
    return ConvertKey(ch);
}

int main(int argc, char *argv[])
{
    EVT event;
    int newmsg  = 1;
    int empty   = 0;

    minf.def_zone    = 0;                     /* set default zone */
    minf.req_version = 0;                     /* level 0 of the MsgAPI */
    MsgOpenApi(&minf);                        /* init the MsgAPI  */

    if ((argc > 1) && (argc < 3))
        command = start(argv[1], NULL);
    else if (argc > 1)
        command = start(argv[1], argv[2]);
    else
        command = start(NULL, NULL);

    if (ST->helpfile)
        HelpInit(ST->helpfile);

    BuildHotSpots();
    DrawHeader();
    ShowNewArea();
    RegisterKeyProc(CKey);   /* to allow for macros in the system */

    while (!endMain)        /* endless loop... exit is through cleanup */
    {
        if (!CurArea.messages || newmsg || !CurArea.status || !message)
        {
            if (!CurArea.status || !message || !CurArea.messages)
            {
                if (!empty)
                {
                    ClearMsgScreen();
                    empty = 1;
                }
            }
            else
                empty = 0;

            ShowMsgHeader(message);

            newmsg = 0;

            if (message)
                RefreshMsg(message->text, 6);
        }

        oldmsg  = CurArea.current;
        command = MnuGetMsg(&event, hMnScr->wid);

        switch (event.msgtype)
        {
            case WM_COMMAND:
                switch(command)
                {
                    case LMOU_CLCK:
                        switch (event.id)
                        {
                            case ID_LNDN:
                                link_from();
                                break;

                            case ID_LNUP:
                                link_to();
                                break;

                            default:
                                break;
                        }
                        break;
                    case MOU_LBTDN:
                    case LMOU_RPT:
                        switch (event.id)
                        {
                            case ID_SCRUP:
                                Go_Up();
                                break;

                            case ID_SCRDN:
                                Go_Dwn();
                                break;

                            case ID_MGLFT:
                                left();
                                break;

                            case ID_MGRGT:
                                right();
                                break;

                            default:
                                break;
                        }
                        break;

                    default:
                        break;
                }
                break;

            case WM_MOUSE:
                switch (command)
                {
                    case MOU_LBTDN:
                        if (event.x >= (maxx - MNU_LEN - 1) && event.y == 0)
                            command = ProcessMenu(&MouseMnu, &event, 0);

                        if (command == ID_QUIT)
                            quit();
                        break;

                    default:
                        break;
                }
                break;

            case WM_CHAR:
                switch (command)
                {
                    case Key_PgUp:
                        Go_PgUp();
                        break;

                    case Key_PgDn:
                    case Key_Spc:
                        Go_PgDwn();
                        break;

                    case Key_Up:
                        Go_Up();
                        break;

                    case Key_Dwn:
                        Go_Dwn();
                        break;

                    default:
                        if (command & 0xff)
                        {
                            if (isdigit(command))
                                gotomsg(command - 0x30);
                            else
                                if (mainckeys[command])
                                    mainckeys[command & 0xff]();
                        }
                        else
                            if (mainakeys[command >> 8])
                                mainakeys[command >> 8]();
                        break;
                }
                break;
        }

        if (CurArea.messages > 0 && (!message || oldmsg != CurArea.current || CurArea.current == 0))
        {
            message = KillMsg(message);

            if (CurArea.current == 0)
                CurArea.current = 1;

            if (CurArea.status)
            {
                message = readmsg(CurArea.current);
                newmsg  = 1;
            }
        }
    }
    return (0);
}

/*--- end ---*/
