/* mnu.c
**
** released into the PUBLIC DOMAIN 10 jul 1994 by John Dennis
**
** Routines to display horizontal and vertical menus with full
** drag/browse mouse support.
*/

#define DEBUG  0

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "WinSys.h"
#include "menu.h"
#include "keys.h"

#if DEBUG

#define ID_SCAN   201
#define ID_QUIT   202
#define ID_AREA   203
#define ID_SETUP  204

MC submenu2 = {
    9, 1, 27, 13,
    CMD_VER,
    SBDR,
    2,
    2,
    15,
    0,
    11,
    {{ 9,  0, NULL, NULL, "File",    'f', 0, 0},
     { 10, 0, NULL, NULL, "Edit",    'e', 1, 0},
     { 11, 0, NULL, NULL, "Compile", 'c', 2, 0},
     { 12, 0, NULL, NULL, "Debug",   'd', 3, 0},
     { 13, 0, NULL, NULL, "Debug1",  'd', 4, 0},
     { 14, 0, NULL, NULL, "Debug2",  'd', 5, 0},
     { 15, 0, NULL, NULL, "Debug3",  'd', 6, 0},
     { 16, 0, NULL, NULL, "Debug4",  'd', 7, 0},
     { 17, 0, NULL, NULL, "Debug5",  'd', 8, 0},
     { 18, 0, NULL, NULL, "Debug6",  'd', 9, 0},
     { 19, 0, NULL, NULL, "Debug7",  'd', 10, 0}}
  };

MC submenu1 = {
    0, 1, 18, 6,
    CMD_VER,
    SBDR,
    1,
    2,
    15,
    0,
    4,
    {  5, 0, NULL, NULL, "File",    'f', 0, 0,
       6, 0, NULL, NULL, "Edit",    'e', 1, 0,
       7, 0, NULL, NULL, "Compile", 'c', 2, 0,
       8, 0, NULL, NULL, "Debug",   'd', 3, 0
    }
  };

int Scan(void);
int Area(void);
int Setup(void);

MC MainMenu = {
    0, 0, 60, 0,
    CMD_HOR,
    NBDR,
    0,
    2,
    9,
    0,
    4,
    { ID_SCAN,  0,        Scan,  NULL, "Scan",  'c', 0, 0,
      ID_AREA,  0,        Area,  NULL, "Area",  'a', 0, 9,
      ID_SETUP, 0,        Setup, NULL, "Setup", 's', 0, 18,
      ID_QUIT,  CMD_EXIT, NULL,  NULL, "Quit",  'q', 0, 27
    }
  };

#endif

int PullDown = 0;
int ExitType = 0;

static int bc = WHITE|_CYAN;
static int nc = BLACK|_CYAN;
static int sc = WHITE|_BLACK;

static int GetFocus(cmd *cmdtab, int num, int id)
{
    int i;

    for (i = 0; i < num; i++)
        if (cmdtab[i].id == id)
            return i;

    return -1;
}

static void DispItem(cmd *c, byte attr, int indent, int slen, int type)
{
    char text[255];
    int  len;

    if (!c || !c->itmtxt)
        return;

    len = strlen(c->itmtxt);
    memset(text, ' ', slen+2);
    strncpy(text+indent, c->itmtxt, len);
    *(text + slen) = '\0';
    if (type == CMD_VER)
        WPutsn(0, c->row, slen, attr, text);
    else
        WPutsn(c->col, c->row, slen, attr, text);
}

static int NextItem(int num, int cur)
{
    cur++;

    if (cur == num)
        cur = 0;

    return cur;
}

static int PrevItem(int num, int cur)
{
    cur--;

    if (cur < 0)
        cur = num - 1;

    return cur;
}

/*
**
** Displays a horizontal menu in a window, according to
** the info in the passed MC structure.
**
** The current mouse position is passed to the function
** to pinpoint the item where the mouse hit before calling
** this function.
*/

int ProcessMenu(MC *m, EVT *event, int show)
{
    HotGroup  Hot;
    WND      *hCurr, *hWnd;
    cmd      *cmdtab  = m->cmdtab;
    int       num     = m->num;
    int       Focus   = m->cur;
    int       mnu     = m->mode;
    int       len     = m->len;
    int       OldFoc  = 0;
    int       done    = 0;
    int       select  = 0;
    int       Msg;
    int       NewFoc;
    int       i, j;

    if (m->btype & INSBDR)
        m->btype = SBDR;

    hCurr = Wtop();
    if (!show && !(m->mode & CMD_PRT))
    {
        if ((hWnd = WndOpen(m->x1, m->y1, m->x2, m->y2, m->btype, bc, nc))==NULL)
        {
            WCurr(hCurr);
            return ERROR;
        }
    }
        
    if (m->btype & NBDR)
         j = 0;
    else j = 1;

    for (i = 0; i < num; i++)
    {
/*      len            = strlen(cmdtab[i].itmtxt); */
        Hot.harr[i].id = cmdtab[i].id;
        Hot.harr[i].x1 = m->x1 + j + cmdtab[i].col;
        Hot.harr[i].x2 = m->x1 + j + cmdtab[i].col + len /* + (m->indent * 2) */;
        Hot.harr[i].y1 = m->y1 + j + cmdtab[i].row;
        Hot.harr[i].y2 = m->y1 + j + cmdtab[i].row;
        DispItem(&cmdtab[i], (byte)nc, m->indent, m->len, mnu);
    }

    if (show)
    {
        return 0;
    }

    Hot.num = num;
    Hot.wid = WN_MENU;

    PushHotGroup(&Hot);

    if (event->msg)
    {
        if (event->msgtype == WM_COMMAND)
            Focus = GetFocus(cmdtab, m->num, event->id);
        else
        {
            if (event->msgtype == WM_MOUSE)
            {
                Focus = LocateHotItem(event->x, event->y, WN_MENU);
                if (Focus)
                    Focus = GetFocus(cmdtab, m->num, Focus);
            }
        }
        if (Focus == -1) Focus = 0;
    }

    DispItem(&cmdtab[Focus], (byte)sc, m->indent, m->len, mnu);

    while (!done)
    {
        if (select)
        {
            if (cmdtab[Focus].m_sub)
            {
                ProcessMenu(cmdtab[Focus].m_sub, event, 0);
            }
            else
            {
                if (cmdtab[Focus].flags & CMD_EXIT)
                {
                    done = TRUE;
                    continue;
                }
                else
                {
                    if (cmdtab[Focus].itmfunc != NULL)
                    {
                        (*cmdtab[Focus].itmfunc)();
                    }
                    done = TRUE;   /* should we exit here ? */
                    continue;
                }
            }
            select = 0;
        }
        else
            Msg = MnuGetMsg(event, WN_MENU);

        OldFoc = Focus;

        switch (event->msgtype)
        {
            case WM_COMMAND:
                if ((NewFoc = GetFocus(cmdtab, m->num, event->id)) != -1)
                {
                    switch (Msg)
                    {
                        case MOU_LBTUP:
                        case LMOU_CLCK:
                            Focus  = NewFoc;
                            select = TRUE;
                            break;

                        case MOU_LBTDN:
                        case LMOU_RPT:
                        case MOUSE_EVT:
                            Focus = NewFoc;
                            if (cmdtab[Focus].m_sub)
                                select = TRUE;
                            break;

                        default:
                            break;
                    }
                }
                else
                {
                    if (mnu == CMD_VER && event->msg != m->parent)
                    {
                        done = TRUE;
                    }
                }
                break;

            case WM_MOUSE:
                switch (Msg)
                {
                    case LMOU_CLCK:
                    case MOU_LBTUP:
                        done = TRUE;
                        break;

                    default:
                        break;
                }
                break;

            case WM_CHAR:
                switch (Msg)
                {

                    case Key_Up:
                        if (mnu == CMD_VER)
                            Focus = PrevItem(m->num, Focus);
                        break;

                    case Key_Dwn:
                        if (cmdtab[Focus].m_sub)
                            select = TRUE;

                        if (mnu == CMD_VER)
                            Focus = NextItem(m->num, Focus);
                        break;

                    case Key_Lft:
                        if (mnu == CMD_HOR)
                            Focus = PrevItem(m->num, Focus);
                        else
                            done = TRUE;
                        break;

                    case Key_Rgt:
                        if (mnu == CMD_HOR)
                            Focus = NextItem(m->num, Focus);
                        else
                            done = TRUE;
                        break;

                    case Key_Esc:
                        done = TRUE;
                        break;

                    case Key_Ent:
                        select = TRUE;
                        break;

                    default :
                        break;
                }
                break;

            default:
                break;
        }
        if (Focus != OldFoc)
        {
            DispItem(&cmdtab[OldFoc], (byte)nc, m->indent, m->len, mnu);
            DispItem(&cmdtab[Focus],  (byte)sc, m->indent, m->len, mnu);
        }
    }
    DispItem(&cmdtab[Focus], (byte)nc, m->indent, m->len, mnu);
    PopHotGroup();
    if (!(m->mode & CMD_PRT))
    {
        WClose(hWnd);
        WCurr(hCurr);
    }
    if ((cmdtab[Focus].flags & CMD_EXIT) && select)   /* then return the ID of ret item */
    {
        event->msgtype = WM_CHAR;
        event->msg     = 0;

        return cmdtab[Focus].id;
    }
    else
        return 0;
}

void MnuSetColours(int nbc, int nnc, int nsc)
{
    bc = nbc;
    nc = nnc;
    sc = nsc;
}

#if DEBUG

#define MLEN 60

int Scan(void)
{
    WND *hCurr, *hWnd;

    hCurr = Wtop();
    if ((hWnd = WPopUp(12, 5, SBDR|SHADOW, bc, nc))==NULL)
    {
        WCurr(hCurr);
        return ERROR;
    }
    WTitle(" Scan ", bc);
    WPutsCen(1, nc, "In Scan");
    TTGetChr();
    WClose(hWnd);
    WCurr(hCurr);
}

int Area(void)
{
    WND *hCurr, *hWnd;

    hCurr = Wtop();
    if ((hWnd = WPopUp(12, 5, SBDR|SHADOW, bc, nc))==NULL)
    {
        WCurr(hCurr);
        return ERROR;
    }
    WTitle(" Area ", bc);
    WPutsCen(1, nc, "In Area");
    TTGetChr();
    WClose(hWnd);
    WCurr(hCurr);
}

int Setup(void)
{
    WND *hCurr, *hWnd;

    hCurr = Wtop();
    if ((hWnd = WPopUp(12, 5, SBDR|SHADOW, bc, nc))==NULL)
    {
        WCurr(hCurr);
        return ERROR;
    }
    WTitle(" Setup ", bc);
    WPutsCen(1, nc, "In Setup");
    TTGetChr();
    WClose(hWnd);
    WCurr(hCurr);
}


int main(void)
{
    WND *hWnd;
    int      Msg   = 0;
    int      Mtype = 0;
    int      Id    = 0;
    int      Iy    = 0;
    int      done  = 0;
    int      ret   = 0;
    int      ex    = 0;

    TTopen();

    hWnd = WndOpen(0, 0, 79, 24, NBDR, nc, nc);

    ProcessMenu(&MainMenu, &Msg, &Mtype, &Id, &Iy, 0, 1);

    while (!done)
    {
        ret = 0;
        Msg = MnuGetMsg(&Mtype, &Id, &Iy, 0);

        switch (Mtype)
        {
            case WM_MOUSE:
                switch (Msg)
                {
                    case MOU_LBTDN:
                        if (Id < MLEN && Iy == 0)
                            ret = ProcessMenu(&MainMenu, &Msg, &Mtype, &Id, &Iy, 1, 0);
                        break;

                    default:
                        break;
                }
                break;

            case WM_CHAR:
                if (Msg == Key_Esc)
                    done = 1;

                break;

            default:
                break;
        }
        if (ret == ID_QUIT)
            WPrintf(0, 24, nc, "  Exited Via QUIT #%d ", ex++);
    }

    WClose(hWnd);

    TTclose();
    return (0);
}

#endif

/* end */
