/* helpcmp.c
**
** released into the PUBLIC DOMAIN jul 10 1994 by John Dennis
** modified by Paul Edwards, whose changes are also public domain
**
** helpfile compiler
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "help.h"

FILE      *inhelp;
FILE      *outhelp;
HFileHdr   Fheader;
HTopicHdr *topichdrs;
int        setup;
int        CurrTopic;

int main(int argc, char *argv[])
{
    char line[255];
    long last;
    int  topics;
    int  curr;
    int  done;

    printf("\nMsgedsq HELP file compiler, by John Dennis.");

    if (argc < 3)
    {
        printf("\nusage: helpcmp <src helpfile> <dest helpfile>\n");
        return (EXIT_FAILURE);
    }

    if ((inhelp = fopen(argv[1], "r")) == NULL)
    {
        printf("\nError opening src file\n");
        return (EXIT_FAILURE);
    }

    if ((outhelp = fopen(argv[2], "wb")) == NULL)
    {
        printf("\nError opening dest file\n");
        return (EXIT_FAILURE);
    }

    done   = 0;
    topics = 0;

    printf("\nDoing pass one...");

    while (!done)
    {
        if (fgets(line, 254, inhelp) == NULL)
            break;

        if (!strncmp(line, "*Begin", 6))
            topics++;
    }

    printf("finished.");

    if (topics >= 1)
    {
        printf("\nDoing pass two (writing)...");

        topichdrs = calloc(topics, sizeof(HTopicHdr));
        if (topichdrs == NULL)
        {
            printf("\nOut of memory...\n");
            return (EXIT_FAILURE);
        }

        memcpy(Fheader.signature, "cz", 3);
        Fheader.topics[0] = (unsigned char)(topics & 0xff);
        Fheader.topics[1] = (unsigned char)((topics >> 8) & 0xff);
        curr           = 0;
        done           = 0;

        fseek(inhelp, 0L, SEEK_SET);

        fwrite(&Fheader, sizeof(HFileHdr), 1, outhelp);
        fwrite(topichdrs, sizeof(HTopicHdr), topics, outhelp);

        while (!done)
        {
            last = ftell(outhelp);

            if (fgets(line, 254, inhelp) == NULL)
                break;

            if (!strncmp(line, "*Begin", 6))
            {
                topichdrs[curr++].offset = last;
            }
            fprintf(outhelp, "%s", line);
        }

        fseek(outhelp, (long) sizeof(HFileHdr), SEEK_SET);
        fwrite(topichdrs, sizeof(HTopicHdr), topics, outhelp);

        printf("finished.");
    }

    fclose(outhelp);
    fclose(inhelp);

    return (EXIT_SUCCESS);
}

/* end of file */
