/*  Ŀ
                            MicroGenesis Spell V1.2                   
                                                                      
                         Copyright 1991 by Jeff Heaton                
                                                                      
                Source code may not be distributed in any form.       
                                                                      
     */


/*	mgspell.h

	Defines structs, unions, macros, and functions for dealing
	with the MicroGenesis Spelling Checker.

	Copyright (c) Jeff Heaton 1990,1991
	All Rights Reserved.
*/
/* Include following line to produce shareware version */
/* Shareware version is no longer supported, NEVER include the
   following line: */

/* #define SHAREWARE */


#include <stdio.h>

#ifndef __MGSPELL_H
#define __MGSPELL_H


#if defined(__TURBOC__)
	#if __STDC__
		#define _Cdecl
	#else
		#define _Cdecl  cdecl
	#endif

	#ifndef __PAS__
		#define _CType _Cdecl
	#else
		#define _CType pascal
	#endif
#elif defined(__ZTC__)
	#define _Cdecl
	#define _NEAR
#elif defined(M_I86) && !defined(__ZTC__)
	#if!defined(NO_EXT_KEYS)
		#define _Cdecl cdecl
		#define _Near  near
	#else
		#define _Cdecl
		#define _Near
	#endif
#endif

typedef struct {
	long	index[26][26];
	long	words[26][26];
} 	INDEX;


typedef struct {
	FILE *fp;
	unsigned char bitpos;
	unsigned char curbyte;
}	DICT;


/* Variables */
extern  char           *_Cdecl  path_main;
extern  char           *_Cdecl  path_user;
extern	char 		_Cdecl	suggest[10][30];
extern	char		_Cdecl	lastword0[80];
extern	char		_Cdecl	lastword1[80];
extern	INDEX		_Cdecl	index;



#ifdef __cplusplus
extern "C" {
#endif
/* IO.C */

void	     _Cdecl next_word	(DICT *fp,char *word);
void	     _Cdecl write_word	(DICT *fp,char *word);
void	     _Cdecl write_index	(FILE *fp);
void	     _Cdecl read_index	(FILE *fp);
void	 _Cdecl	open_spell	(DICT *fp);
void	 _Cdecl	s_seek	(DICT *fp, long position);
void	 _Cdecl	s_putc	(DICT *fp, char chr);
char	 _Cdecl s_getc	(DICT *fp);

/* LOOKUP.C */
char	     _Cdecl spell_check	(char *word);
char	 _Cdecl	add_word(char *word);
char	 _Cdecl fast_check(DICT *fp,char *word);


/* SUGGEST.C */
void	     _Cdecl suggest_word(char *word);
int	 _Cdecl	comp	(char *word1, char *word2);

/* MISC.C */
void	 _Cdecl	inc	(int *dm1, int *dm2);
void	 _Cdecl	dec	(int *dm1, int *dm2);
void	     _Cdecl scan_word(char *word);
long	 _Cdecl	words	(int dm1, int dm2);
void	 _Cdecl	encode	(char *word);
void	 _Cdecl	decode	(char *word);
void	 _Cdecl	reset	(void);
void	 _Cdecl	fgetstr	(FILE *fp,char *word);

/* WORD.C */
long	 _Cdecl word_count(void);

char	 _Cdecl	dump	(char *name);
void	 _Cdecl	import	(void);


#endif
#ifdef __cplusplus
}
#endif

