VERSION 2.00
Begin Form Conv24To12 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Convert 24hr to 12hr"
   ClientHeight    =   2790
   ClientLeft      =   1230
   ClientTop       =   1800
   ClientWidth     =   3975
   Height          =   3195
   Left            =   1170
   LinkTopic       =   "Form1"
   ScaleHeight     =   2790
   ScaleWidth      =   3975
   Top             =   1455
   Width           =   4095
   Begin CommandButton btnExit 
      Cancel          =   -1  'True
      Caption         =   "Exit"
      Height          =   375
      Left            =   2520
      TabIndex        =   6
      Top             =   1440
      Width           =   1215
   End
   Begin TextBox txt12Hour 
      Height          =   285
      Left            =   360
      TabIndex        =   3
      Text            =   "txt12Hour"
      Top             =   2280
      Width           =   1815
   End
   Begin TextBox txt24Hour 
      Height          =   285
      Left            =   360
      TabIndex        =   1
      Text            =   "txt24Hour"
      Top             =   1680
      Width           =   1815
   End
   Begin CommandButton btnConvert 
      Caption         =   "Convert"
      Default         =   -1  'True
      Height          =   375
      Left            =   2520
      TabIndex        =   0
      Top             =   1920
      Width           =   1215
   End
   Begin Label Label3 
      BackColor       =   &H00C0C0C0&
      Caption         =   "This sample program shows how to convert from 24 hour time (as returned by DFInfo) to a 12 hour time format.  Enter times (well-formed) into the 24 Hour Time edit box and press Convert."
      Height          =   1095
      Left            =   240
      TabIndex        =   5
      Top             =   120
      Width           =   3495
   End
   Begin Label Label2 
      BackColor       =   &H00C0C0C0&
      Caption         =   "12 Hour Time"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   240
      TabIndex        =   4
      Top             =   2040
      Width           =   1455
   End
   Begin Label Label1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "24 Hour Time:"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   1440
      Width           =   1455
   End
End
Option Explicit

Sub btnConvert_Click ()
    Dim TempStr As String
    '
    ' get the time the user entered and convert it
    '
    TempStr = txt24Hour
    txt12Hour = Convert24To12(TempStr)
End Sub

Sub btnExit_Click ()
    '
    ' get out
    '
    End
End Sub

'
' this function requires the data is valid and in the
' format of HH:MM:SS.  It does no error checking.
'
Function Convert24To12 (TimeString As String) As String
    Dim OutString As String
    Dim TimeHour As Integer
    '
    ' get hour
    '
    TimeHour = Val(Left(TimeString, 2))
    '
    ' format first part of string, make sure 00:00:00
    ' is formatted as 12:00:00
    '
    If (TimeHour Mod 12) = 0 Then
        OutString = "12" & Mid(TimeString, 3)
    Else
        OutString = Format(TimeHour Mod 12, "00") & Mid(TimeString, 3)
    End If
    '
    ' check for AM/PM
    '
    If TimeHour < 12 Then
        OutString = OutString & " AM"
    Else
        OutString = OutString & " PM"
    End If
    '
    ' return new time
    '
    Convert24To12 = OutString
End Function

Sub Form_Load ()
    Dim TempStr As String
    '
    ' initialize 24 hour text box
    '
    txt24Hour = Format(Now, "hh:mm:ss")
    '
    ' get 24 hour formatted time and convert it to 12 hour
    '
    TempStr = txt24Hour
    txt12Hour = Convert24To12(TempStr)
End Sub

Sub Form_Unload (Cancel As Integer)
    '
    ' make sure we get out
    '
    End
End Sub

