/*
 *  INIT.C
 *
 *  Written on 10-Jul-94 by John Dennis and released to the public domain.
 *
 *  Handles sub-system initialisation for Msged.
 */

#define INCL_MAIN

#include "msged.h"

#ifdef USE_MSGAPI
#include "msg.h"
#endif

#include "fido.h"
#include "quick.h"
#include "main.h"
#include "strextra.h"
#include "memextra.h"

struct _sv *string_vars;
struct _swv *switch_vars;

msghandle msgdo[] =
{
    {
        FidoMsgReadHeader,
        FidoMsgReadText,
        FidoMsgWriteHeader,
        FidoMsgWriteText,
        FidoMsgDelete,
        FidoAreaSetLast,
        FidoMsgAreaOpen,
        FidoMsgAreaClose,
        FidoMsgClose,
        FidoUidToMsgn,
        FidoMsgnToUid
    },
    {
        QuickMsgReadHeader,
        QuickMsgReadText,
        QuickMsgWriteHeader,
        QuickMsgWriteText,
        QuickMsgDelete,
        QuickAreaSetLast,
        QuickMsgAreaOpen,
        QuickMsgAreaClose,
        QuickMsgClose,
        QuickUidToMsgn,
        QuickMsgnToUid
    }
#ifdef USE_MSGAPI
    ,
    {
        SquishMsgReadHeader,
        SquishMsgReadText,
        SquishMsgWriteHeader,
        SquishMsgWriteText,
        SquishMsgDelete,
        SquishAreaSetLast,
        SquishMsgAreaOpen,
        SquishMsgAreaClose,
        SquishMsgClose,
        SquishUidToMsgn,
        SquishMsgnToUid
    }
#endif
};

D_LIST *node_lists = NULL;      /* the nodelists recognized by the system */
AREA *arealist = NULL;          /* list of areas */
ALIAS *aliaslist = NULL;        /* list of aliases */
ADDRESS *domain_list = NULL;    /* list of domain-gates */
ADDRESS *alias = NULL;          /* list of akas */
msg *message = NULL;            /* current message */
char **templates = NULL;        /* templates in system */
USER user_list[MAXUSERS];       /* list of users */
ADDRESS uucp_gate;              /* the uucp gate */

unsigned int *macros[41];       /* function key macros + 1 for autostart */
int maxx;                       /* maximum screen columns */
int maxy;                       /* maximum screen rows */
int rot13;
int stripSoft;

int InitVars(void)
{
    /* Allocate some memory & initialize it. */

    string_vars = xmalloc(sizeof(struct _sv));
    switch_vars = xmalloc(sizeof(struct _swv));

    memset(string_vars, 0, sizeof(struct _sv));
    memset(switch_vars, 0, sizeof(struct _swv));
    memset(user_list, 0, sizeof(user_list));
    memset(macros, 0, sizeof(macros));

    /* Initialize all the variables to default values. */

    SW->rm = 80;
    SW->qm = 80;
    SW->tabsize = 4;
    SW->use_lastr = NO;
    SW->qquote = YES;
    SW->msgids = YES;
    SW->opusdate = NO;
    SW->shownotes = NO;
    SW->seenbys = NO;
    SW->confirmations = YES;
    SW->datearrived = YES;
    SW->redraw = YES;
    SW->showaddr = YES;
    SW->rawcc = YES;
    SW->savecc = YES;
    SW->hardquote = YES;
    SW->chopquote = NO;
    SW->showcr = NO;
    SW->showeol = NO;
    SW->showrealmsgn = NO;
    SW->usemouse = YES;
    SW->tabexpand = YES;
    SW->editcronly = NO;
    SW->usepid = NO;
    SW->soteot = NO;
    SW->showtime = NO;
    SW->importfn = YES;
    SW->dmore = NO;
    SW->statbar = YES;
    SW->rquote = MT_QUO;
    SW->rotharea = MT_QUO | MT_ARC;
    SW->rfollow = MT_QUO | MT_FOL;
    SW->rextra = MT_QUO | MT_FOL | MT_ARC;
    SW->showsystem = YES;
    SW->extformat = YES;
    SW->arealistexactmatch = YES;
    SW->echoflags = YES;
    SW->netmailvia = YES;
    SW->domainorigin = YES;
    SW->rightnextunreadarea = NO;

    ST->comspec = getenv("COMSPEC");
    ST->outfile = xstrdup("msged.txt");
    ST->quotestr = xstrdup(" > ");
    ST->confmail = xstrdup("confmail.out");
    ST->lastread = xstrdup("lastread");
    ST->cfgfile = xstrdup("msged.cfg");
    ST->uucpgate = xstrdup("UUCP");
    ST->editorName = NULL;
    ST->quickbbs = NULL;
    ST->nodebase = NULL;
    ST->sysop = NULL;

    uucp_gate.notfound = 1;

    return OK;
}

void DeinitMem(void)
{
    release(switch_vars);
    release(string_vars);
}
