/*
 *  DIRUTE.H
 *
 *  Released to the public domain.
 */

#ifndef __DIRUTE_H__
#define __DIRUTE_H__

/* file info -- any file size (HPFS) */

#ifdef OS2

struct _dta
{
    char reserved[21];
    char attrib;
    unsigned wr_time;
    unsigned wr_date;
    long size;
    char name[255];
};

#define DIR_DIRECT FILE_DIRECTORY
#define DIR_NORMAL FILE_NORMAL
#define DIR_ARCHVD FILE_ARCHIVED
#define DIR_READON FILE_READONLY
#define DIR_HIDDEN FILE_HIDDEN
#define DIR_SYSTEM FILE_SYSTEM

#else

struct _dta
{
    char reserved[21];
    char attrib;
    unsigned wr_time;
    unsigned wr_date;
    long size;
    char name[13];
};

#define DIR_DIRECT _A_DIRECT
#define DIR_NORMAL _A_NORMAL
#define DIR_ARCHVD
#define DIR_READON _A_RDONLY
#define DIR_HIDDEN
#define DIR_SYSTEM

#endif

int dir_findnext(struct _dta *dta);
int dir_findfirst(char *filename, int attribute, struct _dta *dta);

#define DIRUTE_NONE 1

#endif
