/* Written by Matthew Parker */
/* Released to the public domain */

#ifdef __FLAT__
#include <i86.h>
#include "rmi.h"

struct rminfo RMINF;
#else
#include <dos.h>
#include <conio.h>
#endif

void dospause(void)
{
#ifdef __FLAT__
    int86x(0x28);
#else
    union REGS r;

    int86(0x28, &r, &r);
#endif
}

void dvpause(void)
{
#ifdef __FLAT__
    RMINF.EAX = 0x101a;
    int86x(0x15);
    RMINF.EAX = 0x1000;
    int86x(0x15);
    RMINF.EAX = 0x1025;
    int86x(0x15);
#else
    union REGS r;

    r.x.ax = 0x101a;
    int86(0x15, &r, &r);
    r.x.ax = 0x1000;
    int86(0x15, &r, &r);
    r.x.ax = 0x1025;
    int86(0x15, &r, &r);
#endif
}

void winpause(void)
{
#ifdef __FLAT__
    RMINF.EAX = 0x1680;
    int86x(0x2f);
#else
    union REGS r;

    r.x.ax = 0x1680;
    int86(0x2f, &r, &r);
#endif
}

int dvcheck(void)
{
#ifdef __FLAT__
    RMINF.ECX = 0x4445;
    RMINF.EDX = 0x5351;
    RMINF.EAX = 0x2b01;
    int86x(0x21);

    return !((RMINF.EAX & 0xff) == 0xff);
#else
    union REGS r;

    r.x.cx = 0x4445;
    r.x.dx = 0x5351;
    r.x.ax = 0x2b01;
    int86(0x21, &r, &r);

    return !(r.h.al == 0xff);
#endif
}

int kbdhit(void)
{
#ifdef __FLAT__
    RMINF.EAX = 0x100;
    int86x(0x16);

    return !(RMINF.flags & INTR_ZF);
#else
    return kbhit()? 1 : 0;
#endif
}

unsigned int obtkey(void)
{
#ifdef __FLAT__
    RMINF.EAX = 0;
    int86x(0x16);
    if ((RMINF.EAX & 0xff) == 0)
    {
        return RMINF.EAX & 0xffff;
    }
    else
    {
        return (unsigned)(RMINF.EAX & 0xff);
    }
#else
    union REGS r;

    r.x.ax = 0;
    int86(0x16, &r, &r);
    if (r.h.al == 0)
    {
        return r.x.ax;
    }
    else
    {
        return r.h.al;
    }
#endif
}

unsigned int dosavmem(void)
{
    union REGS r;
    struct SREGS s;

    r.h.ah = 0x48;
#ifdef __FLAT__
    r.w.bx = 0xffff;
    int386(0x21, &r, &r);
#else
    r.x.bx = 0xffff;
    int86(0x21, &r, &r);
#endif
    if (r.x.cflag)
    {
#ifdef __FLAT__
        return r.w.bx;
#else
        return r.x.bx;
#endif
    }
    else
    {
#ifdef __FLAT__
        segread(&s);
        s.es = r.w.ax;
#else
        s.es = r.x.ax;
#endif
        r.h.ah = 0x49;
#ifdef __FLAT__
        int386x(0x21, &r, &r, &s);
#else
        int86x(0x21, &r, &r, &s);
#endif
        return 0xffff;
    }
}

#ifdef __FLAT__
void int86x(unsigned short inty)
{
    union REGS regs;
    struct SREGS sregs;

    segread(&sregs);
    regs.w.ax = 0x0300;
    regs.w.bx = inty;
    regs.w.cx = 0;
    sregs.es = FP_SEG(&RMINF);
    regs.x.edi = FP_OFF(&RMINF);
    int386x(0x31, &regs, &regs, &sregs);
}
#endif
