/*-----------------------------------------------------------------------*/
/* PRIVATE!                                                              */
/* Proposed structures for future message database. One database for each*/
/* message area. It is indexed by message number and To: for quick       */
/* lookups.    Doug Boone 8-13-91                                        */
/*                                                                       */
/*  
   This work is based on the idea of a message "chunk". One problem we've
   had in FidoNet is that there was no avenue for expansion. Hopefully this
   will solve this problem for a long time to come. 

   The basic idea here is that a message is actually a series of "chunks".

   Each chunk is self-contained. It has nothing to do with whatever came
   before it or after it. EXCEPT(!) that the start of a message is always
   the one identified as a MSG_HEAD, the next MSG_HEAD you encounter will
   belong to the next logical message.

   You do not have to have ANY chunk for a message other than a MSG_HEAD 
   and, if you need to, you can have multiples of a chunk type in a 
   message, except for the MSG_HEAD. If the text of a message exceeds 
   64k - 1, the maximum length of any chunk, you would simply add another
   chunk to cover the overage. There is no limit on the absolute size of
   any message, but no chunk can exceed 64k - 1.

   In order to handle future expansion you MUST include the ability to 
   IGNORE any message chunk that you don't recognize. That is, showing
   messages should look something like this:
*/

#ifdef EXAMPLE

   struct  _MsgMark    msgblock;
   short     fh;

       fh = open("msg.dat",O_BINARY|O_RDONLY);

       for(;;) {

           read(fh,(char *)&msgblock,sizeof(struct _MsgMark));

           switch(msgblock.Type) {
               case MSG_HEAD:  display_head(fh); break;
               case MSG_TEXT:  display_text(fh); break;
               default:        lseek(fh,msgblock.Len,SEEK_CUR);
               }
           }
#endif

/*
   If someone invents a "MSG_FAX" block at some point in the future,
   your software would just skip over it like it wasn't there.

   However, if you are working on mail processors, and are sending 
   messages to type-3 boards, the default action should be to forward
   any un-recognized chunks instead of ignoring them.
           
 */
/*-----------------------------------------------------------------------*/

#define    MSGS    ".DAT"
#define    IDX     ".NDX"
#define    LREAD   ".LRD"
#define    SCAN    ".SCN"
#define    EID     ".EID"
#define    RULES   ".RUL"
#define    ORIG    ".ORG"

#ifdef word
#undef word
#endif

#ifndef word
typedef unsigned short word;
#endif

#ifndef byte
typedef unsigned char byte;
#endif

/*-----------------------------------------------------------------------*/
/* Header of message file.                                               */
/*-----------------------------------------------------------------------*/

typedef struct _msgdat {
   short   high_msg;		/* Highest message in file                       */
   short   version;		/* Version of MSG.DAT                            */
   long    last_scan;		/* UNIX time when last scanned                   */
   long    last_update;	/* UNIX time when file was last altered          */
   long    last_scan_pos;	/* Offset into file where last scan ended        */
   word    renum_flags;    /* Flags for renumbering programs                */
   word    maxmsgs;		/* Maximum messages to keep for renumber         */
   word    threshold;		/* Number of messages before renumber kicks in   */
   word    days;		    /* Days old to kill                              */
   word    low;		    /* Keep n messages                               */
   short   fill2[3];
   byte    reserved[16];		/* Reserved for Opus                         */
   byte    ext_prog[32];		/* Reserved for external programs            */
} MSGDAT;		/* 80 bytes */


typedef struct _MsgMark {
/*0*/  long    Marker;     /* Marks the start of new msg 0x00030300L */
/*4*/  word    Type;		/* What is following */
/*6*/  word    Msg_Number;	/* Which message this header is associated with */
/*8*/  word    Len;		/* How long is this piece? */
/*10*/ long    Offset;		/* Offset to start of this header for rebuilding?*/
/*14*/ word    Items;		/* Number of items in this block */
/*16*/ word    Flags;		/* Any special flags for this block */
/*18*/ byte    Vers_Major;	/* Major version number */
/*19*/ byte    Vers_Minor; /* Minor version number */
/*20*/ word    fill[6];	/* Makes 32 bytes and reserves some space */
} MSGMARK;

/*--------------------------------------------------------------------------*/
/* _MsgMark Types                                                           */
/*--------------------------------------------------------------------------*/

#define    MSG_HEAD    2		/* A message header follows */
#define    MSG_TEXT    3		/* Text of message follows  */
#define    MSG_SEEN    4		/* A block of seen-by follows */
#define    MSG_PATH    5		/* A block of path addresses follows */
#define    MSG_FILE    6		/* A file header description follows */
#define    MSG_KLUDGE  7		/* A generic "IFNA kludge" block */
#define    MSG_ORIG    8		/* An Origin line */
#define    MSG_STUFF   0x8000	/* Some stuff that we don't know about */
 
/*-----------------------------------------------------------------------*/
/* Header of one actual message in MSG.DAT file.                         */
/*-----------------------------------------------------------------------*/

typedef struct _newmsg {
/*0*/      byte from[36];
/*36*/     byte to[36];
/*72*/     byte subj[72];		
/*144*/    struct   _ADDRESS    dest;		/* Full address               */
/*152*/    struct   _ADDRESS    orig;		/* Full address               */
/*160*/    long     date_written;         /* UNIX time written         */
/*164*/    long     date_arrived;         /* UNIX time arrived         */
/*168*/    word reply;          /* Current msg is a reply to this msg n*/
/*170*/    word up;             /* Next message in the thread          */
/*172*/    word attr;           /* Attribute (behavior) of the message */
/*174*/    word ext_attr;		/* Extended attributes. DIRECT?       */
/*176*/    long message_id; /* This message's Duplicate/Reply identifie*/
/*180*/    long reply_id;   /* If a reply, that message's identifier   */
/*184*/    long offset;		/* Where is the first ms*/
/*188*/    char szDate[21];   /* Original message date string */
/*209*/    byte bFillDate;
/*210*/    word _reserved[13]; /* fills out to 256 bytes               */
/*224*/    word externals[10]; /* fills out to 256 bytes               */
} NEWMSG;

typedef struct _File {
   char    Name[64];		/* A file name (Can be longer than MSDOS) */
   long    Size;		    /* Total file size */
   long    Time;		    /* File's modification time */
   byte    Full_Path;		/* Where the file is located. Include MSDOS name */
   byte    Description;	/* The length of the description */
} FILEMSG;

/*-----------------------------------------------------------------------*/
/* Instead of dealing with SEEN-BYs, keep track of the last time/date    */
/* you've scanned for each address. Next time you scan the area, only    */
/* scan messages with dates _newer_ than _scanned.last_scan.             */
/* This means you can either scan on demand, or in advance.              */
/* It also means that AreaFixing is just a matter of adding/subtracting  */
/* from the file of _scanned                                             */
/*-----------------------------------------------------------------------*/

typedef struct _scanned {
       struct  _ADDRESS    dest;	/* Where to send messages              */
       long    last_scan;		  /* UNIX time when last scanned         */
       word    type;		      /* Which packet type to use            */
       long    total_scanned;		/* Total messages from this area       */
} MSGSCANNED;

/*-----------------------------------------------------------------------*/
/* This is for a small subj file. Instead of looking through the whole   */
/* MSG.DAT file, just look in here. Its just an idea, maybe not so hot.  */
/*-----------------------------------------------------------------------*/

typedef struct _ndx {
   char    name[22];		/* To: Name                                      */
   long    offset;		   /* Where to find this message in MSG.DAT      */
   word    msg_num;		/* Message number                                    */
   word    attr;		/* message's attribute                               */
   word    ext_attr;		/* Message's extended attribute                  */
} NEWMSGNDX;		/* 32 bytes */

/*-----------------------------------------------------------------------*/
/* This is just a structure used internally when scanning. Not on disk.  */
/*-----------------------------------------------------------------------*/

typedef struct _scans {
   struct  _ADDRESS addr;		/* Where messages are going.             */
   long    last_scan;		    /* UNIX time from last message scanned   */
   short 	type;		        /* Type 2 or type 3 packets?             */
   short	fh;		            /* Open file handle for this PKT.        */
   short   done;		        /* Number of messages scanned from area  */
   short   flag;
} SCANS;

/*--------------------------------------------------------------------------*/
/* Flags used with _newmsg.ext_attr                                         */
/*--------------------------------------------------------------------------*/
#define MSGDIRECT     0x0001		/* Send direct. No routing               */
#define MSGENCRYPTED  0x0002		/* Messages here have been encrypted     */
#define MSGDELETED    0x1000	    /* this entry has been deleted           */


/*--------------------------------------------------------------------------*/
/* Flags used with _scanned                                                 */
/*--------------------------------------------------------------------------*/
#define    TYPE_2      0x0001		/* This is going to be a Type2 bundle */
#define    SEEN_BY     0x0010		/* Keep track of seen-bys             */

/*--------------------------------------------------------------------------*/
/* Renumbering flags                                                        */
/*--------------------------------------------------------------------------*/
#define RECVD	        0x0001
#define QUICK          0x0002
#define USE_MSGDAT     0x0004
#define ZAP 	        0x1000

