/*
 *   Copyright 1992, 1993, 1994 John Melton (G0ORX/N6LYT)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
	viewtext.c

	Simple X-Windows program to view an ascii text message directly from
	a pacsat download file.

	John Melton
	G0ORX, N6LYT

	4 Charlwoods Close
	Copthorne
	West Sussex
	RH10 3QZ
	England

	INTERNET:	g0orx@amsat.org
			n6lyt@amsat.org
			john@images.demon.co.uk
			J.D.Melton@slh0613.icl.wins.co.uk

	History:

	0.1	Initial version.
*/

#include <xview/xview.h>
#include <xview/notice.h>
#include <xview/textsw.h>
#include <xview/panel.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#include <malloc.h>
#include <dirent.h>
#include "header.h"
#include "ftl0.h"

Frame frame;
Textsw textsw;
Panel panel;
Panel_item quit_panel_item;

char *fileName;

extern void exit( );
void quit_notify_proc( void );
void ViewText( void );
void button_reply( void );

main( int argc, char ** argv )
{
	if( argc != 2 )
	{
		fprintf( stderr, "usage: viewtext <file-name>\n" );
		exit( 1 );
	}

	xv_init( XV_INIT_ARGS, &argc, argv, NULL );

	frame = (Frame)xv_create( (Xv_window)NULL, FRAME,
				FRAME_LABEL, argv[1],
				XV_WIDTH, 600,
				XV_HEIGHT, 300,
				NULL );

	panel = xv_create( frame, PANEL,
			PANEL_LAYOUT, PANEL_HORIZONTAL,
			0 );


	textsw = (Textsw)xv_create( frame, TEXTSW,
				TEXTSW_BROWSING, 1,
				TEXTSW_DISABLE_LOAD, 1,
				TEXTSW_DISABLE_CD, 1,
				NULL, 0 );

	xv_set( panel, WIN_WIDTH, 800, 0 );

	quit_panel_item = xv_create( panel, PANEL_BUTTON,
		PANEL_LABEL_STRING, "Quit",
		PANEL_NOTIFY_PROC, quit_notify_proc,
		0 );

	quit_panel_item = xv_create( panel, PANEL_BUTTON,
		PANEL_LABEL_STRING, "Reply",
		PANEL_NOTIFY_PROC, button_reply,
		0 );

	window_fit_height( panel );
	xv_set(textsw, WIN_BELOW, panel, 0 );

	
	fileName = argv[1];
	ViewText( );

	xv_main_loop( frame );
}

void quit_notify_proc( )
{
	xv_set( textsw, TEXTSW_READ_ONLY, FALSE, NULL );
	textsw_reset( textsw, 0, 0 );
	xv_destroy_safe( frame );
}

void ViewText( )
{
	int hFile;
	int fileLength;
	char * pBuffer;
	int headerSize;
	HEADER *pHeader;
	char * pTemp;
	int offset;
	int i;

	/* open the file */
	hFile = open( fileName, O_RDONLY );
	if( hFile == -1 )
	{
		perror( fileName );
		return;
	}

	/* get the file length */
	fileLength = lseek( hFile, 0, 2 );
	pBuffer = malloc( fileLength );
	lseek( hFile, 0, 0 );

	/* read in the complete file */
	read( hFile, pBuffer, fileLength );

	/* close the file */
	close( hFile );

	/* extracting the header */
	pHeader = ExtractHeader( pBuffer, fileLength, &headerSize );
	
	pTemp = malloc( 1024 + pHeader->fileSize );

	if( strlen( pHeader->title ) == 0 )
		offset = sprintf( pTemp, "To: %s\nFrom: %s\nTitle: %s\n%s\n\n",
				pHeader->destination,
				pHeader->source,
				pHeader->fileName,
				"----------------------------------------" );
	else
		offset = sprintf( pTemp, "To: %s\nFrom: %s\nTitle: %s\n%s\n\n",
				pHeader->destination,
				pHeader->source,
				pHeader->title,
				"----------------------------------------" );
	/* now copy in the text */
	for( i=0; i<pHeader->fileSize; i++ )
		if( pBuffer[pHeader->bodyOffset+i] == '\r' )
			pTemp[offset+i] = ' ';
		else
			pTemp[offset+i] = pBuffer[pHeader->bodyOffset+i];
	pTemp[offset+pHeader->fileSize] = '\0';

	xv_set( textsw, TEXTSW_CONTENTS, pTemp, NULL );
 	xv_set( textsw, TEXTSW_READ_ONLY, 1, NULL );
 	xv_set( textsw, TEXTSW_FIRST_LINE, 0, NULL );
 	xv_set( frame, FRAME_NO_CONFIRM, 1, NULL );

	free( pHeader );
	free( pBuffer );
	free( pTemp );
}

void signal_child( )
{
        int pid, pstatus;

        pid = wait( &pstatus );
}

void button_reply( )
{
        int hFile;
        int nBytes;
        char * pBuffer;
        int headerSize;
        HEADER *pHeader;
        char source[32];
        char title[128];
        int pid;

        /* open the file */
        hFile = open( fileName, O_RDONLY );
        if( hFile == -1 )
        {
                perror( fileName );
                return;
        }

        pBuffer = malloc( 1024 );

        /* read in the header */
        nBytes = read( hFile, pBuffer, 1024 );

        /* close the file */
        close( hFile );

        /* extracting the header */
        pHeader = ExtractHeader( pBuffer, nBytes, &headerSize );

        free( pBuffer );

        sprintf( source, "%s", pHeader->source );
        sprintf( title, "Re: %s", pHeader->title );

        free( pHeader );
        
        signal( SIGCHLD, signal_child );

        if( (pid=fork()) == 0 )
        {
                /* the child process */
                execlp( "message", "message", source, title, NULL );
        }
        else if( pid>0 )
        {
                /* success */
        }
        else
                (void)notice_prompt( panel, NULL,
                        NOTICE_MESSAGE_STRINGS, "cannot fork message",
                        NULL,
                        NOTICE_BUTTON, "OK", 100,
                        NULL );
}

