/* TEXTREXX.CMD - Sample REXX command file for testing MaxFile/PM's REXX     */
/* macro extensions.                                                         */

Say 'MaxFile/PM demo in progress.'

Call RxFuncAdd 'SysSleep', 'RexxUtil', 'SysSleep'


/* MPM_GetVersion() returns MaxFile/PM's revision number.                    */

mpmver = MPM_GetVersion()


/* MPM_MsgBox(message, title) displays a simple message box using 'message'  */
/* as the text displayed in the message box and 'title' as the title for the */
/* message box.                                                              */

rc = MPM_MsgBox('Version 'mpmver, 'MaxFile/PM - Query Version Number')


/* MPM_QueryArea([area tag]) works in two different ways.                    */
/* Called with no arguments it returns the area tag of the first file area   */
/* listed in the Main File Area window listing.                              */
/* When called with a single argument containing the area tag of an existing */
/* file area, it will return the area tag of the NEXT file area in the list. */
/* In either case, if an area can't be found it returns 'ERROR'.             */

mpmarea = MPM_QueryArea()
rc = MPM_MsgBox(mpmarea, 'MaxFile/PM - Query File Area')


/* MPM_DeselectArea(area tag) detags a file area in the Main File Area       */
/* window.                                                                   */

retval = MPM_DeselectArea(mpmarea)
rc = MPM_MsgBox(retval, 'MaxFile/PM - Deselect File Area Results')


/* See the MPM_QueryArea() comments above.                                   */

mpmarea = MPM_QueryArea(mpmarea)
rc = MPM_MsgBox(mpmarea, 'MaxFile/PM - Query Next File Area')


/* MPM_SelectArea(area tag) tags a file area in the Main File Area Window.   */

retval = MPM_SelectArea(mpmarea)
rc = MPM_MsgBox(retval, 'MaxFile/PM - Select File Area Results')


/* MPM_OpenArea(area tag) opens a FILES.BBS Window.                          */

retval = MPM_OpenArea(mpmarea)
rc = MPM_MsgBox(retval, 'MaxFile/PM - Open File Area Results')


/* MPM_IsAreaOpen(area tag) returns "1" if the FILES.BBS window associated   */
/* with 'area tag' is open, "0" otherwise.                                   */

retval = MPM_IsAreaOpen(mpmarea)
rc = MPM_MsgBox(retval, 'MaxFile/PM - Is File Area Open Results')


/* MPM_SetFDUFlag(area tag) sets the File Database Utility flag for the      */
/* FILES.BBS that is associated with 'area tag.' Use this to tell MaxFile/PM */
/* that the File Database Utility needs to be run to update your file        */
/* database after making changes that MaxFile/PM doesn't know about.         */

/* retval = MPM_SetFDUFlag(mpmarea) */
/* rc = MPM_MsgBox(retval, 'MaxFile/PM - Set FD Utility Flag Results') */


/* MPM_CloseArea(area tag) closes the FILES.BBS window associated with 'area */
/* tag.'                                                                     */

retval = MPM_CloseArea(mpmarea)
rc = MPM_MsgBox(retval, 'MaxFile/PM - Close File Area Results')


/* MPM_QueryAreaInfo(area tag, '0' | '1' | '2') queries and returns the      */
/* specified information for 'area tag.' The level info is as follows:       */
/*                                                                           */
/*                      0 - Area description                                 */
/*                      1 - Download Path                                    */
/*                      2 - FILES.BBS Location                               */

areainfo = MPM_QueryAreaInfo(mpmarea, '0')
rc = MPM_MsgBox('Description = 'areainfo,,
                'MaxFile/PM - Query Area Info Results')

areainfo = MPM_QueryAreaInfo(mpmarea, '1')
rc = MPM_MsgBox('Download Path = 'areainfo,,
                'MaxFile/PM - Query Area Info Results')

areainfo = MPM_QueryAreaInfo(mpmarea, '2')
rc = MPM_MsgBox('FILES.BBS Location = 'areainfo,,
                'MaxFile/PM - Query Area Info Results')


/*****************************************************************************/
/*                                                                           */
/* What follows is a simple example of querying information about an open    */
/* file area.                                                                */
/*                                                                           */
/*****************************************************************************/

mpmarea = 'TEST'

/* Open up the file area */
retval = MPM_OpenArea(mpmarea)

/* Give the open call a chance to work */
Call SysSleep 3

/* Loop until the file area is open */
areaopen = '0'
do until areaopen \= '0'
    Call SysSleep 1
    areaopen = MPM_IsAreaOpen(mpmarea)
end

/* MPM_QueryFile(area tag[, filename]) returns the base filename of a        */
/* file from a FILES.BBS window. When called with just the area tag of an    */
/* open window it returns the first file in the window. When called with     */
/* both the area tag and an existing filename it will return the NEXT        */
/* filename in the window. If something goes wrong it returns ERROR.         */

/* Query the filename of the first file */
filename = MPM_QueryFile(mpmarea)
rc = MPM_MsgBox('File = 'filename, 'MaxFile/PM - Query File Results')

if filename = 'ERROR' then do
    exit
end

/* Query the next filename */
filename = MPM_QueryFile(mpmarea, filename)
rc = MPM_MsgBox('File = 'filename, 'MaxFile/PM - Query File Results')

/* MPM_QueryFileInfo(area tag, filename, '0' | '1' | '2' | '3') queries      */
/* and returns the specified information about 'filename.' The level         */
/* information is as follows:                                                */
/*                                                                           */
/*                     0 - File Path                                         */
/*                     1 - File Date in DD MMM YYYY format                   */
/*                     3 - File Size                                         */
/*                     4 - File Description                                  */

fileinfo = MPM_QueryFileInfo(mpmarea, filename, '0')
rc = MPM_MsgBox('Filepath = 'fileinfo, 'MaxFile/PM - Query File Info Results')


/* MPM_SelectFile/MPM_DeselectFile(area tag, filename) select and            */
/* deselect 'filename', respectively, in the area identified by 'area        */
/* tag'.                                                                     */

retval = MPM_SelectFile(mpmarea, filename)
rc = MPM_MsgBox(filename' selected!', 'Select File')

fileinfo = MPM_QueryFileInfo(mpmarea, filename, '1')
rc = MPM_MsgBox('Filedate = 'fileinfo, 'MaxFile/PM - Query File Info Results')

fileinfo = MPM_QueryFileInfo(mpmarea, filename, '2')
rc = MPM_MsgBox('Filesize = 'fileinfo, 'MaxFile/PM - Query File Info Results')

fileinfo = MPM_QueryFileInfo(mpmarea, filename, '3')
rc = MPM_MsgBox('File description = 'fileinfo,,
                'MaxFile/PM - Query File Info Results')

retval = MPM_DeselectFile(mpmarea, filename)
rc = MPM_MsgBox(filename' deselected!', 'Deselect File')


/* MPM_SetFileInfo(area tag, filename, '0' | '1' | '2') set the displayed    */
/* information for a file in a FILES.BBS window. The level information is    */
/* as follows:                                                               */
/*                                                                           */
/*                         0 - Set File Date                                 */
/*                         1 - Set File Size                                 */
/*                         2 - Set Description                               */
/*                                                                           */
/* Please note that options 0 and 1 are only for display purposes, if you    */
/* want to set the file's date ("touch" it) you need to perform this         */
/* yourself, MaxFile/PM does not do this for you, the same goes for the      */
/* file's size. This REXX extension is merely to update the display in       */
/* the FILES.BBS window. Option 2, for setting descriptions, does            */
/* actually alter the description that will get saved for the file.          */

/* retval = MPM_SetFileInfo(mpmarea, filename, '2', 'Set with TESTREXX.CMD') */
/* rc = MPM_MsgBox(retval, 'Set File Info Results') */


/* MPM_RemoveFile(area tag, filename) removes the file 'filename' from       */
/* the FILES.BBS window associated with 'area tag'.                          */

/* retval = MPM_RemoveFile(mpmarea, filename) */
/* rc = MPM_MsgBox(retval, 'Remove File results') */


/* MPM_AddFile(area tag, filename, description) adds 'filename' with         */
/* description to the FILES.BBS window associated with 'area tag'.           */
/* 'filename' MUST be a FULL file specification in the form of               */
/* D:\PATH\FILENAME.EXE! The function returns 'ERROR' if something goes      */
/* wrong.                                                                    */

/* retval = MPM_AddFile(mpmarea, 'd:\test\ivtech.zip', 'New File from REXX') */
/* rc = MPM_MsgBox(retval, 'Add File Results') */


/* Close the file area */
retval = MPM_CloseArea(mpmarea)


rc = MPM_MsgBox('REXX Demo Complete!', 'MaxFile/PM - REXX Demo')
