                        INTRODUCTION
                        ------------

        The "open society" and "the free exchange of ideas" are generally
regarded not only as praiseworthy ideals but as indelible characteristics
of twentieth-century Western democracy. Their concomitants, freedom of
speech and the press, are held to be rights the infringement of which
places in jeopardy all other democratic liberties, for it is only through
freedom of expression that the citizenry of a democratic state can reach
an informed consensus.

        Thus the fate of this book and the ordeal of its author, Judge
Wihelm Staglich, is a telling indictment of the Federal Republic of
Germany's imposture as a sovereign democracy. No less is the silence of
those Western circles which so loudly profess devotion to freedom of
expression in other cases a condemnation of their own hypocrisy, for there
are few if any parallels in the recent history of democratic states for the
sustained hounding and persecution which Judge Staglich has endured over
the past twenty years.

        Judge Staglich is unfortunate enough to have trusted his own powers
of observation and to have refused to muzzle himself when the issue was not
only historical truth, but the honor of his country. For, having been
stationed near the Auschwitz concentration camp during Second World War, in
which he served as an officer in an anti-aircraft unit, he made so bold
after the war, when his dismembered fatherland was being re-educated in its
various parts to execrate the allegedly unique wickedness of its conduct,
to remark on his own observations of the camp, which divergeed considerably
from the horror stories which became the staple of Germany's post-war
"mastering of the past".

        In 1965 Staglich, who was serving as a judge in Hamburg, was
denounced by a colleague to the Jewish mayor of the city as a "Nazi" for
his heretical remarks on Auschwitz. Judge Staglich then underwent a
two-year "disciplinary proceeding" aimed at driving him from the bench,
which included an obligatory "psychiatric evaluation".

        This first effort to silence Judge Staglich, which failed for lack
of evidence, served rather to goad than to intimate the courageous jurist.
In 1973 he published an account of his Auschwitz observations in the
magazine NATION EUROPA. Staglich's public challenge to the official version
of life at Auschwitz brought forth a succession of measures aping those of
the modern totalitarian states, and making a sad mockery of the proud
struggle for freedom of expression and inquiry waged by German academics in
the preceding century and a half.

        Judge Staglich was the subject of a second inquisition by which he
was induced to resign, his health having been affected by the campaign
against him. The proceeding was continued, however, with the object of
scripping Staglich of his pension (the authorities eventually settled on
reducing the judge's pension by twenty percent over a fire-year period).

        Prematurely retired, Staglich set to work on a systematic study of
the evidence supposedly substantiating systematic murder by gassing at
Auschwitz , a study to which he brought juristic experience unique in the
Revisionist movement. This book, the fruit of those researches, is the most
comprehensive examination of the various "proofs" offered for the Auschwitz
myth, as well as a damning analysis of the several post-war trials staged
by the Allied victors and their fuglemen in the Federal Republic, most
notably the famous "Auschwitz Trial" which took place in Frankfurt in
1963-1965.

        The appearance of DER AUSCHWITZ MYTHOS in West Germany in 1979
spurred the custodians of the myth of Germany's solitary and monstrous
guilt in the war to new excesses in censorship. West German authorities set
in motion the procedure by which offending books are "indexed" as "harmful
to youth", thereby severely restricting their advertising and distribution.
Nevertheless, all but seven of the 10,000 copies of the first edition had
been sold by the time the book was ordered seized as a result of further
legal action by the government.

        In a crowning absurdity, Judge Staglich was "deprived" of the
doctoral degree he had earned at the University of Gottingen in 1951. In
this action the university authorities had recourse to a law signed
personally by the late Fuhrer and Reichskanzler, Adolf Hitler, to all of
whose values and practices the Federal Republic proclaims itself a standing
reproach. A series of other harassments, from police raids on Judge
Staglich's home to seize forbidden literature to the enactment of a
constitutional provision aimed at those who dare to question the
"Holocaust", has followed.

        It would tax the powers of belief of even the least
conspirational-minded to imagine that there was something adventitious or
arbitrary about the actions of West German authorities, which have been
undertaken under "conservative" and "social democratic" regimes alike.
Their activities, carried out with unswerving purpose against one man and
his ideas for more than twenty years, give abundant evidence that the
maintenance of orthodoxy on the statemandated "Holocaust" tale is far more
important than is the maintenance of even lip service to freedom of
expression and inquiry.

        As Wilhelm Staglich has written:

        " ...We Germans, in spite of the repeated assurances to the
          contrary of our puppet politicians, are politically and
          intellectually no longer a sovereign nation since our defeat in
          the Second World War. Our political subservience, which is
          apparent in the fact of the breaking up of the Reich and the
          incorporation of the individual pieces into the extant power
          blocks of the East and of the West, has had as its consequence a
          corresponding intellectual subservience. Escape from this
          intellectual subservience is prevented primarly by the guilt
          complex inculcated in most Germans through the "re-education"
          instituted in 1945. This guilt complex is based primarily on the
          Holocaust legend. Therefore for us Germans the struggle against
          what I have called the 'Auschwitz Myth' is so frightfully
          important. "

        The suppresion of DER AUSCHWITZ MYTHOS in West Germany, however, is
less than even a Pyrrhic victory for the world-wide forces which strive to
impose a one-sided, propagandistic history of the Second World War, a
history which has as its central motif the "Holocaust" hoax. It is rather
humiliating acknowledgement of their inability to confront modern
Revisionism according to the canons of scholarship, an inability that has
manifested itself in the Holocaust Establishment's attempts to suppress the
writings of scholars such as Arthur Butz and Robert Faurisson.

        The appearance of this translation of THE AUSCHWITZ MYTH under the
auspices of the Institute for Historical Review, indeed, confers upon the
Staglich affair the aspect of triumph and victory. A little more that two
years after the Institute's headquarters were reduced to a heap of ashes
and rubble by a terrorist attack, the English-speaking world has gained
access to this vital Revisionist work. The work of "bringing history into
accord with the facts" goes on; ultimately, there is no power on earth
which will stop it.

                                Theodore J. O'Keefe
                                     December, 1986






                        FOREWORD
                        --------

        "Auschwitz - it was hell".  For all its subjectivity, this remark
attributed to a former inmate does not begin to characterize the
emotion-charged ideas the word Auschwitz evokes today. Auschwitz symbolizes
more than the multitudinous agonies suffered in concentration camps, not
only German camps during the war, but concentration camps everywhere, past
and present: It has come to symbolize the "murder of millions of European
Jews". Everyone "knows" that we are not "supposed to" voice the slightest
doubt regarding the legend that is Auschwitz, or even relate personal
experiences that might not be entirely in line with it. Indeed, to commit
such heresy is to run the risk of losing one's livelihood. For the powers
that be have ordained that Auschwitz must be viewed in one way only.

        That is exactly what should make us leery. Truth does not require
coercion to be accepted. Its persuasiveness does not depend on constant
repetition of bold-faced claims. All that is really needed for truth to
prevail is to show the facts, and let common sense to the rest.

        What then could be more natural than to examine the factual basis
of the allegation that Auschwitz was the site of the most extensive and
atrocious massacre of Jews in history?  Almost everybody is familiar with
this claim, but nobody can say just what evidence there is to support it.
People have come to regard the whole subject as taboo. I noticed this was
true even of the judges who imposed a relatively harsh penalty on me for my
having published, in the form of an open letter, a de visu account of
the Auschwitz parent camp that conflicts with the now current picture of
Auschwitz.

        When I wrote that letter, it was far from my intention to dispute
the extermination thesis per se. Anyway, that would have been outside the
scope of my account. However, the reaction it provoked made me realize for
the first time what importance the powers that have for decades been
determining our destiny as a nation place on the Auschwitz taboo. That
realization awakened in me an irresistable urge to research the historical
sources for the allegation that Auschwitz was an "extermination camp", and
come to grips with it. I believe my findings deserve to be brought to the
attention of the general public.

        At the outset, let one thing be noted: Contrary to popular belief,
Auschwitz was not a single camp under central administration. Rather, it
consisted of a number of individual camps of various sizes, some of which
had considerable organizational autonomy. The actual Auschwitz camp -the so
called Stammlager ("parent camp" or "main camp", also known as Auschwitz I)
- was situated about 2 km southwest of the town of Auschwitz in Upper
Silesia. Not this camp, but the Birkenau camp, located about 3 km west of
the town, is supposed to have been the site of the extermination of the
Jews. There was a series of other camps in the Auschwitz region, some of
which had been established for special purposes, such as Raisko, for
agricultural experiments, and Monowitz, for the production of synthetic
rubber. All these camps were associated, more or less loosely, with the
main camp. Thus it is hardly correct to designate "Auschwitz" as an
"extermination camp", pure and simple, as people often do, perhaps from
ignorance. Basically, "Auschwitz" was a network of labor camps established
in the industrial area of Upper Silesia for the German war economy. The
Birkenau camp ("Auschwitz II"), which is the focal point of the
extermination claims, served primarily as an internment camp for specific
groups of prisoners, such as Gypsies, women with children, as well as the
chronically ill and those who were otherwise incapable of labor. It also
served as a transit camp and, initially, even as a POW camp. In the spring
of 1943, several crematoria -allegedly containing "gas chambers" for the
extermination of Jews- were put into operation there, while the original
camp crematorium in "Auschwitz I" was shut down in July 1943.

        The real subject of our investigation is the charge that Birkenau
was an "extermination camp". This work is not intended to give a definitive
picture of Auschwitz -something that would, in any case, be beyond the
limited resources at my disposal. It also has no pretensions to being a
"Geschichtsschau" in the Ranken sense, that is an attempt to depict
Auschwitz "as it really was". Rather, it is an effort to survey, examine,
and assess as objectively as possible the evidence that has thus far been
presented for the claim that Auschwitz was a "death factory".

        Unfortunately, the Institut fur Zeitgeschichte [Institute for
Contemporary History] in Munich has not seen fit to grant my request for
its assistance. My correspondence with the institute is so revealing that I
must share it with my readers (see Appendix III). Likewise, I was refused
permission to examine relevant trial records (see Appendices IV and V), and
therefore had to rely on published collections of trial documents, such as
they exist.

        I am aware, of course, that Auschwitz is not the only camp that has
been linked to the "extermination of the Jews". Nevertheless, it assumes
such importance in this connection, both qualitatively and quantitatively,
that I am convinced that the extermination thesis stands or falls with the
allegation that Auschwitz was a "death factory". That alone should justify
my restricting the scope of this inquiry.

        Finally, let it be noted that the present volume is the work not of
a professional historian, but of a jurist with an interest in recent
history. Naturally, I have tried to observe the rules of scholarship. My
intention is not to polemicize, but to take stock of the evidence that has
thus far been presented for the claim that Auschwitz was a "death factory",
as objectively as possible, and draw the logical conclusions from it. If
certain passages in this work strike the reader as polemical, he would do
well to ask himself whether such lapses are not unavoidable given the
nature of the subject.


                                        Dr. Wilhelm Staglich

        Hamburg, December 1978.

 