
SPEECHES AND OTHER PUBLIC STATEMENTS BY POLITICAL LEADERS OF THE THIRD REICH
----------------------------------------------------------------------------

        As soon as one turns to the topic of the "extermination of the
Jews", one finds that fragments of speeches made by the leading political
figures of the Third Reich, in particular, Hitler and Himmler, are
frequently cited as evidence. The rather strong language used with regard
to the Jews in certain passages of these speeches is simply taken at face
value, and, therefore, assumes an importance it really does not deserve.
Often such passages are taken out of context, and their significance in
relation to the whole text ignored. That has also been done with spoken and
written statements the German leaders of the period made on subjects other
than the Jewish Question.

        Especially in the case of Hitler, such statements were made largely
in response to the numerous threats to exterminate the German people
uttered by Allied leaders and Jewish spokesmen. Perhaps the most vociferous
of the latter was Theodore Nathan Kaufman. In a book entitled GERMANY MUST
PERISH (1941), he expounded a plan to wipe out the German people by
sterilizing German men and women. Even better known is the "Morgenthau
Plan". Henry Morgenthau, Secretary of the US Treasury and a personal
advisor to President Roosevelt, thought starvation and economic
strangulation were the best means of getting rid of the German people, and
Roosevelt himself endorsed this plan. Nor should one forget that it was
Professor Friedrich Alexander Lindemann - later Lord Cherwell - who advised
the plan on which the carpet bombing that annihilated countless German
civilians was largely based. Finally, the Soviet "expert on international
law", A.N. Trainin, set forth a plan aimed at wiping out the German "ruling
class" and intelligentsia. His plan led to the London Charter, the basis
for the "jurisdiction" of the Nuremberg International Military Tribunal,
which actually did condemn the German leaders to death and imprisonment.
With the exception of Kaufmann's scheme, all these plans were at least
partially executed. If they were not carried out in full, it was more for
practical than humanitarian reasons.

        Besides these very concrete extermination plans, which had no
counterpart on the German side, numerous general statements were made along
the same lines. Only a few of these will be mentioned here.

        Perhaps the most famous exhortations to murder are those of
Stalin's Jewish propagandist Ilya Ehrenburg, who expressed such sentiments
as the following:

            No longer do we say: "Good morning" or "Good night". In the
          morning we say: "Kill a German", and in the evening: "Kill a
          German".
            Books, love, the stars no longer matter. The only thing that
          matters is to kill the Germans. To kill them all. To bury them...
          For us there is nothing more beautiful than German corpses. "Kill
          a German !" -this is what the old mother begs of you. "Kill a
          German!" -this is what a child implores. Germans are not human
          beings. Germans are biped animals, disgusting creatures, beasts.
          Germans are amoebae, soulless microbes, but equipped with
          machines, guns, mortars.
            If you have killed a German, kill another -nothing gladdens us
          more than German corpses.

        That Ehrenburg's exhortations to murder were not without their
effect is well known. What is not well known is that these homicidal
messages were translated into English for the benefit of the onward
marching "Christian Soldiers".

        To be sure, his incitements to murder appeared at a time when the
war was at its greatest intensity. But long before the outbreak of war
threats to exterminate the German people were being broadcast around the
world. That is something, by the way, which one ought to take into account
when considering the question of "war guilt".

        As early as January 1934, Vladimir Jabotinsky, the founder of
Revisionist Zionism, declared in the Jewish paper NASHA RETCH: "Our Jewish
interests require the final destruction of Germany; the Germans, each and
every one of them, are a danger to us". Likewise, on May 24, 1934, the
publisher of THE AMERICAN HEBREW, a leading Zionist, reportedly told the
American publicist Robert E. Edmondson that Jewry was "going to bring a war
on Germany". And on April 16, 1936, the YOUNGSTOWN JEWISH TIMES
(Youngstown, Ohio), commented that after the next war there would no longer
be a Germany. It predicted that "on signal from Paris", France and Belgium,
as well as the peoples of Czechoslovakia, would be set in motion to attack
the "German colossus", and, in a "deadly pincermovement", sever Prussia
from Bavaria, thus bringing Germany to extinction. (The only difference
between this fantasy and the reality of post-war Germany is that the new
borders were set elsewhere and the German people are not yet extinct,
though they certainly seem to be heading in that direction).  Not long
after this article was published, THE AMERICAN HEBREW, in its issue of
April 30, 1937, expressed the same idea in a more general way when it
stated that Germany deserved to be eliminated from the family of nations.
This statement was echoed by the British newspaper THE PEOPLE, which, on
September 3, 1939, described the German people as the "mad dog of Europe",
and demanded their destruction. On the very same day, Churchill purportedly
declared in the House of Commons that this war was England's war and its
aim the destruction of Germany, ending his outburst with the paradoxical
battlecry: "Onward Christian Soldiers!"

        No German statesman ever spoke of another people in such terms as
the British hate-monger Lord Vansittart used against the Germans when
attempting to justify the terror bombings: "The only good Germans are dead
Germans, so let the bombs fall!"

        Those bombs fell, exactly as intended, on women, children, and old
people alike. This is the background against which one must consider the
angry statements made by German leaders. Although they have inevitably been
associated with the "extermination of the Jews", these statements were
mostly made in response to a torrent of hatred against the German
government and threats to annihilate the German people that was unleashed
even before the war. "Wie man in den Wald hineinruft, so schallt es heraus"
("As ye sow, so shall ye reap"; literally, "As you shout into the woods, so
it echoes forth").  What is more, some of the remarks attributed to the
German leaders are either spurious or have been misrepresented.

        There is a vast difference between words and deeds. The attrocities
committed against Germans before, during, and after the war have been
impeccably documented. They even received publicity at the time they
occurred. The same cannot be said of the alleged murder of Jews -especially
since the most prominent Jews, leaders of the Jewish intellectual elite and
political leadership, who would have been the first victims of an actual
extermination plan, survived internment in Auschwitz and other
concentration camps.

        But enough of these preliminary remarks. We shall now examine the
relatively few declarations relating to Germany's supposed ambition to
"exterminate the Jews" that come directly from German leaders of the time.
As we shall see, their statements were no worse than any made against the
Germans by the other side.


        ADOLF HITLER
        ------------

        Hitler quotations are usually introduced with the claim that Hitler
announced his goal of exterminating the Jews by means of lethal gas in MEIN
KAMPF. To support this claim, one cites the following sentences from his
book:

        " Hatte man zu Kriegsbeginn und wahrend des Krieges einmal zwolf
           - oder funfzehntausend dieser hebraischen Volksverderber so unter
          Giftgas gehalten, wie Hunderttausende unserer allerbesten Arbeiter
          aus allen Schichten und Berufen es im Felde erdulden muten, dann
          ware das Millionenopfer der Front nicht vergeblich gewesen. Im
          Gegenteil: Zwolftausend Schurken zur rechten Zeit beseitigt,
          hatte vielleicht einer Million ordentlicher, fur die Zukunft
          wertvoller Deutscher das Leben gerettet. "

        " If at the beginning of the war and during the war twelve or
          fifteen thousand of these Hebrew corruptors of the people had
          been held under poision gas, as happened to hundreds of
          thousands of our very best German workers in the field, the
          sacrifice of millions at the front would not have been in vain.
          On the contrary: twelve thousand scoundrels eliminated in time
          might have saved the lives of a million real Germans, valuable
          for the future. "

        These statements are found in Chapter 15 of Volume II, which is
entitled "The Right of Emergency Defense". Here Hitler was attacking
international Marxism, in Germany then led primarily by Jews. He was not
attacking Jews per se, still less advocating their general destruction.
These lines, written in 1925, refer exclusively to a situation that existed
at the end of World War I. From them one cannot infer that Hitler had some
"general idea" of exterminating, let along gassing, the Jews, as Karl
Dietrich Bracher, for example, would have us believe. To interpret them
objectively, one must bear in mind that Hitler is referring to the past,
and, moreover, is discussing a specific situation. These remarks can be
explained only in terms of Hiter's view of why Germany collapsed at the end
of World War I, as well as his own experience of gas warfare (which the
English, by the way, initiated). They should be taken as an emotional
outburst, not as an embryonic plan. Indeed, MEIN KAMPF is for the most part
more propagandistic than programmatic.

        This passage from Hitler's book recalls the humanitarian sentiments
that Kurt Tucholsky, a Jew, expressed towards members of the German
middle-class who did not share his peculiar "pacifism":

        " Moge das Gas in die Spielstuben eurer Kinder schleichen. Mogen
          sie langsam umsinken, die Puppchen. Ich wunsche der Frau des
          Kirchenrats und des Chefredakteurs und der Mutter des Bildhauers
          und der Schwester des Bankiers, da sie einen bitteren qualvollen
          Tod finden, alle zusammen. "

        " May the gas creep into the play-rooms of your children. They
          should drop dead slowly, the little dolls. I'd like to see the
          wife of the churchwarden and the editor-in-chief and the mother
          of the sculptor and the sister of the banker die a bitter,
          excruciating death, all of them, together. "

        Now, we certainly are not charging that Tucholsky planned or
preached the murder-by-gassing of the German people. Yet it would be
interesting to see how those who accuse Hitler, on the basis of the passage
quoted above, of promoting the murder-by-gassing of the Jewish people would
react to Tucholsky's far more drastic outburst.

        The first remarks in which Hitler specifically uses the word
"annihilation" ("Vernichtung") and "eradication" ("Ausrottung") in relation
to "the Jews" or "Jewry" were made in 1939. They were a reaction to world
Jewry's anti-German campaign, which, by that time, had reached a pitch of
frenzy, as shown at the beginning of this section. In particular, Hitler's
Reichstag speech of January 30, 1939 is often cited. There he declared,
inter alia:

        " Wenn es dem internationalen Finanzjudentum innerhalb und
          auerhalb Europas gelingen sollte, die Volker noch einmal in
          einen Weltkrieg zu sturzen, dann wird das Ergebnis nicht die
          Bolschewisierung der Erde und damit der Sieg des Judentums sein,
          sondern die Vernichtung der judischen Rasse in Europa. "

        " If international finance-Jewry, inside and outside Europe, should
          once again succeed in plunging the nations into a world war, the
          result will not be the Bolshevization of the earth, and with that
          the victory of Jewry, but rather the annihilation of the Jewish
          race in Europe. "

        Obviously, this statement is nothing more than a response to the
war threats that were constantly being made by influential Zionists. It was
meant as an admonition to those war-mongers. Heinrich Hartle interprets
this text as a sign of Hitler's deep committment to peace. He believes
Hitler did not intend to cause a war in order to annihilate the Jews, but
raised the spectre of their annihilation in order to prevent a war. In
using the word "annihilation", Hitler was only borrowing from the
vocabulary of his Zionist foes. Even if one rejects Hartle's
interpretation, one must not jump to the conclusion that the opposite
interpretation is correct. As noted above, angry words were part of the
vocabulary of the times. The rhetoric of Churchill and Roosevelt was no
less vehement.

        When quoted in context -as they seldom are- these remarks show that
Hitler was not really suggesting the physical annihilation of the Jews.
This is how he continued his speech:

        "   Denn die Zeit der propagandistischen Wehrlosigkeit der
          nichtjudischen Volker ist zu Ende. Das nationalsozialistische
          Deutschland und das faschistische Italien besitzen jene
          Einrichtungen, die es gestatten, wenn notwendig, die Welt uber
          das Wesen einer Frage aufzuklaren, die vielen Volkern instinktiv
          bewut, nur wissenschaftlich unklar ist.
            Augenblicklich mag das Judentum in gewissen Staaten seine Hetze
          betreiben unter dem Schutz einer dort in seinen Handen
          befindlichen Presse, des Films, der Rundfunkpropaganda, der
          Theater, der Literatur usw. Wenn es diesem Volk aber noch einmal
          gelingen sollte, die Millionenmassen der Volker in einen fur
          diese ganzlich sinnlosen und nur judischen Interessen dienenden
          Kampf zu hetzen, dann wird sich die Wirksamkeit einer Aufklarung
          auern, der in Deutschland allein schon in wenigen Jahren das
          Judentum restlos erlegen ist. "

        "   For the non-Jewish peoples are no longer without the weapon of
          propaganda. Both National Socialist Germany and Fascist Italy
          have the equipment necessary to enlighten the world about the
          nature of a problem that many nations instinctively recognize,
          though they may lack a scientific view of it.
            For the time being, the Jews may carry on their agitations in
          certain states under the cover of the press, cinema, radio,
          theatre, literature, etc., which are in their hands. But if the
          Jewish nation should once again succeed in goading millions of
          people from other nations into a totally senseless war, to serve
          only Jewish interests, the efficacy of the kind of enlightenment
          that in just a few years utterly defeated the Jews in Germany
          will become manifest. "

        Thus Hitler's threat was that if another world war broke out,
Zionism would be politically eliminated -by disclosing to the peoples of
the world its role in that catastrophe. He started from the premise -and
we may leave aside the question whether rightly or wrongly- that the
preservation of world peace depended largely on the stance of international
Jewry, which did indeed have an extraordinarily strong influence on nearly
all governments.

        Even after the outbreak of war, Hitler continued to make such
threats. These, too, are cited in the literature on our topic as "proof" of
his ambition to exterminate the Jewish people, when, perhaps, they should
be viewed in terms of his repeated attempts to bring the western Allies to
their senses.

        For example, on January 30, 1941, Hitler allegedly threatened that,
if another world war broke out, all European Jewry "would be done for" ("im
Falle eines neuen Weltkrieges seine Rolle ausgespielt"). Likewise, in a
speech delivered on January 30, 1942, he reportedly declared that the war
would result in the "extermination of Jewry in Europe" ("die Vernichtung
des Judentums in Europa"). And, on February 24, 1942, he is supposed to
have "prophesied" that through this war Aryan man would not be
exterminated, but the Jew extirpated ("durch diesen Krieg nicht die arische
Menschheit vernichtet, sondern der Jude ausgerottet"). In other speeches,
Hitler made similar untterances, but they are really not worth quoting.

        None of these remarks are particularly shocking when compared with
the strongly worded statements Allied leaders and influential Zionists made
along the same lines. As I have said, it was then customary to use strong
language against one's opponents. In any case, Hitler's "prophesies" about
the eradication of the Jews had scarcely been fulfilled at that time, or
even at the end of the war. More importantly, in all of Hitler's speeches
and statements one cannot find a single reference to the alleged homidical
role of the concentration camps, in particular, Auschwitz-Birkenau,
purportedly the center of "systematic mass extermination of the Jews".

        In the final analysis, all the allegations regarding Hitler's
"extermination policy" are at odds with a statement he is said to have made
towards the end of the war, on February 13, 1945:

        " Wenn ich den Krieg gewinne, so mache ich der judischen Herrschaft
          in der Welt ein Ende, ich versetze ihr den Todessto. Und wenn
          ich diesen Krieg verliere, so werden sie dieses Sieges nicht
          froh. Denn die Juden werden daruber den Kopf verlieren. Sie
          werden ihre Uberheblichkeit bis zu einem solchen Grade steigern,
          da sie selbst die Reaktion herausforden. "

        " If I win the war, I will put an end to Jewish domination of the
          world. I will deal it a death-blow. And if I lose this war, they
          will not rejoice in their victory. It will go to their heads.
          They will increase their arrogance to such a degree that they
          themselves will provoke a reaction. "

        These remarks are extremely interesting. If the "re-education"
literature is to be believed, the Jews in the German sphere of influence
had already been largely exterminated. According to this statement,
however, Hitler planned merely to end "Jewish domination of the world"
-something quite different from physically destroying the entire race. Thus
even as the war drew to an end, the "extermination of the Jews" could not
have been Hitler's goal. This is also evident from the text of Hitler's
Political Testament that was published by the Nuremberg International
Military Tribunal (Nuremberg Document 3569-PS). Among other things, this
document states:

        " Ich habe aber auch keinen Zweiful daruber gelassen, da wenn die
          Volker Europas wieder nur als Aktienpakete dieser internationalen
          Geld- und Finanzverschworer angesehen werden, dann auch jenes
          Volk zur Verantwortung gezogen werden wird, das der eigentlich
          Schuldige an diesem morderischen Ringen ist: das internationale
          Judentum! Ich habe weiter keinen daruber in Unklaren gelassen,
          da dieses Mal nicht nur Millionen Kinder von Europaren der
          arischen Volker verhungern werden, nicht nur Millionen
          erwachsener Manner den Tod erleiden und nicht nur Hunderttausende
          an Frauen und Kindern in der Stadten verbrannt und zu Tode
          bombardiert werden durften, ohne da der eigentlich Schuldige,
          wenn auch durch humanere Mittel, seine Schuld zu buen hat. "

        " I also made it clear that, if the nations of Europe were again to
          be regarded merely as shares to be bought and sold by these
          international conspirators of money and finance, then that nation
          which is the real guitly part in this murderous struggle
          - international Jewry - would be called to account. Moreover, I
          made it clear to everybody that this time not only would millions
          of children in the European Aryan nations starve to death, not
          only would millions of grown men meet their death, and not only
          would millions of women and children be burnt and bombed to death
          in the cities, but the real culprit would have to pay for his
          guilt as well, even though by more human means than war. "

        Two things are worth noting here. First, even shortly before his
death Hitler apparently knew nothing about a mass extermination of Jews in
"death camps", for otherwise he would have worded his Political Testament
differently. Second, if Hitler aimed at exterminating the Jews and this had
actually been accomplished, it would have been characteristic of him to
boast triumphantly of the accomplishment. But he only says that the "real
guilty party in this murderous struggle", "international Jewry" -but not
"the Jews" as such- would have to pay for its guilt, "even though by more
humane means than war". Thus Hitler was not reffering to any possibility of
physically eliminating the Jewish people, but anticipating that the Jewish
leader-stratum would receive some kind of punishment, which, in his own
words, would be more "humane" than the slaughter of European soldiers and
civilians in the war. His remarks could apply to the period after the
victory for which he may still have entertained some hope. If so, it should
be understood as a warning to the Jewish leaders and an assignment for his
successors.


        HEINRICH HIMMLER
        ----------------

        After Hitler's speeches, it is mainly the speeches of Himmler in
which one seeks to find circumstantial evidence for the alleged racially
motivated murder of the Jews. Speeches and excerpts of speeches of his
supposedly relating to this subject have been published with a commentary
by Agnes F. Peterson and Bradley F. Smith under the rather sensational
title HEINRICH HIMMLER: GEHEIMREDEN 1933 BIS 1945. Of course, it is absurd
to call a speech delivered before a relatively large audience "secret". Nor
is it known whether Himmler ever designated any of his speeches so.
Evidently the title was chosen in the hope of selling more copies of the
book.

        According to the "Remarks on the Edition" at the end of the book
these speeches were discovered in the files of the "Personal Staff of the
Reichsfuhrer-SS", which the Americans seized as war booty. Today they are
reportedly in the Bundesarchiv in Coblenz. Before they were returned, they
were microfilmed. Whether they are entirely genuine is open to question.

        Himmler was in the habit of formulating his speeches as he went
along, using notes that he had written down himself, which often consisted
of no more than a dozen phrases. According to Peterson and Smith, there are
only four or five completely prepared texts among the documents published
in their collection, but they do not specifiy which one. From the end of
1942, Himmler's speeches were frequently -though not always-
phonographically recorded with two machines. These devices are said to have
worked poorly, leaving big gaps in the recordings. Beginning in 1943,
SS-Untersturmfuhrer Werner Alfred Venn was solely responsible for making
and keeping the transcripts of Himmler's speeches. It is not clear just who
had this duty before. Venn is supposed to have taken down and typed out the
speeches - even making "corrections" (!) in the text, but changing the
meaning "barely or not at all".

        One can well imagine the possibilities for error involved in the
preparation of these "documents". What is more, the American officials who
"evaluated" the staff files of the Reichsfuhrer-SS had ample opportunities
to manipulate the papers, and probably took advantage of them, for some of
Himmler's speeches were presented in evidence at the Nuremberg IMT trial.

        Peterson and Smith claim that Venn sent his transcripts of the
speeches to Himmler, who then revised them slightly. Nobody asks whether
this would have made any sense. If these were "secret speeches", there was
little possibility of their ever being published. Moreover, it is doubtful
whether Himmler had the time to go over his speeches carefully. Since they
had already been delivered, that must have seemed a useless undertaking.
How Peterson and Smith discovered these intimate details is a mystery.

        There is considerable doubt as to whether the versions of the
speeches that were presented to a horrified world after the fall of the
Third Reich were identical with speeches Himmler may have actually have
delivered. Nevertheless, we are bound to discuss here those passages which
are cited in support of the extermination thesis. Although they are
constantly used to "substantiate" the charge that murders-by-gassing
ocurred at Auschwitz, they contain no mention of Auschwitz or any other
alleged "extermination camp".

        Most frequently cited is an address Himmler delivered on October 4,
1943 before a gathering of SS-Gruppenfuhrer at Posen. Though basically a
survey of the situation at the beginning of the fifth year of the war, it
contains a discussion -relatively brief- of "The Clearing out of the Jews"
("Die Judenevakuierung"). At any rate, that is the heading this passage of
the transcript was given when it was presented in evidence at the Nuremberg
IMT trial (Nuremberg Document 1919-PS). According to this document, Himmler
declared:

        "    I also want to talk to you, quite frankly, on a very grave
          matter. Among ourselves it should be mentioned quite frankly, and
          yet we will never speak of it publicly ... I mean the clearing
          out of the Jews, the extermination of the Jewish race. It's one
          of those things it is easy to talk about - "The Jewish race is
          being exterminated", says one party member, "that's quite clear,
          it's in our program - elimination of the Jews, and we're doing
          it, exterminating them".  And then they come, 80 million worthy
          Germans, and each one has his decent Jew. Of course the others
          are vermin, but this one is an A-1 Jew. Not one of all those who
          talk this way has witnessed it, not one of them has been through
          it. Most of you know what it means when 100 corpses are lying
          side by side, or 500 or 1000. To have stuck it out and at the
          same time - apart from exceptions caused by human weakness - to
          have remained decent fellows, that is what has made us hard. This
          is a page of glory in our history which has never been written
          and is never to be written, for we know how difficult we should
          have made it ourselves if - with the bombing raids, the burdens
          and the deprivations of war - we still had Jews today in every
          town as secret saboteurs, agitators and trouble-mongers. We would
          now probably have reached the 1916/17 stage when the Jews were
          still in the German national body.
             We have taken their wealth from them. I have issued a strict
          order, which SS-Obergruppfuhrer Pohl has carried out, that this
          wealth should, as a matter of course, be handed over to the Reich
          without reserve. We have taken none of it for ourselves.
          Individual men who have lapsed will be punished in accordance
          with an order I issued at the beginning, which gave this warning;
          Whoever takes so much as a mark of it, is a dead man. A number of
          SS men - there are not very many of them - have fallen short, and
          they will die, without mercy. We had the moral right, we had the
          duty to our people, to destroy this people which wanted to
          destroy us. But we have not the right to enrich ourselves with so
          much as a fur, a watch, a mark, or a cigarette or anything else.
          Because we have exterminated a bacterium we do not want, in the
          end, to be infected by the bacterium and die of it. I will not
          see so much as a small area of the sepsis appear here or gain a
          foothold. Wherever it may form, we will cauterize it. Altogether,
          however, we can say that we have fulfilled this most difficult
          duty for the love of our people. And our spirit, our soul, our
          character has not suffered injury from it. "


        All of this may come as a shock to the unbiased but uninitiated
reader, who might get the impression that Himmler was actually talking
about ideologically motivated, systematic murder of Jews. But those who are
acquainted with the facts of this period in history will find it difficult
to believe that Himmler made all these remarks, some of which are utterly
nonsensical. A fair guess is that certain passages necessary to the
continuity of the document are missing, for no logical connection really
exists between the things Himmler purportedly discussed in this speech. He
seems to be talking about several different matters, viz., the evacuation
of the Jews, the efforts of the Einsatzgruppen to combat guerilla warfare,
the suppression of Jewish mutinies in Sobibor, Treblinka (autumn 1943),
and, most especially, the Warsaw Ghetto (April-May 1943). That Himmler is
not referring to large-scale, systematic murder of the Jews -even when he
is apparently discussing executions- is evident from the comparatively
small number of "corpses" he mentions: 100, 500 or 1,000. Far greater
numbers of people are usually said to have perished in the "gas chambers"
at any one time.

        Let us examine some details of Himmler's alleged statements which
not only indicate that the passage quoted above is incomplete, but also add
to the suspicion that it may be forged.

        Above all, it is astonishing that Himmler should have had no qualms
about defining "evacuation of the Jews" as "extermination of the Jewish
people". Of course, one may claim that he was simply employing the
"code-words" purportedly used by functionaires involved in the
"extermination program", but, as we have noted, there is no proof that such
a jargon existed. The audience for this speech was definitely not composed
of those SS leaders who might have been involved in the "secret
extermination of the Jews" -assuming for a moment there was such a plan. If
they had been, Himmler surely would have commented in greater detail on
this subject, instead of limiting himself to generalities. All things
considered, it is quite improbable that he would have suddenly confronted an
unprepared audience with the "real" meaning of the term "evacuation of the
Jews". If the "extermination of the Jews" were, as is usually claimed, so
highly secret that Hitler personally communicated to Himmler the order to
carry it out, would Himmler have discussed this matter before a large
assembly of men who had little or nothing to do with it?  Here one recalls
that it is frequently alleged, on the basis of statements made by Rudolf
Hoss, that Himmler personally transmitted Hitler's "secret order" for the
"extermination of the Jews" to Hoss, the commandant of Auschwitz,
instructing him to keep absolutely silent about it. If this were so,
Himmler would not have enlarged the circle of initiates to any great
extent, even without going into details. Hence this portion of the speech
cannot be authentic.

        It seems strange, too, that Himmler should allude to the
"elimination" ("Ausrottung") of the Jews as being contained in the party
program of the NSDAP, since it is neither mentioned nor implied there.
Himmler's supposed claim to the contrary, no level-headed Party Comrade
would never have seriously advocated such a thing. That Himmler uttered
this nonsense in front of high-ranking SS leaders, who were perfectly
familiar with the NSDAP program, is virtually impossible. Somebody who had
not the faintest inkling of the actual contents of the NSDAP program must
have slipped these remarks into the speech.

        Just as incongruous is the statement in the second paragraph of the
address: "We had the moral right, we had the duty to our people, to destroy
this people which wanted to destroy us" ("Wir hatten das moralische Recht,
wir hatten die Pflicht gegenuber unserem Volk, dieses Volk, das uns
umbringen wollte, umzubringen").  Himmler allegedly said this when
discussing the confiscation of the evacuated Jews' wealth. In that context,
it stands out as a foreign body. Since the Jews still residing in Germany
and German-occupied territory were -considering that a war was going on-
undoubtedly a security risk, as Himmler pointed out, their evacuation and
internment in camps or ghettos was perhaps necessary, but not their murder,
which is what the word "umbringen" ("destroy", "kill") denotes. It may be
argued that the Jews were quarantined out of racial hatred, not for any
logical reason. But that would not explain why Himmler had no reservations
about discussing an "extermination plan" when the official line was that
Jews were simply being "evacuated" eastwards. To say that this was, after
all, a "secret speech" is to beg the question.

        Quite possibly, the words "Ausrottung" (which can mean either
"extermination or "uprooting") and "umbringen" (which can mean either
"destroy" or kill") were mistranslated -deliberately or accidentally- in
the passage of the speech that appears in English under the heading "The
Clearing Out of the Jews" (see above) if indeed Himmler used these words.
Deliberate mistranslations are nothing new. When President Roosevelt, who
saw the mutual defense pact between Germany and Japan as the "back door"
through which an unwilling American people could be herded into the
European conflict, was zealously attempting to provoke a war with Japan, a
U.S. government agency deliberately mistranslated a Japanese official
document. Thanks to Professor Rassinier, we know that distorted
translations were employed in the Nurember IMT trial. For example, in a
retroversion of the English translation of the "Wannsee Protocol" the
phrase "Zuruckdrangung der Juden" ("pushing back the Jews", ie., to the
East European countries from whence they came to Germany) was rendered as
"Vernichtung" ("extermination"). To give another instance, the American
Chief Prosecutor cited a translation in which the expression "Ausrottung
des Judentums" ("eradication of Jewry" or "Judaism") was made into
"extermination of the Jews" -which, of course, is something altogether
different. For as Rassinier has pointed out, Jewry is, among other things,
an idea, or, to put it in other words, an expression of a common mentality,
just as is Christianity (or Christendom). When one speaks of eradicating an
idea, that does not necessarily mean physically exterminating the bearers
of that idea, in this case, individual Jews. At least, one should not jump
to that conclusion. Rassinier maintains that in this speech of Himmlers's
the term "Ausrottung" is used not in the sense of "extermination", but
rather "exclusion", or "elimination of the influence", of the Jews.

        Be that as it may, Nuremberg Document 1919-PS must be considered
highly suspect, especially the part of it quoted above. It contains so many
muddled, incongruous, and utterly nonsensical remarks that even in the
post-war "re-education" literature it is usually cited only by the
sentence. In their collection of "secret speeches", Peterson and Smith make
only a brief mention of this address. Instead of reproducing it, they give
the full text of another of Himmler's speeches, delivered two days later,
on October 6, 1943, before a meeting of Reichsleiter and Gauleiter in
Posen. It also contains a discussion of the "Jewish Question", which
Peterson and Smith describe as the "most open and characteristic passage on
the extermination of the Jews". In point of fact, the train of thought is
much the same as in Nuremberg Document 1919-PS, though this speech is
somewhat better organized than the earlier one and lacks its crass
absurdities. According to this text, Himmler made the following remarks on
the "Jewish Question":

        "   In this connection, I may comment before this very tightly knit
          group on a matter which you, my Party Comrades, all take for
          granted, and which is the most difficult task I have ever faced
          in my life, the Jewish problem. All of you gladly take it for
          granted that there are no longer any Jews in your administrative
          districts. All Germans - with a few individual exceptions - are
          aware that we could not have endured the bombings, the hardships
          of the fourth year of the war, and could not endure fifth and
          sixth years of war that are perhaps yet to come, if we still had
          this demoralizing pest in our national body. "The Jews must be
          eradicated". This brief sentence is easily said. But for the man
          who must carry out what it calls for, it is the gravest and
          hardest thing in existence. Now, look, after all they're Jews,
          only Jews. That's plain enough. But just think about how many
          people - including Party comrades - have addressed to me and
          other officials those famous petitions of theirs in which they
          say: The Jews are all bastards, of course, but so-and-so is a
          good Jew and should be left alone. I daresay, judging by the
          number of such appeals and the number of people who express such
          opinions, the number of "good Jews" in Germany must have exceeded
          the total Jewish population!  In Germany we have millions and
          millions of people who each have their "one good Jew". I mention
          this only because you can see in the vital field of your own
          administrative districts how many respected and upright National
          Socialists have their "good Jew".
            I ask you assembled here pay attention to what I have to say,
          but not repeat it. The question came up: Well, what about the
          women and children?  - I came to a determinedly simple conclusion
          about that, too. I did not believe that I had the right to wipe
          out the men - rather I should say, kill them or have them killed
          - and let their children grow up to avenge themselves on our sons
          and grandsons. The hard decision to wipe this people off the face
          of the earth had to be made. For us, the organization that had to
          carry out this task, it was the most difficult one we ever had.
          But it was accomplished, and without - I believe I can say - our
          men and their leaders suffering any mental or spiritual damage.
          That was clearly a danger. To become too brutal, too heartless,
          and lose respect for human life, or to be too soft and bring
          oneself to the point of a nervous breakdown - the path between
          these two ever-present possibilities is incredibly narrow, the
          course between Scylla and Charybdis.
            We have turned over to the Reich Ministry of Economics all the
          wealth we confiscated from the Jews - the sums were staggering -
          right down to very last penny. I have always maintained: We have
          a duty to our people, to our race, we have a duty to a leader
          such as has been given to our people only once in 2,000 years,
          not to be pretty here, but to go the limit, as we must do in all
          things if we are to win the war. Yet we do not have the right to
          take even one penny of the wealth confiscated from the Jews. At
          the outset, I laid down the line: Any SS men who take so much as
          a mark of it are as good as dead. In the past few days, I've had
          to sign a number of death sentences - I might as well say it,
          there were about a dozen. One has to be strict here, or everyone
          will suffer. I considered in my duty to speak very openly to you
          - the highest bearers of the will, the highest dignitaries, of
          the Party, of this political order, of this political instrument
          of the Fuhrer - about this matter and to give the facts as they
          are. By the end of the year, the Jewish problem in the lands we
          have occupied will be solved. There will be left only remnants,
          individual Jews who are in hiding. The problem of Jews who are
          partners in mixed marriages and the problem of half-Jews will, in
          accordance with this policy, be rationally examined, decided
          upon, and resolved.
            Believe me, I've had lots of trouble with many units of the
          economic apparatus. I cleared out big Jewish ghettos in the lines
          of communication areas. In Warsaw, we had four weeks of
          street-fighting in the ghetto. Four weeks!  We had to clean out
          around 700 bunkers. The whole ghetto was making fur coats,
          dresses, and the like. Time was, if you tried to lay a hand on
          that place, you'd be told: Stop! You're interfering with the war
          effort. Stop! This is part of the armaments industry. - Of
          course, Party Comrade Speer had nothing to do with that. There is
          nothing you people can do about it. It is a part of the so-called
          armaments industry that Comrade Speer and I will be cleaning up
          in the forthcoming weeks and months. We will do this quite
          unsentimentally, as all things must be done in the fifth year of
          the war, without sentiment but with a stout heart for Germany.
            With this I'll wind up my discussion of the Jewish problem. You
          now have the necessary information, and you will keep it to
          yourselves. At some much later date, one may consider the
          possibility of telling the German people a little more. I believe
          that it is better that we all bear this together for our people,
          as we have done, and take the responsibility on ourselves (the
          responsibility for a deed, not just for an idea) and take this
          secret with us to our graves. "


        The "re-education" scribblers are fond on quoting this speech. In
contrast to them, I have reproduced this passage in its entirety, so that
Himmler's remarks can be seen in context. Even if it seems more polished
than the Posen address, and, above all, does not contain as many glaring
absurdities, this speech cannot be judged in any different terms. It is
quite improbable that Himmler would have used such remarks to inform
Reichsleiter and Gauleiter of the genocide supposedly carried out by the SS
on his orders.

        No doubt the first and third paragraphs of this excerpt concern the
evacuation of the Jews from Germany and the occupied Western European
countries. This is especially true of the last part of the third paragraph
(after the dashes), which, incidentally, contains an echo of the "Wannsee
Protocol" in its approach to the problem of mixed marriages and persons of
mixed parentage. Since Himmler mentions "remnants" who are "in hiding", he
can only be referring here to the evacuation of the Jews from Germany and
the occupied European countries. He could not be referring to the
subsequent fate of Jews evacuated to the eastern ghettos and concentration
camps, for there they would find no place to "hide". The sentence "The Jews
must be eradicated" ("Die Juden mussen ausgerottet werden"), in the first
paragraph, is an absurdity, and was probably forged into the text. Inasmuch
as nobody in Germany had at that time heard anything about the "eradication
of the Jews", Himmler would have had to provide these high-ranking national
and regional administrators with some explanation of the term. Otherwise,
these men, who were acknowledged leaders of the Party, would have been
puzzled by it. In fact, if Himmler had discussed such a thing as killing
off the Jews, he would most likely have chosen a word like "elimination"
rather than "eradication".

        When I asked two former Gauleiter, Karl Wahl and Rudolf Jordan,
whether they had ever heard something from Himmler, directly or indirectly,
about "this type of solution to the Jewish Question" (as I put it to Wahl)
or something about the "mass murder of the Jewish people" (as I put it to
Jordan), neither of them could recall anything. And neither of them could
remember specific details of the meeting at Posen on October 6, 1943.
Gauleiter Wahl believes it is possible that he missed the conference
because of illness. He told me: "In 17 long years" - that is how long Wahl
served as Gauleiter - "I never heard him say anything that was not humane
or moral ... I cannot conceive of Himmler's being so stupid as to make any
such remarks, or, if he did, which I do not believe, to preserve them so
that these literary shysters could publish them 30 years later".  This last
point is remarkably well taken. It casts doubt on the authenticity of
Himmler's alleged discourse on the "Jewish Question", especially the final
paragraph of it. For how can any rational person believe that Himmler would
have had his remarks written down for posterity if he wanted to take the
"secret" of the "Final Solution" with him to the grave, and advised his
listeners to do the same?  The real author of these lines must have
believed - and it seems with good reason - that the human race is awfully
gullible.

        Gauleiter Jordan told me that during the war he heard "some
executions took place in connection with tactical problems of combating
guerilla warfare", but these had nothing to do with the so-called Final
Solution; they were "necessary wartime measures". I brought up this
interpretation when discussing Himmler's address of October 4, 1943 to the
SS-Gruppenfuhrer, and I think the second paragraph indisputably confirms
it. As I have pointed out, the second paragraph of the excerpt has no
discernible relation to the first paragraph. Some of Himmler's later
speeches clarify and corroborate the fact thatthis reference must be to
executions carried out against partisans.

        Even if Wahl and Jordan did not attend the meeting at which Himmler
delivered this talk, they no doubt would have heard, in some way or other,
of his remarks on the "Jewish problem" had he actually made them. Their
statements on this subject are therefore very pertinent. In my estimation,
they are satisfactory proof that Himmler did not express the notions
attributed to him in the present version of the speech of October 6, 1943.
It would be a cheap shot to impugn the veracity of these two contemporary
witnesses because of their former rank in the NSDAP - particularly since
Himmler, as I already pointed out, would have had no reason to discuss the
"Final Solution" with outsiders like Wahl and Jordan.

 