
                                Chapter 2

                        CONTEMPORANEOUS DOCUMENTS
                        -------------------------

        As we make a detailed examination of documents of the most diverse
kinds from the period of the Third Reich we shall see that the Auschwitz
mythologists are able to draw from them the conclusions they desire - if
indeed at all - only by resorting to forced logic, conjecture, and the
creation of fictive, or at least dubious, associations. That is to say,
there are gaps in the chain of "proof", and the individual pieces of
circumstantial evidence are far from unambiguous.

        Such argumentation is no more acceptable to the historian than it
is to the jurist. With reference to the question of whether Hitler "knew"
about the "gassing" of Jews, the distinguished British historian David
Irving has stated, in no uncertain terms, that none of the available
documents contains any solid information, and historians cannot go by
speculation alone.

        Only in a very few contemporaneous "eyewitness accounts" is it
expressly claimed that "gas chambers" existed at Birkenau. These reports,
however, are so questionable and contradictory that after the war one
hardly ever dared invoke them as proof, or quoted them only in part.
        In the following chapter, I shall deal with the contemporaneous
documents according to subject matter as well as importance.

                Basic Documents from German Official Records
                --------------------------------------------

THE "GORING DECREE" :

        In nearly all the historical accounts of the "extermination of the
Jews", a directive Reichsmarschall Goring issued to SS-Gruppenfuhrer
Reinhard Heydrich, head of the Security Service and the Secret Police, on
July 31, 1941, is cited as a fundamental document. It supposedly aims at
consolidating and co-ordinating "extermination actions" planned earlier and
already partially executed. As a rule, the great "extermination action"
that allegedly culminated in the Auschwitz "death camp" is dated from the
time of this "decree". The document, placed in evidence at the Nuremberg
IMT trial (Nuremberg Document 610-PS), reads as follows:

        Der Reichsmarschall des Grodeutschen      Berlin, den 31.7.1941
                        Reiches
        Beauftragter fur den Vierjahresplan
                        Vorsitzender
        des Ministerrats fur die Reichsverteidi-
                        gung
        An den
                Chef der Sicherheitspolizei und des SD
                SS-Gruppenfuhrer Heydrich
                                                Berlin
        " In Erganzung der Ihnen bereits mit Erla vom 24.1.39 ubertragenen
          Aufgabe, die Judenfrage in Form der Auswanderung oder Evakuierung
          einer den Zeitverhaltnissen entsprechend moglichst gunstigen Losung
          zuzufuhren, beauftrage ich Sie hiermit, alle erforderlichen
          Vorbereitungen in organisatorischer, sachlicher und materieller
          Hinsicht zu treffen fur eine Gesamtlosung der Judenfrage im
          deutschen Einflugebiet in Europa.
          Soferne hierbei die Zustandigkeiten anderer Zentralinstanzen
          beruhrt werden, sind diese zu beteiligen.
          Ich beauftrage Sie weiter, mir in Blade einen Gesamtentwurf uber
          die organisatorischen, sachlichen und materiellen Vorausmanahmen
          zur Durchfuhrung der angestreben Endlosung der Judenfrage
          vorzulegen. "
                                Goring

        " Supplementary to the task that was entrusted to you in the decree
          dated 24 January 1939, namely to solve the Jewish question by
          emigration and evacuation in a way which is most favorable in
          connection with the conditions prevailing at the time, I herewith
          commission you to carry out all preparations with regard to
          organizational, factual, financial viewpoints for a total solution
          of the Jewish question in those territories in Europe under German
          influence.
          If the competency of other central organizations is touched in this
          connection, these organizations are to participate.
          I further commission you to submit to me as soon as possible a
          comprehensive proposal showing the organizational, factual, and
          material measures already taken for the intended final solution of
          the Jewish question. "


        For the glib Nuremberg prosecutor Robert M.W. Kempner it was a
foregone conclusion that: "Thereby Heydrich and his henchmen were
officially entrusted with the administration of murder."

        To the unbiased reader of the document this remark is simply
astonishing. Nothing in the "Goring Decree" has any direct bearing on a
"murder plan".  From the wording it is obvious that this order concerns
measures for evacuating or promoting the emigration of Jews out of the
German sphere of influenc in Europe, not physically exterminating them. The
document takes on the latter meaning only when the expression "final
solution" is given the forced interpretation treatment, as almost
invariably happens. To give but one example, Andreas Hillgruber, in his
essay "Die Englosung und das deutsche Ostimperium" ("The Final Solution and
the German Eastern Empire"), published in the Vierteljahreshefte fur
Zeitgeschichte in 1972, goes so far as to designate the "Final Solution",
by which he means, of course, the "extermination of Jews", as the
cornerstone of the racial-ideological program of National Socialism. None
of those who attribute this meaning to "Final Solution" have taken the
trouble to ascertain when, where, and, most importantly, by whom it was
attached to the term. In the literature on our topic, Heydrich's long
involvment with organizing the emigration of Jews from Reich territory (a
project for which the agency headed by SS-Obersturmbannfuhrer Eichmann,
Bureau IV B 4 of the Reich Security Main Office [RSHA], had primary
responsibility), is conveniently viewed as preparation for his later
assignment of "exterminating the Jews".  Any other possible correlations
between the "Goring Decree" and Heydrich's previous tasks are studiously
ignored. Sometimes it is even claimed that the "Final Solution" went back
to an order Hitler gave Himmler, and was already in progress. According to
this theory, the "Goring Decree" was a "mere formality", simply granting
Heydrich the authority to "engage other State agencies" in the "Final
Solution".

        Here we have quite a good example of the reckless speculation that
attends so many discussions of this subject. An "order" Hitler may never
have given - that he did so has yet to be proved - is combined with the
arbitrary definition of the term "final solution" to create the impression
that Goring's rather commonplace directive is evidence of a scheme to
murder the Jews. How Goring, in particular, came to transmit to Heydrich
and order Hitler supposedly gave Himmler (Heydrich's immediate superior),
providing to some extent the modus operandi for its execution, is a secret
known only to these artificers of explication.

        Evidently Robert H. Jackson, the American Chief Prosecutor at the
Nuremberg IMT trial, was not quite satisfied with the document in its
original form. At any rate, he introduced a retroversion of the English
translation that had already been submitted by the prosecution in which,
among other things, the term "total solution" ("Gesamtlosung"), in the
first paragraph of the original text, was changed to "final solution"
("Endlosung"), presumably so that the document would fit in better with the
charges in the indictment. Goring energetically and successfully contested
this attempt at falsification. Ever since, only the text of the "decree" he
acknowledge (the version that appears above) has been cited.

        The real reason for the issuing of this directive is to be found,
simply and indubitably, in the first sentence, where it is stated that the
Reich Government's policy or deporting or promoting the emigration of Jews,
which until then directly involved only Jews in Germany, would be extended
to include all Jews residing in the German sphere of influence. Considering
that the German sphere of influence had recently been expanded, the
measures previously applied to Jews in the Reich could be regarded only as
a "partial solution" to the Jewish question. Thus it was quite appropriate
to refer to their application to Jews in the occupied territories as a
"total solution". Something that doubtless played an important role in this
policy was the fact that the Jews in the lands occupied by the German armed
forces in 1940-41 represented a security risk not to be taken lightly,
especially in view of the countless threats, provocations, and
incitements against the Reich then emanating from various leaders of
international Jewry. This state of affairs must have suggested the
necessity of evacuating all Jews from German-occupied territories in
Europe, insofar as their removal was not possible through emigration.

        Heydrich's assignment was simply to extend to other parts of Europe
the policy of emigration and evacuation already in effect in the Reich. In
this respect, the "Goring Decree" brought nothing new, except that it
empowered Heydrich to enlist the participation of other governmental
agencies in applying these measures, if their "competency" were "touched in
this connection."

        Although Heydrich was basically to continue a pre-existing policy
("namely to solve the Jewish question by emigration and evacuation"), he
clearly had to take into account certain objective changes in the
preconditions and possibilities for it. The outbreak of war set strict
limits to the policy of emigration, which had been the solution of first
choice. Even before, however, the countries to which it was thought the
Jews might emigrate proved increasingly reluctant to admit them. This fact
was illustrated by the "Evian Conference" of July 1938. Each of the states
participating in this conference brought forth reasons why it no longer
could or would take Jews. Nevertheless, the emigration policy was pursued -
even during the war - until all the possibilities were exhausted, as the
Jewish author Hannah Arendt had to admit. It was only in autumn 1941 that
Himmler prohibited all further emigration of Jews, though numerous
dispensations appear to have been granted. According to Jurgen Rohwer, even
as late as 1944 several shiploads of Jewish emigres left Rumania via Black
Sea under the protection of the German Navy. All this contradicts the
extermination claim. Every Jewish emigre is living proof that the physical
destruction of the Jewish people was not the aim of the Reich Government.

        Besides emigration, the settlement of all Jews in some out of the
way place was considered a possible solution, even before the war, and not
just by the German Government. The term "evacuation" was applied to this
plan, too. On a pratical level, the German government first contemplated,
in or about 1938, the island of Madagascar as a settler-colony for the
Jews. Here Germany was in accord with the initial plan for the
establishment of a Jewish "homeland" put forth by the founder of the
Zionist movement Theodor Herzl. The Madagascar Plan, which the proponents
of the extermination thesis seem to have great difficulty in bringing
themselves to mention, and seldom take seriously, did not appear within the
realm of possibility until the defeat of France in 1940, since Madagascar
was a French colony. There were repeated discussions on this proposal
between Germany and France, but the Madagascar plan ultimately fell
through, owing to the resistance of the Vichy Government.

        On the other hand the recently annexed territories in Eastern
Europe afforded new opportunities for the evacuation of the Jews from the
West, and this development is something Goring may also have had in mind
when he issued his "decree". If so, that would explain why he directed
Heydrich to submit a "draft showing the organizational, factual, and
financial measures already taken for the execution of the intended final
solution of the Jewish question".

        One must not forget that to the National Socialists the term "Final
Solution" had always meant colonization and isolation of the Jews in one
particular territory. As early as 1933, the well-known political scientist
Dr. Johann von Leers wrote, in his book 14 JAHRE JUDENREPUBLIK [Fourteen
Years of the Jewish Republic]:

        " For all its radicalism, our struggle against Jewry had never
          aimed at the destruction of the Jewish people, but rather at the
          protection of the German people. We have every reason to wish the
          Jewish people success in an honorable national development in a
          land of their own, so long as they lack the will or the
          opportunity to interfere ever again with Germany's national
          developement. Hostility to Jews for its own sake is stupid and,
          in the last analysis, barbaric. Our opposition to the Jews is
          based upon the desire to rescue our own people from spiritual,
          economic, and political enslavement to Jewry. The basic idea of
          Zionism, to organize the Jewish people as a nation among nations
          in a land of their own, is - provided no ambitions of
          world-domination are involved - healthy and justified. Instead of
          fruitlessly shoving the Jewish problem on each other, century
          after century, it would behoove the European nations to rid
          themselves of Jewry, once and for all, by organizing the
          settlement of the Jews in an adequate and wholesome
          extra-European colonial territory. "

        That is how a prominent National Socialist viewed the Jewish
question. No one can claim that his statements contain the slightest hint
of an embryonic plan to exterminate the Jews. The promotion of the
Madagascar Plan, before and even during the first years of war, proves that
von Leer's conception of the solution to the Jewish problem simply
reflected the policy of the German Government. All the many attempts to
show that the Madagascar Plan was never given serious consideration have no
basis in fact.

        Even Heydrich who is constantly represented as a particularly
uncompromising advocate of "exterminating the Jews", was quite obviously
interested in a "territorial solution". From a letter dated June 24, 1940,
in which he requests Foreign Secretary Ribbentrop to take part in
forthcoming discussions on the final solution of the Jewish question, his
views on the matter are clear:

        " Das Gesamtproblem - es handlet sich bereits um rund 3 1/4
          Millionen Juden in den heute deutschen Hoheitsgewalt unterstehenden
          Gebieten - kann durch Auswanderung nicht mehr gelost werden; eine
          territoriale Endlosung wird daher notwendig. "

        " The very size of the problem - and we have to consider that
          there are about three and a quarter million Jews in the
          territories now under German control - can no longer be solved by
          emigration; a territorial final solution will have to be found. "

        And Himmler, in a memorandum accompanying a policy report to
Hitler, probably from around May 1940, stated:

        " Den Begriff Juden hoffe ich durch die Moglichkeit einer groen
          Auswanderung samtlicher Juden nach Afrika oder sonst in eine
          Kolonie vollig ausloschen zu segen. "

        " I hope through the possibility of a great migration of all the
          Jews to a colony in Africa or somewhere else, to see the complete
          obliteration of the concept Jew. "

        It is worth noting, by the way, that in the same document Himmler
expressly rejects "from inner conviction" the idea of physically
exterminating a people as "un-Germanic and impossible" ("aus innerer
Uberzeugung als ungermanisch und unmoglich"). Hitler found this report to
be "very good and correct" ("sehr gut und richtig"). He is also supposed to
have stated at the time that he intended to "evacuate all Jews from Europe"
("samtliche Juden aus Europa zu evakuieren"). According to Hitlers
Tischgesprache [Hitler's Table Talk], a volume of selections from
stenographic records of Hitler's private conversations, edited by one of
the stenographers, Dr. Henry Picker, the accuracy and authenticity of which
no one was has ever disputed, Hitler declared, on July 24, 1942, that the
evacuation of the Jews was among his plans for the post-war era.

        If nothing else, Heydrich's statement proves that the term "Final
Solution" was indeed used in connection with the plan of removing the Jews
to a territory where they could live as a separate community in their own
state. But all the remarks by leading National Socialists quoted above show
this is how they really viewed the "Final Solution to the Jewish Question".
Utterances of equal clarity in which the term "Final Solution" points,
either directly or even indirectly, to the "extermination of the Jews"
simply do not exist. The plan of the National Socialists authorities
generally corresponded to the Zionists' demand for their own Jewish state,
the main difference being that Zionist aspirations focused exclusively on
Palestine.

        Furthermore, the term "Final Solution" was used in this sense in an
official document even after the so-called Wannsee Conference, at which -
so the story goes - it was decided to "exterminate" the Jews and details of
that project were worked out. On February 10, 1942, Franz Rademacher, head
of Department "Deutschland III" of the Foreign Office (the bureaucratic
liaison between the Foreign Office and the SS), issued a directive on the
"Final Solution", of which the part that interests us here reads as follow:

        " Der Krieg gegen die Sowjetunion hat inzwischen die Moglichkeit
          gegeben, andere Territorien fur die Endlosung zur Verfugung zu
          stellen Demgema hat der Fuhrer entschieden, da die Juden nicht
          nach Madagaskar, sondern nach dem Osten abgeschoben werden
          sollen. Madagaskar braucht mithin nich mehr fur die Endlosung
          vorgesehen zu werden. "

        " The war with the Soviet Union has in the meantime created the
          possibility of making other territories available for the Final
          Solution. In consequence the Fuhrer had decided that the Jews
          should be evacuated not to Madagascar but to the East. Madagascar
          need no longer therefore be considered in connection with the
          Final Solution. "

        It is evident that in this context, too, the term "Final Solution"
can only mean the resettlement and segregation of the Jews in a distinct
territory. Whenever you find some scribbler claiming this policy was a
"cloak to hide the real plans for the Final Solution" - to use Reitlinger's
phrase - you may be sure he is totally biased.

        In view of all these facts, not to mention the unambiguous wording
of the document, the "Goring Decree" cannot be said to contain the
slightest indication that Heydrich was being "officially entrusted with the
administration of murder", as the Jewish-American Nuremberg prosecutor
Kempner so melodramatically put it. The obvious purpose of the "decree" was
to consolidate and extend throughout the whole German sphere of influence
in Europe the pre-existing policy of "forcing out" Jewry by means of
emigration and deportation. To that end, Heydrich was ordered to submit a
plan outlining preliminary measures for accomplishing the "Final Solution
to the Jewish Question", which was still conceived as resettlement of the
Jews in a territory of their own - something on the order of Theodor
Herzl's "Judenstaat" - not as the physical extermination of the Jewish
people, that recurrent but undocumented and indemonstrable allegation.

        In passing, be it noted that the claim that the "Nazis exterminated
6,000,000 Jews" is nonsensical simply because the Reich Government never
had even a remote possibility of doing so. At the beginning of the war, the
world Jewish population amounted to 16,000,000. Of that the number of Jews
living in areas under German control at the time of its greatest extent was
- as Richard Harwood has shown - no more than 3,000,000. Significantly, the
New York Jewish paper AUFBAU reported, in its issue of June 30, 1965, that
the Bonn Government had already received 3,375,000 applications for
"restitution". Any commentary would be superfluous.


THE "WANNSEE PROTOCOL" :

        Leaving aside the "Goring Decree", the "key document" for the
extermination thesis is the alleged record of discussions said to have been
held on January 20, 1942 at the offices of the German section of Interpol
(No. 56/58 Gross Wannsee Road, Berlin), under the chairmanship of Heydrich.
Among the participants reportedly were a number of ministerial and other
high-ranking officials whose administrative "competency" was "touched" by
the projected "total solution of the Jewish question in Europe".  The
"minutes" of this conference, usually designated the "Wannsee Protocol",
were presented in evidence by Chief Prosecutor Robert M.W. Kempner at the
NMT "Wilhelmstrasse Trial" (Case XI; US vs. Weizsaecker) as document
NG-2586.

        Given the importance generally attributed to the "Wannsee
Protocol", I thought it necessary to reproduce the entire document here,
despite its length, so that each line may be studied in its proper context
(see Appendix I). The version of the "Wannsee Protocol" we shall be
discussing is the "facsmile" that appears in Kempner's book EICHMANN UND
KOMPLIZEN [Eichmann and Accomplices].

        First of all, it should be noted that these "minutes" are not a
protocol in the true sense of the word. According to the Institut fur
Zeitgeschichte, they must actually be notes made after the conference by
Eichmann and his colleague Rolf Gunther. It is rather peculiar that even
the more scholarly members of the Institut fur Zeitgeschichte use the term
"protocol". For this designation is usually thought to apply only to
minutes recorded during a particular session of a trial, hearing,
conference, etc., which the responsible participants guarantee to be a true
and accurate report by their signature. Only such a protocol can be
considered a more or less valid record of the proceeding. Jottings from
memory - known in German officialese as "Aktenvermerke" ("notes for the
files") - may, on the other hand, be designated
"Erinnerungsniederschriften" ("aidesmemoire" or "memoranda"). To these one
assigns very little probative value, since there is always a possibility of
lapses of memory on the part of the writer. As a rule, they have the force
of proof only when combined with other circumstantial evidence.

        There can be little doubt that this aide-memoire has been described
as a "protocol" in order to create the impression that the information it
contains about the subject and conclusions of the Wannsee Conference is
trustworthy in every aspect. At any rate, its authenticity and accuracy
were simply taken for granted in the "Wilhelmstrasse Trial", and the
proponents of the extermination theory have adhered to that assumption ever
since. Yet it is questionable that the document, in its present form, was
prepared by Eichmann or any other participant in the conference, if indeed
it is genuine. Even the format of the document gives rise to suspicions
about its authenticity.

        As Professor Rassinier has noted, the "Wannsee Protocol" bears no
official imprint, no date, no signature, and was written with an ordinary
typewriter on small sheets of paper. This latter fact cannot, of course, be
readily gathered from the "facsmile" in Kempner's book (the original is not
available for examination). What strikes one first about the document, as
reproduced there, is indeed that it does not bear the name of an agency,
nor the serial number under which an official record of the proceedings
would have been kept by the agency that initiated them. That is totally out
of keeping with official usage, and is all the more incomprehensible
because it is stamped "Geheime Reichssache" ("Top Secret"). One can only
say that any "official record" of governmental business without a file
number or even administrative identification - especially a document
classified "Top Secret" - must be regarded with the utmost skepticism.
Kempner's "facsmile" of the "Wannsee Protocol" does bear the designation
"D. III. 29. g. Rs", on the first page, which may be taken as some kind of
official record number. However, the German bureaucracy did not formally
classify documents in that way.

        All these oddities should be enough to arouse suspicion that the
"Wannsee Protocol" is a forgery - especially since there are numerous
relevant examples of such fabrications. Nevertheless, it does not appear
that any of the "court historians" have bothered to check the authenticity
of the document, or perhaps have even seen the original. In any case, when
Heinrich Hartle raised this question at a historians conference held on the
30th anniversary of the Nuremberg trial, he received no answers. It is
worth noting that even in his Auschwitz Trial deposition Helmut Krausnick
cites merely a photocopy of the "Wannsee Protocol", from the files of the
Institut fur Zeitgeschichte.

        The "Wannsee Protocol" does not clearly outline an "extermination
plan". Of course, the absence of any reference to such a plan in this
document has not stopped the proponents of the extermination thesis from
citing it for support. However, so many participants in the Wannsee
Conference survived the fall of the Third Reich that at first the
extermination mythologists could not risk making grossly false charges
about the subject and outcome of the conference. Hence they limited
themselves to more or less vague statements about "preparations" for an
"extermination program". Otherwise, the document could not be reconciled
with the testimony of the surviving participants in the conference, who
unanimously disputed the charge that it was held to plan the "extermination
of European Jewry". The only discussion they could recall concerned the
deportation of Jews for a labor force in the occupied Eastern territories.
In his book EICHMANN UND KOMPLIZEN, Kempner presents selected passages from
transcripts of his interrogations of surviving participants in the
conference, and, of course, maintains that they "resorted to denials" for
"fearing of being indentified with the murder plan". Certainly, that is
nothing more than an allegation, and he can "support" it only by going back
to the "Wannsee Protocol". Just as telling as this begging of the question
are the low and brutal methods of intimidation that Kempner - a former
Prussian senior civil servant - employed in his interrogations of these and
other Reich officials. Even the interrogation transcripts he quotes - which
he has, no doubt, "doctored" - testify to those methods. Yet he failed to
induce any of the surviving participants in the Wannsee Conference to serve
as a key witness for the prosecution.

        The very fact that the "Wannsee Protocol" does not clearly outline
an "extermination plan" speaks against the theory that it is entirely a
forgery. Also opposing the total forgery hypothesis is the fact that the
particulars of the document are essentially correct, though the population
statistics on the Jews (see p. 286) are certainly overestimates. Of course,
even a substantially forged document does not have to be false in every
detail. No doubt forgers could have obtained without difficulty the needed
assurance about numerous points that actually were discussed at the
conference, and incorporated them into a forgery.

        While it remains to be seen whether the document is entirely a
forgery, I am convinced that segments of certain paragraphs were either
subsequently added, deleted, or altered to suit the purposes of the
Nuremberg trials and the kind of "historiography" that followed in their
footsteps. Obviously, it is easy to falsify an unsigned document written on
an ordinary typewriter. A piece of writing not identified by one or more
signatures at its conclusions could be altered in part, abridged, or
created out of thin air. Entire paragraphs could be easily inserted or
excised, without being recognizable at first glance, since a machine with a
typeface corresponding to that of one on which the original was written
would not be hard to obtain, and, if necessary, could be specially
constructed for the desired purpose. Only by recourse to the techniques of
criminological investigation can such fabrications be exposed beyond a
shadow of a doubt, unless - as in the case of the "Wannsee Protocol" - the
content alone is enough to serve as proof of forgery.

        Despite its generally dubious character - in particular, the fact
that even its format is quite at variance with the German official usage -
nobody seems to have undertaken to examine the content of the "Wannsee
Protocol" with a view to determining whether the document is authentic.
Even in their Auschwitz Trial depositions, the "historians" of the Institut
fur Zeitgeschichte falied to address themselves to this obvious question,
though as advisors to the court it was incumbent upon them to do so. They
simply took it for granted that the "document" was genuine in its entirety,
and proceeded with a reckless interpretation of it. Their treatment of the
"Wannsee Protocol" was at odds with the methods of scholarship, especially
since they could not have been unaware that the French historian Paul
Rassinier had expressed some well-founded doubts about its authenticity.
The scholarly method demands that one come to grips with opposing views and
not merely gloss over them, as those who have almost succeeded in
portraying the "extermination of the Jews" as an established fact habitually
do.
        Assuming that an official memorandum was prepared after the
conclusion of the Wannsee Conference, a critical examination of the
document Kempner presents as that record shows it is not a complete and
accurate report of the meeting. Several passages do not fit into the
overall picture. Even if much of the document is genuine, those passages
can only be subsequent interpolations.

        According to Section II of the "Wannsee Protocol", Heydrich gave
the conference participants a review of the measures that had been thus far
employed to "force the Jews out of the living space of the German people".
In the report of his statements, however, only the policy of encouraging
their emigration is mentioned, not the Reich Government's many attempts to
create a homeland for the Jews in Madagascar. That omission seems a
particularly significant datum when one reflects that the plan for creating
a Jewish homeland had for some years played a role in the policy
deliberations of the German Government, and had even then by no means been
abandoned. Heydrich would not have forgotten to mention this plan in
reviewing Germany's Jewish policy to date. Of course, Eichmann - assuming
he composed the memorandum - could have neglected to record any discussion
of the Madagascar Plan, but that is most unlikely, since it was a project
with which he was deeply involved. Thus one cannot rule out the possibility
that a portion of the original typescript dealing with the Madagascar Plan
was omitted in order to prevent the obvious indentification of the term
"Final Solution", which appears repeatedly in the "Wannsee Protocol", with
the plan of founding a Jewish homeland.

        Heydrich is supposed to have concluded his review with the
statement that Himmler had prohibited any further emigration of Jews "in
view of ... the possibilities in the East". Most likely, this vague and
insinuating reference to unspecified "possibilities" was also slipped into
the document to facilitate its interpretation as an "extermination plan".
For would not Heydrich have mentioned here that the Jews were - as numerous
documents attest - desperately needed as manpower for the projected
armaments industry in the East ?

        In the first paragraph of Section III, the evacuation of the Jews
to the East is, in fact, mentioned as a "further possible solution"
("Losungsmoglichkeit") and in the next paragraph it is stated that "here
practical experience has already been gained which is of great importance
for the coming Final Solution" ("doch werden hier bereits jene praktischen
Erfahrungen gesammelt, die im Hinblick auf die kommende Endlosung der
Judenfrage von wichtiger Bedeutung sind") [typically, these words are
omitted from the NMT translation of this passage].  If one bears in mind
that the German Government never thought of "extermination" as the "Final
Solution", but, at least since the beginnings of the Madagascar Plan,
understood it as settlement of the Jews in an independent state, then this
passage seems hardly remarkable. The colonization of all Jews in a state of
their own entailed numerous problems, and its feasibility had to be tested
in the ghettos of the occupied Eastern territories. Nevertheless, one
should not reject out of hand the possibility that the second paragraph of
Section III was subsequently inserted into the document, in order to make
it seem as though the testing of various methods of killing were under
consideration - after all, the term "Final Solution" is usually equated
with the "systematic extermination of the Jews". Thus Krausnick, in his
Auschwitz Trial deposition, conjectures that "this euphemistic speech may
have been intended to conceal the idea of using some of the Jews condemned
to be deported in an experiment in extermination ... which might prove
useful for the large-scale liquidation plans". Krausnick remarks are, by
the way, an outstanding example of the kind of suspicions, conjectures, and
facile leaping to conclusions that one so frequently encounters in the
attempts to "prove" the extermination thesis. Moreover, with this
paragraph omitted, the document sounds more plausible, especially if one
brings in the Rademacher directive.

        None of these questionable points is of decisive importance,
however, since the extermination thesis is principally based on two other
paragraphs in the document, which are usually quoted separetely and out of
context. If one views the "Wannsee Protocol" as a whole, these passages,
especially, stand out as foreign entities; hence at least this portion of
the document may very well be a forgery.

        It seems appropriate here to return to these two paragraphs. They
read as follow:

        " Unter entsprechender Leitung sollen im Zuge der Endlosung die
          Juden in geeigneter Weise im Osten zum Arbeitseinsatz kommen. In
          groen Arbeitskolonnen, unter Trennung der Geschlechter, werden
          die arbeitsfahigen Juden straenbauend in diese Gebiete gefuhrt,
          wobei zweifellos ein Groteil durch naturliche Verminderung
          ausfallen wird.
          Der allfallig endlich verbleibende Resbestand wird, da es sich
          bei diesem um den widerstandfahigsten Teil handelt, entsprechend
          behandelt werden mussen, da dieser, eine naturlich Auslese
          darstellend, bei Freilassung als Keimzelle eines neuen judischen
          Aufbaus azusprechen ist. (Siehe die Erfahrung der Geschichte) "

        " Under proper direction the Jews should now in the course of the
          Final Solution [Endlosung] be brought to the East in a suitable
          way for use as labor. In big labor gangs, with separation of the
          sexes, the Jews capable of work are brought to these areas and
          employed in road-building, in which task undoubtedly a great part
          will fall out through natural diminution. [naturliche Verminderung]
          The remnant that finally is able to survive all this - since this
          is undoubtedly the part with the strongest resistance - must be
          treated accordingly [entsprechend behandlet werden] since these
          people, representing a natural selection, are to be regarded as
          the germ cell of a new Jewish development. (See the experience of
          history)

        With the exception of the initial sentence of the first paragraph,
these two paragraphs do not fit into the framework of the document, and
that quite apart from the obscurity of the second paragraph, which for the
record of such an important conference is unusual, to say the least.
Rassinier has raised doubts about the authenticity of this passage. He
maintains that the second of these two paragraphs does not follow the first
in the original text, noting that when the "Wannsee Protocol" is quoted in
the press, the first paragraph is separated from the second with ellipses.
That would, of course, suggest that something has been omitted from the
passage. However, the original of the "Wannsee Protocol" was apparently not
at his disposal, or else he would have quoted the missing part to support
his thesis. I myself have not been able to find any corroboration for this
claim. Nevertheless, should it be true, then, in addition to the version of
the "Wannsee Protocol" put in circulation by Kempner, there must be
another, dissimilar version in circulation. Moreover, Rassinier holds that
the two paragraphs are not written in the same style. That they do not stem
from the same writer would be difficult to prove, though the second
paragraph, in particular, seems even more vague and verbose than the rest
of the "Wannsee Protocol". Taken as a whole, Rassinier's arguments for the
manipulation of this passage are, by themselves, not sufficiently
convincing.

        Nevertheless, there can be no mistaking the incompatibility of
these two paragraphs with the rest of the document. Hence it is not at all
surprising that they should be quoted out of context. Only by means of such
devices can critical readers be deceived about the actual content of the
"Wannsee Protocol". The need for them bespeaks great laxity on the part of
the forgers. They simply were not careful enough to bring their forgeries
in line with the rest of the text.

        The statement, in the first of the two paragraphs, that the Jews
capable of work would be brought "to these areas" while building roads is
disconcerting, for it has not been mentioned previously to which "areas"
the Jews were to be sent. In fact, nothing in the preceeding text prepares
us for this statement. Moreover, it does not correspond to what actually
happened: There is not one known case of Jews being "evacuated to the East
while building roads". Likewise, it conflicts with the first statement in
the paragraph, that the Jews should be "brought to the East in a way
suitable for use as labor". That this was the real plan is substantiated -
as we have already noted several times - by numerous documents on the
incorporation of the Jews into the war economy, an objective that would
have ruled out the intentional decimation of ablebodied Jews through an
excessively rigorous trip to the Eastern territories, let alone the
liquidation of the survivors. The phrase "given treatment accordingly"
("entsprechend behandelt"), from which the proponents of the extermination
thesis invariably infer that survivors were to be killed, obviously lends
itself to other interpretations.

        Even from these few discrepancies one can tell the passage is of
dubious authenticity, but when one considers the following paragraph
(Appendix I, p. 287), it seems utterly spurious.

        " Die evakuierten Juden werden zunachst Zug um Zug in sogennante
          Durchgangsghettos verbracht, um von dort aus weiter nach dem Osten
          transportiert zu werden. "

        " The evacuated Jews are brought first group by group into the
          so-called transit ghettos, in order from there to be transported
          farther to the East. "

        "Transporting" Jews to the East is certainly something quite
different from having them build roads on their way to that destination.
[This, by the way, is what the German phrase "straenbauend ... gefuhrt"
actually means, not "brought to these areas and employed in road-building",
as the NMT version has it. -T.F.]  In fact, one of the participants in the
conference, State Secretary Buhler, brought up the "transport problem" a
second time (see Appendix I, page 290). If one planned on having the Jews
march to the East while building roads, transportation would not have been
that much of a problem. This glaring contradiction would not appear in a
completely authentic record of such an important conference. From it alone
one must conclude that these two paragraphs (page 287 below) of the
"Wannsee Protocol", which are constantly invoked as proof of the
extermination thesis, did not exist in the original document. Moreover, no
plans for this combined death march and construction project are discussed
in any other part of the "Wannsee Protocol". Simply because of its muddled
language, the paragraph beginning with "the remnant that is able to survive
all this" ("der allfallig endlich verbleibende Restbestand" - what a
mouthful!) seems of dubious authenticity.

        Time and again, it has been asserted - for example, by Kempner -
that all participants in the conference knew perfectly well that the
subject under discussion was the "extermination of the Jews". But if that
is so, then why did Heydrich talk in riddles?  In this connection, Albert
Wucher makes an interesting remark:

        " Apart from Heydrich, the Chief of the Security Service and the
          Reich Security Main Office, nobody who was at the Gross Wannsee
          on the 20th of January had completely made up his mind about what
          even the most basic solution would be. "

        In other words, only Heydrich knew what he wanted, but didn't come
out with it. So what was the point of holding this conference ?

        Once again, let us put the "Wannsee Protocol" to the test, this
time by omitting the dubious sentences from it. If one simply removes the
passage from "in big labor gangs..." to "(See experience of history)", the
continuity is in no way disrupted. On the contrary, only then does the text
make sense. From the last paragraph of page 7 to the third paragraph on
page 8 it would now read:

        " Unter entsprechender Leitung sollen nun im Zuge der Endlosung die
          Juden in geeigneter Weise im Osten zum Arbeitseinsatz kommen.
          Im Zuge der praktischen Durchfuhrung der Endlosung wird Europa
          vom Westen nach Osten durchkammt. Das Reichsgebiet einschlielich
          Protektorat Bohmen und Mahren wird, allein schon aus Grunden der
          Wohnungsfrage und sonstigen sozialpolitischen Notwendigkeiten,
          vorweggenommen werden mussen.
          Die evakuierten Juden werden zunachst Zug um Zug in sogenannte
          Durchgangsghettos verbracht, um von dort aus weiter nach dem
          Osten transportiert zu werden. "

        " Under proper direction the Jews should now in the course of the
          Final Solution be brought to the East in a suitable
          way for use as labor.
          In the program of the practical execution of the Final Solution,
          Europe is combed through from the West to the East. The Reich
          area, including the Protectorate Bohemia and Moravia, will have
          to be taken in advance, alone for reasons of the housing problem
          and other social and political necessities. "

        Only this reading is consistent with the numerous documents form
the period indicating that all internees -including Jews- were regarded as
a source of urgently needed manpower for the war economy, and, after the
conquest of the Eastern territories, were to be transported there in
successive stages. Here it would be impossible to treat all these documents
at length. Only one of them merits special attention, owing to its
unmistakable connection with the Wannsee Conference, a wire from Himmler to
the Inspector-General of Concentration Camps, SS-Gruppenfuhrer Richard
Glucks, dated January 26, 1942. It was presented in evidence at the NMT
"I.G. Farben Trial" (Case VI; US vs Krauch) as document NI-500, and is
quoted by Reitlinger:

        " Richten Sie sich darauf ein, in den nachsten 4 Wochen 100 000
          mannliche Juden und bis 50 000 Judinnen in die KL aufzunehmen.
          Groe wirtschaftliche Aufgaben werden in den nachsten Wochen an
          die Konzentrationslager herantreten. "

        " During the next few weeks 100,000 Jews and 50,000 Jewesses will
          be sent to concentration camps, which will have to deal with
          major economic problems and tasks. "

        Reitlinger makes a clumsy attempt to contrast Himmler and Heydrich
by attributing responsibility for initiating the "extermination of the
Jews" to Heydrich, while portraying Himmler as interested only in pooling
Jewish labor. In his Auschwitz Trial deposition, Dr. Martin Broszat of the
Institut fur Zeitgeschichte argues in more or less the same vein.
Apparently, he found it hard to come to terms with this document: On the
one hand, he expresses the opinion that Himmler only temporarily exempted
able-bodied Jews from "extermination". On the other, he speaks of "two
conflicting aims with two different authorities in charge", namely, the
alleged plan to "exterminate" the Jews and the well-documented plan to use
their labor.

        These are, of course, very feeble attempts to explain away a fact
that does not fit in with the extermination thesis. Even Krausnick, in his
Auschwitz Trial deposition, has to admint that Jews were still being
employed in the munitions factories during the final year of the war. As
late as 1944, he says, "tens of thousands of Jews were forcibly removed
from the Polish camps to Germany". Leaving aside the rather melodramatic
expression "forcibly removed", his statement is completely accurate, and
simply confirms the fact that the realities of the time made it necessary
to bring Jews back from the East to work in the armaments industry. In such
exegetics as those of Reitlinger and Krausnick, one senses the utter
embarrassment which the numerous documents on the conscription of Jewish
labor cause all proponents of the extermination thesis. By 1944, there
would have been hardly a Jew alive in the German Reich had "Final Solution"
actually meant "extermination of all Jews".

        The fact that the Jews deported to the East were to be employed in
war industries there also accords with the proposal, ascribed to Heydrich
in the "Wannsee Protocol", that Jews over the age of 65 not be evacuated to
the East, but removed to a "ghetto for the aged". (p287, 5th paragraph)
Had the extermination of all Jews been intended, it is inconceivable that
elderly Jews would have been spared, much less accorded privileges,
especially since in the mass executions allegedly planned a few thousand
victims would not have mattered one way or the other. However, if the
conscription of Jewish labor were planned -and there can be no doubt of
that- it certainly would have made sense to exempt Jews over age 65, for
one could hardly expect much of their performance. Likewise, the fact that
the exemption would apply to Jews who were "serious war wounded cases and
Jes with war decorations (Iron Class, First Class)" (p.287 paragraph 8)
does not fit in with the allegation that the Wannsee Conference was held to
plot the "extermination of all Jews". This part of the "Wannsee Protocol"
is decidedly at odds with the extermination thesis.

        Faced with these facts, the extermination mythologists argue that
exemptions and other preferential treatment were merely "tactical
measures". That is the position Krausnick takes. He alludes, moreover, to
the "significant distinction" Heydrich supposedly makes between
"evacuation" (in this context, allegedly, "killing") and removal to a
"ghetto for the aged". This kind of intellectual legerdemain, whereby one
expression is arbitarily defined as "killing", has nothing whatsoever in
common with scholarship.

        The rest of the "Wannsee Protocl" is obviously irrelevant to the
extermination question. One may dispute the feasibility or morality of the
approach to the Mischling problem set forth in Section IV, but our
subject is the "extermination plan", and that passage has no direct bearing
on it. This also applies to the next two last paragraphs of the document
(p.290), which proponents of the extermination thesis occasionally cite for
support. Here, as always, one must keep in mind that the "Wannsee Protocol"
is basically questionable in its entirety.

        According to this paragraph, the conference ended with a discussion
of the "various kinds of solutions" ("die verschiedenen Arten der
Losungsmoglichkeiten"), in which two of the participants advocated that
"certain preparatory tasks in the course of the Final Solution should be
performed immediately in the territories concerned" and that in this "any
disturbing of the population must be avoided". Quite naturally, the term
"Final Solution" is used again in this context, and it has been taken by
the proponents of the extermination thesis as a synonym for "annihilation
of the Jews", which it certainly was not. The expression
"Losungsmoglichkeiten" ("possibilities for a solution") has likewise been
interpreted as "possibilities for killing", although there is no point of
reference for that interpretation either. To be sure, Krausnick maintains
in his Auschwitz Trial deposition that Eichmann interpreted the expression
"Losungsmoglichkeiten" in this way, during the Jerusalem "trial", but he
has yet to produce a shred of evidence for this implausible definition.

        Since at this stage of the conference the "solution of the Jewish
problem in the Government General" was discussed, one would not be amiss in
assuming that the term "Losungsmoglichkeiten" was used with reference to
the possibilities for evacuating the Jews in that area. That account of the
evacuation is obvious, and actually proves nothing about an "extermination
plan". In the course of the evacuation, one could form an estimate of the
problems the "Final Solution" would entail. The ability of the Jews to live
as a community in a state of their own could be put to the test in the
Eastern ghettos. As is well knowm, the Warsaw ghetto did for some time
constitute a community of sorts.

        In conclusion, it can be said that the "Wannsee Protocol" -if one
does not choose to view it as a total forgery- contains some passages which
are at least substantially genuine, along with sentences that do not fit
into context, and must have been subsequently forged into the document.
Likewise, several authentic passages may have been excised, for example,
details of the Madagascar Plan. Leaving aside any possible manipulations,
the document remains questionable simply because its origin is so obscure.
In form it hardly corresponds to German official usage, and the original
has yet to be submitted to impartial experts who could perhaps determine
whether or not it is authentic. As such, the document is hardly adequate
proof that a plan existed to exterminate all Jews residing in
German-controlled territory. Even in its present form, it does not
constitute sufficient proof of that allegation. For in the entire document
there is not a word about "exterminating", much less "gassing" the Jews,
and the portions of it cited to prove this claim are seen in a different
light when one refrains from taking "Final Solution" as a synonym for
extermination.

                Further Documents Regarding Deportation
                ---------------------------------------

        Naturally, the technique of arbitrarily defining terms and
concepts, which the extermination mythologists have applied to the "Goring
Decree" and the "Wannsee Protocol", has been extended to all other
documents pertaining to the deportation of the Jews. Not a single document
of this kind makes reference to an "extermination plan" or to "mass
gassings" in Auschwitz-Birkenau. Otherwise, the extermination mythologists
would not have to resort to the technique of verbal and conceptual
falsification. Thus it seems hardly necessary to treat in detail all the
various decrees, orders, wires, and such. From the general content of the
most commonly cited ones it is easy to see that they actually have nothing
to do with an extermination plan and its execution. Quite the contrary:
Many of these documents make it clearer than ever that the deported Jews
were to be integrated into the war economy.

        In addition to the previously mentioned terms "Final Solution", and
"evacuation", the expressions "Jewish resettlement", "colonization of the
Jews in the East", and of course, "deportation" itself are continually
interpreted as "annihilation" and "extermination" of the Jews, or, at
least, represented as denoting preparation for that. The redefinition of
these words is usually justified on the grounds that they were only
"euphemisms" or "code words" with which one sought to cover up what was
actually happening. By means of this trick -one can hardly call it anything
else- which even certain "scholars" have been known to employ, it is easy
to furnish most any document with the desired meaning, though conscientious
and earnest historians could never be fooled. For not a single document has
been found to date that shows when, where, or by whom these alleged "code
words" for murder were devised. The "expert witnesses" in the Auschwitz
Trial were at loss to explain the origin of these terms, and they even
availed themselves of the dubious mode of argumentation. Whether the
governmental agencies and functionaries concerned with the Jewish matter
actually "knew" the "real" meaning of the "code words" is a pressing
question that is generally not asked and has never been answered.

        The expression "special treatment" ("Sonderbehandlung"), which
appears in some documents concerning the transport of Jews to concentration
camps in the East, deserves particular consideration. This term is not
readily understandable. Supposedly, it is also a "code word" for "killing"
or "gassing" Jews within the framework of the "extermination program". But
for this definition, too, no credible sources have been found. The actual
meaning is not quite so evident as in the case of the terms "Final
Solution", "evacuation", and "resettlement". In all probability, "special
treatment" had, from time to time, various meanings, known only to the
agencies involved, and today it is often no longer possible to determine
exactly what it meant on a given occasion. Used in connection with
deportations, it might have meant, for example, "special billeting", which
could have been ordered for some compelling reason. One has only to think
of the disease carriers among the deportees. In fact, it is well known that
a special quarantine camp existed at Auschwitz.

        At the Nuremberg IMT trial, Dr. Ernst Kaltenbrunner, sucessor to
Heydrich, testified that in certain cases the term "special treatment"
actually referred to billeting prominent internees in luxury hotels and
otherwise granting them special privileges. Theresienstadt was a
preferential treatment camp, intended, above all, for elderly or disabled
Jewish war veterans, who were accorded good living conditions and exempted
from labor service - exactly as specified in the "Wannsee Protocol". In May
1945, a delegate of the International Red Cross who had been sent to
inspect the camp stated in his report that the Germans could not be blamed
for the violent death of even one Jew at Theresienstadt.

        To be sure, none of this rules out the possibility that under
certain circumstances -for example, in operations of the Einsatzgruppen-
the term "special treatment" could also have meant "execution without
trial". Since the liquidation of Soviet commissars and active partisans, or
even those suspected of collusion with them, Jews and non-Jews alike, did
take place, sometimes in nearby concentration camps, the term could have
meant "execution" in this exceptional case. Nevertheless, such executions
had nothing to do with any systematic extermination of Jews on account of
their race. Specifically, no documentary evidence has ever been presented
to show that in Birkenau "special treatment" was equated with death in the
"gas chamber" that allegedly existed at the camp.


                "EXTERMINATION CAMP" DOCUMENTS
                ------------------------------

        Since there are no documents from German official files which
directly substantiate the existence of "gas chambers" at Auschwitz, the
extermination mythologists have attempted to deduce the presence of "gas
chambers" indirectly, from other documents.

        Cited in this regard are, above all, documents relating to the
crematoria in Auschwitz-Birkenau, of which there are supposed to have been
four. It is usually contended that these crematoria were built specifically
for the "extermination program", and so had adjoining "gas chambers".
However, the documents thus far presented contain no indication of that.
For other reasons, too, they are suspect. At the Nurember IMT trial, Soviet
prosecutor Alexander Smirnov asserted, during the early morning of February
19, 1946, that in "office records of Auschwitz camp there was discovered a
voluminous correspondence between the administration of the camp and the
firm of Topf and Sons" on the construction of "four powerful crematoria and
gas chambers in Birkenau", and that these facilities had been completed by
the beginning of 1943. Nevertheless, he presented the Tribunal only a
single "document" in this regard, a letter from the contractor, which lacks
any mention of "gas chambers". Thereafter, nothing more was heard or seen
of this "voluminous correspondence". The document upon which Smirnov based
his allegations reads as follows:

        " J.A. Topf & Sons, Erfurt.
          12. Februar 1943
          An das Zentralbauamt der SS und Polizei Auschwitz:
          Betr.: Krematorien 2 und 3 fur das Kriegsgefangenenlager.
          Wir bestatigen den Empfang Ihres Telegramms vom 10. Februar
          folgenden Inhalts:
          Wir bestatigen nochmals, da wir Ihren Auftrag auf 5 Stuck
          dreifacher Muschelofen erhalten haben, einschlielich zweier
          elektrischer Aufzuge fur den Aufzug der Leichen und eines
          provisorischen Aufzuges. Ebenso wurde eine praktische Einrichtung
          zur Kohlenlieferung bestellt und ferner eine Vorrichtung zum
          Aschenabtransport. Sie mussen die vollstandige Einrichtung fur
          das Krematorium Nr. 3 liefern. Wir erwarten, da Sie dafur Sorge
          tragen, da alle Maschinen mit ihren Teilen unverzuglich zum
          Versand gebracht werden. "  (**)

        " I.A. Topf and Sons, Erfurt; 12 February 1943.
          To Central Construction Office of SS and Police, Auschwitz.
          Subject: Crematoria 2 and 3 for the camp for prisoners of war.
          We acknowledge receipt of your wire of 10 February, as follows:
          We again acknowledge receipt of your order for five triple
          furnaces, including two electric lifts for raising the corpses
          and one emergency lift. A practical installation for stoking coal
          was also ordered and one for transporting the ashes. You are to
          deliver the complete installation for Crematorium Number 3. You
          are expected to take steps to ensure the immediate dispatch of
          all the machines complete with parts. "

        Leaving aside the fact that Birkenau was not a prisoner of war camp
at that time, this letter is so confusedly worded as to be unintelligible.
If one takes the text read by Smirnov literally, it would seem that the
firm of "I.A. Topf and Sons" had ordered cremation equipment from the
Central Construction Office!  Moreover, one finds it hard to imagine
exactly what is meant by "triple furnaces" or a "practical installation for
stoking coal".

(**) [ We should notice that here, as always, Dr. Staglich is citing the
German edition of the IMT volumes. It is not clear whether this German text
of the communication Smirnov read during the proceedings (presumably, in
his native tongue) is a direct transcription of some genuine or spurious
document, or a retroversion from the Russian. Certainly, the version that
appears in the "Report of the Soviet War Crimes Commission", which for some
reason the Russians choose to present in a tin-eared and often
ungrammatical German, is not the original text. To reproduce that version
here would be to waste paper. (or bytes...)  Readers with an insatiable
appetite for textual criticism may consult IMT, Vol. XXXIX, p.243
(Nuremberg Document 008-USSR). The above English translation of the Smirnov
document is taken from IMT, Vol. VII, p.584, "Official text in the English
language." -T.F. ]

        In the "Report of the Soviet War Crimes Commission, 6 May 1945",
which we shall discuss in more detail later, another version of this letter
is to be found. There the wording is "fuenf dreiteilige Verbrennungsoefen"
("five tripartite cremation ovens") and "eine brauchbare Einrichtung fuer
die Beheizung mit Kohle" ("a workable contrivance for heating with coal").
And this version includes a final sentence missing from the Smirnov text:
"Die Einrichtung muss am 10. April 1943 betriebsfertig sein" ("The
installation must be ready for use by April 10, 1943).

        It goes without saying that this document is very suspicious and
despite Smirnov's assertion to the contrary -it was obviously the only
document of its kind the Soviets could produce. This "document", with its
two rather disparate versions, is a good example of the type of "evidence"
presented at the Nuremberg trials. That is the main reason I chose to bring
it up here. Basically, its contents are insignificant. Hence we may leave
aside the question of whether it is a miserable Soviet forgery or merely an
inaccurate and faulty retroversion of a Russian translation.

        Incidentally, it is also uncertain whether the Nuremberg Tribunal
actually accepted this document in evidence. In its verdict, the Tribunal
based its "finding" that mass extermination of Jews by gassing was carried
out in Birkenau not on this document, but on some equally dubioius witness
testimony, in particular, that of former Auschwitz commander Rudolf Hoss,
which we shall treat at length elsewhere.

        More noteworthy than the document itself is the remark Smirnov made
after reading it:

        " I omit the next document which deals with "bath houses for
          special purposes " (gas chambers)...

        Later in the same session, he declared, with astonishing naivete,
that the Tribunal already had sufficient knowledge of such matters, though
-as we explained in our first chapter- this was hardly the case.
Significantly, the court did not venture to disagree.

        This withholding of "facts" about a concentration camp in
Soviet-occupied territory, a camp of which the Nuremberg Tribunal basically
knew only what could be gleaned from previous witness testimony, is simply
amazing. For if one may believe Smirnov, here at last was a document that
contained direct information about the legendary "gas chambers". But it
never became an issue in the proceedings, nor was it mentioned in the
judgement of the Tribunal. Was this "document" so patently frauded that one
dared not present it even to these hardly impartial judges?  So far as I
know, it was not submitted as evidence in any of the subsequent "war crimes
trials". Yet Smirnov's claim that the Birkenau "gas chambers" were
disguised as shower rooms is accepted even today, and trotted out whenever
the occasion presents itself.

        As proof that "gas chambers" were structually part of the crematory
installations, the proponents of the extermination thesis often cite a
letter from the Central Construction Office of the SS and Police in
Auschwitz to SS-Brigadefuhrer Hans Kammler. Chief of Amtsgruppe C of the SS
Economic and Administrative Main Office. This report, dated January 29,
1943 and signed by SS-Sturmbannfuhrer Karl Bischoff, head of the Central
Construction Office in Auschwitz, reads as follows:

        " Das Krematorium II wurde unter Einsatz aller verfugbaren Krafte
          trotz unagbarer Schwierigkeiten und Frostwetter bei Tag- und
          Nachbetrieb bis auf bauliche Kleinigkeiten fertiggestelt. Die
          Ofen wurden in Beisein des Herrn Oberingenieur Prufer der
          ausfuhrenden Firma, Topf u. Sohne, Erfurt, angefeuert und
          funktionieren tadellos. Die Eisenbetondecke des Leichenkellers
          konnte infolge Frosteinwirkung noch nicht ausgeschalt werden. Die
          ist jedoch unbedeutend, da ver Vergasungskeller hierfur benutzt
          werden kann.
          Die Firma Topf u. Sohne konnte infolge Waggonsperre die Be- und
          Entluftungsanlage nicht wie von der Zentralbauteilung gefordert
          rechtzeitig anliefern. Nach Eintreffen der Be- und
          Entluftungsanlage wird jedoch mit dem Einbau sofort begonnen,
          soda voraussichtlich am 20.2.43 die Anlage vollstandig
          betriebsfertig ist. "

        " The crematorium II has been completed -save for some minor
          constructional work- by the use of all forces available, in spite
          of unspeakable difficulties, the severe cold, and in 24-hours
          shifts. The fires were started in the ovens in the presence of
          Oberingenieur Pruefer, representative of the contractors of the
          firm of Topf and Sohne, Erfurt, and they are working most
          satisfactorily. The planks from the concrete ceiling of the
          cellar used as mortuary [Leichenkeller] could not yet be removed
          on account of the frost. This is, however, not very important, as
          the gas chamber [Vergasungkeller] can be used for that purpose. "
          The firm Topf and Soehne was not able to start deliveries of the
          installation in time for aeration and ventilation as had been
          requested by the Central Building Management because of
          restrictions in the use of railroad cars. As soon as the
          installation for aeration and ventilation arrive, the installing
          will start so that the complete installation may be expected to
          be ready for use 20 February 1943.

        To the best of my knowledge, this document is the only one in which
the term "gassing" ("Vergasung") is used is connection with the crematoria.
Of course, one cannot say for certain whether the "Vergasungkeller" was
actually part of the crematorium or whether it was located inside the
crematorium buildings. Since the German text refers only to a
"Vergasungskeller" ("gasification cellar" or "carburation cellar"), and not a
"Gaskammer" ("gas chamber"), this could not be one of the rooms supposedly
used for "extermination", which are always called "gas chambers". For this
reason, it is significant that at the NMT "Concentration Camp Trial" (Case
IV; US vs Pohl), the word "Vergasungskeller" was rendered as "gas chamber"
in the English translation of the document (NO-4473), as Dr. Butz has
noted. Ever since, the wording has been misinterpreted, even in the German
language literature on our subject.

        Dr. Butz gives a convincing explanation of the function of this
part of the crematoria. Except for electrically powered units, which do not
figure in the Auschwitz controversy, all crematoria, including those which
use coal, coke, or wood as fuel, are fired with gas. According to his
research, the space in which the primary fuel is converted into combustible
gas before being fed into hearth is known in German as the "Vergasungsraum"
or "Vergasungskeller". Hence these terms have nothing whatsoever to do with
the "gassing" of human beings.

        Another plausible explanation is that this room was intended for
the fumigation of clothing and other personal effects, a common practice in
all concentration camps. The proprietary hydrocyanic fumigant Zyklon B used
for this purpose is supposed to have been used for the "extermination of
the Jews" as well.

        Never has there been any question that these "Vergasungskeller"
were used as "gas chambers" for exterminating Jews. When it is claimed that
the "gas chambers" were underground installations, they are identified
with the "Leichenkeller", ie., "corpse cellar" or subterranean mortuaries,
of the crematoria. The document under consideration here makes it clear,
however, that the "Leichenkeller" and the "Vergasungskeller" were two
different things. The equation of "corpse cellar" with "gas chamber" has
resulted from the assumption that the "scale model" on display at the
Polish State Auschwitz Museum is based on building plans of the crematoria.
But these plans have never been made public. (They are gathering dust in
the Auschwitz Museum archive under catalogue number 519). Through a
fortunate set of circumstances, I came into possession of a photocopy of
the plans of crematoria II and III. I shall return to them later.

        Since Bischoff's letter of January 29, 1943 is the only known
document from the Auschwitz camp files in which the word "Vergasung" is
used in connection with the crematoria, one should now realize that there
is no documentary evidence for the allegation that chambers for killing
people by means of lethal gas were part of the crematoria. Nor does the
charge, made by various Auschwitz mythologists, that the construction of
crematoria resulted from the necessity of disposing of the corpses of the
thousands of people "gassed" daily at the camp find any support in the
crematoria documents. Hence we may well ask the question: When did the
Birkenau crematoria -or the Birkenau crematorium-  first go into operation
and how long did it or they remain in operation?  We may also ask: What was
the actual capacity for incineration of the individual crematoria? Only
one, highly questionable document touches on this last point. With nothing
solid to go by, we can only make conjectures as to the incineration
capacity of the crematoria from what few clues are available. Our
conclusions are very different from the estimates that so often appear in
the literature on this topic.

        It is usually maintained that, owing to the commencement of "mass
exterminations" in 1942, four crematoria were constructed at Birkenau in
the winter of 1942-43, and went into operation in the spring of 1943. This
is the version attributed to Rudolf Hoss. Even Rassinier and Scheidl have
given credence to it, on the basis of two NMT documents (NO-4401 and NO-4463).
These documents state that the ovens for all four crematoria were ordered
either on August 8, 1942 from the firm Topf & Sohne, installed in February,
1943, and went in operation on May 1, 1943. I have not consulted the
documents mentioned by Rassinier and Scheidl, but other documents, at least
in part, contradict this story.

        Even the Smirnov document of May 1, 1943 does not support it. In
still greater contradiction to this story is a preliminary cost estimate
from the firm of Topf & Sohne for the delivery of a cremation oven to
Birkenau, dated April 1, 1943. A preliminary cost estimate is, of course,
always given before an order is placed. On the other hand, the Central
Construction Office letter of January 29, 1943 cited above leads one to the
conclusion that the ovens for the crematorium II were already installed and
in operation by January, 1943, which is also in contradiction to the two
previously mentioned documents. Finally, in Reinhard Kuhnl's collection of
documents, there is a facsmile of a letter from Topf & Sohne to the Central
Construction Office in Auschwitz dated April 10, 1943, in which the firm
promises to repair cracks that had "recently" appeared in the "8-muffle
oven of crematorium IV". From this one would assume that crematorium IV was
in operation by March 1943.

        Part of another letter Bischoff wrote to Kammler, reproduced in
Adler, Langbein, and Lingens-Reiner's book AUSCHWITZ: ZEUGNISSE UND
BERICHTE, also seems to substantiate to current version of the inauguration
of the Birkenau crematoria. The document in question is an excerpt from a
purported list of finished "construction projects" presented to the
Auschwitz camp administration. In it the completion dates of the crematoria
are recorded as follows:

        crematorium IV          on March 22, 1943.
        crematorium II          on March 31, 1943.
        crematorium V           on April 4, 1943.
        crematorium III         on June 25, 1943.

        However, the authenticity of this document must be questioned until
it can be shown where it was discovered and a full text is made available.
The only indication as to its origin is a rubber-stamped imprint on the
upper left-hand side: "Bauleitung der Waffen-SS u. Polizei [There follow
three undecipherable letters] Auschwitz". This is obviously not in accord
with the usual official designation: "Zentralbauleitung der Waffen-SS und
Polizei Auschwitz".

        Faced with all these discrepancies and obscurities, even Gerald
Reitlinger, who certainly cannot be suspected of doubting the extermination
thesis, concludes that Bischoff's letter of January 29, 1943 is not a
reliable source of information:

        " In fact Crematorium No. 2 was not ready till March 13th. On June
          13th it was still the only crematorium of the four which was
          actually working, and the carpentry work was incomplete. On
          November 6th, 1943, an order for young trees to form a green belt
          between the crematoria and the camp only mentions Nos. 1 and 2.
          The working of all four crematoria was not put to the test till
          May, 1944, when the massive transports arrived from Hungary. "

        According to Reitlinger, then, the crematoria were not in full
operation until exactly one year later than is officially claimed today.

        Given all these discrepancies, one can only say that to this day
there is still no reliable evidence of the completion dates of the Birkenau
crematoria. With some assurance, one may even dispute whether there really
were four crematoria at Birkenau. In 1972, a book was published containing
sketches of everyday life at various concentration camps, drawn by an
inmate named Alfred Kantor. None of the many views of Birkenau he sketched
shows more than one crematorium or one crematorium chimney. A person who
toured the grounds of the former Birkenau camp without a guide and who is
questionably reliable, so far as I am concerned, told me he saw the
ostensible remains of crematoria II and III, but could find no trace of
crematoria IV and V.

        Nor are there any reliable data on the incineration capacity of the
Birkenau installations. In the literature on the camp, yet another report
by SS-Sturmbannfuhrer Bischoff, dated June 28, 1943, is frequently cited.
It states that the individual crematoria were capable of incinerating the
following number of corpses daily:

        I   old crematorium (parent camp)         340 corpses
        II  new crematorium (Birkenau)          1,440 corpses
        III new crematorium (Birkenau)          1,440 corpses
        IV  new crematorium (Birkenau)            768 corpses
        V   new crematorium (Birkenau)            768 corpses
                                                 -------------
                                         Total  4,756 corpses

        Where this report was discovered is not mentioned. On the subject
of the incineration capacity of the crematoria one usually cites as the
authority a "Kalendarium der Ereignisse im Konzentraionslager
Auschwitz-Birkenau" ("Chronology of the Events in the Auschwitz-Birkenau
Concentration Camp"), compiled by Danuta Czech, Custodian of the Polish
State Museum at Auschwitz. I have been unable to determine whether this
lady was ever interned at the camp or what her source of information may
be.
        The estimates listed above strike one as absurd. The sheer
punctiliousness of the accounting -right down to the very last corpse- is
suspicious, for cremation is a complicated technical process, involving so
many variables that the incineration capacity of a crematorium is not
always the same.

        Some indication of the actual capacity of the crematoria may be
found in a letter from the firm Topf & Sohne to the Mauthausen
concentration camp. It states that in the "coke-fuelled Topf dual-muffle
cremation ovens ... about ten to thirty-five corpses" could be cremated "in
about ten hours", and that as many could be "cremated daily without
overloading the ovens", even if the "cremations took place one after the
other, day and night".

        Presumably, the cremation ovens manufactured by Topf & Sohne were
of uniform design, and thus the same type of oven was sent to Auschwitz as
to Mauthausen and other camps. (The firm received the German patent number
861,731 for its cremation ovens). The ovens might have differed slightly in
the number of cremation chambers; one cannot otherwise account for any
variation in their capacity.

        Starting with the premise that there really were four crematoria in
Birkenau, and that each crematorium contained one oven capable of cremating
at most 35 corpses per diem, then the highest capacity of all four
crematoria would be a total of 140 corpses daily. That does not seem
excessive for a complex the size of Auschwitz, each component camp of which
was planned for over 100,000 inmates - all the more so, since contagious
diseases were rampant there. Leaving aside the normal mortality rate,
epidemic and other diseases undoubtedly claimed numerous victims. Dr.
Scheidl has reported that, during certain periods, there were between 69
and 177 deaths each day.

        While these are no more than purely hypothetical estimates, they
are probably closer to reality than the absurd figures given in the letter
attributed to SS-Sturmbannfuhrer Bischoff- even if one assumes that all
four crematoria had 46 cremation units, as is claimed in an official
bulletin of the Polish State Auschwitz Museum, dated November 29, 1977.
Dr. Butz also starts from this premise, and also, based on the fact that it
should take at least one hour to incinerate each corpse, calculates that
the total incineration capacity per diem would be 1,058 corpses. Actually,
this is still too many. Even today, in the most modern facilities, it takes
from one and a half to two hours to cremate human remains. One can hardly
imagine that better results could have been achieved with the cremation
techniques of forty years ago.

        The claim that the Birkenau crematoria were built only for use in a
"mass extermination program" thus proves to be totally false. In passing, I
should like to remark that, according to the official publication of the
Polish State Auschwitz Museum to which I have referred above, crematorium I
(the old crematorium in the Auschwitz parent camp), was in operation only
until July 1943, so there was no reason for Bischoff to include it in his
alleged report, which is dated June 28, 1943.

        It is worth noting that Bischoff, who resided in Bremem under his
own name until his death in 1950, escaped the usual post-war harrassment.
He was never prosecuted as a "war criminal", nor, so far as I know, was he
ever called to testify as a witness in any "war crimes trial". That is
strange indeed when one considers that the former head of the Auschwitz
Central Construction Office would have been an ideal witness on the
Birkenau "death factory", since he supervised the building of the camp
crematoria. Was someone afraid that he could have proved, maybe with
documents still at his disposal, that all the allegations about the
crematoria were baseless?  The prosecution at the NMT "Concentration Camp"
Trial, for instance, instead of Bischoff, made do with the testimony of one
Wolfgang Grosch, who obviousl had never laid eyes on the buildings about
which he gave "evidence".

        Likewise, it is worth noting that in the entire post-war
"re-education" literature almost nothing is said about the building plans
for the crematoria. Professor Rassinier alone mentions that the plans for
crematoria II through V were presented in evidence at the NMT
"Wilhelmstrasse" and "Concentration Camp" trials. These plans, showing that
the alleged "gas chambers" were really "corpse cellars" and shower rooms,
have been consigned to oblivion, and so we may assume that Professor
Rassinier's statement is correct.

        There can be no doubt that such building plans existed. (With their
famous thouroughness, the Germans certainly would not have undertaken any
building project without a well-laid plan!)  In fact, as I have stated
above, there are buildings plans for crematoria II and III in the archives
of the Polish State Auschwitz Museum, but they are unavailable to the
public. Instead, visitors are shown a "scale model" of crematorium II
-complete with "gas chambers"- that is purportedly based on "technical
plans that were saved from destruction".

        As I have mentioned, I have copies of these plans, and there can be
no doubt as to their origin, since they bear the official stamp of the
Polish State Auschwitz Museum. These copies show that the model differs
from the building plan in several important details and no provision was
made for anything like a "gas chamber". The area marked "corpse cellar",
which is supposed to have measured 7 meters by 30 meters (210 square meters
or about 2,260 square feet) would not have been suitable for the "gassings"
to which some "eyewitnesses" have testified. In particular, it could not
have held from 2,000 to 3,000 people at once, as has been claimed.
According to the Auschwitz Museum, three smaller rooms in crematoria IV and
V, with a total space of 236.78 square meters (2,550 square feet), were used
as "gas chambers". The plans lend no support to this allegation, and, in
any case, such use of the rooms would have been impossible because of their
position. Significantly a model of these rooms has not been prepared for
display to visitors of the Auschwitz Museum. In all literature on this camp,
then, there is no exact description of the "gas chambers" of crematoria IV
and V.
        I must cut short my discussion of this piece of evidence, since my
purpose is to examine the evidence concerning the Auschwitz legend that has
been presented, not documents that are -for whatever reason- being witheld,
of which there are doubtless more. Our "contemporary historians" should at
least take a closer look at these plans.

        Even today, visitors to the Auschwitz Museum are shown a "gas
chamber" in the old crematorium of the parent camp. But this is -as the
French scholar Robert Faurisson discovered- merely a "reconstruction",
something of which Auschwitz Museum tourists are, of course, not informed.
This "reconstruction" has little in common with the structure that actually
existed. For one thing, a "gas chamber" has been made out of what were
originally several rooms, as can be seen from the surviving ground-plan.
The larger of these rooms is designated in the ground-plan as "morgue"
("Leichenkeller"), a necessary adjunct to a crematorium. This is exactly
the same kind of hoax the Americans perpetrated at Dachau.

        Since the crematorium was no longer standing when the Soviets
occupied Birkenau, no one will ever know just how the previously mentioned
building plans were executed -if indeed they were. Hence all we can say
with absolute certainty is that the attempt to prove the existence of "gas
chambers" at Birkenau from the presence there of one or more crematoria
simply has not come off.

        Even more questionable is the attempt to use deliveries of Zyklon B
to Auschwitz as proof that the camp had "gas chambers" in which Jews were
murdered with this highly toxic gas.

        At the various Nuremberg trials, the prosecution submitted invoices
for these deliveries as "evidence" that "gassings" had occured. One of
these invoices, dated March 13, 1944, appears in Reimund Schnabel's book
MACHT OHNE MORAL [Power without Morals], as "Document 134". This invoice
attests to the delivery of 14 crates of Zyklon B, containing a total of 420
canisters (210 kilograms altogether), to the "Department of Disinfestation
and Disinfection" at Auschwitz. The task of this department -as of such
units everywhere- was the disinfection of living quarters, clothing, and
personal effects. According to the testimony of Arthur Breitwieser, a
defendant in the Frankfurt Auschwitz Trial, it had nothing to do with
exterminating human beings. Breitwieser, who for some time served as the
director of this department, and so ought to be well-informed about its
activities, was acquitted by the Auschwitz Trial court. This is one of the
many absurdities in that "trial". For the disinfectors were undoubtedly
responsible for the storage and application of Zyklon B, and without their
cooperation it would have been impossible to use this preparation to "gas"
Jews.

        Rassinier points out the well-known fact that Zyklon B had been
used by the German Army since 1924. During World War II it was employed as
a disinfectant in every branch of the service and in all the concentration
camps. Invoices have been found for deliveries of Zyklon B to the
Oranienburg and Bergen-Belsen camps, where -as has been proved- gas
chambers for exterminating human beings did not exist.

        One cannot deny that this preparation could have been used to
exterminate people. Of course, that does not mean that it was. After all,
nobody could be accused of being a murderer simply because he owned an axe,
an instrument extraordinarily well-suited to homicide. Such an accusation
would be laughed out of any court. But to "prove" the existence of "gas
chambers" at Birkenau -something for which real evidence is utterly
lacking- no argument, however idiotic, is disdained, even by certain
"scholars".

        For example, Professor Krausnick, in a footnote to his Auschwitz
Trial deposition, cites an NMT document (NO-4465) that is so ambiguous that
most of the other writers on this subject do not venture to mention it.
This is an order that the Central Construction Office of Auschwitz
allegedly placed with the Deutsche Ausrustungswerke GmbH, an SS industrial
firm near Auschwitz, for the manufacture of "three gas-tight towers ... of
exactly the same dimensions and type as the towers previously supplied"(**)
("drei gasdichte Turme ... genau nach den Ausmaen und der Art der bisher
angelieferten Turme").  One asks in vain what these towers might have to do
with "gas chambers" -a question Krausnick, of course, does not answer. None
of the "eyewitnesses" to the "gas chambers" has anything to say about such
towers.

(**) [ My translation. In the NMT translation of this document, the phrase
"drei gasdichte Turme" is rendered into English as "three gas-tight
chambers", but the translator was honest -or puzzled- enough to add the
word "Turme" in brackets (NMT, Vol. V, p.622) ]

        In this order, dated March 31, 1943, there is also a reference to
the filling of another order, placed on March 6, 1943, for a "gas door
100 x 192 cm for corpse cellar I of crematorium III ... of exactly the same
type and size as the cellar door of the crematorium opposite it,
crematorium II, with a peep-hole made of double-strength 8-mm glass, with
rubber gasket and [metal?] cap" ("Gastur 100/192 fur Leichenkeller I des
Krematorium II ... genau nach Art und Ma der Kellertur des
gegenuberliegenden Krematoriums II mit Guckloch aus doppeltem 8 mm Glas mit
Gummidichtung und Beschlag").

        Could this be the famous peep-hole through which the SS physicians
who allegedly supervised the "gassing" of inmates are said to have observed
the death-throes of the victims?  Probably not. Like the other documents of
its kind, this order really proves nothing. At that time, gas tight doors
were not uncommon, since every cellar had to double as an air raid shelter.
The peep-holes in these doors were a source of light and a means of
observing the outside. Through such a peep-hole it would have been quite
impossible to view a whole interior of a "gas chamber", especially if it
were as large as these rooms are usually claimed to have been (i.e., had a
capacity of 3,000 or more people). Air raid shelters had to be secure not
only against explosives, but against gas as well. Considering that Birkenau
had no other fortified places, it would only have been common sense to make
the cellars of the crematoria into air raid shelters. Perhaps these
"gas-tight towers" were intended as some kind of aboveground shelter.

        In nearly all the collections of documents on Auschwitz, papers
containing only routine information about the billeting and employement of
inmates, their transfer to other camps, and similar matters are adduced as
evidence of the alleged gassings. The commentators explain that seemingly
innocuous words and phrases in these papers really denote the "gassing" of
inmates. For such conjectures there is not the slightest factual basis. Not
only does the term "special treatment", which we have already discussed,
play a role in this connection, but phrases like "given special
accommodation" ("gesondert untergebracht"), which is used in a wire from
the Commandant's Office at Auschwitz in regard to a newly arrived group of
Jews, are also interpreted as "murdered in the gas chambers". Similarly, in
their commentary on a list of prisoners being tranferred from Monowitz to
Birkenau, Adler, Langblein, and Lingens-Reiner state that the persons
listed had been designated for "gassing", even though the document itself
does not contain the slightest indication of that.

        All these attempts to read such things into both vaguely and
unequivocally worded documents shamelessly capitalize on a critical
ineptitude, gullibility, and prejudice that have resulted from years of
brainwashing. As any person with the capacity to think must admit, these
"documents" on the alleged gassings have no value whatsoever as evidence.
Even the fait accompli of some of them having been accepted in evidence at
the Nuremberg trial cannot alter this fact. Consider the transfer list
mentioned above, which was used in the NMT "IG-Farben Trial" (Document
NI-14997). No historian who holds to the traditional scholarly methods of
researching and evaluating sources would accept a mode of argumentation
based on the premise that documents can be made to serve a desired end by
the use of unwarranted assumptions and arbitrary interpretations. It is
hardly necessary to go into every little detail of such documents, without
which the legend of the "extermination of the Jews" would have gotten
nowhere.

        What has just been said applies equally to the exhibits of clothing
and human hair from concentration camps, which in the post-war
"re-education" literature are frequently invoked as proof of the
"extermination of the Jews". It is claimed that these articles came from
prisoners who had been "gassed", even though that cannot be so much as
inferred from any document. What is never mentioned is that, for hygienic
reasons, the hair was cut off all incoming prisoners before they were sent
to the showers. Afterwards, they were given a uniform to wear. Their street
clothes had to be turned over to the authorities, as is standard procedure
in all prisons.

        Our survey of official documents from recent German history shows
that there is no documentary evidence that proves the existence of "gas
chambers" in Birkenau or a plan to "exterminate the Jews", or that would
even cause one to suspect there might be something to such charges. It also
shows that the statement recently made by one of the vilest members of the
Nuremberg lynching party, the Jewish-American prosecutor Robert M. Kempner,
that the "historical assessments" on the "extermination of the Jews" are
based "almost exclusively on official German documents of the Hitler regime
that have been preserved by an experienced bureaucracy" is totally
unfounded. Kempner's statement contradicts facts that must be well known to
the man himself. The famous "Wannsee Protocol", which we may have had in
mind when he made his remarks, had proved to be -at least in part- a crude
forgery. We may pass over the recent conjectures that Kempner was
responsible for that forgery -it was he who "discovered" the "document".
The conduct of this charge cannot be established, though Kempner's general
conduct as chief of the American prosecution team at Nuremberg might seem
enough to warrant it.

        The only document from the German official files in which the term
"gassing" ("Vergasung") is used in connection with the Birkenau crematoria
(Nuremberg Document NO-4473), owes its interpretation as "proof" that a
"gas chamber" for killing Jews existed at Auschwitz to a mistranslation. As
Butz has shown, the word "Vergasungskeller" (carburation cellar) was
rendered into English as "gas chamber". That even German scholars have
adopted this misinterpretation testifies to how far removed our historical
scholarship is from a free and objective examination of "Auschwitz" and
everything that word connotes.

        Since it has been established that the Auschwitz Myth does not rest
on official documents, let us see in the following pages what other
"evidence" has been prepared for us.

 