
                            Chapter 1


                        THE MAKING OF A MYTH
                        --------------------

        In every period of history, men have succumbed to certain
illusions. Perhaps the most widespread illusion of our time is that people
are now more thoroughly, comprehensively, and, above all, accurately
informed than ever before. In reality, just the opposite seems to be the
case. The quality of the information disseminated via modern techniques of
communication stands in inverse proportion to its quantity. This general
observation also applies to the veracity of specific pieces of information.
Anyone who has seen an event reported about which he has firsthand
knowledge will attest that much of the depiction was at variance -even
radically so- with that actually happened.

        This is hardly the place to examine the manifold causes of such
distortion. Of one thing there can be no doubt: All politically related
"information" that appears in the mass media today is designed to serve a
purpose. The vaunted "independence" of the communications media is little
more than a soothing copybook platitude. Though every once in a while
ostensibly dissenting viewpoints are aired in the mass media, so as to give
a certain substance to pretensions of "balance", that does not alter in the
least the fact that the clique which, by virtue of its enormous wealth,
largely controls the communications media is primarily interested in
manipulating individuals and nations to attain its political objectives.
The ultimate achievement of propaganda is, as Emil Maier-Dorn has so
vividly put it, to "make millions of people eagerly forge the chains of
their own servitude".

        A most depressing example of a people forging its own chains is to
be seen in the almost fanatical tenacity with which so many Germans cling
to feelings of guilt that have been implanted in them about an epoch in
which bitter necessity impelled the German people to seek an independence
path to the future. Many things go into the makeup of our national guilt
complex, but more than anything else it is the product of deliberate
misinformation about the German past. As a result of this artificial and
utterly baseless guilt complex, at no time since the fall of the Third
Reich has the German people been able to bring itself to pursue its own
political interests. Mendacious propaganda of a kind and scope perhaps
unique in history has insidiously - and thus all the more effectively -
deprived it of the national self-confidence required for such a policy.
Just as an individual cannot get along without a healthy measure of
personal self-esteem, so a people without a sense of national self-esteem
cannot maintain its political independence. In the long run, this political
propaganda disguised as "historiography" can have a positively lethal
effect on the nation.

        Pivotal to the German national guilt complex is the Auschwitz Myth.
During the war, a number of concentration camps were established near
Auschwitz, an industrial town of some 12,000 inhabitants situated about 50
kilometers west of Cracow. In the course of the 1960's, but especially
after the so-called  Auschwitz Trial of 1963-65, the name of this town
evolved into a synonym for "genocide". In the concentration camps of the
Auschwitz region -so the story goes- millions of Jews were systematically
killed on orders from the leadership of the Third Reich. Today the word
"Auschwitz" has the almost mystical force of traditional fables and
legends, and it is in this sense, too, that the phrase "Auschwitz Myth"
should be understood. Indeed, the Auschwitz Myth has become a
quasi-religious dogma. Skepticism about it is not tolerated, nor often
expressed. Cleverly using the Auschwitz Myth to represent itself as the
sacrosanct embodiment of "Humanity" -and the German people as the
embodiment of utter evil- international Jewry has laid claim to a
priveledged status among nations. Similarly, forces inside Germany, as well
as outside, have used the Auschwitz Myth to forestall or suppress any
objective discussion of the Third Reich era. Whenever Germans show signs of
deviating from what Golo Mann calls the "socio-pedagogically desirable view
of history" ("das volkspadagogisch erwunschte Geschichtsbild"), one need
only utter the catchword "Auschwitz" to remove all doubt as to the basic
depravity of the German people. Not only does the very mention of
"Auschwitz" call a halt to rational discussion of the Third Reich, since
beside "Auschwitz", this symbol of absolute evil, everything else seems
inconsequential; it can also be used to cast a shadow over any other aspect
of the German past. So long as the Auschwitz Myth retains it terrible
power, the recovery of our national self-esteem is virtually impossible.


                ORIGINS OF THE AUSCHWITZ MYTH
                -----------------------------

        When one traces the evolution of the extermination legend, it is
really quite difficult to comprehend how the Auschwitz Myth came to occupy
such a towering position in it. To be sure, as early as 1944 the inventors
of the legend had decided on Auschwitz as the site of the "extermination of
the Jews", and were clever enough to bolster this allegation with an
official U.S. Government publication, the "War Refugee Board Report", as
Dr. Butz has shown. However, the WRB Report, which we shall discuss at
greater length in the next two chapters, was consigned to oblivion after
the war. At least in Germany, the "gas chamber" propaganda largely centered
around camps in the Reich itself, even though the International Military
Tribunal (IMT) had asserted in its decision, on the basis of an affidavit
from Rudolf Hoss, the former commandant of Auschwitz, that some 2,500,000
Jews were murdered in "gas chambers" at the camp. Almost immediately after
the war, severe tensions arose between the western Allies and Soviet
Russia, with the result that a line of demarcation, the "Iron Curtain", was
drawn between their respective spheres of influence. Partly for that
reason, partly for others, the western Allies never got to inspect the
Auschwitz area. Here one recalls the statement of Stephen F. Pinter, a U.S.
War Department attorney who was stationed at Dachau for 17 months:

        " We were told that there was a gas chamber at Auschwitz, but since
          that was in the Russian zone of occupation, we were not permitted
          to investigate, since the Russians would not permit it. "

        Thus there was some uncertainty about what position the Soviets
would ultimately take on the "extermination of the Jews", especially since
Stalin himself was reputed to be an "anti-Semite".

        For whatever reason, the Auschwitz Myth was not widely publicized
until well into the 1950's. At least, it still had not acquired the crucial
significance attributed to it today. No distinction was as yet made between
the various camps when the "Final Solution" -the physical destruction of
European Jewry allegedly ordered by the leadership of the Third Reich- was
discussed. They were all supposed to have played basically the same role in
this enormous "murder plot". Every concentration camp, it was said, had one
or more "gas chambers" in which Jews were asphyxiated with volatile cyanide
(in the form of "Zyklon-B", a proprietary fumigant) or carbon monoxide -in
usu vulgi: "gassed". Even in the later edition of this "standard work" THE
FINAL SOLUTION, Gerald Reitlinger claims:

        " Thus eventually, every German concentration camp acquired a gas
          chamber of sorts, though not on Auschwitz lines. The Dachau gas
          chamber, for instance, was preserved by the American occupation
          authorities as an object lesson, but its construction had been
          hampered and its use restricted to a few experimental victims,
          Jews or Russian POWs, who had been committed by the Munich
          Gestapo. "

        In Reitlinger's hedging of his statement about the Dachau "gas
chamber", one sees a rearguard action. As early as 1960, the Institut fur
Zeitgeschichte in Munich felt itself called upon to issue the following
statement, perhaps in response to the findings of the French historian Paul
Rassinier:

        " Neither in Dachau nor Bergen-Belsen nor in Buchenwald were Jews
          or other inmates gassed. The gas chamber in Dachau was never
          finished and put into operation ... The mass extermination of the
          Jews by gassing began in 1941-42, and occurred in a very few
          places, selected exclusively for the purpose and outfitted with
          the appropriate technical facilities, above all in occupied
          Polish territory (but nowhere in the German Reich proper). "

        If Reitlinger's statement was a rearguard action, the statement of
the Institut fur Zeitgeschichte was a general retreat. What made it so
sensational was that not only had a host of former inmates testified that
"gassings" took place at concentration camps in the Reich, but several
commandants of these camps even signed "confessions" affirming the
existence of the alleged "gas chambers". At the Nuremberg IMT trial, the
British Chief Prosecutor Sir Hartley Shawcross specifically cited Dachau,
Buchenwald, Mauthausen, and Oranienburg as places where murder was
"conducted like some mass production industry in the gas chambers and
ovens".

        For a long time, Auschwitz and other camps that had existed in the
German-occupied eastern territories played a subordinate role in the
extermination legend. But after Dr. Martin Broszat, a leading member of the
Institut fur Zeitgeschichte, made the statement quoted above, the view that
any concentration camps in Germany were "death factories" became completely
untenable.

        However, the claim that some six million Jews had fallen victim to
the "Final Solution" was so vital to the interests of the inventors and
promoters of the extermination legend that they absolutely could not
abandon it. Not only was that charge a means of holding the German people
in political subjugation; it had also become a highly lucrative source of
income for international Jewry. The six million figure was the basis of the
"reparations" which the Federal Republic of Germany obligated itself to pay
to the "State of Israel" and individual Jews, beginning in the early 1950's
and continuing even today. For that reason alone, the six million figure,
about which certain writers had already expressed well-founded and earnest
doubts on other grounds, could not be abandoned, even after it was
established definitely that none of the camps in the German Reich proper
were "extermination camps".

        Thus the necessity of sticking to the six million figure led the
extermination mythologists to shift their emphasis from the camps in
Germany to the camps in German-occupied Poland. Auschwitz, undoubtedly the
largest camp complex, became the focal point of the extermination
allegation. Since the Poles had set themselves to the task of refashioning
part of the camp complex into an "Auschwitz Museum" -a move that also
signaled the Soviets would hold to the extermination legend, something
about which there had been some uncertainty after the IMT trial- the
extermination propagandists no longer had any reason for restraint.

        Although the Auschwitz propaganda campaign was aggressively pursued
from the very beginning, it still had a lot of catching up to do. To be
sure, "extermination camps" in occupied Poland had been mentioned in the
so-called Gerstein Report, a document allegedly composed by a onetime SS
man named Kurt Gerstein. At first, nobody seemed to take this document
seriously, and it was not even admitted in evidence at the IMT trial. At
least three versions of it were circulated: two French versions and one
German version. Numerous passages in these texts vary from one another.
According to the French version published in 1951, the following
"extermination camps" were in existence as of August 17, 1942:

   " 1) Belzec, on the Lublin-Lwow road. Maximum per day, 15,000 persons.
     2) Sobibor, I don't know exactly where it is, 20,000 persons a day.
     3) Treblinka, 120 Kilometers NNE of Warsaw.
     4) Maidanek, near Lublin (in preaparation). "



        One notes that the supposedly well-informed Gerstein does not
include Auschwitz in this list, though "mass murders" are now alleged to
have begun there in the spring of 1942. (The first "gas chamber" were, it
is claimed, two converted farm houses). Since, according to this document,
Gerstein was responsible for the procurement and distribution of Zyklon-B,
he certainly would have been aware of the existence of Auschwitz. As a
matter of fact, Auschwitz is mentioned as an "extermination camp" at the
end of the English version of the document -along with Theresienstadt,
Oranienburg, Dachau, Belsen, and Mauthausen!  This version of the "Gerstein
Report" (the one that appears in Dr. Butz's volume) was used by the
Americans in the "trials" they conducted on their own after the IMT
proceedings.

        As the years went on, Auschwitz by and large receded into the
background. A decade after the war, the public knew virtually nothing about
it. This may be attributed partly to the fact that the Soviets did not
permit outsiders to inspect the grounds of the Auschwitz complex. What is
more, none of the German and Austrian soldiers interned at Auschwitz, which
served for several months as a Soviet POW camp, found any traces of the
alleged mass murders, not even in Birkenau, supposedly the actual
extermination camp, or else did not report them after their release. Of
course, remnants of the crematoria were there to be seen, but the quantity
of rubble did not match what would have been left behind by crematoria of
the size required for the mass extermination of several thousand people per
day.

        One may well ask: If this allegation were true, why then did not
the Soviets immediately exhibit the camp to journalists from all over the
world and place the evidence of the alleged mass murders under
international control?  I shall leave it to the reader to answer this
question for himself. Even less comprehensible is the fact that the
majority of Germans offered virtually no resistance to the Auschwitz
propaganda campaign that began in the middle of the 1950's. They did not
ask why Auschwitz was suddenly being brought forward as the greatest
extermination camp of them all, a camp in which Jews were "gassed" by the
millions. Everyone seemed to have forgotten the old German proverb: Wer
einmal lugt, dem glaubt man nicht. ("Falsus in uno, falsus in omnibus".
Literally, "He who lies once is not to be believed twice").   Given the fact
that the falsehoods about Dachau, Bergen-Belsen, Buchenwald, and other
camps lasted hardly a decade, similar charges about Auschwitz should have
been regarded with the utmost suspicion.

        Of course, here one must take into account the fact that even today
many Germans are in the dark about how shamelessly they were deceived in
regard to the concentration camps in Reich territory. Countless Germans
still believe the lies they were told, for neither the government nor the
mass media gave Dr. Broszat's revealing admission the publicity it
deserved.

        However, that alone is not enough to explain the establishment and
entrenchment of the Auschwitz Myth. Not even the segment of our population
most familiar with the Dachau "gas chamber" hoax, for example, is immune to
the Auschwitz Myth. Anyone who follows the nationalist press knows that
even there "Auschwitz" is often used as a synonym for "genocide". In part,
this implicit endorsement of the Auschwitz Myth may be result of a
thoughtlessness that is in belief involved, as became clear to me from
discussions with editors of those publications. To support their position
they usually cited the findings of the first Frankfurt Auschwitz Trial.
Indeed, the actual reason for the widespread public acceptance of the
Auschwitz Myth may be that the decisions of German courts enjoy the
unlimited confidence of the German people. Despite many miscarriages of
justice, judicial authority and objectively are still considered above
suspicion. Whether this trust is justified when it comes to such blatantly
political trials as the so-called Frankfurt Auschwitz Trial is a question
that will arise many times in the course of our investigation. At this
point, it should be enough simply to note that it can never be the task of
the courts to pronounce the final verdict on historical matters, something
that certain groups consider the real purpose of the so-called "Nazi Crimes
of Violence Trials" ("NSG-Verfahren"), of which the Auschwitz Trial is the
prime example.

        Considering the importance of the Auschwitz Myth, and its strange
etiology, it is high time that the facts be systematically investigated and
scrutinized. To be sure, other writers -for example, Rassinier and Butz-
have brought many significants facts to light. However, since their studies
embraced the whole problem of the German concentration camps, their
treatment of Auschwitz was necessarily limited to the essentials, and could
do with some supplementation. Beyond that, I should like to treat the
Auschwitz Myth from a different point of view, as will become evident in
the following pages.
 