/* MOIRE6.C */


#include <stdio.h>      /* Standard input/output libraries */
#include <conio.h>      /* For kbhit */
#include <graph.h>      /* Microsoft graphics library */
#include <time.h>       /* Used in delays */

int speed=3;
int rate=47;
int shift=2 ;
int size=66;
int zoom=17 ;

char text[64];

void status(void);

int main(void)
{
   int a, i, j, k, x, y,   /* counters for looping */
	   cx, cy;	   /* x,y center of the screen */
   int flag=1;		   /* flag used to toggle status() function */
   int option;		   /* used by switch */

   time_t current_time, start_time; /* used for delay */

   _setvideomode(_MRES256COLOR);

   printf("\n\n\n\n\n\n\n\n               MOIRE6");
   printf("\n\n           Hit H for help");
   time(&start_time);               /* delay */
   do
		time(&current_time);
		while (current_time - start_time < 4);
		_clearscreen(_GCLEARSCREEN);

   /* drawing forwards */
   while(1)
   {
	  for (a = 0; a <10000000; a+=rate)         /* main loop */
	  {
		 for(k=0; k<zoom; k++)
		 {
			cx = 160; cy = 100;    /* set screen center */

			for (x = a, i = 0; i <=(size*(k+1))%90; x += a, i += speed)
			{
			    for (y = x, j = i; j <= size; y += a, j += speed)
			    {
				  if (kbhit())
				  {
					 option = getch();

					 switch(option)
					 {
					 case 'H':
					 case 'h':
					   _settextwindow(1,10,34,70);
					   _clearscreen(_GCLEARSCREEN);
					   sprintf(text, " H this help menu\n");
					   _outtext(text);
					   sprintf(text, " C clear the screen\n\n");
					   _outtext(text);
					   sprintf(text, " ) increase size\n");
					   _outtext(text);
					   sprintf(text, " ( decrease size\n\n");
					   _outtext(text);
					   sprintf(text, " + speed it up\n");
					   _outtext(text);
					   sprintf(text, " - slow it down\n\n");
					   _outtext(text);
					   sprintf(text, " ] increase zoom\n");
					   _outtext(text);
					   sprintf(text, " [ decrease zoom\n\n");
					   _outtext(text);
					   sprintf(text, " > increase shift\n");
					   _outtext(text);
					   sprintf(text, " < decrease shift\n\n");
					   _outtext(text);
					   sprintf(text, " D disable autolist \n");
					   _outtext(text);
					   sprintf(text, " E enable autolist \n\n");
					   _outtext(text);
					   sprintf(text, " L list parameters \n\n");
					   _outtext(text);
					   sprintf(text, " Q quit \n\n");
					   _outtext(text);
					   time(&start_time);
						 do
						   time(&current_time);
						   while (current_time - start_time < 8);
					   _clearscreen(_GCLEARSCREEN);
					   break;
					 case 'C':
					 case 'c':
					   _clearscreen(_GCLEARSCREEN);
					   break;
					 case 'E':
					 case 'e':
					   flag=1;
					   break;
					 case 'D':
					 case 'd':
					   flag=0;
					   break;
					 case 'L':
					 case 'l':
					   status();
					   break;
					 case '=':
					 case '+':
					   speed+=1;
					   if(flag)
						 status();
					   break;
					 case '_':
					 case '-':
					   if(speed >= 2)
						 speed-=1;
					   if(flag)
						 status();
					   break;
					 case ']':
					 case '}':
					   zoom+=1;
					   if(flag)
						 status();
					   break;
					 case '[':
					 case '{':
					   if(zoom >= 2)
						 zoom-=1;
					   if(flag)
						 status();
					   break;
					 case '.':
					 case '>':
					   if(shift<30)
						 shift+=1;
					   if(flag)
						 status();
					   break;
					 case ',':
					 case '<':
					   if(shift >= 2)
						 shift-=1;
					   if(flag)
						 status();
					   break;
					 case ')':
					 case '0':
					   size++;
					   if(flag)
						 status();
					   break;
					 case '(':
					 case '9':
					   if(size >= 3)
						  size--;
					   if(flag)
						 status();
					   break;
					 case 27:
					 case 'Q':
					 case 'q':
					   printf("BYE");
						time(&start_time);
						  do
							  time(&current_time);
						  while (current_time - start_time < 2);
					   _setvideomode(_DEFAULTMODE);   /* close down graphics */
					   return(0);

					 }
				  }
				  _setcolor((((long) x * x + (long) y * y)>> shift)  % 255);

				  _setpixel(cx + i - k, cy - j + k);
				  _setpixel(cx + j - k, cy - i + k);
				  _setpixel(cx + j - k, cy + i - k);
				  _setpixel(cx + i - k, cy + j - k);
				  _setpixel(cx - i + k, cy + j - k);
				  _setpixel(cx - j + k, cy + i - k);
				  _setpixel(cx - j + k, cy - i + k);
				  _setpixel(cx - i + k, cy - j + k);

			   }
			}
		 }

	  /* Drawing backwards */

		 for(k=0; k<zoom; k++)
		 {
			cx = 160; cy = 100;

			for (x = a, i = (size*(k+1))%90 ; i >=0; x += a, i -= speed)
			{
			   for (y = x, j = i; j >= 0; y += a, j -= speed)
			   {
				  _setcolor((((long) x * x + (long) y * y)>>shift)  % 255);

				  _setpixel(cx + i - k, cy + j - k);
				  _setpixel(cx + j - k, cy + i - k);
				  _setpixel(cx + j - k, cy - i + k);
				  _setpixel(cx + i - k, cy - j + k);
				  _setpixel(cx - i + k, cy - j + k);
				  _setpixel(cx - j + k, cy - i + k);
				  _setpixel(cx - j + k, cy + i - k);
				  _setpixel(cx - i + k, cy + j - k);

			   }
			}
		 }
	  }
   }
}

void status(void)
{
				 _settextwindow(2,1,10,9);
				 _clearscreen(_GWINDOW);
				 sprintf(text, "Size %d\n",size);
				 _outtext(text);
				 sprintf(text, "Sped %d\n",speed);
				 _outtext(text);
				 sprintf(text, "Zoom %d\n",zoom);
				 _outtext(text);
				 sprintf(text, "Shft %d\n",shift);
				 _outtext(text);

}
