@echo off
rem HUNT.Bat provided by Steven H. Lin, Ph.D., M.S.
echo Magazine filespec : %1
echo Inbound directory : %2
echo Display directory : %3
echo Archive directory : %4

echo - Scanning %2 for new %1 issue ...
if exist %2\%1.??? goto step1
goto end

:step1
  echo - Throw away old issue ...
  if exist %3\????????.art del %3\????????.art
  rem if exist %3\press.lmt del %3\press.lmt
  rem if exist %3\%1.??? del %3\%1.???

:step2
  echo - Flipping through %1.??? for bad pages (file defects) ...
  pkunzip -t %2\%1.???
  if errorlevel 51 goto error1
  if errorlevel 50 goto error2
  if errorlevel 11 goto error3
  if errorlevel 10 goto error4
  if errorlevel 9 goto error5
  if errorlevel 8 goto error6
  if errorlevel 7 goto error6
  if errorlevel 6 goto error6
  if errorlevel 5 goto error6
  if errorlevel 4 goto error6
  if errorlevel 3 goto error1
  if errorlevel 2 goto error1
  if errorlevel 1 goto error1
  goto step3

:step3
  echo - Copying %1.??? to %3 ...
  copy %2\%1.??? %3
  echo - Copying %1.??? to %4 ...
  copy %2\%1.??? %4
  echo - Deleting %1.??? from %2 ...
  del %2\%1.???

:step4
  echo - Unpacking new %1 issue ...
  pkunzip -o %3\%1.??? %3
  if errorlevel 51 goto error1
  if errorlevel 50 goto error2
  if errorlevel 11 goto error3
  if errorlevel 10 goto error4
  if errorlevel 9 goto error5
  if errorlevel 8 goto error6
  if errorlevel 7 goto error6
  if errorlevel 6 goto error6
  if errorlevel 5 goto error6
  if errorlevel 4 goto error6
  if errorlevel 3 goto error1
  if errorlevel 2 goto error1
  if errorlevel 1 goto error1
  goto end

:error6
  echo .
  echo INSUFFICIENT MEMORY!
  goto end

:error5
  echo .
  echo No file found!
  goto end

:error4
  echo .
  echo ERROR! Bad or illegal parms specified!
  goto end

:error3
  echo .
  echo ERROR! No files found!
  goto end

:error2
  echo .
  echo DISK FULL!
  goto end

:error1
  echo .
  echo ERROR! Check %1 magazine file for possible errors in archive!

:end
