{$M 5120,0,655360}
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}
{$DEFINE MLADD}

USES DOS;
{$I ML_INC.PAS}

VAR
  Total : WORD;
  NameList : ListLink;
  ParamIndex : BYTE;
  WorkFile : STRING;

  ListPath  : PATHSTR;    { List file path. }
  ListDir   : DIRSTR;     { List file dir.  }
  FileInfo : SEARCHREC;
  f : FILE;

BEGIN
  IF ParamCount < 1 THEN ExitOnError (1, 'Insufficient number of parameters.');
  NameList := NIL;
  Total := 0;

  IF NOT IsFile (ParamStr (1)) THEN  { Verify first param is valid file }
  BEGIN
    Assign (f, ParamStr (1));
    ReWrite (f);
    IF IOResult <> 0
      THEN ExitOnError (3, 'The "MasterList" file was not found.')
      ELSE EraseFile (ParamStr (1));  { Erase file for now }
  END;

  FOR ParamIndex := 1 to ParamCount DO
  BEGIN
    ListPath := GetFilePath (ParamStr (ParamIndex), ListDir);
    FindFirst (ListPath, Archive, FileInfo);

    WHILE DosError = 0 DO
    BEGIN
      AddToList (NameList, ListDir + FileInfo.Name, Total);
      WriteLn ('Total members now: ', Total);
      FindNext (FileInfo);
    END;
  END;

  EditList (NameList, Total);
  WriteLn ('Unique members: ', Total);

  WriteList (NameList, ParamStr (1), Total);
  WriteLn ('Finished consolidating lists.');
END.
