;---------------------------------------------------------------------------
;Proto types for MLPrint.ASM
;---------------------------------------------------------------------------
Seek            Proto Near, Handle1:Word, Pointer:Dword
OpenFile        Proto Near, FileName:Word, Attr:Word
Read            Proto Near, Handle2:Word, Buffer:Word, BufSize:Word
Write           Proto Near, Handle3:Word, Buffer:Word, BufSize:Word
Exist           Proto Near, FileSpec:Word
SetRawMode      Proto Near, Handle1:Word
Close           Proto Near, Handle4:Word
ClearPunct      Proto Near, SBuffer:Word, SBufSize:Word
GetString       Proto Near, StBuffer:Word, NumChars:Word, Row:Byte, Col:Byte, Mode:Byte
SetScreenString Proto Near, StBuffer:Word, NumChars:Word, Row:Byte, Col:Byte, Mode:Byte
DPrint          Proto Near
PrintZStr       Proto Near, StrAddr:Word, SColor:Word, AbsLoc:Word
CLS             Proto Near, LRow:Word, LCol:Word, RRow:Word, RCol:Word
PaintBar        Proto Near, AtrColr:Word, Numchars:Word
PrintZipBarcode Proto Near, ZipString:Word
FindZip Proto Near, AdrBuffer:Word, ZipBuffer:Word, MaxChars:Word
Num2Ascii       Proto Near, Num2Conv:Word, Buffer:Word
ZStrLen         Proto Near, Message:Word
MessageBox      Proto Near, Message:Word
LabelMenu       Proto Near, DefFlag:Word
CursorOff       Proto Near, CursorLoc:Word
CursorOn        Proto Near, CursorLoc:Word


;--- Macro support
StartMacro      Proto Near, IDNum:Word
FireMacro       Proto Near, IDNum:Word
EndMacro        Proto Near
SendIt          Proto Near, String2Prnt:Word
DeleteMacro     Proto Near

;---------------------------------------------------------------------------
;--- parameters
;---------------------------------------------------------------------------

Color        DW  31                    ;regular color
Hilite       DW  112                   ;highlight color
ErrColor     DW  78                    ;error Color
MonoColor    DW  7                     ;mono versions of colors
MonoErrCol   DW  31
;-----
;--- File and printing parameters
MFileBuff    DB  51 Dup (32)           ;start with spaces
LPTFile      DB  'LPT'
PrPortBuf    DB  '1',0                 ;zero to terminate for file open
UseDestFile  DB  'N'
DestFile     DB  51 Dup (32)
UsePostNet   DB  'N'
DPFlag       DB  'N'
LabelFlag    DB  'L'                   ;default L for labels, 1 for envelopes
ManualFeed   DB  'N'                   ;manual feed
NumTopFields DW  8
LoadFlag     DB  0

;-------- Envelopes ---------------------------------------------------------
RetAddrYN    DB  'N'                   ;return address
EnvCentered  DB  'Y'                   ;centered env feed
EnvSize      DB  '1'                   ;size

TopRowOff   DW     0                   ;top row offset for first number
TopBarRow   DW     0
LabelIndex  DW     0
RetAddrSave DB     240 Dup (20h)

SaveSize     DW   $ - Color            ;size of default file
DefaultFile  DB  'MLPRINT.CNF',0       ;default file name

;-----
ErrorNum     DW  0
BLoc         DW 1920                   ;location on the screen for lower menu
RTP          DW  ?
ScrnSeg      DW  ?

;--- File handles and variables
LFileHandle  DW  ?                     ;list file handle'
OFileHandle  DW  ?                     ;Output file handle
LFileSize    DD  ?                     ;size of list file

;;---------------------------------------------------------------------------
;Main menu screen locations
;---------------------------------------------------------------------------

;*** NOTE do not insert any data between this spot and the next note ***
;*** it is a table for the menus ***

;*** Start of Table1 ***

MlFileLC     DB  2,23,50,0,3           ;screen loc for file input
MfilePtr     DW  Offset MFileBuff      ;pointer to file name buffer

RlistFileLc  DB  3,23,1,0,2            ;mode 0 alpha numeric
RLfilePtr    DW  UseDestFile           ;pointer to dest file flag

DestFileLoc  DB  4,23,50,0,3           ;screen loc for destfile
RListPtr     DW  DestFile              ;pointer to Rlist file buffer

PrPort       DB  5,23,1,0,1            ;mode 1 = numeric
PrPortPtr    DW  PrPortBuf             ;pointer to printer variable

PostNCode    DB  6,23,1,0,2            ;Yes/no
PostPtr      DW  UsePostNet            ;pointer to postnet flag

DPLabels     DB  6,57,1,0,2            ;Delivery Point Y/N
DPPtr        DW  DPFlag                ;pointer to Delivery Point flag

ManFeedLoc   DB  7,23,1,0,2            ;manual feed  Y/N
ManFeedPtr   DW  ManualFeed            ;

PLabels      DB  7,57,1,0,4            ;Labels Envelopes
LabelPtr     DW  LabelFlag             ;pointer to label flag

Terminator   DB  0                     ;end field marker

;*** End of Table1 ***

TestPrint    DB  0                     ;test print flag

MainMnu  DB 'Ĵ Mailing List Printer Ŀ'
         DB '                                                                              '
         DB '   Mailing List File:                                                         '
         DB '   Redirect to File?: N                                                       '
         DB '    Destination File:                                                         '
         DB '        Printer Port: 1                                                       '
         DB ' PostNet Codes?(Y/N): Y       Use Delivery Point (Y/N): N                     '
         DB '   Manual Feed?(Y/N): N       <L>abels - <E>nvelopes  : L                     '
         DB '                                                                              '
         DB 'Ĵ'
         DB '     ESC to Quit       F1 for Help      F2 test print       F10 to Print      '
         DB '',0

Copyrite DB 'Ŀ'
         DB 'Copyright (c) 1992 Jay Munro  First Published PC Magazine December 15, 1992',0


EnvMenu  DB '                                                                                '
         DB ' Return Address? Y/N    : N         Return Address :                            '
         DB ' Centered Envelopes? Y/N: Y         >                                         < '
         DB '                                    >                                         < '
         DB ' Envelope Size:                     >                                         < '
         DB ' 1. Personal 3-5/8 x 6-1/2          >                                         < '
         DB ' 2. #80 3-7/8 x 7-1/2 Letter        >                                         < '
         DB ' 3. #10 4-1/8 x 9-1/2  Business     >                                         < '
         DB ' 4. #90 International 110mm x 220mm                                             '
         DB ' 5. #91 International 162mm x 229mm                                             '
         DB '                                                                                ',0

;*** Note: Do not insert anything in this table until next *** note
;*** Start of Table2 ***

BackTotop2   DB  -1,0,0,0,0,0,0
EnvScrLoc    DB  13,26,1,0,2           ;return address (Y/N)
RetAdrPtr    DW  Offset RetAddrYN      ;pointer to var

RetLabel1    DB  14,38,40,0,0          ;
RetLabel1Adr DW  EnvMenu+198           ;RetAddr1
RetLabel2    DB  15,38,40,0,0          ;
RetLabel2Adr DW  EnvMenu+278           ;RetAddr1
RetLabel3    DB  16,38,40,0,0          ;
RetLabel3Adr DW  EnvMenu+358           ;RetAddr1
RetLabel4    DB  17,38,40,0,0          ;
RetLabel4Adr DW  EnvMenu+438           ;RetAddr1
RetLabel5    DB  18,38,40,0,0          ;
RetLabel5adr DW  EnvMenu+518           ;RetAddr1
RetLabel6    DB  19,38,40,0,0          ;
RetLabel6Adr DW  EnvMenu+598           ;RetAddr1

;--- screen locations
;Syntax      [row],[col],[len DW],[Mode],flag, Buff Addr

CenterEnvLoc DB  14,26,1,0,2           ;is envelope centered
CentEnvPtr   DW  Offset EnvCentered    ;pointer to var

EnvSizeLoc   DB  16,17,1,0,1           ;envelope size
EnvSizePtr   DW  EnvSize               ;pointer to var


;-------- Labels ------------------------------------------------------------
BackTotop    DB  -1,0,0,0,0,0,0
LabelScrLoc  DB  -1   ;12,22,1,0,1            ;screen loc for # of labels
EndOfLine2   DB  -1

;*** End Of Table2 ***

;---------------------------------------------------------------------------
; Macro data
;---------------------------------------------------------------------------
Number       DB  '0123456789',0
EndIt        DB  0,0

Zero         DB  11000b
One          DB  00011b
Two          DB  00101b
Three        DB  00110b
Four         DB  01001b
Five         DB  01010b
Six          DB  01100b
Seven        DB  10001b
Eight        DB  10010b
Nine         DB  10100b

FirstBar     DB 27,'*c5a6g40b0P',0
Space        DB 27,'*p+14X',0
TallCodes    DB 27,'*c40b0P',0
Shortcodes   DB 27,'*p+22Y',27,'*c18b0P',27,'*p-22Y',0
Reset        DB 27,'E',0

BackUpForZip DB 27,'*p-35Y',0

PageOut      DB 13,10,12,0
CheckDig     DB 0,0
MacroCounter DW 0

IDSetCode  DB  27,'&f'
    IDCode DB  '00Y',0

MacStart   DB  27,'&f0X',0             ;start macro, last ID spec'd
MacEnd     DB  27,'&f1X',0             ;end macro
MacFire    DB  27,'&f2X',0             ;execute macro, last ID Spec'd
ClearAll   DB  27,'&f6X',0             ;deletes all macros

;---------------------------------------------------------------------------
;---Label Menu data
;---------------------------------------------------------------------------
MenuWidth    DW 76

MenuHead  DB ' AVERY              Hewlett Packard                SIZE        Row x Col',0 
MenuData  DB '5160/5260               92296A                  2 5/8" x 1"       3x10',0
          DB '5161/5261               92296C                  4" x 1"           2x10',0
          DB '5162/5252               92296B                  4" x 1 1/3"       2x7',0
          DB '5163                    92296D                  4" x 2"           2x5',0
          DB '5164                    92296E                  4" x 3 1/3"       2x3',0
          DB '5196  3" disk           92296H                  2 3/4" x 2 3/4"   3x3',0
          DB '5197  5" disk           92296J                  4" x 1 1/2"       2x6',0
          DB '5660 clear                                      2 5/6" x 1"       3x10',0
          DB '5662 clear                                      4 1/4" x 1 1/3"   2x7',0
          DB '5663 clear                                      4 1/4" x 2"       2x5',0
          DB 0,0 

LMenuLoc   DW     1760                 ;menu starting location
NextRow    DW     160                  ;value to bump up or down on menu

;---------------------------------------------------------------------------
; File input buffer variables
;---------------------------------------------------------------------------

FileInBuffer DB  800h Dup (0)          ;pull in 4 sector's worth
FIBufferSz   DW  800h                  ;keep track of buffer size

TotalFileSz  DD  ?                     ;total file size

AddressBuffer   DB 800h Dup (20)       ;up to 32 lines of address buffer
AddressSize     DW 800h                ;size of address buffer

CurBufPtr       DW 0                   ;current buffer pointer
CurFilePtr      DD 0                   ;current file pointer
LineCount       DB 0                   ;linecounter
LSize           DW 0

;---------------------------------------------------------------------------
ZipString   DB  14  Dup (20h)
PageFeed    DB  12                     ;page feed
CRLF        DW  0D0Ah                  ;carriage return/line feed
;---------------------------------------------------------------------------
AutoFeed   DB  27,'&l1H'
ManFeed    DB  27,'&l2H'
EnvFeed    DB  27,'&l3H'

Portrait   DB  27,'&l0O'
Landscape  DB  27,'&l1O'
ZeroZero   DB  27,'&a0C'

;-- Standard centered envelopes
Personal DB 27,'&l16E',27,'&a45L',27,'&a45c1R' ;3 5/8 x 6 1/2  ;total len 18
    Adr1 DB 27,'&a70l10R'              ;total len 8

Monarch  DB 27,'&l15E',27,'&a24L',27,'&a24c1R' ;3 7/8 x 7 1/2  ;total len 18
    Adr2 DB 27,'&a60l10R'              ;total len 8

Number10 DB 27,'&l15E',27,'&a16L',27,'&a16c1R' ;4 1/8 x 9 1/2
    Adr3 DB 27,'&a50l10R'

DLenv    DB 27,'&l12E',27,'&a20L',27,'&a20c1R' ;4.33 x 8.66 inch
    Adr4 DB 27,'&a50l09R'

C5env    DB 27,'&l10E',27,'&a19L',27,'&a19c1R' ;6.37 x 9.01 inch
    Adr5 DB 27,'&a50l09R'
TotalLen DW $ - C5Env

FirstLen   DW  Adr1 - Personal
SecondLen  DW  TotalLen - Adr5

Personal1 DB 27,'&l01E',27,'&a45L',27,'&a45c1R' ;3 5/8 x 6 1/2  ;total len 18
    Adr1a DB 27,'&a70l10R'             ;total len 8

Monarch1  DB 27,'&l01E',27,'&a24L',27,'&a24c1R' ;3 7/8 x 7 1/2
    Adr2a DB 27,'&a60l10R'

Number101 DB 27,'&l01E',27,'&a16L',27,'&a16c1R' ;4 1/8 x 9 1/2
    Adr3a DB 27,'&a50l10R'

DLenv1    DB 27,'&l01E',27,'&a20L',27,'&a20c1R' ;4.33 x 8.66 inch
    Adr4a DB 27,'&a50l09R'

C5env1    DB 27,'&l01E',27,'&a19L',27,'&a19c1R' ;6.37 x 9.01 inch
    Adr5a DB 27,'&a50l09R'

CenterJump DW Personal1 - Personal

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;                                     LS - 1
;Avery Labels              Top   Left   H        W   Max
;             #Across #down Marg Side  Height Width Height
    A5160  DW     3,     10, 200,   1,  300,     27,  6
    A5161  DW     2,     10, 200,   1,  300,     41,  6
    A5162  DW     2,      7, 300,   1,  400,     41,  8
    A5163  DW     2,      5, 200,   1,  600,     41, 12
    A5164  DW     2,      3, 200,   1, 1000,     41, 20
    A5196  DW     3,      3, 200,   1,  825,     26, 14
    A5197  DW     2,      6, 350,   1,  450,     41,  9
    A5660  DW     3,     10, 200,   0,  300,     28,  6
    A5662  DW     2,      7, 300,   0,  400,     42,  8
    A5663  DW     2,      5, 200,   0,  600,     42,  12
    AVLen  DW   $ - A5663              ;get the length of one list of data

;---- Error trapping variables
    OldInt24IP    DW       ?
    OldInt24CS    DW       ?
    DOSErrCode    DW       ?
    CritErrFlag   DW       ?

    PushCur   DB 27,'&f0S'
    PopCur    DB 27,'&f1S'

    LineSpace6 DB 27,'&l6D'
    PerfSkip   DB 27,'&l0L'
    TopMargin  DB 27,'&a0R'

;---- Error messages
FileNotFound DB 'File Not Found',0
PathNotFound DB 'Path Not Found',0
AccessDenied DB 'Access Denied',0
UnKnownError DB 'Unknown Error',0
DiskNotReady DB 'Disk Not Ready',0
OutOfPaper   DB 'Printer Out Of Paper',0

HelpScrn DB '͵ MLPrint Help ͻ'
         DB '                                                                              '
         DB '  Mailing List File - ASCII Text file with Names and Addresses in the format  '
         DB '                            Name                                              '
         DB '                            Address1                                          '
         DB '                            Address2                                          '
         DB '                            City   State   Zip+4                              '
         DB '                            <CRLF>                                            '
         DB '                                                                              '
         DB '  Addresses must be separated by a blank line.                                '
         DB '                                                                              '
         DB '  Redirect to File? - MLPrint prints envelopes or label commands              '
         DB '                      to the file specified by Destination File Field.        '
         DB '                                                                              '
         DB '  PostNet Codes - MLPrint will derives 5 or 9 PostNet Barcodes from           '
         DB '                  Zip Code on last line of address label.                     '
         DB '                                                                              '
         DB '  Use Delivery Point - MLPrint will attempt to create a 2 digit Delivery      '
         DB '                  Point code to add to the 9 digit Barcode only.              '
         DB '                                                                              '
         DB '  Manual Feed - Printer will wait for manually fed envelope or label sheet.   '
         DB '                                                                              '
         DB '  While Printing, any key to pause.  Press ESC to quit, or other key to       '
         DB '                                continue.                                     '
         DB 'ͼ',0


ScrnBuffer  DB  4000 Dup (?)            ;buffer to save screen in
ScrnBufLen  DW  $ - ScrnBuffer
BoxStart    DW  1600                   ;row 10
ScrnMsgAddr DW  2000                   ;center of message area

DblLine  DB 'ͻ'
         DB '                                                                              '
         DB '                                                                              '
         DB '                                                                              '
         DB '͵ Press Any Key to Continue --- ESC to Quit ͼ',0

WaitMsg  DB 'Printing Paused',0

FirstCRLF DW 0
Zipcount  DB 0

Across    DW  0
Down      DW  0
TopMarg   DW  0
LeftSide  DW  0
LHeight   DW  0
LWidth    DW  0
LMax      DW  0

SAcross   DW  0
SDown     DW  0

LocBuffer DB 27,'9',27,'&l0E',27,'&a'
  Infobuf DB 24 Dup (0)              ;build margin instructions in here.
SheetDone DB 0

DTA       DB  128 Dup (0)

PrintMsg     DB 'Printing',0
PrintMsgLoc  DW 1346
