/* packetec.c -- old packet based protocol */
static char rcsid[] = "$Id: packetec.c 1.7 1995/04/23 04:32:32 Ezra_Story Exp $";

#define INC_SYS

#include "defs.h"

export VOID PacketECInit P((VOID));
export VOID PacketECDeinit P((VOID));
export int PacketECIn P((ubyte *, int, ubyte *));
export int PacketECOut P((Fifo, ubyte *));

/* internal packet structure */
struct packet
{
    ulong   timeout;
    int     len;
    ubyte   *data;
    int     memlen;
};

/* constants */
#define SOP     'C'
#define ACK     '<'
#define MAXPAK  32
#define HEADSZ  3
#define TAILSZ  1
#define CRAPSZ  (HEADSZ+TAILSZ)       /* bytes of extra packet crap */

/* redefinable constants */
local int       delayWindow;
export int       packetTO;        /* export this for dynamic change */
export int      maxPacketSize;

/* state variables */
local int       incount;
local int       nextin;
local int       nextout;

/* current input packet stuff */
local ubyte     packetType;
local int       packetLen;
local int       packetChk;
local ubyte     packetNum;
local ubyte     *packetData;

/* packet IO lists */
local struct packet     packetsIn[32];
local struct packet     packetsOut[32];

/* outgoing ack list */
local ubyte     ackOut[64];
local int       ackOutSize;

VOID
PacketECInit(VOID)
{
    int x;

    for (x=0;x<32;x++)
    {
        packetsIn[x].len = 0;
        packetsIn[x].data = 0;
        packetsIn[x].memlen = 0;
        packetsOut[x].len = 0;
        packetsOut[x].data = 0;
        packetsOut[x].memlen = 0;
    }
    ackOutSize = 0;
    incount = 0;
    nextin = nextout = 0;

    delayWindow = 16;
    packetTO = 10;
    maxPacketSize = 2047;
}

VOID
PacketECDeinit(VOID)
{
    int x;

    for (x=0;x<32;x++)
    {
        if (packetsIn[x].memlen)
            free(packetsIn[x].data);
        if (packetsOut[x].memlen)
            free(packetsOut[x].data);
    }
}

/*
 * Build output packets from output fifo.  Also does reciever
 * Acks and old timed old packets.
 */
int
PacketECOut(f, ob)
Fifo f;
ubyte *ob;
{
    ubyte *oob = ob;
    ulong currtime;
    struct timeval tv;
    int x, y, olddist;

    Gettimeofday(&tv);
    currtime = tv.tv_sec;

    /* Output acks queued by PacketECIn() */
    if (ackOutSize)
    {
        bcopy(ackOut, ob, ackOutSize);
        ob += ackOutSize;
        ackOutSize = 0;
    }

    /* calc dist to oldest packet */
    olddist = 1;
    for (x = (nextout+1)&31; (x!=nextout)&&(packetsOut[x].len==0); x=(x+1)&31)
        olddist++;


    /*
     * Output new packets only if the oldest unacked packet trails
     * behind within the given window size.
     */
    while((x=AmountInFifo(f, FIFO_ALL)) && (olddist >= (32-delayWindow)))
    {
        x = MIN(x, maxPacketSize) + CRAPSZ;
        if ((packetsOut[nextout].memlen < x) ||
            ((packetsOut[nextout].memlen - x) > 1024))
        {
            packetsOut[nextout].memlen = x;
            if (packetsOut[nextout].data)
                free(packetsOut[nextout].data);
            packetsOut[nextout].data = malloc(x);
        }
        packetsOut[nextout].data[0] = SOP;
        packetsOut[nextout].data[1] = (nextout << 3) + ((x-CRAPSZ) >> 8);
        packetsOut[nextout].data[2] = (x-CRAPSZ) & 0xff;
        ReadFifo(f, packetsOut[nextout].data+HEADSZ, x-CRAPSZ, FIFO_ALL);
        packetsOut[nextout].len = x;
        for(y=0,x-=(TAILSZ+1); x>=HEADSZ; x--)
            y = (y + packetsOut[nextout].data[x]) & 0xff;
        packetsOut[nextout].data[packetsOut[nextout].len-1] = y;
        bcopy(packetsOut[nextout].data, ob, packetsOut[nextout].len);
        ob += packetsOut[nextout].len;
        packetsOut[nextout].timeout = currtime + packetTO;
        olddist--;
        nextout = (nextout + 1) & 31;
    }

    /* output timed out packets */
    for(x=(nextout+1)&31; x!=nextout; x=(x+1)&31)
    {
        if (packetsOut[x].len && (packetsOut[x].timeout < currtime))
        {
            bcopy(packetsOut[x].data, ob, packetsOut[x].len);
            ob += packetsOut[x].len;
            packetsOut[x].timeout = currtime + packetTO;
        }
    }

    return(ob - oob);
}


/*
 * Returns the amount of time until the packet routines
 * need to send. 0 or negative time means it wants to send
 * now.
 */
int
PacketECTimeout(VOID)
{
    int x, z;
    int minto = 100;   /* 100 secs sounds like a nice LARGE amount :-) */
    struct timeval tv;
    ulong currtime;


    if (ackOutSize)
        return(0);

    Gettimeofday(&tv);
    currtime = tv.tv_sec;

    for(x=(nextout+1)&31; x!=nextout; x=(x+1)&31)
    {
        if (packetsOut[x].len)
            {
            z = packetsOut[x].timeout - currtime;
            minto = MIN(z, minto);
            }
    }
    return(minto);
}


/*
 * Queue incoming packets and add them to the input buffer.  Save
 * Acks for output for packetecout().
 */
int
PacketECIn(ib, len, ob)
ubyte *ib, *ob;
int len;
{
    int x;
    ubyte *oob = ob;
    ubyte c;
    static int breakcount = 0;

    for (; len>0; len--)
    {
        c = *ib++;
        switch (incount)
        {
        case 0:  /* waiting for protocol markers */
            if ((c == SOP)||(c == ACK))
            {
                packetType = c;
                incount++;
            }
            else if (c == '@')
            {
                if (++breakcount > 5)
                    done();
            }
            else
                breakcount = 0;

            break;

        case 1:  /* process header */
            packetNum = c >> 3;
            switch (packetType)
            {
            case SOP:
                packetLen = c;

                /* get distance from current pos to received packet */
                if ((x = packetNum - nextin) < 0)
                    x += 32;

                /*
                 * Accept packet if its within the window, and its not
                 * already been received.
                 */
                if ((x < delayWindow) && (packetsIn[packetNum].len == 0))
                    incount++;
                else
                    incount = 11;
                break;

            case ACK:
                if (((c & 7) == (packetNum & 7)) && packetsOut[packetNum].len)
                {
                    packetsOut[packetNum].len = 0;
                }
                incount = 0;
                break;

            default:
                incount = 0;
                break;
            }
            break;

        case 2:  /* set up to read a packet in */
            packetLen = (packetLen & 0x7) << 8;
            packetLen += c;
            if (packetLen == 0)
            {
                incount = 0;
                break;
            }
            packetsIn[packetNum].len = packetLen;
            if ((packetsIn[packetNum].memlen < packetLen) ||
                ((packetsIn[packetNum].memlen - packetLen) > 1024))
            {
                packetsIn[packetNum].memlen = packetLen;
                if (packetsIn[packetNum].data)
                    free(packetsIn[packetNum].data);
                packetsIn[packetNum].data = malloc(packetLen);
            }
            packetChk = 0;
            packetData = packetsIn[packetNum].data;
            incount++;
            break;

        case 11:
            packetLen = (packetLen & 0x7) << 8;
            packetLen += c;
            if (packetLen == 0)
            {
                incount = 0;
                break;
            }
            packetChk = 0;
            incount++;
            break;

        case 12:  /* special case, discards a packet */
            packetLen--;
            if (packetLen < 0)
            {
                if (packetChk == c)
                {
                    ackOut[ackOutSize++] = ACK;
                    ackOut[ackOutSize++] = ((packetNum << 3) + (packetNum & 7)) & 0xff;
                }
                incount = 0;
            }
            packetChk = (packetChk + c) & 0xff;
            break;


        default:  /* reading packet */
            packetLen--;
            if (packetLen < 0)
            {
                if (packetChk == c)
                {
                    ackOut[ackOutSize++] = ACK;
                    ackOut[ackOutSize++] = ((packetNum << 3) + (packetNum & 7)) & 0xff;
                    while(packetsIn[nextin].len)
                    {
                        bcopy(packetsIn[nextin].data, ob, packetsIn[nextin].len);
                        ob += packetsIn[nextin].len;
                        packetsIn[nextin].len = 0;
                        nextin = (nextin + 1) & 31;
                    }
                }
                else
                {
                    packetsIn[packetNum].len = 0;
                }
                incount = 0;
            }
            else
            {
                packetChk = (packetChk + c) & 0xff;
                *packetData++ = c;
            }
            break;
        }
    }

    return(ob - oob);
}
