/*
 *      m_openpty - open a pseudo-terminal
 *
 */
static char rcsid[] = "$Id: openpty.c 1.12 1995/03/26 21:22:18 Ezra_Story Exp $";

#define INC_SYS
#define iNC_STRING
#define INC_TTY
#define INC_IOCTL
#define INC_SIGNAL
#define INC_ERRNO

#include "defs.h"


struct ptydesc {
        int             pt_pfd;         /* file descriptor of master side */
        int             pt_tfd;         /* file descriptor of slave side */
        char            *pt_tname;      /* slave device name */
};

export int  m_forkpty P((VOID));

local  int  m_openpty P((struct ptydesc *));

/*
 * OS/F has prebuilt openpty/forkpty routines. aww,
 * how sweet (bastards :-P).
 */
#ifdef PTY_OSF
int
m_openpty(pt)
struct ptydesc *pt;
{
    int x;
    void (*savesig)(int);

    savesig = signal(SIGCHLD, SIG_DFL);
    x = openpty(&pt->pt_pfd, &pt->pt_tfd, NULL, NULL, NULL);
    signal(SIGCHLD, savesig);

    if (x == 0)
        pt->pt_tname = ttyname(pt->pt_tfd);

    return(x);
}
#endif

/*
 * AIX's /dev/ptc
 */
#ifdef PTY_AIX
int
m_openpty(pt)
struct ptydesc *pt;
{
    if ((pt->pt_pfd = open("/dev/ptc", O_RDWR|O_NDELAY)) >= 0)
        {
        pt->pt_tname = (char *)ttyname(pt->pt_pfd);
        if ((pt->pt_tfd = open(pt->pt_tname, O_RDWR)) >= 0)
            return(pt->pt_tfd);
        }

    return(-1);
}
#endif

/*
 * Systems that use _getpty() to grab pty's
 */
#ifdef PTY_GETPTY
int
m_openpty(pt)
struct ptydesc *pt;
{
    char *line;

    line = _getpty(&pt->pt_pfd, O_RDWR|O_NDELAY, 0600,0);
    if (line == 0) return(-1);
    if ((pt->pt_tfd = open(line,O_RDWR)) < 0)
        {
        (void)close(pt->pt_pfd);
        return(-1);
        }
    pt->pt_tname = line;
    return(0);
}
#endif


/*
 * System V's standard pty mechanism. (/dev/ptmx)
 */
#ifdef PTY_SYSV
int
m_openpty(pt)
struct ptydesc *pt;
{
  void (*savesig)(int);

    if ((pt->pt_pfd = open("/dev/ptmx", O_RDWR)) == -1) return (-1);
    savesig = signal(SIGCHLD, SIG_DFL);

    if ((pt->pt_tname = ptsname(pt->pt_pfd)) == NULL || unlockpt(pt->pt_pfd) || grantpt(pt->pt_pfd))
        {
        signal(SIGCHLD, savesig);
        close(pt->pt_pfd);
        return (-1);
        }

    signal(SIGCHLD, savesig);

#ifdef CF_TCFLUSH
    tcflush(pt->pt_pfd, TIOCFLUSH);
#else
#ifdef TIOCFLUSH
    (void)ioctl(pt->pt_pfd, TIOCFLUSH, (char *) 0);
#endif
#endif

    if ((pt->pt_tfd = open(pt->pt_tname,O_RDWR)) < 0)
        {
        close (pt->pt_pfd);
        return (-1);
        }

#ifdef SVR4
    ioctl(pt->pt_tfd, I_PUSH, "ptem");
    ioctl(pt->pt_tfd, I_PUSH, "ldterm");
    ioctl(pt->pt_tfd, I_PUSH, "ttcompat");
#endif

    return(0);
}
#endif


/*
 * Uses a straight search algorithm.
 */
#ifdef PTY_SEARCH
#ifdef __hpux
static  char masterline[]="/dev/ptym/ptyXY";
static  char slaveline[]="/dev/pty/ttyXY";
static  char *first ="pqrstuv";
#else                           /*  not hpux. */
static  char masterline[]="/dev/ptyXY";
static  char *first ="pqrstuvwxyz";
static  char slaveline[]="/dev/ttyXY";
#endif
#define SFIRST  (sizeof (slaveline) - 3)
#define SSECOND (sizeof (slaveline) - 2)
#define MFIRST  (sizeof (masterline) - 3)
#define MSECOND (sizeof (masterline) - 2)
static  char ptyarray[] = "0123456789abcdef";
int
m_openpty(pt)
struct ptydesc *pt;
{
  char *ptr;
  int  i,c,pgrp;
  struct stat statbuff;

  /* loop through all possible combinations */
  ptr = first;
  for (c = *ptr; (c = *ptr); ++ptr)
    {
    masterline[MFIRST] = c;
    masterline[MSECOND] = '0';

    /* no pty's on this bank /dev/ptyX0? */
    if (stat (masterline, &statbuff) < 0) continue;

    /* try to find an openable master pty */
    for (i = 0; i < 16; ++i)
        {
        masterline[MSECOND] = ptyarray[i];
        if ((pt->pt_pfd = open (masterline, O_RDWR, 0)) > 0) break;
#ifdef sun
        if ((ioctl(pt->pt_pfd, TIOCGPGRP, &pgrp) != -1) || errno != EIO)
            {
            close(pt->pt_pfd);
            continue;
            }
#endif
        }

    /* if we found one check the slaves */
    if (i != 16)
        {
        slaveline[SFIRST] = masterline[MFIRST];
        slaveline[SSECOND] = masterline[MSECOND];

        /* can we open it? */
        if ((pt->pt_tfd = open (slaveline, O_RDWR, 0)) < 0)
            {
            close(pt->pt_pfd);
            continue;
            }

    /* hack to check for used sun ptys */
        break;
        }

    }

    if (c==0) return(-1);
    pt->pt_tname = slaveline;

    return(0);
}
#endif




/*
 * Starts up a shell in a pty, and returns the master
 * descriptor.
 */
int
m_forkpty(VOID)
{
    struct ptydesc pt;
    int            pipd[2];
    int            datafd,fd;
    int            pr,pid;
    char           *shell,*sh2,*home;
#ifdef SYSV
    void (*savesig)(int);
#endif

    if (m_openpty(&pt) == -1) return(-1);

    datafd = pt.pt_pfd;

#ifdef SYSV
    savesig = signal(SIGCLD, SIG_DFL);
#endif

    /* use pipes to pause the parent until
     * the child finishes.  Otherwise, we
     * just sleep.
     */
    if (pipe(pipd) < 0)
        {
        pipd[0] = -1;
        pipd[1] = -1;
        }

    while ((pid = fork()) < 0) sleep(5);
    if (!pid)
        {
        /* this is the pty process */

        /* reset signals to defaults */
        (void)signal(SIGHUP, SIG_DFL);
        (void)signal(SIGINT, SIG_DFL);
        (void)signal(SIGQUIT, SIG_DFL);
        (void)signal(SIGTERM, SIG_DFL);
        (void)signal(SIGTSTP, SIG_IGN);
        (void)signal(SIGCHLD, SIG_DFL);

        /* Set the user/group ids of process */
        (void)setuid(getuid());
        (void)setgid(getgid());

        /* create new session & make us leader
         * this also dumps out controlling tty
         */
#ifdef CF_SETSID
        setsid();
#else
#ifdef SYSV
        setpgrp();
#else
#ifndef TIOCNOTTY
#define TIOCNOTTY (_IO('t', 113))
#endif
        (void)ioctl(fd = open("/dev/tty",O_RDWR,0),(int)TIOCNOTTY, (char *)0);
        close(fd);
#endif
#endif

        /* close all the shared fd's except for the slave pty */
        for (fd=0; fd < FD_SETSIZE; fd++)
            if (fd != pt.pt_tfd && fd != pipd[0] && fd != pipd[1])
                (void)close(fd);

        /* open our own copy of slave pty and
         * discard the that our parent opened.
         * on some systems, this will also set the
         * controlling terminal (first open)
         */
        fd = open(pt.pt_tname, O_RDWR);
        (void)close(pt.pt_tfd);

        /* create stdin/out/err
         * if caller to forkpty had none of these,
         * the pipes could be here, oh well...
         * we'll just have to make sure 0,1,2
         * exist before calling forkpty.
         */
        if (fd != 0) (void)dup2(fd, 0);
        if (fd != 1) (void)dup2(fd, 1);
        if (fd != 2) (void)dup2(fd, 2);

        /* Set the controlling terminal (for some)
         */
#ifdef TIOCSCTTY
        ioctl(fd, TIOCSCTTY, (char *)0);
#endif
        /* Set us as foreground on the controlling terminal
         */
        pr = getpid();
#ifdef TIOCSPGRP
        ioctl(fd, TIOCSPGRP, (char *)&pr);
#else
        tcsetpgrp(fd, pr);
#endif

        /* Get rid of remnants */
        if (fd > 2) (void)close(fd);

        /* set to normal tty parameters */
        TtyRestore();

        /* get shell */
        if (!(shell = getenv("SHELL"))) shell = "/bin/sh";
        for(sh2=shell+strlen(shell); (*sh2 != '/')&&(sh2 != shell); sh2--);
        if (*sh2 == '/') sh2++;

        /* chdir to $HOME */
        if (home = getenv("HOME"))
            chdir(home);

#ifdef CF_PUTENV
        putenv("MLINK=1");
#else
#ifdef CF_SETENV
        setenv("MLINK","1",1);
#endif
#endif
        /* tell the parent */
        if (pipd[0] != -1)
        {
            write(pipd[1],(char *)pipd,1);
            close(pipd[0]);
            close(pipd[1]);
        }

        /* do it! */
        execl(shell, sh2, (char *)0);
        exit(1);
        }
#ifdef SYSV
    signal(SIGCLD, savesig);
#endif

    /* synchronize */
    if (pipd[0] == -1)
        sleep(2);
    else
    {
        read(pipd[0], (char *)(pipd+1), 1);
        close(pipd[0]);
        close(pipd[1]);
    }

    /* parent.. just close slave side for us */
    (void)close(pt.pt_tfd);

    /* set nonblocking IO */
    NONBLOCK(datafd);
    return(datafd);
}

