/* lists.h
 *
 * Exec list support
 *
 * Copyright (c) 1993 by Ezra Story.  All rights reserved.  Permission to
 * copy this program is given provided that the copy is not sold and that
 * this copyright notice is included.
 * $Id: lists.h 1.6 1994/07/14 23:29:31 Ezra_Story Exp $
 *
 */

typedef struct Node
{
    struct Node *Succ;      /* Pointer to next (successor) */
    struct Node *Pred;      /* Pointer to previous (predecessor) */
    char Pri;       /* Priority, for sorting */
} node;

typedef struct List
{
   struct Node *Head;
   struct Node *Tail;
   struct Node *TailPred;
} list;

#define LIST list
#define NODE node

#define IsListEmpty(x) ( ((x)->TailPred) == (NODE *)(x) )

extern  void    NewList P((LIST *));
extern  void    AddTail P((LIST *, NODE *));
extern  void    AddHead P((LIST *, NODE *));
extern  void    Insert P((LIST *, NODE *, NODE *));
extern  NODE    *RemHead P((LIST *));
extern  NODE    *RemTail P((LIST *));
extern  void    Remove P((NODE *));
extern  void    Enqueue P((LIST *, NODE *));

