/* includes.h -- an easier way to track unix's confusing includes */
/* $Id: includes.h 1.16 1995/04/22 19:40:25 Ezra_Story Exp $ */
/*
    INC_SYS         if using unix types
    INC_STRING      if using string library
    INC_TTY         if using termio or sgtty
    INC_SOCKET      if using bsd socket api
    INC_ERRNO       if using errno
    INC_IOCTL       if using ioctl/fcntl type calls
    INC_SIGNAL      if using signals
    INC_PWD         if using pwent
*/


#ifdef INC_SYS
#ifndef CF_NOUNISTD
#include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <sys/time.h>
#include <sys/resource.h>
#ifdef CF_SYSSELECT
#include <sys/select.h>
#endif
#ifdef SVR4
#define Gettimeofday(x) gettimeofday(x)
#else
#define Gettimeofday(x) gettimeofday(x, 0)
#endif
#endif

#ifdef INC_IOCTL
#include <fcntl.h>
#include <sys/ioctl.h>
#ifdef SYSV
#ifndef CF_NOFILIO
#include <sys/filio.h>
#endif
#endif
#ifndef FNDELAY
#ifndef O_NONBLOCK
#define FNDELAY O_NDELAY
#else
#define FNDELAY O_NONBLOCK
#endif
#endif
#endif

#ifdef INC_TTY
#ifdef CF_TERMIO
#ifdef SVR4
#include <stropts.h>
#endif
#include <termios.h>
#else
#include <sgtty.h>
#endif
#endif

#ifdef INC_SIGNAL
#include <signal.h>
#ifndef SIGCHLD
#ifdef SIGCLD
#define SIGCHLD SIGCLD
#endif
#endif
#endif

#ifdef INC_SOCKET
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#ifdef SYSV
#include <sys/utsname.h>
#endif
#endif

#ifdef INC_ERRNO
#include <errno.h>
#endif

#ifdef INC_STRING
#ifdef CF_STRING
#include <string.h>
#else
#include <strings.h>
#endif
#endif

#ifdef INC_PWD
#include <pwd.h>
#endif

#ifdef CF_NOBCOPY
#define bzero(x,y) memset(x, 0, y)
#define bcopy(x,y,z) memmove(y,x,z)
#endif

/* always */
#include <stdio.h>
#include <stdlib.h>

