/* errnomap.c - maps between this unix's errnos and as225 */
static char rcsid[] = "$Id: errnomap.c 1.2 1995/03/07 03:17:26 Ezra_Story Exp $";

#define INC_SYS
#define INC_ERRNO

#include "defs.h"


export VOID SetErrnoMap P((VOID));
export ubyte GetErrno P((ubyte));

local ubyte errnomap[256];

/* Thank god for dme's macro langyuage! :-) */

VOID
SetErrnoMap(VOID)
{
#ifdef EPERM
    errnomap[ EPERM       ] =    1     ;
#endif
#ifdef ENOENT
    errnomap[ ENOENT      ] =    2     ;
#endif
#ifdef ESRCH
    errnomap[ ESRCH       ] =    3     ;
#endif
#ifdef EINTR
    errnomap[ EINTR       ] =    4     ;
#endif
#ifdef EIO
    errnomap[ EIO         ] =    5     ;
#endif
#ifdef ENXIO
    errnomap[ ENXIO       ] =    6     ;
#endif
#ifdef E2BIG
    errnomap[ E2BIG       ] =    7     ;
#endif
#ifdef ENOEXEC
    errnomap[ ENOEXEC     ] =    8     ;
#endif
#ifdef EBADF
    errnomap[ EBADF       ] =    9     ;
#endif
#ifdef ECHILD
    errnomap[ ECHILD      ] =    10    ;
#endif
#ifdef EAGAIN
    errnomap[ EAGAIN      ] =    11    ;
#endif
#ifdef ENOMEM
    errnomap[ ENOMEM      ] =    12    ;
#endif
#ifdef EACCES
    errnomap[ EACCES      ] =    13    ;
#endif
#ifdef EFAULT
    errnomap[ EFAULT      ] =    14    ;
#endif
#ifdef ENOTBLK
    errnomap[ ENOTBLK     ] =    15    ;
#endif
#ifdef EBUSY
    errnomap[ EBUSY       ] =    16    ;
#endif
#ifdef EEXIST
    errnomap[ EEXIST      ] =    17    ;
#endif
#ifdef EXDEV
    errnomap[ EXDEV       ] =    18    ;
#endif
#ifdef ENODEV
    errnomap[ ENODEV      ] =    19    ;
#endif
#ifdef ENOTDIR
    errnomap[ ENOTDIR     ] =    20    ;
#endif
#ifdef EISDIR
    errnomap[ EISDIR      ] =    21    ;
#endif
#ifdef EINVAL
    errnomap[ EINVAL      ] =    22    ;
#endif
#ifdef ENFILE
    errnomap[ ENFILE      ] =    23    ;
#endif
#ifdef EMFILE
    errnomap[ EMFILE      ] =    24    ;
#endif
#ifdef ENOTTY
    errnomap[ ENOTTY      ] =    25    ;
#endif
#ifdef ETXTBSY
    errnomap[ ETXTBSY     ] =    26    ;
#endif
#ifdef EFBIG
    errnomap[ EFBIG       ] =    27    ;
#endif
#ifdef ENOSPC
    errnomap[ ENOSPC      ] =    28    ;
#endif
#ifdef ESPIPE
    errnomap[ ESPIPE      ] =    29    ;
#endif
#ifdef EROFS
    errnomap[ EROFS       ] =    30    ;
#endif
#ifdef EMLINK
    errnomap[ EMLINK      ] =    31    ;
#endif
#ifdef EPIPE
    errnomap[ EPIPE       ] =    32    ;
#endif
#ifdef EDOM
    errnomap[ EDOM        ] =    33    ;
#endif
#ifdef ERANGE
    errnomap[ ERANGE      ] =    34    ;
#endif
#ifdef EWOULDBLOCK
    errnomap[ EWOULDBLOCK    ] = 35            ;
#endif
#ifdef EINPROGRESS
    errnomap[ EINPROGRESS    ] = 36            ;
#endif
#ifdef EALREADY
    errnomap[ EALREADY       ] = 37            ;
#endif
#ifdef ENOTSOCK
    errnomap[ ENOTSOCK       ] = 38            ;
#endif
#ifdef EDESTADDRREQ
    errnomap[ EDESTADDRREQ   ] = 39            ;
#endif
#ifdef EMSGSIZE
    errnomap[ EMSGSIZE       ] = 40            ;
#endif
#ifdef EPROTOTYPE
    errnomap[ EPROTOTYPE     ] = 41            ;
#endif
#ifdef ENOPROTOOPT
    errnomap[ ENOPROTOOPT    ] = 42            ;
#endif
#ifdef EPROTONOSUPPO
    errnomap[ EPROTONOSUPPORT] = 43            ;
#endif
#ifdef ESOCKTNOSUPPO
    errnomap[ ESOCKTNOSUPPORT] = 44            ;
#endif
#ifdef EOPNOTSUPP
    errnomap[ EOPNOTSUPP     ] = 45            ;
#endif
#ifdef EPFNOSUPPORT
    errnomap[ EPFNOSUPPORT   ] = 46            ;
#endif
#ifdef EAFNOSUPPORT
    errnomap[ EAFNOSUPPORT   ] = 47            ;
#endif
#ifdef EADDRINUSE
    errnomap[ EADDRINUSE     ] = 48            ;
#endif
#ifdef EADDRNOTAVAIL
    errnomap[ EADDRNOTAVAIL  ] = 49            ;
#endif
#ifdef ENETDOWN
    errnomap[ ENETDOWN       ] = 50            ;
#endif
#ifdef ENETUNREACH
    errnomap[ ENETUNREACH    ] = 51            ;
#endif
#ifdef ENETRESET
    errnomap[ ENETRESET      ] = 52            ;
#endif
#ifdef ECONNABORTED
    errnomap[ ECONNABORTED   ] = 53            ;
#endif
#ifdef ECONNRESET
    errnomap[ ECONNRESET     ] = 54            ;
#endif
#ifdef ENOBUFS
    errnomap[ ENOBUFS        ] = 55            ;
#endif
#ifdef EISCONN
    errnomap[ EISCONN        ] = 56            ;
#endif
#ifdef ENOTCONN
    errnomap[ ENOTCONN       ] = 57            ;
#endif
#ifdef ESHUTDOWN
    errnomap[ ESHUTDOWN      ] = 58            ;
#endif
#ifdef ETOOMANYREFS
    errnomap[ ETOOMANYREFS   ] = 59            ;
#endif
#ifdef ETIMEDOUT
    errnomap[ ETIMEDOUT      ] = 60            ;
#endif
#ifdef ECONNREFUSED
    errnomap[ ECONNREFUSED   ] = 61            ;
#endif
#ifdef ELOOP
    errnomap[ ELOOP          ] = 62            ;
#endif
#ifdef ENAMETOOLONG
    errnomap[ ENAMETOOLONG   ] = 63            ;
#endif
#ifdef EHOSTDOWN
    errnomap[ EHOSTDOWN      ] = 64            ;
#endif
#ifdef EHOSTUNREACH
    errnomap[ EHOSTUNREACH   ] = 65            ;
#endif
#ifdef ENOTEMPTY
    errnomap[ ENOTEMPTY      ] = 66            ;
#endif
#ifdef EPROCLIM
    errnomap[ EPROCLIM       ] = 67            ;
#endif
#ifdef EUSERS
    errnomap[ EUSERS         ] = 68            ;
#endif
#ifdef EDQUOT
    errnomap[ EDQUOT         ] = 69            ;
#endif
#ifdef ESTALE
    errnomap[ ESTALE         ] = 70            ;
#endif
#ifdef EREMOTE
    errnomap[ EREMOTE        ] = 71            ;
#endif
#ifdef ENOSTR
    errnomap[ ENOSTR         ] = 72            ;
#endif
#ifdef ETIME
    errnomap[ ETIME          ] = 73            ;
#endif
#ifdef ENOSR
    errnomap[ ENOSR          ] = 74            ;
#endif
#ifdef ENOMSG
    errnomap[ ENOMSG         ] = 75            ;
#endif
#ifdef EBADMSG
    errnomap[ EBADMSG        ] = 76            ;
#endif
#ifdef EIDRM
    errnomap[ EIDRM          ] = 77            ;
#endif
#ifdef EDEADLK
    errnomap[ EDEADLK        ] = 78            ;
#endif
#ifdef ENOLCK
    errnomap[ ENOLCK         ] = 79            ;
#endif
}

ubyte
GetErrno(err)
ubyte err;
{
    return(errnomap[err]);
}
