/* defs.h -- misc defines, typdefs and structs
 *
 * Copyright (c) 1994 by Ezra Story.  All rights reserved.  Explicit
 * permission is given to use this source for any purpose as long as
 * the author (Ezra Story) is notified and this copyright notice is
 * included.
 *
$Id: defs.h 1.24 1995/04/13 02:08:46 Ezra_Story Exp $
 *
 */
/* unix system includes */
#include "config.h"
#include "includes.h"
#include "mlink.h"

/* debug */
#ifdef DEBUG
#define D(x) x
#else
#define D(x)
#endif

/* ANSI or K&R */
#ifdef NOANSI
#ifdef __STDC__
#undef __STDC__
#endif
#endif

#ifndef __STDC__
#define P(x) ()
#define VOID
#else
#define P(x) x
#define VOID void
#endif


#define ESC_NONE        0         /* no escaping */
#define ESC_44          1         /* split byte escaping */
#define ESC_BYTE        2         /* byte by byte escaping */

#define SERBUFSIZE      24000     /* size of serial in buffer */
#define SINBUF          4000      /* socket in buffer */
#define CINBUF          300       /* command packet in buffer */
#define MAXSOCKS        64        /* maximum # of sockets */

#define SK_OPEN         1       /* fd is open */
#define SK_CONNECTED    2       /* connected to a peer (stream) */
#define SK_CLOSING      4       /* socket has a pending CMD_CLOSE */
#define SK_BOUND        8       /* socket has address */
#define SK_LISTENING    16      /* socket is listening for connects */
#define SK_CONNECTING   32      /* socket is attempting connection */
#define SK_KNOCKED      64      /* socket had already indicated a connect */
#define SK_BLOCKED      128     /* socket has been blocked from sending */
#define SK_WEBLOCK      256     /* socket was marked as full to client */
#define SK_ISPTY        512     /* socket is actually a pty */

#define UL(x,y)  ((ulong)((x)[y]))
#define DATAWORD(x) ((UL(x,0) << 8) + UL(x,1))
#define DATALONG(x)  ((UL(x,0) << 24) + (UL(x,1) << 16) + (UL(x,2) << 8) + UL(x,3))
#define NONBLOCK(x) fcntl(x,F_SETFL,fcntl(x,F_GETFL)|FNDELAY)
#define BLOCK(x) fcntl(x,F_SETFL,fcntl(x,F_GETFL)&(~FNDELAY))
#ifndef MIN
#define MIN(x,y) ((x)<(y)?x:y)
#endif
#ifndef MAX
#define MAX(x,y) ((x)>(y)?x:y)
#endif
#define SWAPSERBUFS()  {tmpbuf = serbuf; serbuf = serbuf2; serbuf2 = tmpbuf;}

/* structs */
typedef unsigned char ubyte;
typedef unsigned short uword;
#ifndef CF_ULONG
typedef unsigned long  ulong;
#endif
typedef char  byte;
typedef short word;
typedef void          *aptr;

#include "lists.h"
#include "fifo.h"
struct selmask
{
    struct fd_set   rd;
    struct fd_set   wr;
    struct fd_set   ex;
};
typedef struct
{
    NODE        n;      /* for entry in priority list */
    int         fd;     /* descriptor for socket out */
    int         desc;   /* channel / mlink descriptor */
    int         domain; /* unix or inet */
    int         type;   /* dgram or stream */
    int         state;  /* current state of socket   */

    Fifo        rdbuf;  /* read buffer */
    Fifo        dgbuf;  /* output datagram buffer */

    int         quant;  /* priority loop modifier */

    ulong       addr;   /* connecting/peer addr */
    int         port;   /* connecting/peer port */

    int         pings;  /* current amt of retrys on connect */
    ulong       lsttry; /* last time tried to connect */
} mlsocket;


/* prototypes */
#define export extern
#define local  /*static*/
#include "globals.h"
#undef export
#define export

