/*------------------------------------------------------------------------*\
|                                                                          |
|          MKWINOS2.CMD - Version 0.728 - Version Date 1995-07-28          |
|                 Copyright (c) 1995 by C F S Nevada, Inc.                 |
|                                                                          |
|                 Dick Goran      - Voice      702-732-9616                |
|                                 - FAX        702-732-3847                |
|                                 - CompuServe 71154,2002                  |
|                                 - Internet   dgoran@cfsrexx.com          |
|                                                                          |
|          Produced and distributed by Productivity Solutions, Inc.        |
|                 David Moskowitz - Voice      610-631-5685                |
|                                 - FAX        610-631-0414                |
|                                 - CompuServe 76701,100                   |
|                                 - Internet   davidm@cfsrexx.com          |
|                                                                          |
| ------------------------------------------------------------------------ |
|  Requires: REXXLIB.DLL  - OS/2 REXX external function library            |
|                           (c) Copyright 1992-95 Quercus Systems          |
\*------------------------------------------------------------------------*/
/*

#1 Command Line

   MKWINOS2 [ path to windows directory ] [ /d ]

   An optional path to the Windows directory which is to serve as the
   source for the information used to create the Windows Desktop equivalent.
   The default is the value specified when OS/2 was installed (which is the
   path pointed to by the WINOS2_LOCATION in the PM_INSTALL application name
   in the OS2.INI file).

   The /d (debug) parameter is intended primarily for support use.

#2 WARNING!

   The order and position of the lines of code within this program are
   critical. Altering them may result in incorrect output by the code
   generation phase of MKWINOS2.

*/

   SIGNAL ON ERROR                  /* trap object time errors     */
   SIGNAL ON FAILURE                /* trap object time errors     */
   SIGNAL ON HALT                   /* trap object time errors     */
   SIGNAL ON NOVALUE                /* trap object time errors     */
   SIGNAL ON SYNTAX                 /* trap object time errors     */

GBL. = ''             /* initialize stem */
parse Arg             GBL.command_line
parse Version         GBL.REXX_version .
parse Source          GBL.operating_system,
                      GBL.calling_environment,
                      GBL.program_path_and_name
GBL.package_name    = 'MKWINOS2'
GBL.environment     = 'OS2ENVIRONMENT'
GBL.boot_drive      = LEFT( VALUE( 'RUNWORKPLACE',, GBL.environment ), 2 )
GBL.program_version = 0.728       /* version / mod of this program */
GBL.program_name    = FILESPEC( 'N', GBL.program_path_and_name )
GBL.program_path    = FILESPEC( 'D', GBL.program_path_and_name ) ||,
                      FILESPEC( 'P', GBL.program_path_and_name )

parse var GBL.program_name,
   GBL.program_fn '.',
   GBL.program_fe

/*-----------------------------------------------*\
|  Assure that REXXUTIL & REXXLIB are registered  |
\*-----------------------------------------------*/
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

if RxFuncQuery( 'RexxLibDeregister' ) = 0 then
   do
      call RexxLibDeregister
   end
if GBL.REXX_version = 'REXX/Personal' then
   do
      dll_name = 'QREXXLIB'
   end
else
   do
      dll_name = 'REXXLIB'
   end
call RxFuncAdd 'RexxLibRegister', dll_name, 'rexxlibregister'
call RexxLibRegister

call TIME 'E'                       /* set elapsed timer - sssss.uuuuu */
call SysCls
say 'Begin' TRANSLATE( GBL.program_name ) 'at' TIME('N')

GBL.width         = 76              /* report file max width */
GBL.white_on_blue = '1B'x || '[1;37;44m'
GBL.ansi_off      = '1B'x || '[0m'

call CHAROUT 'CON:',,
   '1B'x || '[s'      ||,
   COPIES( ' ', 2 )   ||,
   GBL.white_on_blue  ||,
   CENTER( 'This program may take a couple of minutes to run', GBL.width - 2 ) ||,
   GBL.ansi_off       ||,
   '1B'x || '[u'      ||,
   ''
call STREAM 'CON:', 'C', 'CLOSE'

/*-------------------*\
|  Start report file  |
\*-------------------*/
GBL.report_file =,
   GBL.program_path ||,
   GBL.package_name || '.RPT'
call SysFileDelete GBL.report_file
heading_1 =,
   CENTER( 'MKWINOS2 Report created on' DATE() 'at' TIME(), GBL.width )
call LINEOUT GBL.report_file, heading_1
call LINEOUT GBL.report_file, COPIES( '-', LENGTH(heading_1) ) || '0D0A'x

/*-----------------*\
|  Start copy file  |
\*-----------------*/
GBL.copy_file =,
   GBL.program_path ||,
   'MKWINRUN.CPY'
call SysFileDelete GBL.copy_file

uppercase_command_line = STRIP( SPACE( TRANSLATE( GBL.command_line ) ) )

if POS( '?', uppercase_command_line ) > 0 then
   do forever
      input_line = LINEIN( GBL.program_path_and_name )
      if LEFT( input_line, 1 ) = '#' then
         if GBL.copy_switch = 1 then
            do
               call STREAM GBL.program_path_and_name, 'C', 'CLOSE'
               call EOJ 000
            end
      if LEFT( input_line, 2 ) = '#1' then
         do
            GBL.copy_switch = 1
            iterate
         end
      if GBL.copy_switch = 1 then
         do
            say GBL.white_on_blue             ||,
                LEFT( input_line, GBL.width ) ||,
                GBL.ansi_off
         end
   end

debug_word_number =,
   BITOR( WORDPOS( '/D', uppercase_command_line ),,
          WORDPOS( '-D', uppercase_command_line ) )
if debug_word_number > 0 then
   do
      GBL.debug_file =,
         GBL.program_path ||,
         GBL.package_name || '.LOG'
      call SysFileDelete GBL.debug_file
      uppercase_command_line =,
         SPACE( OVERLAY( '  ',,
                         uppercase_command_line,,
                         WORDINDEX(uppercase_command_line,,
                                   debug_word_number ) ) )
   end

/*-----------------------------------*\
|  For the time being, the debug log  |
|          will be forced             |
\*-----------------------------------*/
GBL.debug_file =,
   GBL.program_path ||,
   GBL.package_name || '.LOG'
call SysFileDelete GBL.debug_file

/*------------------------------------*\
|  Set required environment variables  |
\*------------------------------------*/
'@echo off'                         /* eliminate junk on 4OS2 - 95/07/28 */
call SETLOCAL                       /* let system save environment */

/* set TEMP to MKWINOS2 path */
call VALUE 'TEMP',,
           STRIP( GBL.program_path, 'T', '\' ),,
           GBL.environment

/* MKWINOS2 variables */
v=0
v=v+1; var.v = 'COPY'    GBL.copy_file
v=v+1; var.v = 'DEBUG'   GBL.debug_file
v=v+1; var.v = 'PATH'    GBL.program_path
v=v+1; var.v = 'REPORT'  GBL.report_file
       var.0 = v
do v = 1 to var.0
   call VALUE GBL.package_name || '_' || WORD( var.v, 1 ),,
              WORD( var.v, 2 ),,
              GBL.environment
end

/*-----------------*\
|  Load macrospace  |
\*-----------------*/
do m = 1 to 10
   call MACRODROP 'MKWIN' || RIGHT( m, 3, '0' )
end

program_file_extension = 'SAA'
if GBL.REXX_Version = 'REXX/Personal' then
   do
      program_file_extension = 'PER'
   end
macro_file =,
   STREAM( GBL.program_path || 'MKWINOS2.' || program_file_extension,,
           'C', 'QUERY EXISTS' )

if macro_file = '' then
   do
      call MACROLOAD macro_file
   end
call mkwin001 uppercase_command_line

/*-------------------*\
|  Unload macrospace  |
\*-------------------*/
do m = 1 to 10
   call MACRODROP 'MKWIN' || RIGHT( m, 3, '0' )
end

call ENDLOCAL                       /* let system restore environment */
call EOJ 0


/* EOJ marker */
/*------------------------------------------------------------------------*\
|                                                                          |
|                                End of Job                                |
|                                                                          |
\*------------------------------------------------------------------------*/
EOJ:
   Procedure expose,
      GBL.

if ARG() = 0 then
   eoj_rc = 0
else
   eoj_rc = ARG(1)

elapsed_time = TIME('E')            /* get elapsed time - sssss.uuuuu */
parse value elapsed_time with seconds '.' micro_seconds
if LEFT( micro_seconds, 1, 1 ) >= 5 then
   seconds = seconds + 1
ss = FORMAT( seconds // 60, 2 )
minutes = ( seconds - ss ) / 60
mm = FORMAT( minutes // 60, 2 )
hh = FORMAT( ( minutes - mm ) / 60, 2 )
duration = hh':'mm':'ss

program_name = TRANSLATE( FILESPEC( 'N', GBL.program_path_and_name ) )
say 'End  ' program_name 'at' TIME('N') ||,
    ', duration' TRANSLATE( duration, '0', ' ' )
exit eoj_rc

/*------------------------------------------------------------------------*\
|                                                                          |
|                              Trap Routines                               |
|                                                                          |
\*------------------------------------------------------------------------*/
ERROR:   call TRAP_PROCESSING SIGL, 'ERROR',   RC
FAILURE: call TRAP_PROCESSING SIGL, 'FAILURE', RC
HALT:    call TRAP_PROCESSING SIGL, 'HALT',    ''
NOVALUE: call TRAP_PROCESSING SIGL, 'NOVALUE', ''
SYNTAX:  call TRAP_PROCESSING SIGL, 'SYNTAX',  RC

/* Rev. 95/07/26 */
TRAP_PROCESSING:
   parse Source . . TRAP.path_and_program
   trap.line_nbr = ARG(1)
   if POS( ':', TRAP.path_and_program ) > 0 then
      /* get source line if it is available */
      do t = 1
         trap_source_line.t =  SOURCELINE( trap.line_nbr )
         trap_source_line.0 = t
         trap.line_nbr      = trap.line_nbr + 1
         if RIGHT( SOURCELINE( trap.line_nbr ), 1 ) = ',' then
            do
               if t > 1 then
                  do
                     t = t + 1
                     trap_source_line.t =  SOURCELINE( trap.line_nbr )
                     trap_source_line.0 = t
                  end
               leave
            end
      end
   else
      /* program is running in macrospace */
      do
         TRAP.path_and_program = VALUE( 'TEMP',, 'OS2ENVIRONMENT' ) ||,
                                 '\' || TRAP.path_and_program
         trap_source_line.1 = 'Source line is not available.'
         trap_source_line.0 = 1
      end

   parse value FILESPEC( 'N', TRAP.path_and_program ) with,
      TRAP.fn '.' TRAP.fe
   trap_file_name = FILESPEC( 'D', TRAP.path_and_program ) ||,
                    FILESPEC( 'P', TRAP.path_and_program ) ||,
                    TRAP.fn || '.' || 'DMP'

   /*------------------------------------------*\
   |  check for reason not to create .DMP file  |
   \*------------------------------------------*/
   if ARG(2) = 'HALT' then
      do
         trap_file_name = ''
      end
   if RxFuncQuery( 'VARDUMP' ) <> 0 then
      do
         trap_file_name = ''
      end
   if POS( ':', trap_file_name ) = 0 then
      do
         trap_file_name = ''
      end

   /*------------------------*\
   |  Build trap message box  |
   \*------------------------*/
   dbl.h    = 'CD'x                 /*  double line - horizontal   */
   dbl.v    = 'BA'x                 /*  double line - vertical     */
   dbl.bl   = 'C8'x                 /*  double line - bottom left  */
   dbl.br   = 'BC'x                 /*  double line - bottom right */
   dbl.tl   = 'C9'x                 /*  double line - top left     */
   dbl.tr   = 'BB'x                 /*  double line - top right    */
   trap.red = '1B'x || '[1;37;41m'  /* bright white on red          */
   trap.dul = '1B'x || '[0m'        /* reset to normal              */

   say ' '
   trap_error_description =,
      'Error line = ' || ARG(1) ||,
      '; ' ||,
      ARG(2) ||,
      ' error.'
   if ARG(3) <> '' then
      trap_error_description = trap_error_description ||,
                               '  Return code = ' || ARG(3)
   trap.width = MAX( 74, LENGTH( trap_error_description ) )
   say trap.red || dbl.tl || COPIES( dbl.h,trap.width + 2 ) || dbl.tr || trap.dul
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( TRAP.fn'.CMD',trap.width )    dbl.v  || trap.dul
   say trap.red || dbl.v CENTER( trap_error_description, trap.width ) dbl.v || trap.dul
   if trap_file_name <> '' then
      do
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.v     CENTER( 'See: ' || trap_file_name,,
                                     trap.width )  dbl.v  || trap.dul
      end
   say trap.red || dbl.v  || COPIES( ' ',  trap.width + 2 ) || dbl.v  || trap.dul
   say trap.red || dbl.bl || COPIES( dbl.h,trap.width + 2 ) || dbl.br || trap.dul
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul
   say trap.red || LEFT( 'Source line at time of trap:', trap.width + 4 ) || trap.dul
   do t = 1 to trap_source_line.0
      say trap.red || LEFT( '   ' || trap_source_line.t, trap.width + 4 ) || trap.dul
   end
   say trap.red || COPIES( ' ', trap.width + 4 ) || trap.dul

   /*---------------------------------*\
   |  Create .DMP file if appropriate  |
   \*---------------------------------*/
   if trap_file_name <> '' then
      do
         call SysFileDelete trap_file_name
         /* remove meaningless labels from dump for clarity */
         drop dbl. TRAP. RC RESULT SIGL !tr!
         call VARDUMP trap_file_name  /* write variables to program.DMP file */
      end
   exit 253
