#############################################################################
#
#                       Copyright (C) 1994 SciTech Software
#                               All rights reserved.
#
# Descripton:   Generic DMAKE startup makefile definitions file. Assumes
#               that the SCITECH environment variable has been set to point
#               to where all our stuff is installed. You should not need
#               to change anything in this file.
#
#               Watcom C++ 10.x 16 bit version. Supports 16 bit DOS and
#               16 bit Windows development.
#
# $Id: wc16.mk 1.4 1995/09/26 12:37:11 kjb release $
#
#############################################################################

# Disable warnings for macros redefined here that were given
# on the command line.
__.SILENT       := $(.SILENT)
.SILENT         := yes

# File suffix definitions
   L            := .lib   # Libraries
   E            := .exe   # Executables
   O            := .obj   # Objects
   A            := .asm   # Assembler sources
   P            := .cpp   # C++ sources
   D            := .dll   # Dynamic Link Library file
   R            := .res   # Compiled resource file

# Import enivornment variables that we use
TMPDIR := $(ROOTDIR)/tmp
.IMPORT .IGNORE : TMPDIR COMSPEC INCLUDE LIB SCITECH DBG OPT OPT_SIZE SHW BETA FPU
.IMPORT .IGNORE : USE_WIN16 BUILD_DLL IMPORT_DLL

# We use the MSDOS shell at all times
   SHELL        := $(COMSPEC)
   GROUPSHELL   := $(SHELL)
   SHELLFLAGS   := $(SWITCHAR)c
   GROUPFLAGS   := $(SHELLFLAGS)
   SHELLMETAS   := *"?<>
   GROUPSUFFIX  := .bat
   DIRSEPSTR    := \\
   DIVFILE       = $(TMPFILE:s,/,\)

# Default commands for compiling, assembling linking and archiving
   CC           := wcl      # C-compiler and flags
   CFLAGS       := -ml-zq-w2-s-fh -fhq
   AS           := tasm     # Assembler and flags
   ASFLAGS      := /mx /m /D__LARGE__ /i$(SCITECH)\INCLUDE
   LD           := wlink    # Loader and flags
   LDFLAGS       =
   RC           := wrc      # Watcom resource compiler
   RCFLAGS      := /bt=windows
   LIB          := wlib     # Librarian
   LIBFLAGS     := -q
   ILIB         := wlib     # Import librarian
   ILIBFLAGS    := -c

# Optionally turn on debugging information
.IF $(DBG)
   CFLAGS       += -d2      # Turn on debugging for C compiler
   LIBFLAGS     += -p=128   # Larger page size for libraries with debug info!
   ASFLAGS      += /zi      # Turn on debugging for assembler
   LDFLAGS      += D A      # Turn on debugging for linker
.ELSE
   ASFLAGS      += /q       # Suppress object records not needed for linking
.END

# Optionally turn on optimisations
.IF $(OPT)
   CFLAGS       += -onatx-5
.ELIF $(OPT_SIZE)
   CFLAGS       += -onaslmr-5
.END

# Optionally turn on direct i387 FPU instructions optimised for Pentium

.IF $(FPU)
   CFLAGS       += -fpi87-fp5-DFPU387
   ASFLAGS      += -DFPU387
.END

# Optionally compile a shareware version of a product
.IF $(SHW)
   LIB_DIR      := LIBSW
   CFLAGS       += -DSHAREWARE
.ELSE
   LIB_DIR      := LIB
.END

# Optionally compile a beta release version of a product
.IF $(BETA)
   CFLAGS       += -DBETA
   ASFLAGS      += -DBETA
.END

# Use a larger stack during linking if requested

.IF $(STKSIZE)
    LDFLAGS     += OP STACK=$(STKSIZE)
.ENDIF

.IF $(USE_WIN16)
.IF $(BUILD_DLL)
    CFLAGS       += -bd-bt=windows-D_WINDOWS-DBUILD_DLL
    ASFLAGS      += -DBUILD_DLL
.ELSE
    CFLAGS       += -bt=windows-D_WINDOWS
.ENDIF
    DX_ASFLAGS   += -D__WINDOWS16__
    LIB_OS       = WIN16
.ELSE
    LIB_OS       = DOS16
.END

# Place to look for PMODE library files

.IF $(MK_PMODE)
.ELSE
PMLIB           := pmode.lib,
.END

# Define where to install library files
   LIB_BASE     := $(SCITECH)\$(LIB_DIR)\$(LIB_OS)\WC
   LIB_DEST     := $(LIB_BASE)

# Definition of $(MAKE) macro for recursive makes.
   MAKE = $(MAKECMD) $(MFLAGS)

# Macro to install a library file
   INSTALL      := cp

# Implicit generation rules for making object files
   %$O: %.c ; +$(CC) $(CFLAGS) -c $<
   %$O: %$P ; +$(CC) $(CFLAGS) -c $<
   .SWAP %$O: %$A ; +$(AS) $(ASFLAGS) $(<:s,/,\)

# Implicit rule for building resource files
   %$R: %.rc ; +$(RC) $(RCFLAGS) -r $<

# Implicit rule for building a library file using response file
.IF $(BUILD_DLL)
   %$L: ; $(ILIB) $(ILIBFLAGS) $@ +$?
.ELIF $(IMPORT_DLL)
   %$L: ; $(ILIB) $(ILIBFLAGS) $@ +$?
.ELSE
   %$L: ; +$(LIB) $(LIBFLAGS) $@ @$(mktmp,$*.rsp -+$(?:t"\n-+":s/\/\\)\n)
.ENDIF

# Implicit rule for building an executable file using response file
.IF $(USE_WIN16)
.IF $(BUILD_DLL)
   .SWAP %$E: ;
@[
    @trimlib $(mktmp $(LDFLAGS) OP quiet SYS windows_dll\nN $@\nF $(&:t",":s/\/\\)\nLIBR $(EXELIBS:t",")) $*.lnk
    rclink $(LD) $(RC) $@ $*.lnk
    @rm $*.lnk
]
.ELSE
   .SWAP %$E: ;
@[
    @trimlib $(mktmp $(LDFLAGS) OP quiet SYS windows\nN $@\nF $(&:t",":s/\/\\)\nLIBR $(EXELIBS:t",")) $*.lnk
    rclink $(LD) $(RC) $@ $*.lnk
    @rm $*.lnk
]
.ENDIF
.ELSE
   %$E: ;
@[
    @trimlib $(mktmp OP quiet\nN $@\nF $(&:t",":s/\/\\)\nLIBR $(PMLIB) $(EXELIBS:t",")) $*.lnk
    $(LD) $(LDFLAGS) @$*.lnk
    @rm $*.lnk
]
.ENDIF

# DMAKE uses this recipe to remove intermediate targets
.REMOVE :; $(RM) -f $<

# Turn warnings back to previous setting.
.SILENT := $(__.SILENT)

# We dont use TABS in our makefiles
.NOTABS         := yes

# Define where the local include files are kept for dependencies in
# makefiles after this file is included.

RCSINC :=  $(SCITECH)\INCLUDE

